/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views;

import org.eclipse.core.resources.IProject;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.DVTPlugin;

public class DVTHelpListener
implements HelpListener {
    public static final String EDT_HELP = "ro.amiq.edt.help.";
    public static final String SLN_HELP = "ro.amiq.slndt.help.";
    public static final String MSDL_HELP = "ro.amiq.msdldt.help.";
    public static final String PSS_HELP = "ro.amiq.pssdt.help.";
    public static final String VLOG_HELP = "ro.amiq.vlogdt.help.";
    public static final String VHDL_HELP = "ro.amiq.vhdldt.help.";
    public static final String DEFAULT_HELP = "ro.amiq.vlogdt.help.";
    private static volatile DVTHelpListener fInstance;
    private static final Object fSyncInstance;

    static {
        fSyncInstance = new Object();
    }

    protected DVTHelpListener() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DVTHelpListener getInstance() {
        if (fInstance == null) {
            Object object = fSyncInstance;
            synchronized (object) {
                fInstance = new DVTHelpListener();
            }
        }
        return fInstance;
    }

    public void helpRequested(HelpEvent e) {
        try {
            String id;
            IWorkbenchPage wbp = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IWorkbenchPartReference activePartReference = wbp.getActivePartReference();
            if (activePartReference == null) {
                return;
            }
            String helpUrl = "ro.amiq.vlogdt.help.";
            IProject project = DVTPlugin.getSelectionManager().getLastSelectedProject();
            if (project == null || !project.isAccessible()) {
                id = wbp.getPerspective().getId();
                if (id.equals("ro.amiq.vlogdt.ui.perspectives.VlogPerspective")) {
                    helpUrl = "ro.amiq.vlogdt.help.";
                } else if (id.equals("ro.amiq.edt.ui.perspectives.EDTPerspective")) {
                    helpUrl = EDT_HELP;
                } else if (id.equals("ro.amiq.vhdldt.ui.perspectives.VhdlPerspective")) {
                    helpUrl = VHDL_HELP;
                }
            } else if (project.hasNature("ro.amiq.edt.enature")) {
                helpUrl = EDT_HELP;
            } else if (project.hasNature("ro.amiq.vlogdt.VlogNature")) {
                helpUrl = "ro.amiq.vlogdt.help.";
            } else if (project.hasNature("ro.amiq.slndt.slnnature")) {
                helpUrl = SLN_HELP;
            } else if (project.hasNature("ro.amiq.msdldt.msdlnature")) {
                helpUrl = MSDL_HELP;
            } else if (project.hasNature("ro.amiq.pssdt.pssnature")) {
                helpUrl = PSS_HELP;
            } else if (project.hasNature("ro.amiq.vhdldt.VhdlNature")) {
                helpUrl = VHDL_HELP;
            }
            id = activePartReference.getId();
            String[] parts = id.split("\\.");
            if (parts == null || parts.length == 0) {
                return;
            }
            String viewName = parts[parts.length - 1];
            PlatformUI.getWorkbench().getHelpSystem().displayHelp(String.valueOf(helpUrl) + viewName);
        }
        catch (Exception exception) {}
    }
}

