/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.diagrams.ch.model.CHUVMComponent;
import ro.amiq.dvt.interpreter.IXXVMComponent;
import ro.amiq.dvt.model.reflection.BindingRuleWrapper;
import ro.amiq.dvt.model.reflection.DVTRfUtils;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfNamedElementAndScope;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.IRfVHBreadcrumbElement;
import ro.amiq.dvt.power.format.DVTPFInfo;
import ro.amiq.dvt.power.format.DVTPFIsolationStrategyInfo;
import ro.amiq.dvt.power.format.DVTPFRetentionRuleInfo;
import ro.amiq.dvt.ui.trace.connections.model.TCNode;
import ro.amiq.dvt.ui.trace.connections.model.TCNodeSignalPair;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.utils.parser.IDVTFileInstance;

public class DVTTreeElementWrapper
extends IDVTElementWrapper {
    private static final int INITIAL_CAPACITY = 4;
    protected List<DVTTreeElementWrapper> fChildren;
    private boolean fInTreeRoot;
    private boolean fOverlayStatus;
    private boolean fAccessDecoratorEnable;
    private DVTTreeElementWrapper fSelected;
    private DVTTreeElementWrapper fParent;
    private boolean fGrayIcon;
    private int fLineNumber;
    private boolean fOverrideLine = false;
    private Object fItem;
    private int fExpanded;
    private long uniqueID;
    private String fTreeName;
    private IRfNamedElement fInstanceType;
    private IRfNamedElement fComponent;
    private BindingRuleWrapper fBindResult;
    private IRfNamedElement fEntity;
    private Object fGoToElement;

    public DVTTreeElementWrapper(Object element, boolean access) {
        super(element);
        this.fElement = element;
        this.fAccessDecoratorEnable = access;
    }

    public DVTTreeElementWrapper(Object element) {
        super(element);
        this.fElement = element;
        this.fAccessDecoratorEnable = false;
    }

    public DVTTreeElementWrapper() {
        super(null);
    }

    @Override
    public void addChild(IDVTElementWrapper child) {
        if (this.fChildren == null) {
            this.fChildren = new ArrayList<DVTTreeElementWrapper>(4);
        }
        ((DVTTreeElementWrapper)child).setParent(this);
        this.fChildren.add((DVTTreeElementWrapper)child);
    }

    @Override
    public <T extends IDVTElementWrapper> void setChildren(List<T> children) {
        this.fChildren = children;
    }

    public List<DVTTreeElementWrapper> getChildren() {
        return this.fChildren;
    }

    @Override
    public IDVTElementWrapper getFirstChild() {
        return this.fChildren == null || this.fChildren.isEmpty() ? null : (IDVTElementWrapper)this.fChildren.get(0);
    }

    public DVTTreeElementWrapper getChild(Object unwrapped) {
        if (this.fChildren == null) {
            return null;
        }
        int i = 0;
        while (i < this.fChildren.size()) {
            DVTTreeElementWrapper child = this.fChildren.get(i);
            if (child.fElement.equals(unwrapped)) {
                return child;
            }
            ++i;
        }
        return null;
    }

    public boolean isInTreeRoot() {
        return this.fInTreeRoot;
    }

    public void setInTreeRoot(boolean inTreeRoot) {
        this.fInTreeRoot = inTreeRoot;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IResource.class) {
            if (this.fElement instanceof IRfFileDef) {
                return ((IRfFileDef)this.fElement).getAdapter(adapter);
            }
            if (this.fElement instanceof IDVTFileInstance) {
                return DVTRfUtils.getFile((IDVTFileInstance)this.fElement, this.getProject());
            }
        } else if (adapter == IRfNamedElement.class ? this.fElement instanceof IRfNamedElement : (adapter == IRfDefElement.class ? this.fElement instanceof IRfDefElement : adapter == TCNode.class && this.fElement instanceof TCNode)) {
            return this.fElement;
        }
        return null;
    }

    @Override
    public boolean getOverlayStatus() {
        return this.fOverlayStatus;
    }

    @Override
    public void setOverlayStatus(boolean status) {
        this.fOverlayStatus = status;
    }

    @Override
    public boolean getAccessDecoratorEnable() {
        return this.fAccessDecoratorEnable;
    }

    @Override
    public DVTTreeElementWrapper getSelectedElement() {
        return this.fSelected;
    }

    public void setSelectedElement(DVTTreeElementWrapper selected) {
        this.fSelected = selected;
    }

    public void setParent(DVTTreeElementWrapper parent) {
        this.fParent = parent;
    }

    @Override
    public void setParent(IDVTElementWrapper parent) {
        if (parent instanceof DVTTreeElementWrapper) {
            this.setParent((DVTTreeElementWrapper)parent);
        }
    }

    @Override
    public DVTTreeElementWrapper getParent() {
        return this.fParent;
    }

    public void setGrayIcon(boolean grayIcon) {
        this.fGrayIcon = grayIcon;
    }

    @Override
    public boolean isGrayIcon() {
        return this.fGrayIcon;
    }

    public void overrideLineNumber(int line) {
        this.fLineNumber = line;
        this.fOverrideLine = true;
    }

    public int getLineNumber() {
        return this.fLineNumber;
    }

    public boolean isOverrideLine() {
        return this.fOverrideLine;
    }

    @Override
    public void setItem(Object item) {
        this.fItem = item;
    }

    @Override
    public Object getItem() {
        return this.fItem;
    }

    @Override
    public void setExpanded(int expanded) {
        this.fExpanded = expanded;
    }

    @Override
    public int getExpanded() {
        return this.fExpanded;
    }

    @Override
    public void setSelectedElement(Object selected) {
        if (selected instanceof DVTTreeElementWrapper) {
            this.fSelected = (DVTTreeElementWrapper)selected;
        }
    }

    @Override
    public void setInstanceType(IRfDesignElement instanceType) {
        this.fInstanceType = instanceType;
    }

    @Override
    public IRfNamedElement getInstanceType() {
        return this.fInstanceType;
    }

    @Override
    public void setUniqueID(long id) {
        this.uniqueID = id;
    }

    @Override
    public long getUniqueID() {
        return this.uniqueID;
    }

    @Override
    public void setAssociatedElements(IRfNamedElement component, BindingRuleWrapper bindResult, IRfNamedElement entity) {
        this.fComponent = component;
        this.fBindResult = bindResult;
        this.fEntity = entity;
    }

    @Override
    public IRfNamedElement getConnectComponent() {
        return this.fComponent;
    }

    @Override
    public BindingRuleWrapper getConnectBind() {
        return this.fBindResult;
    }

    @Override
    public IRfNamedElement getConnectDesign() {
        return this.fEntity;
    }

    @Override
    public IDVTElementWrapper create() {
        DVTTreeElementWrapper element = new DVTTreeElementWrapper(this.fElement);
        element.setInstanceType((IRfDesignElement)this.fInstanceType);
        return element;
    }

    @Override
    public void deepClean() {
        if (this.fChildren != null) {
            for (DVTTreeElementWrapper child : this.fChildren) {
                child.deepClean();
            }
        }
        this.fChildren = null;
        this.fParent = null;
        this.fSelected = null;
        this.fBindResult = null;
        this.fAdditionalInfo = null;
        this.fComponent = null;
        this.fElement = null;
        this.fEntity = null;
        this.fItem = null;
        this.fInstanceType = null;
        this.fProject = null;
    }

    @Override
    public <T extends IDVTElementWrapper> void addChildren(List<T> children) {
        if (children == null || children.isEmpty()) {
            return;
        }
        for (IDVTElementWrapper elementWrapper : children) {
            this.addChild(elementWrapper);
        }
    }

    @Override
    public boolean hasChildren() {
        return this.fChildren != null && !this.fChildren.isEmpty();
    }

    @Override
    public void removeChild(IDVTElementWrapper child) {
        if (!this.hasChildren()) {
            return;
        }
        this.fChildren.remove(child);
    }

    public String toString() {
        Object rfElement = this.getRfElement();
        return rfElement != null ? rfElement.toString() : "";
    }

    @Override
    public LanguageKind getLanguageKind() {
        Object element = this.fElement;
        if (element instanceof TreePath) {
            element = ((TreePath)element).getElement();
        }
        if (element instanceof IRfDefElement) {
            return ((IRfDefElement)element).getLanguageKind();
        }
        if (element instanceof IRfNamedElement) {
            return ((IRfNamedElement)element).getLanguageKind();
        }
        if (element instanceof IRfVHBreadcrumbElement && ((IRfVHBreadcrumbElement)element).getNamedElement() != null) {
            return ((IRfVHBreadcrumbElement)element).getNamedElement().getLanguageKind();
        }
        if (element instanceof IRfNamedElementAndScope && ((IRfNamedElementAndScope)element).getIRfNamedElement() != null) {
            return ((IRfNamedElementAndScope)element).getIRfNamedElement().getLanguageKind();
        }
        if (element instanceof TCNode && ((TCNode)element).namedElement != null) {
            return ((TCNode)element).namedElement.getLanguageKind();
        }
        if (element instanceof TCNodeSignalPair && ((TCNodeSignalPair)element).node != null && ((TCNodeSignalPair)element).node.namedElement != null) {
            return ((TCNodeSignalPair)element).node.namedElement.getLanguageKind();
        }
        if (element instanceof IXXVMComponent) {
            return ((IXXVMComponent)element).getLanguageKind();
        }
        if (element instanceof CHUVMComponent) {
            return ((CHUVMComponent)element).getLanguageKind();
        }
        if (element instanceof ElementPath || element instanceof DVTPFInfo || element instanceof DVTPFIsolationStrategyInfo || element instanceof DVTPFRetentionRuleInfo) {
            return LanguageKind.PF;
        }
        return LanguageKind.UNKNOWN;
    }

    public void setTreeName(String treeName) {
        this.fTreeName = treeName;
    }

    public String getTreeName() {
        return this.fTreeName;
    }

    @Override
    public IProject getProject() {
        IRfNamedElement namedElement;
        if (this.fProject != null) {
            return this.fProject;
        }
        if (this.fElement instanceof IAdaptable && (namedElement = (IRfNamedElement)((IAdaptable)this.fElement).getAdapter(IRfNamedElement.class)) != null) {
            IRfSingleLangProject rfProject = namedElement.getRfProject();
            if (rfProject != null) {
                this.fProject = rfProject.getProject();
                return this.fProject;
            }
            return null;
        }
        if (this.fElement instanceof IDVTElementWrapper) {
            return ((IDVTElementWrapper)this.fElement).getProject();
        }
        return super.getProject();
    }

    public Object getGoToElement() {
        return this.fGoToElement;
    }

    public void setGoToElement(Object fgoToElement) {
        this.fGoToElement = fgoToElement;
    }
}

