/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.views.DVTViewContributorsCommon;
import ro.amiq.dvt.ui.views.IDVTViewContributor;

public class DVTViewContributors
extends DVTViewContributorsCommon {
    private static DVTViewContributors INSTANCE;
    private static final Object SYNC_OBJECT;
    public static final String DVT_VIEW_EXTENSION_POINT_ID = "ro.amiq.dvt.viewContributors";
    public static final String DVT_VIEW_CONTRIBUTOR_ELEMENT = "viewContributors";
    private static List<IDVTViewContributor> fAllContributors;

    static {
        SYNC_OBJECT = new Object();
        fAllContributors = new ArrayList<IDVTViewContributor>();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(DVT_VIEW_EXTENSION_POINT_ID);
        IExtension[] iExtensionArray = extensionPoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement configurationElement = iConfigurationElementArray[n4];
                if (!DVT_VIEW_CONTRIBUTOR_ELEMENT.equals(configurationElement.getName())) {
                    DVTLogger.INSTANCE.logError((Throwable)new Exception("Invalid element: " + configurationElement + " for extension point: " + DVT_VIEW_EXTENSION_POINT_ID));
                }
                try {
                    Object executableExtension = configurationElement.createExecutableExtension("class");
                    fAllContributors.add((IDVTViewContributor)executableExtension);
                }
                catch (CoreException e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
                ++n4;
            }
            ++n2;
        }
        Collections.sort(fAllContributors, (o1, o2) -> {
            if (o1 == null || o1.getLanguageKind() == null) {
                return -1;
            }
            if (o2 == null || o2.getLanguageKind() == null) {
                return 1;
            }
            return o1.getLanguageKind().VIEW_NAME.toLowerCase().compareTo(o2.getLanguageKind().VIEW_NAME.toLowerCase());
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DVTViewContributors getInstance() {
        if (INSTANCE == null) {
            Object object = SYNC_OBJECT;
            synchronized (object) {
                INSTANCE = new DVTViewContributors();
            }
        }
        return INSTANCE;
    }

    @Override
    protected List<IDVTViewContributor> getAllContributors() {
        return fAllContributors;
    }
}

