/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views;

import org.eclipse.ui.IViewPart;
import ro.amiq.dvt.ui.views.ViewDataContainer;

public class DVTViewEvent {
    public static final String VLOGDT_EDITOR = "ro.amiq.vlogdt.ui.editor.VlogEditor";
    public static final String VHDLDT_EDITOR = "ro.amiq.vhdldt.ui.editor.VhdlEditor";
    public static final String EDT_EDITOR = "ro.amiq.edt.ui.editor.EEditor";
    public static final String PSSDT_EDITOR = "ro.amiq.pssdt.ui.editor.PSSEditor";
    public static final String SLNDT_EDITOR = "ro.amiq.slndt.ui.editor.SLNEditor";
    public static final String MSDLDT_EDITOR = "ro.amiq.msdldt.ui.editor.MSDLEditor";
    public static final String CONTEXT_MENU = "context_menu";
    public EventKind fKind;
    public ViewDataContainer fDataContainer;
    public String fSourceId;
    public boolean fForceOverride;
    public CustomEventImplementation fCustomImplementation;

    public DVTViewEvent(EventKind kind, String sourceId, ViewDataContainer dataContainer) {
        this.fKind = kind;
        this.fSourceId = sourceId;
        this.fDataContainer = dataContainer;
        this.fForceOverride = true;
        this.fCustomImplementation = null;
    }

    public DVTViewEvent(EventKind kind, ViewDataContainer dataContainer, String sourceId, boolean forceOverride, CustomEventImplementation customImplementation) {
        this.fKind = kind;
        this.fSourceId = sourceId;
        this.fDataContainer = dataContainer;
        this.fForceOverride = forceOverride;
        this.fCustomImplementation = customImplementation;
    }

    public EventKind getKind() {
        return this.fKind;
    }

    public String getSourceId() {
        return this.fSourceId;
    }

    public ViewDataContainer getDataContainer() {
        return this.fDataContainer;
    }

    public boolean hasDataContainer() {
        return this.fDataContainer != null;
    }

    public boolean isSourceEditor() {
        return this.fSourceId.equals(VLOGDT_EDITOR) || this.fSourceId.equals(EDT_EDITOR) || this.fSourceId.equals(VHDLDT_EDITOR) || this.fSourceId.equals(SLNDT_EDITOR) || this.fSourceId.equals(MSDLDT_EDITOR) || this.fSourceId.equals(PSSDT_EDITOR);
    }

    public boolean isForceOverride() {
        return this.fForceOverride;
    }

    public void setOverrideView(boolean override) {
        this.fForceOverride = override;
    }

    public CustomEventImplementation getCustomImplementation() {
        return this.fCustomImplementation;
    }

    public void setCustomImplementation(CustomEventImplementation customImplementation) {
        this.fCustomImplementation = customImplementation;
    }

    public static abstract class CustomEventImplementation {
        protected IViewPart view;

        public void setUp(IViewPart view) {
            this.view = view;
        }

        public abstract void run();
    }

    public static enum EventKind {
        TRIGGER,
        CUSTOM;

    }
}

