/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.search.ui.ISearchResultPage;
import org.eclipse.search.ui.ISearchResultViewPart;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.IResourceSelectionChangeListener;
import ro.amiq.dvt.ai.AIHostContributorManager;
import ro.amiq.dvt.ai.IAIHostContributor;
import ro.amiq.dvt.diagrams.uml.editor.DUMLEditorFactory;
import ro.amiq.dvt.dynamicactions.launchconfigs.DynamicLaunchConfigToolbar;
import ro.amiq.dvt.interpreter.XUpdateEvent;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTStartupConstants;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.actions.guifilters.GUIFiltersHandler;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.lazy.outline.DVTLazyOutlinePage;
import ro.amiq.dvt.ui.editor.scopebreadcrumb.ScopeBreadcrumbViewer;
import ro.amiq.dvt.ui.guifilters.DVTMarkerViewsUpdater;
import ro.amiq.dvt.ui.guifilters.GUIFilter;
import ro.amiq.dvt.ui.search.text.BaseFileSearchPage;
import ro.amiq.dvt.ui.views.BuildEventManager;
import ro.amiq.dvt.ui.views.BuildEvents;
import ro.amiq.dvt.ui.views.DVTViewManagerCommon;
import ro.amiq.dvt.ui.views.IDVTView;
import ro.amiq.dvt.ui.views.TreeViewContentProvider;
import ro.amiq.dvt.ui.views.ViewDataContainer;
import ro.amiq.dvt.ui.views.ViewKind;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.interpreter.IInterpreterViews;
import ro.amiq.dvt.ui.views.interpreter.IInterpreterViewsCommon;

public class DVTViewManager
extends DVTViewManagerCommon
implements IResourceSelectionChangeListener,
IWindowListener {
    private static final String SEARCH_VIEW_ID = "org.eclipse.search.ui.views.SearchView";
    private static final Object fSyncInstance = new Object();
    private static Map<IWorkbenchWindow, DVTViewManager> fInstances = new HashMap<IWorkbenchWindow, DVTViewManager>();
    private final Set<IDVTView> fViews = Collections.newSetFromMap(new ConcurrentHashMap());
    private IWorkbenchWindow fWorkbenchWindow;
    private IPartListener2 fPartListener;

    public DVTViewManager(IWorkbenchWindow window) {
        if (window == null) {
            return;
        }
        this.fWorkbenchWindow = window;
        this.registerPartListener(window);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.addResourceChangeListener(new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                try {
                    IResourceDelta eventDelta = event.getDelta();
                    if (eventDelta != null) {
                        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                        int n = iProjectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IResourceDelta delta;
                            IProject project = iProjectArray[n2];
                            if (project.isAccessible() && (delta = eventDelta.findMember(project.getFullPath().append(".dvt/content_filters.xml"))) != null && ((delta.getFlags() & 0x100) != 0 || (delta.getFlags() & 0x40000) != 0 || (delta.getFlags() & 0x1000) != 0 || (delta.getFlags() & 0x2000) != 0 || delta.getKind() == 2 || delta.getKind() == 1 || delta.getKind() == 4)) {
                                DVTViewManager.this.notifyViewsWithBuildEvents(BuildEvents.GUI_FILTERS_PROJECT, project, ViewsUtils.ALL_VIEWS);
                            }
                            ++n2;
                        }
                        event.getDelta().accept(new IResourceDeltaVisitor(){

                            public boolean visit(IResourceDelta delta) throws CoreException {
                                if (delta == null) {
                                    return false;
                                }
                                if (delta.getResource() instanceof IWorkspaceRoot) {
                                    return true;
                                }
                                if (!(delta.getResource() instanceof IProject)) {
                                    return false;
                                }
                                IProject project = (IProject)delta.getResource();
                                if (!this.projectWasOpened(project, delta)) {
                                    return false;
                                }
                                Object tryRestoreProp = project.getSessionProperty(DVTStartupConstants.QN_DVT_TRY_RESTORE);
                                boolean tryRestore = tryRestoreProp instanceof Boolean && (Boolean)tryRestoreProp != false;
                                PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
                                    try {
                                        for (IDVTView view : (this).DVTViewManager.this.fViews) {
                                            if (!view.getKind().contains((Object)ViewKind.PROJECT_INFORMATION) && !view.getKind().contains((Object)ViewKind.FILE_INFORMATION) && !view.getKind().contains((Object)ViewKind.DYNAMIC_ELEMENT_INFORMATION)) continue;
                                            view.setInput(new ViewDataContainer((IProject)delta.getResource(), null));
                                            if (tryRestore) continue;
                                            ViewsUtils.updateView(view, null, false);
                                        }
                                    }
                                    catch (Throwable e) {
                                        DVTLogger.INSTANCE.logError(e);
                                    }
                                });
                                return false;
                            }

                            private boolean projectWasOpened(IProject project, IResourceDelta delta) {
                                return (delta.getFlags() & 0x4000) != 0 && project.isOpen();
                            }
                        });
                    }
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
        });
        DVTPlugin.getSelectionManager().addResourceSelectionChangeListener(window, this);
        BuildEventManager.getInstance().registerListener(this);
        PlatformUI.getWorkbench().addWindowListener((IWindowListener)this);
        PlatformUI.getWorkbench().getWorkingSetManager().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("workingSetContentChange".equals(event.getProperty())) {
                    DynamicLaunchConfigToolbar.INSTANCE.refresh();
                }
            }
        });
    }

    private void registerPartListener(IWorkbenchWindow window) {
        IPartService partService = (IPartService)window.getService(IPartService.class);
        if (partService == null) {
            return;
        }
        this.fPartListener = new IPartListener2(){

            public void partVisible(IWorkbenchPartReference partRef) {
                IDVTView dvtView;
                IWorkbenchPart ref = partRef.getPart(true);
                if (ref instanceof IDVTView && (dvtView = (IDVTView)ref).isDirty()) {
                    ViewsUtils.updateView(dvtView, null, true);
                }
            }

            public void partOpened(IWorkbenchPartReference partRef) {
            }

            public void partInputChanged(IWorkbenchPartReference partRef) {
            }

            public void partHidden(IWorkbenchPartReference partRef) {
            }

            public void partDeactivated(IWorkbenchPartReference partRef) {
            }

            public void partClosed(IWorkbenchPartReference partRef) {
            }

            public void partBroughtToTop(IWorkbenchPartReference partRef) {
            }

            public void partActivated(IWorkbenchPartReference partRef) {
            }
        };
        partService.addPartListener(this.fPartListener);
    }

    private void disposePartListener() {
        IPartService partService = (IPartService)this.fWorkbenchWindow.getService(IPartService.class);
        if (partService == null) {
            return;
        }
        partService.removePartListener(this.fPartListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DVTViewManager getInstanceByWorkbenchWindow(IWorkbenchWindow window) {
        DVTViewManager instance = null;
        Object object = fSyncInstance;
        synchronized (object) {
            if (window != null) {
                instance = fInstances.get(window);
            }
            if (instance == null) {
                instance = new DVTViewManager(window);
                if (window != null) {
                    fInstances.put(window, instance);
                }
            }
        }
        return instance;
    }

    public static DVTViewManager getInstanceByCurrentWorkbenchWindow() {
        return DVTViewManager.getInstanceByWorkbenchWindow(Utils.getActiveWorkbenchWindow());
    }

    public void registerView(IDVTView view) {
        this.fViews.add(view);
        String viewId = view.getId();
        if (!ViewsUtils.ALL_VIEWS.contains(viewId)) {
            DVTLogger.INSTANCE.logError((Throwable)new RuntimeException("Incomplete view register for: " + viewId));
        }
        if (view instanceof IInterpreterViews && IInterpreterViewsCommon.isInterpreterMode()) {
            view.setInput(new ViewDataContainer(DVTPlugin.getSelectionManager().getLastSelectedProject(), null));
            view.update(BuildEvents.INTERPRETER_MODE);
            return;
        }
        if (view.getKind().contains((Object)ViewKind.PROJECT_INFORMATION) || view.getKind().contains((Object)ViewKind.FILE_INFORMATION) || view.getKind().contains((Object)ViewKind.DYNAMIC_ELEMENT_INFORMATION)) {
            view.setInput(new ViewDataContainer(DVTPlugin.getSelectionManager().getLastSelectedProject(), null));
        }
        ViewsUtils.updateView(view, null, false);
    }

    public void unregisterView(IDVTView view) {
        this.fViews.remove(view);
    }

    public void clearAllViews() {
        if (this.fWorkbenchWindow == null) {
            return;
        }
        for (IDVTView view : this.fViews) {
            if (view == null) continue;
            view.clean();
        }
    }

    @Override
    public void notifyViewsWithBuildEventsInternal(final BuildEvents event, final IProject project, Set<?> classes, Set<String> updateViewIds) {
        IAIHostContributor aiHostContributor;
        if (this.fWorkbenchWindow == null) {
            return;
        }
        if (event == BuildEvents.FULL_BUILD || event == BuildEvents.GUI_FILTERS_PROJECT) {
            filtering = GUIFiltersHandler.isFilteringEnabled();
            DVTViewManager.loadGuiFilters(project, filtering);
            this.updateGuiFilteredViews(event);
        } else if (event == BuildEvents.GUI_FILTERS_WORKSPACE) {
            filtering = GUIFiltersHandler.isFilteringEnabled();
            if (filtering) {
                DVTViewManager.loadGuiFilters(project, filtering);
                this.updateGuiFilteredViews(event);
            } else {
                this.removeNonPreferenceFilters();
                this.updateGuiFilteredViews(event);
            }
        }
        for (final IDVTView view : this.fViews) {
            IDVTView parentView;
            if (view == null) continue;
            if (!ViewsUtils.ALL_VIEWS.contains(view.getId())) {
                DVTLogger.INSTANCE.logError((Throwable)new RuntimeException("Unsupported view update: " + view.getId()));
            }
            if (updateViewIds != null && !updateViewIds.contains(view.getId()) || !this.canHandleBuildEvent(event, view.getKind()) && ((parentView = view.getParentView()) == null || updateViewIds == null || updateViewIds.contains(parentView.getId())) || classes != null && !classes.contains(view.getClass())) continue;
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ViewDataContainer currentDataContainer = view.getDataContainer();
                    if (currentDataContainer != null && project != currentDataContainer.getProject()) {
                        return;
                    }
                    if (event == BuildEvents.CLEAN_BUILD) {
                        view.clean();
                    } else {
                        ViewsUtils.updateView(view, event, false);
                    }
                }
            });
        }
        if (event != BuildEvents.CLEAN_BUILD) {
            DUMLEditorFactory.getInstance().refreshUMLDiagrams(this.fWorkbenchWindow, event == BuildEvents.GUI_FILTERS_PROJECT || event == BuildEvents.GUI_FILTERS_WORKSPACE ? null : project);
        }
        if ((aiHostContributor = AIHostContributorManager.INSTANCE.getAiHostContributor()) != null) {
            aiHostContributor.invalidateAIToolsRegistryCache();
        }
    }

    @Override
    protected synchronized void removeNonPreferenceFilters() {
        for (List filters : fGuiFilters.values()) {
            for (GUIFilter filter : filters) {
                if (filter.getType() == GUIFilter.FilterType.PREFERENCE) continue;
                filters.remove(filter);
            }
        }
    }

    private boolean canHandleProjectClose(EnumSet<ViewKind> viewKinds) {
        return !viewKinds.contains((Object)ViewKind.NO_INFORMATION);
    }

    @Override
    protected void updateGuiFilteredViews(final BuildEvents event) {
        DVTMarkerViewsUpdater.updateMarkerViews();
        if (this.fWorkbenchWindow.getActivePage() == null) {
            return;
        }
        this.fWorkbenchWindow.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IEditorPart editor = DVTViewManager.this.fWorkbenchWindow.getActivePage().getActiveEditor();
                if (editor != null && editor.getAdapter(IContentOutlinePage.class) instanceof DVTLazyOutlinePage && (event == BuildEvents.GUI_FILTERS_PROJECT || event == BuildEvents.GUI_FILTERS_WORKSPACE)) {
                    DVTLazyOutlinePage page = (DVTLazyOutlinePage)editor.getAdapter(IContentOutlinePage.class);
                    page.update(true);
                }
                IEditorReference[] iEditorReferenceArray = DVTViewManager.this.fWorkbenchWindow.getActivePage().getEditorReferences();
                int n = iEditorReferenceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    DVTEditor inactiveEditor;
                    Object page;
                    IEditorReference editorReference = iEditorReferenceArray[n2];
                    IEditorPart editorPart = editorReference.getEditor(false);
                    if (editorPart instanceof DVTEditor && editorPart != editor && (page = (inactiveEditor = (DVTEditor)editorPart).getAdapter(IContentOutlinePage.class)) instanceof DVTLazyOutlinePage) {
                        ((DVTLazyOutlinePage)page).setDirty(true);
                    }
                    ++n2;
                }
                iEditorReferenceArray = DVTViewManager.this.fWorkbenchWindow.getActivePage().getViewReferences();
                n = iEditorReferenceArray.length;
                n2 = 0;
                while (n2 < n) {
                    ISearchResultPage searchViewPage;
                    ISearchResultViewPart searchResultView;
                    IEditorReference viewReference = iEditorReferenceArray[n2];
                    if (DVTViewManager.SEARCH_VIEW_ID.equals(viewReference.getId()) && (searchResultView = (ISearchResultViewPart)viewReference.getView(true)) != null && (searchViewPage = searchResultView.getActivePage()) instanceof BaseFileSearchPage) {
                        ((BaseFileSearchPage)searchViewPage).refresh(true);
                    }
                    ++n2;
                }
                if (event != BuildEvents.GUI_FILTERS_PROJECT && event != BuildEvents.GUI_FILTERS_WORKSPACE) {
                    return;
                }
                for (IEditorReference editorReference : Utils.getCurrentlyOpenEditorReferences()) {
                    IWorkbenchPart visibleEditor = editorReference.getPart(false);
                    if (!(visibleEditor instanceof DVTEditor) || !DVTViewManager.this.fWorkbenchWindow.getActivePage().isPartVisible(visibleEditor)) continue;
                    ((DVTEditor)visibleEditor).updateBreadcrumbLabels(ScopeBreadcrumbViewer.class);
                }
            }
        });
    }

    public void notifyProjectClose(final IProject project) {
        BuildEventManager.getInstance().notifyXModelListenerResourceChanges(project, XUpdateEvent.PROJECT_CLOSE);
        for (final IDVTView view : this.fViews) {
            if (view == null || !this.canHandleProjectClose(view.getKind())) continue;
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    ViewDataContainer currentDataContainer = view.getDataContainer();
                    if (currentDataContainer == null) {
                        return;
                    }
                    IProject currentProject = currentDataContainer.getProject();
                    if (currentProject == null) {
                        return;
                    }
                    if (currentProject.getName().equals(project.getName())) {
                        view.setInput(new ViewDataContainer(null, null));
                        ViewsUtils.updateView(view, null, false);
                    }
                }
            });
        }
    }

    private boolean canHandleProjectSelectionChanged(EnumSet<ViewKind> viewKind) {
        return !viewKind.contains((Object)ViewKind.NO_INFORMATION) && !viewKind.contains((Object)ViewKind.FIXED_ELEMENT_INFORMATION);
    }

    private boolean canHandleResourceSelectionChanged(EnumSet<ViewKind> viewKind) {
        return viewKind.contains((Object)ViewKind.CAN_HANDLE_RESOURCE_SELECTION_CHANGED);
    }

    private void projectSelectionChanged(final IResource resource) {
        if (resource == null) {
            return;
        }
        final IProject newProject = resource.getProject();
        BuildEventManager.getInstance().notifyXModelListenerResourceChanges(newProject, XUpdateEvent.RESOURCE_SELECTION);
        for (final IDVTView view : this.fViews) {
            if (view == null || !this.canHandleProjectSelectionChanged(view.getKind())) continue;
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (resource == null) {
                        return;
                    }
                    ViewDataContainer currentDataContainer = view.getDataContainer();
                    if (currentDataContainer == null) {
                        return;
                    }
                    IProject currentProject = currentDataContainer.getProject();
                    if (currentProject == null || !newProject.getName().equals(currentProject.getName())) {
                        view.setInput(new ViewDataContainer(newProject, null));
                        ViewsUtils.updateView(view, null, false);
                    }
                }
            });
        }
    }

    private void refreshSelection(final IResource resource) {
        for (final IDVTView view : this.fViews) {
            if (view == null || !this.canHandleResourceSelectionChanged(view.getKind())) continue;
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (resource == null) {
                        return;
                    }
                    IProject project = resource.getProject();
                    ViewDataContainer currentDataContainer = view.getDataContainer();
                    if (currentDataContainer == null) {
                        return;
                    }
                    IProject currentProject = currentDataContainer.getProject();
                    if (currentProject == null) {
                        return;
                    }
                    if (currentProject.getName().equals(project.getName())) {
                        view.refreshSelection(resource);
                    }
                }
            });
        }
    }

    @Override
    public void resourceSelectionChanged(IResource resource) {
        this.projectSelectionChanged(resource);
        this.refreshSelection(resource);
    }

    public void windowActivated(IWorkbenchWindow window) {
    }

    public void windowDeactivated(IWorkbenchWindow window) {
    }

    public void windowClosed(IWorkbenchWindow window) {
        if (window == this.fWorkbenchWindow) {
            this.dispose();
        }
    }

    public void windowOpened(IWorkbenchWindow window) {
    }

    public Set<IDVTView> getViews() {
        return this.fViews;
    }

    private void dispose() {
        BuildEventManager.getInstance().unregisterListener(this);
        DVTPlugin.getSelectionManager().removeResourceSelectionChangeListener(this.fWorkbenchWindow, this);
        fInstances.remove(this.fWorkbenchWindow);
        this.disposePartListener();
        PlatformUI.getWorkbench().removeWindowListener((IWindowListener)this);
    }

    public void updateViewLabels(Set<?> classes, EnumSet<TreeViewContentProvider.LabelUpdateKind> labelUpdateKind) {
        for (IDVTView view : this.fViews) {
            if (classes != null && !classes.contains(view.getClass())) continue;
            ViewsUtils.updateViewLabels(view, labelUpdateKind);
        }
    }
}

