/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.resources.IProject;
import org.xml.sax.SAXParseException;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.builders.DVTBuildConsoleRegistry;
import ro.amiq.dvt.model.FileCompileInfo;
import ro.amiq.dvt.settings.DVTSFiles;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.guifilters.DVTGUIFiltersTopFilePatternExpander;
import ro.amiq.dvt.ui.guifilters.DVTGUIFiltersXMLParser;
import ro.amiq.dvt.ui.guifilters.DVTPredefinedGUIFilters;
import ro.amiq.dvt.ui.guifilters.GUIFilter;
import ro.amiq.dvt.ui.guifilters.ViewSet;
import ro.amiq.dvt.ui.views.BuildEvents;
import ro.amiq.dvt.ui.views.IBuildEventManagerListener;
import ro.amiq.dvt.ui.views.ViewKind;
import ro.amiq.dvt.ui.views.ViewsUtils;

public abstract class DVTViewManagerCommon
implements IBuildEventManagerListener {
    public static final String GUI_FILTERS_XML = ".dvt/content_filters.xml";
    protected static Map<IProject, List<GUIFilter>> fGuiFilters = new HashMap<IProject, List<GUIFilter>>();

    public static synchronized void loadGuiFilters(IProject project, boolean filtering) {
        if (project == null || !project.isOpen()) {
            return;
        }
        fGuiFilters.remove(project);
        CopyOnWriteArrayList<GUIFilter> projectFilters = new CopyOnWriteArrayList<GUIFilter>();
        projectFilters.addAll(DVTPredefinedGUIFilters.getPreferenceFilters());
        fGuiFilters.put(project, projectFilters);
        if (!filtering) {
            return;
        }
        try {
            Set<GUIFilter> predefinedFilters = DVTPredefinedGUIFilters.getPredefinedFilters(project);
            projectFilters.addAll(predefinedFilters);
            ArrayList<File> guiFilterFiles = DVTSFiles.GUI_FILTERS.getAllFiles(true);
            if (guiFilterFiles == null) {
                guiFilterFiles = new ArrayList<File>();
            }
            guiFilterFiles.add(project.getLocation().append(GUI_FILTERS_XML).toFile());
            for (File guiFiltersFile : guiFilterFiles) {
                if (!guiFiltersFile.exists()) continue;
                DVTGUIFiltersXMLParser filterParser = DVTGUIFiltersXMLParser.newParser(project, guiFiltersFile);
                projectFilters.addAll(filterParser.load());
                for (String message : filterParser.getMessages()) {
                    DVTViewManagerCommon.reportToConsole(project, message);
                }
            }
            DVTGUIFiltersTopFilePatternExpander.expand(projectFilters, project);
            if (!projectFilters.isEmpty()) {
                fGuiFilters.put(project, projectFilters);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            DVTViewManagerCommon.reportToConsole(project, "Failed to load filters for project " + project.getName() + " because: ");
            String additionalInfo = "";
            if (e instanceof SAXParseException) {
                additionalInfo = "In " + ((SAXParseException)e).getSystemId() + " at line " + ((SAXParseException)e).getLineNumber() + ": ";
            }
            DVTViewManagerCommon.reportToConsole(project, String.valueOf(additionalInfo) + e.getMessage());
        }
    }

    protected synchronized void removeNonPreferenceFilters() {
        for (Map.Entry<IProject, List<GUIFilter>> project : fGuiFilters.entrySet()) {
            List<GUIFilter> filters = project.getValue();
            for (GUIFilter filter : filters) {
                if (filter.getType() == GUIFilter.FilterType.PREFERENCE) continue;
                filters.remove(filter);
            }
        }
    }

    protected static synchronized void reportToConsole(IProject project, String string) {
        DVTBuildConsoleRegistry.getConsole(project).print(string);
    }

    public static synchronized List<GUIFilter> getGuiFilters(IProject project) {
        return fGuiFilters.get(project);
    }

    public static synchronized List<GUIFilter> getGuiFilters(IProject project, ViewSet.ViewName viewName) {
        ArrayList<GUIFilter> result = new ArrayList<GUIFilter>();
        List<GUIFilter> filters = DVTViewManagerCommon.getGuiFilters(project);
        if (filters == null || filters.isEmpty()) {
            return Collections.emptyList();
        }
        for (GUIFilter filter : filters) {
            Set<ViewSet.ViewName> views;
            ViewSet viewSet = filter.getViewSet();
            if (viewSet == null || (views = viewSet.getViews()) == null || !views.contains((Object)viewName)) continue;
            result.add(filter);
        }
        return result;
    }

    public static synchronized boolean hasGuiFilters(IProject project, ViewSet.ViewName viewName) {
        List<GUIFilter> filters = DVTViewManagerCommon.getGuiFilters(project);
        if (filters == null || filters.isEmpty()) {
            return false;
        }
        for (GUIFilter filter : filters) {
            Set<ViewSet.ViewName> views;
            ViewSet viewSet = filter.getViewSet();
            if (viewSet == null || (views = viewSet.getViews()) == null || !views.contains((Object)viewName)) continue;
            return true;
        }
        return false;
    }

    public void notifyViewsWithBuildEvents(BuildEvents event, IProject project, Set<String> updateViewIds) {
        this.notifyViewsWithBuildEventsInternal(event, project, null, updateViewIds);
    }

    @Override
    public void notifyFullBuild(IProject project) {
        this.notifyViewsWithBuildEvents(BuildEvents.FULL_BUILD, project, ViewsUtils.ALL_VIEWS);
    }

    @Override
    public void notifyIncrementalBuild(IProject project, Map<LanguageKind, Set<FileCompileInfo>> changedFiles, Set<String> updateViewIds) {
        if (changedFiles == null) {
            return;
        }
        for (Set<FileCompileInfo> languageFileInfos : changedFiles.values()) {
            if (languageFileInfos == null) continue;
            for (FileCompileInfo fileCompileInfo : languageFileInfos) {
                if (fileCompileInfo == null || !fileCompileInfo.isIncrCompiled()) continue;
                this.notifyViewsWithBuildEvents(BuildEvents.INCREMENTAL_BUILD, project, updateViewIds);
                return;
            }
        }
    }

    @Override
    public void notifyCleanBuild(IProject project) {
        this.notifyViewsWithBuildEvents(BuildEvents.CLEAN_BUILD, project, ViewsUtils.ALL_VIEWS);
    }

    protected boolean canHandleBuildEvent(BuildEvents event, EnumSet<ViewKind> viewKinds) {
        if (viewKinds.contains((Object)ViewKind.NO_INFORMATION)) {
            return false;
        }
        if ((event == BuildEvents.GUI_FILTERS_WORKSPACE || event == BuildEvents.GUI_FILTERS_PROJECT) && viewKinds.contains((Object)ViewKind.CAN_HANDLE_GUI_FILTERS)) {
            return true;
        }
        if (event == BuildEvents.FULL_BUILD && (viewKinds.contains((Object)ViewKind.CAN_HANDLE_FULL_BUILD) || viewKinds.contains((Object)ViewKind.CAN_HANDLE_ALL_BUILD_EVENTS))) {
            return true;
        }
        if (event == BuildEvents.INCREMENTAL_BUILD && (viewKinds.contains((Object)ViewKind.CAN_HANDLE_INCREMENTAL_BUILD) || viewKinds.contains((Object)ViewKind.CAN_HANDLE_ALL_BUILD_EVENTS))) {
            return true;
        }
        return event == BuildEvents.CLEAN_BUILD && (viewKinds.contains((Object)ViewKind.CAN_HANDLE_CLEAN_BUILD) || viewKinds.contains((Object)ViewKind.CAN_HANDLE_ALL_BUILD_EVENTS));
    }

    public void notifySelectedViewsWithBuildEvents(BuildEvents event, IProject project, Set<?> classes) {
        this.notifyViewsWithBuildEventsInternal(event, project, classes, ViewsUtils.ALL_VIEWS);
    }

    protected abstract void notifyViewsWithBuildEventsInternal(BuildEvents var1, IProject var2, Set<?> var3, Set<String> var4);

    protected abstract void updateGuiFilteredViews(BuildEvents var1);
}

