/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import ro.amiq.dvt.ui.views.interpreter.DVTXInterpreterViewsLabelProvider;
import ro.amiq.dvt.ui.views.lazy.tree.LazyTree;
import ro.amiq.dvt.ui.views.registers.RegistersView;

public interface IDVTDynamicTableLayout {
    public static final Map<Integer, TreeColumn> treeColumns = new LinkedHashMap<Integer, TreeColumn>();
    public static final Map<Integer, TableColumn> tableColumns = new LinkedHashMap<Integer, TableColumn>();

    default public void updateOrInstallTableColumn(LazyTree lazyTree, int swtStyle, String name, int columnIndex, int width) {
        Table table = lazyTree.getTopTable();
        Tree tree = lazyTree.getTree();
        if (table == null || tree == null) {
            return;
        }
        TableColumn column = tableColumns.remove(columnIndex);
        if (column == null) {
            column = new TableColumn(table, swtStyle);
        }
        if (column.isDisposed()) {
            return;
        }
        column.setText(name);
        column.setWidth(width);
        this.updateOrInstallTreeColumn(tree, swtStyle, name, columnIndex, width);
        tableColumns.put(columnIndex, column);
        this.addResizeListener(columnIndex, lazyTree, new RegistersView.DVTRegistersViewLabelProviderListener((DVTXInterpreterViewsLabelProvider)lazyTree.getLabelProvider(), column, columnIndex));
    }

    default public void addResizeListener(int columnIndex, LazyTree lazyTree, Runnable customListener) {
        TableColumn tableColumn = tableColumns.get(columnIndex);
        if (tableColumn == null || tableColumn.isDisposed()) {
            return;
        }
        ScrolledComposite scrolledComposite = lazyTree.getScrolledComposite();
        Tree tree = lazyTree.getTree();
        tableColumn.addListener(11, event -> {
            int n1 = 0;
            for (TableColumn column : tableColumns.values()) {
                n1 += column.getWidth();
            }
            scrolledComposite.setMinWidth(n1);
            this.updateOrInstallTreeColumn(tree, 16384, tableColumn.getText(), columnIndex, tableColumn.getWidth());
            if (customListener != null) {
                customListener.run();
            }
        });
    }

    default public void updateOrInstallTreeColumn(Tree tree, int style, String name, int columnIndex, int width) {
        TreeColumn column = treeColumns.remove(columnIndex);
        if (column == null) {
            column = new TreeColumn(tree, style);
        }
        if (column.isDisposed()) {
            return;
        }
        column.setText(name);
        column.setWidth(width);
        treeColumns.put(columnIndex, column);
    }

    default public void dispose(int columnIndex) {
        TreeColumn treeColumn = treeColumns.remove(columnIndex);
        if (treeColumn != null) {
            treeColumn.dispose();
        }
    }
}

