/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.interpreter.IXXVMComponent;
import ro.amiq.dvt.model.reflection.BindingRuleWrapper;
import ro.amiq.dvt.model.reflection.DummyDesignElement;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.ErrorDesignElement;
import ro.amiq.dvt.model.reflection.IRfBaseElement;
import ro.amiq.dvt.model.reflection.IRfBreadcrumbElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.symbolcollector.ISymbolCollectorPrerequisite;
import ro.amiq.dvt.ui.decorators.util.ILazyOverlayElement;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbSegment;
import ro.amiq.dvt.ui.views.designhierarchy.DHViewUtils;

public abstract class IDVTElementWrapper
implements IAdaptable,
ILazyOverlayElement,
ISymbolCollectorPrerequisite {
    public static final int COLLAPSED = -2;
    public static final int ALL_LEVELS = -1;
    public static final int IRRELEVANT = 0;
    public static final int EXPANDED = 1;
    protected IProject fProject;
    protected Object fElement;
    protected Map<Object, Object> fAdditionalInfo;

    public IDVTElementWrapper(Object element) {
        this.fElement = element;
    }

    public abstract Object getItem();

    public abstract void setExpanded(int var1);

    public abstract int getExpanded();

    public Object getRfElement() {
        return this.fElement;
    }

    public <T> T getRfElement(Class<T> clazz) {
        if (clazz != null && clazz.isInstance(this.fElement)) {
            return (T)this.fElement;
        }
        return null;
    }

    public <T extends IDVTElementWrapper> List<T> getAllChildren() {
        return this.getChildren();
    }

    public abstract <T extends IDVTElementWrapper> List<T> getChildren();

    public abstract IDVTElementWrapper getFirstChild();

    public abstract void setItem(Object var1);

    public abstract Object getSelectedElement();

    public abstract void setSelectedElement(Object var1);

    public <V> V getAdditionalInfo(Object attribute) {
        if (this.fAdditionalInfo == null) {
            return null;
        }
        return (V)this.fAdditionalInfo.get(attribute);
    }

    public <T, V> void setAdditionalInfo(T attribute, V additionalInfo) {
        if (this.fAdditionalInfo == null) {
            this.fAdditionalInfo = new HashMap<Object, Object>();
        }
        this.fAdditionalInfo.put(attribute, additionalInfo);
    }

    public <V> V removeAdditionalInfo(Object attribute) {
        if (this.fAdditionalInfo == null) {
            return null;
        }
        return (V)this.fAdditionalInfo.remove(attribute);
    }

    public abstract IDVTElementWrapper getParent();

    public abstract void setParent(IDVTElementWrapper var1);

    public abstract boolean isGrayIcon();

    public abstract void setUniqueID(long var1);

    public abstract long getUniqueID();

    public abstract IDVTElementWrapper create();

    public abstract void addChild(IDVTElementWrapper var1);

    public abstract <T extends IDVTElementWrapper> void addChildren(List<T> var1);

    public abstract <T extends IDVTElementWrapper> void setChildren(List<T> var1);

    public abstract boolean hasChildren();

    public abstract void removeChild(IDVTElementWrapper var1);

    public abstract void deepClean();

    public boolean shouldHaveCustomColor() {
        return false;
    }

    @Override
    public IProject getProject() {
        if (this.fProject != null) {
            return this.fProject;
        }
        if (this.fElement == null) {
            return null;
        }
        if (this.fElement instanceof IRfBaseElement && ((IRfBaseElement)this.fElement).getRfProject() != null) {
            IRfSingleLangProject rfProject = ((IRfBaseElement)this.fElement).getRfProject();
            if (rfProject != null) {
                return rfProject.getProject();
            }
            return null;
        }
        if (this.fElement instanceof IXXVMComponent) {
            return ((IXXVMComponent)this.fElement).getIProject();
        }
        return null;
    }

    public void setProject(IProject project) {
        this.fProject = project;
    }

    public abstract boolean getAccessDecoratorEnable();

    public abstract LanguageKind getLanguageKind();

    public ElementPath getInstancePath() {
        return DHViewUtils.getInstancePath(this);
    }

    public void setAssociatedElements(IRfNamedElement connectComponent, BindingRuleWrapper connectBind, IRfNamedElement connectDesign) {
    }

    public IRfNamedElement getConnectComponent() {
        return null;
    }

    public BindingRuleWrapper getConnectBind() {
        return null;
    }

    public IRfNamedElement getConnectDesign() {
        return null;
    }

    public void setInstanceType(IRfDesignElement element) {
    }

    public IRfNamedElement getInstanceType() {
        return null;
    }

    public List<BreadcrumbSegment> getAllElementsToRoot(boolean addSelf, boolean forVH) {
        IRfBreadcrumbElement currentElement = this.getRfElement(IRfBreadcrumbElement.class);
        if (currentElement == null) {
            return null;
        }
        ArrayList<BreadcrumbSegment> elementsList = new ArrayList<BreadcrumbSegment>();
        if (addSelf) {
            this.addSegment(currentElement, elementsList, forVH);
        }
        IDVTElementWrapper parentWrapper = this.getParent();
        while (parentWrapper != null) {
            currentElement = parentWrapper.getRfElement(IRfBreadcrumbElement.class);
            if (currentElement == null || currentElement instanceof DummyDesignElement || currentElement instanceof ErrorDesignElement) {
                if (elementsList.isEmpty()) {
                    this.addSegment(this.getRfElement(IRfBreadcrumbElement.class), elementsList, forVH);
                }
                Collections.reverse(elementsList);
                return elementsList;
            }
            this.addSegment(currentElement, elementsList, forVH);
            parentWrapper = parentWrapper.getParent();
        }
        Collections.reverse(elementsList);
        if (elementsList.isEmpty()) {
            this.addSegment(currentElement, elementsList, forVH);
        }
        return elementsList;
    }

    private void addSegment(IRfBreadcrumbElement currentElement, List<BreadcrumbSegment> elementsList, boolean forVH) {
        if (!forVH) {
            elementsList.add(new BreadcrumbSegment(currentElement));
            return;
        }
        if (currentElement instanceof IRfNamedElement) {
            currentElement = (IRfBreadcrumbElement)((Object)((IRfNamedElement)currentElement).getDeclaration());
        }
        elementsList.add(new BreadcrumbSegment(currentElement));
    }

    public List<IRfNamedElement> getAllNamedElementsToRoot(boolean addSelf) {
        ArrayList<IRfNamedElement> result = new ArrayList<IRfNamedElement>();
        List<BreadcrumbSegment> allElementsToRoot = this.getAllElementsToRoot(addSelf, false);
        if (allElementsToRoot == null || allElementsToRoot.isEmpty()) {
            return Collections.emptyList();
        }
        BreadcrumbSegment root = allElementsToRoot.get(0);
        if (root.getElement() instanceof IRfInstanceElement) {
            result.add(DesignUtils.getDesign(DesignUtils.DesignRequest.of((IRfNamedElement)root.getElement())));
        } else {
            result.add((IRfNamedElement)root.getElement());
        }
        if (allElementsToRoot.size() == 1) {
            return result;
        }
        int i = 1;
        while (i < allElementsToRoot.size()) {
            BreadcrumbSegment breadcrumbSegment = allElementsToRoot.get(i);
            if (!(breadcrumbSegment.getElement() instanceof IRfNamedElement)) {
                return Collections.emptyList();
            }
            result.add((IRfNamedElement)breadcrumbSegment.getElement());
            ++i;
        }
        return result;
    }

    public void unfilter() {
    }

    public int getCustomColor() {
        return 0;
    }

    public static enum Attribute {
        ARHITECTURE,
        MATCH,
        TO_STRING,
        WHYPATHNODE,
        SHOW_LINE_NUMBERS,
        PREPEND_TEXT,
        OVR_OUTSIDE_PACKAGE,
        WHEN_SUBTYPE,
        TYPES_MEMBERS_DEF,
        CHILDREN_COMPUTED,
        SEQ_TREE_ARGUMENT_SEQ_ITEM_TYPE,
        SEQ_TREE_PREPEND_SCOPE_TYPE,
        SEQ_TREE_METHOD_CALL_INFO,
        SEQ_TREE_ROOT_COMMENT,
        POWER_DOMAIN_NAME,
        POWER_DOMAIN_BG_RGB,
        POWER_DOMAIN_FG_RGB,
        IS_FILTERED,
        IS_DUMMY,
        IS_MESSAGE,
        HAS_CHILDREN,
        MEMBER_PARENT_WRAPPER,
        TYPES_INDEX,
        XVM_BROWSER_IS_PHYSICAL_SEQ,
        PORT_INSTANCE,
        CDT_MACRO_EXPANSION,
        TREE_PATH,
        VHDL_RULES,
        PF_RULE_NAME,
        CLAMP_VALUE,
        QUICK_QUERY_EXTRA_INFO;

    }
}

