/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.diagrams.fsm.model.FSMTransition;
import ro.amiq.dvt.diagrams.wavedrom.BitFieldModel;
import ro.amiq.dvt.model.reflection.HierarchicalElement;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.ui.actions.history.HistoryItem;
import ro.amiq.dvt.ui.trace.connections.model.TCNode;
import ro.amiq.dvt.ui.views.AbstractFilteredView;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.InspectViewGoToInfo;
import ro.amiq.dvt.ui.views.lazy.views.IDVTLazyView;
import ro.amiq.dvt.ui.views.trace.connections.TraceConnectionsPortsView;
import ro.amiq.dvt.ui.views.trace.connections.TraceConnectionsView;

public abstract class InspectViewUpdateEventCommon
extends HistoryItem {
    private TYPE fType;
    private Object fElement;
    private LanguageKind fLanguageKind;
    protected IProject fProject;
    private int fCallOffset = -1;
    private String fCallParserPath;
    private SelectionChangedEvent fEvent;
    private List<InspectViewGoToInfo> fInfos = new ArrayList<InspectViewGoToInfo>();
    private int fNofContextLine;

    public void setCallOffset(int offset) {
        this.fCallOffset = offset;
    }

    public int getCallOffset() {
        return this.fCallOffset;
    }

    public String getCallParserPath() {
        return this.fCallParserPath;
    }

    protected InspectViewUpdateEventCommon(Object element, LanguageKind languageKind, int offset, String callParserPath, IProject project, TYPE type) {
        super("");
        this.fElement = element;
        this.fLanguageKind = languageKind;
        this.fProject = project;
        this.fType = type;
        this.fCallOffset = offset;
        this.fCallParserPath = callParserPath;
    }

    protected InspectViewUpdateEventCommon(Collection<FSMTransition> transitions, Collection<InspectViewGoToInfo> infos, IProject project, LanguageKind languageKind, TYPE type) {
        super("");
        this.fInfos = new ArrayList<InspectViewGoToInfo>(infos);
        this.fElement = transitions;
        this.fProject = project;
        this.fLanguageKind = languageKind;
        this.fType = type;
    }

    protected InspectViewUpdateEventCommon(Collection<InspectViewGoToInfo> infos, IProject project, LanguageKind languageKind, TYPE type) {
        super("");
        this.fInfos = new ArrayList<InspectViewGoToInfo>(infos);
        this.fProject = project;
        this.fLanguageKind = languageKind;
        this.fType = type;
    }

    protected InspectViewUpdateEventCommon(IFile iFile, TYPE type) {
        super("");
        this.fElement = iFile;
        this.fLanguageKind = LanguageKind.VLOG;
        this.fProject = iFile.getProject();
        this.fType = type;
    }

    protected InspectViewUpdateEventCommon(IFile file, TYPE type, int offset) {
        this(file, type);
        this.fCallOffset = offset;
    }

    protected InspectViewUpdateEventCommon(IProject project) {
        super("");
        this.fElement = project;
        this.fLanguageKind = LanguageKind.VLOG;
        this.fProject = project;
        this.fType = TYPE.PROJECT;
    }

    protected InspectViewUpdateEventCommon(IFolder folder) {
        super("");
        this.fElement = folder;
        this.fLanguageKind = LanguageKind.VLOG;
        this.fProject = folder.getProject();
        this.fType = TYPE.FOLDER;
    }

    protected InspectViewUpdateEventCommon(String content) {
        super("");
        this.fElement = content;
        this.fLanguageKind = LanguageKind.VLOG;
        this.fProject = null;
        this.fType = TYPE.WAVEFORM;
    }

    protected InspectViewUpdateEventCommon(BitFieldModel content) {
        super("");
        this.fElement = content;
        this.fLanguageKind = LanguageKind.VLOG;
        this.fProject = null;
        this.fType = TYPE.WAVEFORM;
    }

    protected InspectViewUpdateEventCommon(Map<String, Object> content, IProject project, boolean padding) {
        super("");
        this.fElement = content;
        this.fLanguageKind = LanguageKind.VLOG;
        this.fProject = project;
        this.fType = TYPE.PROBLEM_MARKER;
    }

    protected InspectViewUpdateEventCommon(IDVTElementWrapper wrapper, SelectionChangedEvent event) {
        super("");
        if (wrapper == null || event == null) {
            return;
        }
        this.fEvent = event;
        this.fType = TYPE.WRAPPER;
        this.fProject = wrapper.getProject();
        if (this.fProject == null) {
            if (event.getSource() instanceof AbstractFilteredView) {
                this.fProject = ((AbstractFilteredView)event.getSource()).getProject();
            } else if (event.getSource() instanceof IDVTLazyView) {
                this.fProject = ((IDVTLazyView)event.getSource()).getProject();
            }
        }
        this.fElement = wrapper;
        if (event.getSource() instanceof TraceConnectionsView || event.getSource() instanceof TraceConnectionsPortsView) {
            TCNode node = wrapper.getRfElement(TCNode.class);
            if (node != null) {
                this.fElement = node.namedElement;
            } else if (wrapper.getRfElement() instanceof HierarchicalElement) {
                this.fElement = ((HierarchicalElement)wrapper.getRfElement()).getFirstSegment();
            }
        }
        this.fLanguageKind = this.fElement instanceof IRfNamedElement ? ((IRfNamedElement)this.fElement).getLanguageKind() : (wrapper.getRfElement() instanceof IRfNamedElement ? ((IRfNamedElement)wrapper.getRfElement()).getLanguageKind() : (wrapper.getRfElement() instanceof IRfDefElement ? ((IRfDefElement)wrapper.getRfElement()).getLanguageKind() : (wrapper.getLanguageKind() == LanguageKind.CPP ? LanguageKind.CPP : LanguageKind.VLOG)));
    }

    public SelectionChangedEvent getTriggerEvent() {
        return this.fEvent;
    }

    public TYPE getType() {
        return this.fType;
    }

    public boolean hasInfos() {
        return !this.fInfos.isEmpty();
    }

    public List<InspectViewGoToInfo> getInfos() {
        return this.fInfos;
    }

    public Object getElement() {
        return this.fElement;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean equals(Object object) {
        try {
            if (!(object instanceof InspectViewUpdateEventCommon)) {
                return false;
            }
            InspectViewUpdateEventCommon ev = (InspectViewUpdateEventCommon)object;
            if (this.fType != null && !this.fType.equals((Object)ev.getType())) {
                return false;
            }
            if (this.fCallParserPath != null && !this.fCallParserPath.equals(ev.getCallParserPath())) {
                return false;
            }
            if (this.fElement != null && !this.fElement.equals(ev.getElement())) {
                return false;
            }
            if (this.fLanguageKind != null && !this.fLanguageKind.equals((Object)ev.getLanguage())) {
                return false;
            }
            if (this.fProject != null && !this.fProject.equals((Object)ev.getProject())) {
                return false;
            }
            if (this.fInfos == null) return true;
            if (ev.getInfos() == null) {
                return false;
            }
            if (this.fInfos.size() != ev.getInfos().size()) {
                return false;
            }
            int i = 0;
            while (true) {
                InspectViewGoToInfo otherInfo;
                if (i >= this.fInfos.size()) {
                    return true;
                }
                InspectViewGoToInfo myInfo = this.fInfos.get(i);
                if (!myInfo.equals(otherInfo = ev.getInfos().get(i))) {
                    return false;
                }
                ++i;
            }
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.fType == null ? 0 : this.fType.hashCode());
        result = 31 * result + (this.fCallParserPath == null ? 0 : this.fCallParserPath.hashCode());
        result = 31 * result + (this.fElement == null ? 0 : this.fElement.hashCode());
        result = 31 * result + (this.fLanguageKind == null ? 0 : this.fLanguageKind.hashCode());
        result = 31 * result + (this.fProject == null ? 0 : this.fProject.hashCode());
        result = 31 * result + (this.fInfos == null ? 0 : this.fInfos.hashCode());
        return result;
    }

    @Override
    public LanguageKind getLanguage() {
        return this.fLanguageKind;
    }

    @Override
    public IProject getProject() {
        return this.fProject;
    }

    public void setLanguage(LanguageKind language) {
        this.fLanguageKind = language;
    }

    public void setType(TYPE type) {
        this.fType = type;
    }

    public int getNofContextLine() {
        return this.fNofContextLine;
    }

    public void setNofContextLine(int nofContextLine) {
        this.fNofContextLine = nofContextLine;
    }

    public static enum TYPE {
        WRAPPER,
        PRELIMINARY_EDITOR,
        EDITOR,
        DIAGRAM,
        FSM_TRANSITIONS,
        FSM_TRANSITIONS_WITH_LOOPBACK,
        FILE,
        PROJECT,
        FOLDER,
        NUMBER,
        AUTOFIX,
        WAVEFORM,
        PROBLEM_MARKER,
        AUTO_DETECT_INDENTATION;

    }
}

