/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views;

import java.util.Arrays;
import java.util.Iterator;
import ro.amiq.dvt.test.TestHelper;

public class KPermGen
implements Iterator {
    private boolean hasNext = true;
    private final int n;
    private final int k;
    private final int[] a;
    private final int[] result;

    public static void identityPermutation(int[] a) {
        int i = a.length - 1;
        while (i >= 0) {
            a[i] = i;
            --i;
        }
    }

    public static int[] identityPermutation2(int n) {
        int[] a = new int[n];
        KPermGen.identityPermutation(a);
        return a;
    }

    public KPermGen(int n, int k) {
        if (n < 1) {
            throw new IllegalArgumentException("Need at least 1 element!");
        }
        if (k < 0 || k > n) {
            throw new IllegalArgumentException("0 < k <= n!");
        }
        this.n = n;
        this.k = k;
        this.a = KPermGen.identityPermutation2(n);
        this.result = new int[k];
    }

    @Override
    public final boolean hasNext() {
        return this.hasNext;
    }

    public final int[] next() {
        System.arraycopy(this.a, 0, this.result, 0, this.k);
        this.computeNext();
        return this.result;
    }

    private void computeNext() {
        int i = this.k - 1;
        int j = this.k;
        while (j < this.n && this.a[i] >= this.a[j]) {
            ++j;
        }
        if (j < this.n) {
            this.swap(i, j);
        } else {
            this.reverseRightOf(i);
            --i;
            while (i >= 0 && this.a[i] >= this.a[i + 1]) {
                --i;
            }
            if (i < 0) {
                this.hasNext = false;
                return;
            }
            --j;
            while (j > i && this.a[i] >= this.a[j]) {
                --j;
            }
            this.swap(i, j);
            this.reverseRightOf(i);
        }
    }

    private void reverseRightOf(int start) {
        int i = start + 1;
        int j = this.n - 1;
        while (i < j) {
            this.swap(i, j);
            ++i;
            --j;
        }
    }

    private void swap(int x, int y) {
        int t = this.a[x];
        this.a[x] = this.a[y];
        this.a[y] = t;
    }

    @Override
    public void remove() {
    }

    public static void main(String[] args) {
        KPermGen it = new KPermGen(5, 3);
        while (it.hasNext()) {
            int[] b = it.next();
            TestHelper.out.println(Arrays.toString(b));
        }
    }

    public static class Factory
    implements Iterable<int[]> {
        private final int n;
        private final int k;

        public Factory(int n, int k) {
            if (n < 1) {
                throw new IllegalArgumentException("Need at least 1 element!");
            }
            if (n < k || k < 0) {
                throw new IllegalArgumentException("0 < k <= n!");
            }
            this.n = n;
            this.k = k;
        }

        @Override
        public final Iterator<int[]> iterator() {
            return new KPermGen(this.n, this.k);
        }
    }
}

