/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views;

import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.IPageSite;

public class MenuCommandInstaller {
    private static final String DVT_VIEWS_CONTEXT_MENU_COMMANDS = "#DVTViewsContextMenu";
    private static final String DVT_VIEWS_CONTEXT = "ro.amiq.dvt.ui.views.context";

    public static MenuManager installContextMenu(IWorkbenchPart part, Control control) {
        IWorkbenchPartSite site = part.getSite();
        if (site == null) {
            return null;
        }
        MenuManager menuManager = MenuCommandInstaller.installContextMenu((IWorkbenchSite)site, control);
        if (menuManager == null) {
            return null;
        }
        site.registerContextMenu(DVT_VIEWS_CONTEXT_MENU_COMMANDS, menuManager, (ISelectionProvider)part);
        return menuManager;
    }

    public static MenuManager installContextMenu(IPageBookViewPage page, Control control) {
        IPageSite site = page.getSite();
        if (site == null) {
            return null;
        }
        MenuManager menuManager = MenuCommandInstaller.installContextMenu((IWorkbenchSite)site, control);
        if (menuManager == null) {
            return null;
        }
        site.registerContextMenu(DVT_VIEWS_CONTEXT_MENU_COMMANDS, menuManager, (ISelectionProvider)page);
        return menuManager;
    }

    private static MenuManager installContextMenu(IWorkbenchSite site, Control control) {
        if (control == null || control.isDisposed()) {
            return null;
        }
        IContextService contextService = (IContextService)site.getService(IContextService.class);
        contextService.activateContext(DVT_VIEWS_CONTEXT);
        MenuManager menuManager = new MenuManager(DVT_VIEWS_CONTEXT_MENU_COMMANDS, DVT_VIEWS_CONTEXT_MENU_COMMANDS);
        menuManager.setRemoveAllWhenShown(false);
        Menu menu = menuManager.createContextMenu(control);
        control.setMenu(menu);
        return menuManager;
    }
}

