/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views;

import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.ui.trace.connections.model.TCNode;
import ro.amiq.dvt.ui.trace.connections.model.TCNodeSignalPair;
import ro.amiq.dvt.ui.views.DVTTreeElementWrapper;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;

public class TCTreeElementWrapper
extends DVTTreeElementWrapper {
    public TCTreeElementWrapper(TCNode node, IDVTElementWrapper parent) {
        super(node);
        this.setParent((DVTTreeElementWrapper)parent);
        this.setExpanded(1);
    }

    public TCTreeElementWrapper(TCNodeSignalPair nodeSignalPair) {
        super(nodeSignalPair);
        this.setParent(null);
        this.setExpanded(1);
    }

    public TCNode getNode() {
        return (TCNode)this.getRfElement();
    }

    @Override
    public <T> T getRfElement(Class<T> clazz) {
        TCNode node;
        if (IRfNamedElement.class.isAssignableFrom(clazz) && (node = (TCNode)this.getAdapter(TCNode.class)) != null) {
            return (T)node.namedElement;
        }
        return super.getRfElement(clazz);
    }

    @Override
    public IProject getProject() {
        if (!(this.fElement instanceof TCNodeSignalPair)) {
            return null;
        }
        IRfNamedElement signal = ((TCNodeSignalPair)this.fElement).hotSignal;
        if (signal != null) {
            IRfSingleLangProject rfProject = signal.getRfProject();
            return rfProject != null ? rfProject.getProject() : null;
        }
        return super.getProject();
    }

    @Override
    public Object getAdapter(Class adapter) {
        Object result = super.getAdapter(adapter);
        if (result != null) {
            return result;
        }
        if (this.fElement == null) {
            return null;
        }
        if (adapter == TCNode.class) {
            Object element = this.fElement;
            if (element instanceof TCNodeSignalPair) {
                element = ((TCNodeSignalPair)element).node;
            }
            if (element.getClass() == adapter) {
                return element;
            }
        } else if (adapter == TCNodeSignalPair.class && this.fElement.getClass() == adapter) {
            return this.fElement;
        }
        return null;
    }
}

