/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.utils.DVTColorUtil;
import ro.amiq.dvt.ui.views.IFilterableView;
import ro.amiq.dvt.ui.views.TextFilterObjectCommon;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.lazy.views.quick.DVTQuickLazyView;

public class TextFilterObject
extends TextFilterObjectCommon {
    public static final Object FAMILY_FILTER = new Object();
    public static final String CLEAR_FILTER_BUTTON_TOOLTIP = "Clear filter";
    public static final String DEFAULT_FILTER_SWTBOT_ID = String.valueOf(TextFilterObject.class.getCanonicalName()) + ".textFilterSWTBotId";
    private static final int DELTA_T = 100;
    private final IFilterableView fFilterableView;
    private final String fTextFilterId;
    private final Text fTextFilter;
    private final String fTreeId;
    private final boolean fSearchForPorts;
    private FilterTriggerJob fFilterTriggerJob;
    private boolean fHidden;
    private boolean fMoving;
    private Composite fExtendedContainer;
    private ScrolledComposite fExtendedScroller;
    private Composite fContainer;
    private ToolItem fClearButton;
    private List<String> fQuickSearchPreferences;

    public TextFilterObject(IFilterableView filterableView, String id, Composite parent, String treeId, boolean searchForPorts, List<String> quickSearchPreferences) {
        this.fFilterableView = filterableView;
        this.fTextFilterId = id;
        this.fSearchForPorts = searchForPorts;
        this.fQuickSearchPreferences = quickSearchPreferences;
        this.fTreeId = treeId;
        this.fTextFilter = this.createNewFilterText(parent);
        this.fFilterTriggerJob = new FilterTriggerJob(this.fTextFilterId);
    }

    public TextFilterObject(IFilterableView filterableView, String id, Composite parent, String treeId, boolean searchForPorts) {
        this(filterableView, id, parent, treeId, searchForPorts, null);
    }

    public void setPreferencs(List<String> preferences, SelectionListener listener) {
        this.fQuickSearchPreferences = preferences;
    }

    private void move() {
        int nextHint;
        int targetHint;
        this.fMoving = true;
        int currentHint = ((GridData)this.fExtendedScroller.getLayoutData()).heightHint;
        int n = targetHint = this.fHidden ? 0 : this.fExtendedContainer.computeSize((int)-1, (int)-1).y;
        if (targetHint > 100) {
            targetHint = 100;
        }
        if (currentHint == targetHint) {
            this.fMoving = false;
            return;
        }
        int currentHeight = this.fExtendedScroller.getSize().y;
        if (this.fHidden) {
            nextHint = currentHeight / 3 - 1;
            if (nextHint < 0) {
                nextHint = 0;
            }
        } else {
            nextHint = (currentHeight + 1) * 3;
            if (nextHint >= targetHint) {
                nextHint = targetHint;
            }
        }
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).hint(-1, nextHint).applyTo((Control)this.fExtendedScroller);
        this.fExtendedScroller.getParent().getParent().layout(true);
        Display.getCurrent().timerExec(100, new Runnable(){

            @Override
            public void run() {
                TextFilterObject.this.move();
            }
        });
    }

    protected Text createNewFilterText(Composite parent) {
        final Display display = parent.getDisplay();
        this.fContainer = new Composite(parent, 0);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)this.fContainer);
        GridLayoutFactory.fillDefaults().extendedMargins(0, 0, 0, 0).spacing(0, 0).margins(0, 0).applyTo(this.fContainer);
        Composite filterAndClearContainer = new Composite(this.fContainer, 0);
        GridLayoutFactory.fillDefaults().numColumns(3).extendedMargins(0, 0, 0, 0).spacing(0, 0).margins(0, 0).applyTo(filterAndClearContainer);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)filterAndClearContainer);
        final Text filterText = new Text(filterAndClearContainer, 2048);
        Utils.setWidgetSWTBotId((Widget)filterText, DEFAULT_FILTER_SWTBOT_ID);
        filterText.setFont(this.fContainer.getFont());
        DVTColorUtil.INSTANCE.setBackground((Control)filterText, JFaceResources.getColorRegistry().get("ro.amiq.dvt.ui.filter.emptyBackgroundColor"));
        DVTColorUtil.INSTANCE.setForeground((Control)filterText, JFaceResources.getColorRegistry().get("ro.amiq.dvt.ui.filter.foregroundColor"));
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)filterText);
        Label more = null;
        if (this.fQuickSearchPreferences != null) {
            more = new Label(filterAndClearContainer, 0);
            more.setText("...");
        }
        ToolBar clearToolBar = new ToolBar(filterAndClearContainer, 0x800000);
        this.fClearButton = new ToolItem(clearToolBar, 8);
        this.fClearButton.setImage(DVTImages.imageCache.getImage(DVTImages.CLEAR_QUICK_SEARCH));
        this.fClearButton.setToolTipText(CLEAR_FILTER_BUTTON_TOOLTIP);
        this.fClearButton.setEnabled(false);
        this.fClearButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TextFilterObject.this.fTextFilter.setText("");
            }
        });
        if (!(this.fFilterableView instanceof DVTQuickLazyView)) {
            filterText.addKeyListener(new KeyListener(){

                public void keyPressed(KeyEvent e) {
                    if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                        TextFilterObject.this.fFilterableView.gotoSelectedElement(TextFilterObject.this.fTreeId);
                    }
                    if (e.keyCode == 0x1000002 || e.keyCode == 0x1000001) {
                        TextFilterObject.this.fFilterableView.setFocusOnTree(TextFilterObject.this.fTreeId);
                    }
                }

                public void keyReleased(KeyEvent e) {
                }
            });
        }
        filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TextFilterObject.this.setFilterTextColor(filterText);
                String text = ((Text)e.widget).getText().trim();
                if (text.isEmpty()) {
                    TextFilterObject.this.fClearButton.setEnabled(false);
                } else {
                    TextFilterObject.this.fClearButton.setEnabled(true);
                }
                text = TextFilterObject.this.fFilterableView.prepareText(TextFilterObject.this.fTextFilterId, text);
                if (text == null) {
                    return;
                }
                TextFilterObject.this.setMatcherStringsInternal(text, TextFilterObject.this.fSearchForPorts);
                TextFilterObject.this.fFilterTriggerJob.cancel();
                TextFilterObject.this.fFilterTriggerJob.schedule(500L);
            }
        });
        filterText.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                IEditorPart activeEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
                if (!(activeEditor instanceof DVTEditor)) {
                    return;
                }
                if (((DVTEditor)activeEditor).fFocusLostEventTime != e.time) {
                    return;
                }
                ViewsUtils.showDidYouKnowQuickViewNotification(TextFilterObject.this.fFilterableView);
            }
        });
        this.fExtendedScroller = new ScrolledComposite(this.fContainer, 512);
        this.fExtendedScroller.setExpandVertical(true);
        this.fExtendedScroller.setExpandHorizontal(true);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).hint(-1, 0).applyTo((Control)this.fExtendedScroller);
        this.fExtendedContainer = new Composite((Composite)this.fExtendedScroller, 0);
        GridLayoutFactory.fillDefaults().extendedMargins(0, 0, 0, 0).spacing(0, 0).margins(0, 0).applyTo(this.fExtendedContainer);
        Group dotPrefs = new Group(this.fExtendedContainer, 0);
        GridLayoutFactory.fillDefaults().extendedMargins(0, 0, 0, 0).spacing(0, 0).margins(0, 0).applyTo((Composite)dotPrefs);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)dotPrefs);
        dotPrefs.setText("Dot search preferences");
        if (this.fQuickSearchPreferences != null) {
            for (String pref : this.fQuickSearchPreferences) {
                Button b = new Button((Composite)dotPrefs, 32);
                b.setText(pref);
                b.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        TextFilterObject.this.fFilterTriggerJob.cancel();
                        TextFilterObject.this.fFilterTriggerJob.schedule(500L);
                    }
                });
                GridDataFactory.fillDefaults().align(4, 1).grab(true, false).applyTo((Control)b);
            }
        }
        this.fExtendedScroller.setContent((Control)this.fExtendedContainer);
        this.fExtendedContainer.setSize(this.fExtendedContainer.computeSize(-1, -1));
        if (more != null) {
            more.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

                public void mouseEnter(MouseEvent e) {
                    TextFilterObject.this.fHidden = false;
                    if (!TextFilterObject.this.fMoving) {
                        TextFilterObject.this.move();
                    }
                    Listener exitListener = new Listener(){

                        public void handleEvent(Event event) {
                            Control p = (Control)event.widget;
                            do {
                                if (p != (this).TextFilterObject.this.fContainer) continue;
                                return;
                            } while ((p = p.getParent()) != null);
                            (this).TextFilterObject.this.fHidden = true;
                            if (!(this).TextFilterObject.this.fMoving) {
                                TextFilterObject.this.move();
                            }
                            display.removeFilter(5, (Listener)this);
                        }
                    };
                    display.addFilter(5, exitListener);
                }
            });
        }
        return filterText;
    }

    private void setFilterTextColor(Text filterText) {
        if (filterText.getText().length() == 0) {
            DVTColorUtil.INSTANCE.setBackground((Control)filterText, JFaceResources.getColorRegistry().get("ro.amiq.dvt.ui.filter.emptyBackgroundColor"));
        } else {
            DVTColorUtil.INSTANCE.setBackground((Control)filterText, JFaceResources.getColorRegistry().get("ro.amiq.dvt.ui.filter.backgroundColor"));
        }
    }

    public void initTextFilterSilent(String text) {
        if (text == null) {
            return;
        }
        Display display = Display.getDefault();
        if (display == null) {
            return;
        }
        Text filterText = this.getTextFilter();
        if (filterText == null || filterText.isDisposed()) {
            return;
        }
        this.setTextFilterText(text);
        this.setFilterTextColor(filterText);
        if (text.isEmpty()) {
            this.fClearButton.setEnabled(false);
        } else {
            this.fClearButton.setEnabled(true);
        }
        text = this.fFilterableView.prepareText(this.fTextFilterId, text);
        if (text == null) {
            return;
        }
        this.setMatcherStringsInternal(text, this.fSearchForPorts);
    }

    public Composite getControl() {
        return this.fContainer;
    }

    public Text getTextFilter() {
        return this.fTextFilter;
    }

    public String getTextFilterText() {
        return this.fTextFilter.getText();
    }

    public void setTextFilterFont(Font font) {
        this.fTextFilter.setFont(font);
    }

    public void setTextFilterMessage(String message) {
        this.fTextFilter.setMessage(message);
    }

    public void setTextFilterBackground(Color color) {
        DVTColorUtil.INSTANCE.setBackground((Control)this.fTextFilter, color);
    }

    public void setTextFilterText(String text) {
        this.fTextFilter.setText(text);
    }

    public void setFocus() {
        this.fTextFilter.setFocus();
    }

    public boolean isFocusControl() {
        return this.fTextFilter.isFocusControl();
    }

    public void setSelection(int start, int end) {
        this.fTextFilter.setSelection(start, end);
    }

    public void setTextFilterSWTBotId(String id) {
        Utils.setWidgetSWTBotId((Widget)this.fTextFilter, id);
    }

    private boolean containsAnIdChar(String portPattern) {
        int i = 0;
        while (i < portPattern.length()) {
            if (Character.isJavaIdentifierPart(portPattern.charAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void dispose() {
        this.fTextFilter.dispose();
        this.fStringMatcher = null;
        this.fSearchSegments = null;
        this.fSearchTextStrictness = null;
        this.fSearchPort = null;
        this.fFilterTriggerJob = null;
        if (this.fClearButton != null) {
            this.fClearButton.dispose();
        }
        this.fClearButton = null;
        if (this.fExtendedScroller != null) {
            this.fExtendedScroller.dispose();
        }
        this.fExtendedScroller = null;
        if (this.fExtendedContainer != null) {
            this.fExtendedContainer.dispose();
        }
        this.fExtendedContainer = null;
        if (this.fContainer != null) {
            this.fContainer.dispose();
        }
        this.fContainer = null;
    }

    public void resetTextFilter(String textFilterId) {
        this.makeSearchSegmentsAndStrictness("", false);
        this.setMatcherStringsInternal("", false);
    }

    public FilterTriggerJob getFilterJob() {
        return this.fFilterTriggerJob;
    }

    public class FilterTriggerJob
    extends UIJob {
        private final String fUIJobTextFilterId;

        public FilterTriggerJob(String textFilterId) {
            super("FilterTriggerJob");
            this.setPriority(10);
            this.setSystem(true);
            this.fUIJobTextFilterId = textFilterId;
        }

        public boolean belongsTo(Object family) {
            return family == FAMILY_FILTER;
        }

        public String getTextFilterId() {
            return this.fUIJobTextFilterId;
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            try {
                try {
                    TextFilterObject.this.fFilterableView.stringMatcherUpdated(this.fUIJobTextFilterId);
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    ObjectionManager.getInstance().clear(TextFilterObject.this.fFilterableView.getTextFilterObjection());
                }
            }
            finally {
                ObjectionManager.getInstance().clear(TextFilterObject.this.fFilterableView.getTextFilterObjection());
            }
            return Status.OK_STATUS;
        }
    }
}

