/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views;

import java.util.ArrayList;
import java.util.regex.Pattern;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.StringMatcher;

public class TextFilterObjectCommon {
    public static final Pattern START_MULTIPLE_SLASHES = Pattern.compile("^/*");
    public static final Pattern MULTIPLE_SLASHES = Pattern.compile("//+");
    protected StringMatcher[] fSearchSegments = new StringMatcher[0];
    protected boolean[] fSearchTextStrictness = new boolean[0];
    protected StringMatcher fStringMatcher;
    protected String fSearchPort;

    public String getSearchPort() {
        return this.fSearchPort;
    }

    public StringMatcher[] getSearchSegments() {
        return this.fSearchSegments;
    }

    public boolean[] getSearchTextStrictness() {
        return this.fSearchTextStrictness;
    }

    public StringMatcher getStringMatcher() {
        return this.fStringMatcher;
    }

    public boolean isFiltered() {
        return this.fStringMatcher != null;
    }

    protected void makeSearchSegmentsAndStrictness(String text, boolean searchForPorts) {
        String preprocessedText;
        if (text == null) {
            return;
        }
        this.fSearchPort = null;
        int indexOfDot = (text = text.trim()).lastIndexOf(46);
        if (indexOfDot != -1 && searchForPorts) {
            if (indexOfDot < text.length()) {
                this.fSearchPort = text.substring(indexOfDot + 1);
            }
            text = text.substring(0, indexOfDot);
        }
        if ((preprocessedText = DVTStringUtil.replaceAll(START_MULTIPLE_SLASHES, text, "")).endsWith("/") && !preprocessedText.endsWith("//")) {
            preprocessedText = String.valueOf(preprocessedText) + " ";
        }
        preprocessedText = DVTStringUtil.replaceAll(MULTIPLE_SLASHES, preprocessedText, "//");
        ArrayList<String> tokensList = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < preprocessedText.length()) {
            builder.append(preprocessedText.charAt(i));
            if (i == preprocessedText.length() - 1 || preprocessedText.charAt(i) == '/' && preprocessedText.charAt(i + 1) != '/') {
                tokensList.add(builder.toString());
                builder.delete(0, builder.length());
            }
            ++i;
        }
        String[] tokens = tokensList.toArray(new String[tokensList.size()]);
        String[] searchSegmentsTxt = new String[tokens.length];
        this.fSearchSegments = new StringMatcher[tokens.length];
        this.fSearchTextStrictness = new boolean[tokens.length];
        int i2 = 0;
        while (i2 < tokens.length) {
            if (tokens[i2].endsWith("//")) {
                searchSegmentsTxt[i2] = tokens[i2].substring(0, tokens[i2].length() - 2);
                this.fSearchTextStrictness[i2] = false;
            } else if (tokens[i2].endsWith("/")) {
                searchSegmentsTxt[i2] = tokens[i2].substring(0, tokens[i2].length() - 1);
                this.fSearchTextStrictness[i2] = true;
            } else if (i2 == tokens.length - 1) {
                searchSegmentsTxt[i2] = tokens[i2].trim();
                this.fSearchTextStrictness[i2] = true;
            } else {
                DVTLogger.INSTANCE.logError("Design Hierarchy complex filter: malformed segment " + tokens[i2]);
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < searchSegmentsTxt.length) {
            this.fSearchSegments[i2] = ViewsUtils.createCamelCaseOrRegexMatcher(searchSegmentsTxt[i2].isEmpty() ? "*" : searchSegmentsTxt[i2], true, false);
            ++i2;
        }
    }

    protected void setMatcherStringsInternal(String text, boolean searchForPorts) {
        this.makeSearchSegmentsAndStrictness(text, searchForPorts);
        this.fStringMatcher = ViewsUtils.createCamelCaseOrRegexMatcher(text, true, false);
    }
}

