/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.progress.UIJob;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.EclipseUtils;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.DVTSyntheticEvent;
import ro.amiq.dvt.ui.decorators.util.ILazyOverlayElement;
import ro.amiq.dvt.ui.views.DVTBaseLabelProvider;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.ILazyTreeContentProvider;
import ro.amiq.dvt.ui.views.designhierarchy.IDHLabelProvider;

public class TreeViewContentProvider
implements ILazyTreeContentProvider<IDVTElementWrapper> {
    public static final String DVT_DISABLE_LAZY_UPDATE_VIEWS = "DVT_DISABLE_LAZY_UPDATE_VIEWS";
    private static int MAX_NUMBER_OF_ELEMENTS = 30;
    private static int NUMBER_OF_ITEMS_ON_UPDATE = 70;
    private static final boolean IS_MACOSX = "macosx".equals(Platform.getOS());
    protected boolean fLazyUpdateDisabled = false;
    protected Tree fTree;
    private ILabelProvider fLabelProvider;
    protected int fExpandLevel;
    protected UpdateItemCountJob fUpdateItemCountJob;
    private ILabelDecorator fDecorator;
    protected boolean fDisableUpdateTree;
    private int fYieldCounter;
    private Listener fExpandListener;

    public TreeViewContentProvider(Tree tree, DVTBaseLabelProvider labelProvider) {
        this.fTree = tree;
        this.fLabelProvider = labelProvider;
        this.fDecorator = labelProvider.getDecorator();
        if (System.getenv(DVT_DISABLE_LAZY_UPDATE_VIEWS) != null) {
            this.fLazyUpdateDisabled = new Boolean(System.getenv(DVT_DISABLE_LAZY_UPDATE_VIEWS));
        }
        if (!this.fLazyUpdateDisabled) {
            this.fUpdateItemCountJob = new UpdateItemCountJob();
        }
        this.fTree.addListener(36, new Listener(){

            public void handleEvent(Event event) {
                if (!TreeViewContentProvider.this.fLazyUpdateDisabled) {
                    TreeViewContentProvider.this.updateItemWrapperData((TreeItem)event.item, event.index);
                }
            }
        });
        final ILabelProviderListener listener = new ILabelProviderListener(){

            public void labelProviderChanged(LabelProviderChangedEvent event) {
                Object[] elements = event.getElements();
                if (elements == null || elements.length == 0) {
                    return;
                }
                Object[] objectArray = elements;
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    if (element instanceof IDVTElementWrapper) {
                        TreeViewContentProvider.this.updateLabel((IDVTElementWrapper)element, EnumSet.allOf(LabelUpdateKind.class));
                    }
                    ++n2;
                }
            }
        };
        labelProvider.addListener(listener);
        this.fTree.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TreeViewContentProvider.this.fLabelProvider.removeListener(listener);
            }
        });
        final LazyOverlayRefreshListener overlayRefreshlistener = new LazyOverlayRefreshListener();
        if (!this.fTree.isDisposed()) {
            this.fTree.addListener(42, (Listener)overlayRefreshlistener);
        }
        this.fTree.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TreeViewContentProvider.this.fTree.removeListener(42, (Listener)overlayRefreshlistener);
            }
        });
        this.fTree.addListener(17, new Listener(){

            public void handleEvent(Event event) {
                TreeItem item = (TreeItem)event.item;
                IDVTElementWrapper element = (IDVTElementWrapper)item.getData();
                element.setExpanded(1);
            }
        });
        this.fTree.addListener(18, new Listener(){

            public void handleEvent(Event event) {
                TreeItem item = (TreeItem)event.item;
                IDVTElementWrapper element = (IDVTElementWrapper)item.getData();
                element.setExpanded(-2);
            }
        });
        this.fExpandListener = new Listener(){

            public void handleEvent(Event event) {
                if (IS_MACOSX) {
                    Display.getDefault().asyncExec(() -> this.internalHandleEvent(event));
                } else {
                    this.internalHandleEvent(event);
                }
            }

            public void internalHandleEvent(Event event) {
                try {
                    TreeItem item = (TreeItem)event.item;
                    if (item == null || item.isDisposed()) {
                        return;
                    }
                    IDVTElementWrapper element = (IDVTElementWrapper)item.getData();
                    if (element == null) {
                        return;
                    }
                    if (TreeViewContentProvider.this.fExpandLevel == -1) {
                        if (element.getExpanded() == 0) {
                            item.setExpanded(true);
                        }
                    } else if (TreeViewContentProvider.this.fExpandLevel == 1 || TreeViewContentProvider.this.fExpandLevel == 0) {
                        if (element.getExpanded() == 0) {
                            item.setExpanded(false);
                        }
                    } else if (TreeViewContentProvider.this.fExpandLevel > 1) {
                        int itemDepth = this.getItemDepth(item);
                        if (TreeViewContentProvider.this.fExpandLevel - 1 > itemDepth) {
                            if (element.getExpanded() == 0) {
                                item.setExpanded(true);
                            }
                        } else if (element.getExpanded() == 0) {
                            item.setExpanded(false);
                        }
                    }
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }

            private int getItemDepth(TreeItem item) {
                TreeItem parent = item;
                if (item == null || item.isDisposed()) {
                    return -1;
                }
                int depth = 0;
                while ((parent = parent.getParentItem()) != null && !parent.isDisposed()) {
                    ++depth;
                }
                return depth;
            }
        };
    }

    protected void updateLabel(IDVTElementWrapper element, EnumSet<LabelUpdateKind> labelUpdateKind) {
        if (labelUpdateKind.isEmpty()) {
            return;
        }
        Object itemCandidate = element.getItem();
        if (!(itemCandidate instanceof TreeItem)) {
            return;
        }
        TreeItem item = (TreeItem)itemCandidate;
        if (item.isDisposed() || item.getParent() != this.fTree) {
            return;
        }
        int numberOfColumns = this.fTree.getColumnCount();
        if (numberOfColumns > 1 && this.fLabelProvider instanceof ITableLabelProvider) {
            int i;
            ITableLabelProvider tmpLabelProvider = (ITableLabelProvider)this.fLabelProvider;
            if (labelUpdateKind.contains((Object)LabelUpdateKind.IMAGE)) {
                Image[] images = new Image[numberOfColumns];
                i = 0;
                while (i < numberOfColumns) {
                    images[i] = tmpLabelProvider.getColumnImage((Object)element, i);
                    ++i;
                }
                item.setImage(images);
            }
            if (labelUpdateKind.contains((Object)LabelUpdateKind.TEXT)) {
                String[] texts = new String[numberOfColumns];
                i = 0;
                while (i < numberOfColumns) {
                    texts[i] = tmpLabelProvider.getColumnText((Object)element, i);
                    ++i;
                }
                item.setText(texts);
            }
        } else {
            item.setImage(this.fLabelProvider.getImage((Object)element));
            item.setText(this.fLabelProvider.getText((Object)element));
            if (this.fLabelProvider instanceof IDHLabelProvider) {
                item.setBackground(((IDHLabelProvider)this.fLabelProvider).getWrapperBackground(element));
                item.setForeground(((IDHLabelProvider)this.fLabelProvider).getWrapperForeground(element));
            }
        }
    }

    public void updateAllLabels(EnumSet<LabelUpdateKind> labelUpdateKind) {
        if (labelUpdateKind.isEmpty()) {
            return;
        }
        Object data = this.fTree.getData();
        if (!(data instanceof List)) {
            return;
        }
        this.updateAllLabelsRecursive(labelUpdateKind, (List)data);
    }

    private void updateAllLabelsRecursive(EnumSet<LabelUpdateKind> labelUpdateKind, List wrappersList) {
        if (wrappersList == null || wrappersList.isEmpty()) {
            return;
        }
        for (Object wrapper : wrappersList) {
            if (!(wrapper instanceof IDVTElementWrapper)) continue;
            Object itemCandidate = ((IDVTElementWrapper)wrapper).getItem();
            if (!(itemCandidate instanceof TreeItem)) {
                return;
            }
            TreeItem item = (TreeItem)itemCandidate;
            if (item.isDisposed() || item.getParent() != this.fTree) {
                return;
            }
            this.updateLabel((IDVTElementWrapper)wrapper, labelUpdateKind);
            this.updateAllLabelsRecursive(labelUpdateKind, ((IDVTElementWrapper)wrapper).getChildren());
        }
    }

    @Override
    public void setInput(List<IDVTElementWrapper> input, int expandLevel) {
        this.fDisableUpdateTree = true;
        this.fYieldCounter = 0;
        if (this.fLazyUpdateDisabled) {
            this.testSetItemCount(null, 0, 0);
        } else {
            this.fUpdateItemCountJob.cancel();
            this.fUpdateItemCountJob.setItemCount(null, 0, 0, 0);
        }
        this.fExpandLevel = expandLevel;
        this.fTree.setRedraw(false);
        this.fTree.removeAll();
        List<IDVTElementWrapper> oldData = this.getInput();
        if (oldData != null) {
            oldData.clear();
        }
        this.fTree.setData(input);
        this.fTree.setRedraw(true);
        this.fDisableUpdateTree = false;
        this.fYieldCounter = 0;
        if (input == null) {
            return;
        }
        if (this.fLazyUpdateDisabled) {
            this.testSetItemCount(null, input.size(), 0);
        } else {
            this.fUpdateItemCountJob.setItemCount(null, input.size(), 0, 0);
            this.fUpdateItemCountJob.schedule();
        }
    }

    private boolean checkEquals(List<IDVTElementWrapper> wrapperList1, List<IDVTElementWrapper> wrapperList2) {
        if (wrapperList1 == null && wrapperList2 == null) {
            return true;
        }
        if (wrapperList1 == null || wrapperList2 == null) {
            return false;
        }
        if (wrapperList1.size() != wrapperList2.size()) {
            return false;
        }
        int i = 0;
        while (i < wrapperList1.size()) {
            if (!this.checkEquals(wrapperList1.get(i), wrapperList2.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean checkEquals(IDVTElementWrapper wrapper1, IDVTElementWrapper wrapper2) {
        if (wrapper1 == null && wrapper2 == null) {
            return true;
        }
        if (wrapper1 == null || wrapper2 == null) {
            return false;
        }
        if (wrapper1.getRfElement() == null && wrapper2.getRfElement() == null) {
            return true;
        }
        if (wrapper1.getRfElement() == null || wrapper2.getRfElement() == null) {
            return false;
        }
        if (wrapper1.getAdditionalInfo((Object)IDVTElementWrapper.Attribute.IS_FILTERED) != wrapper2.getAdditionalInfo((Object)IDVTElementWrapper.Attribute.IS_FILTERED)) {
            return false;
        }
        if (!wrapper1.getRfElement().equals(wrapper2.getRfElement())) {
            return false;
        }
        return this.checkEquals(wrapper1.getAllChildren(), wrapper2.getAllChildren());
    }

    public List<IDVTElementWrapper> getInput() {
        return (List)this.fTree.getData();
    }

    @Override
    public void updateItemWrapperData(TreeItem item, int index) {
        try {
            boolean hasChildren;
            int oldItemCount;
            List elements;
            TreeItem parentItem = item.getParentItem();
            if (parentItem == null) {
                elements = (List)this.fTree.getData();
                oldItemCount = this.fTree.getItemCount();
            } else {
                elements = ((IDVTElementWrapper)parentItem.getData()).getChildren();
                oldItemCount = parentItem.getItemCount();
            }
            int totalItemCount = elements.size();
            if (oldItemCount < totalItemCount && oldItemCount - 20 < index) {
                int newItemCount = Math.min(oldItemCount + 50, totalItemCount);
                this.setItemCount(parentItem, newItemCount, oldItemCount);
                this.fUpdateItemCountJob.cancel();
                this.fUpdateItemCountJob.setItemCount(parentItem, totalItemCount, newItemCount, index);
                this.fUpdateItemCountJob.schedule();
            }
            if (index >= elements.size()) {
                return;
            }
            IDVTElementWrapper element = (IDVTElementWrapper)elements.get(index);
            if (element == null) {
                return;
            }
            Object isFiltered = element.getAdditionalInfo((Object)IDVTElementWrapper.Attribute.IS_FILTERED);
            if (isFiltered != null && ((Boolean)isFiltered).booleanValue()) {
                return;
            }
            item.setData((Object)element);
            element.setItem(item);
            int numberOfColumns = this.fTree.getColumnCount();
            if (numberOfColumns > 1 && this.fLabelProvider instanceof ITableLabelProvider) {
                ITableLabelProvider tmpLabelProvider = (ITableLabelProvider)this.fLabelProvider;
                ArrayList<String> strings = new ArrayList<String>();
                ArrayList<Image> images = new ArrayList<Image>();
                int i = 0;
                while (i < numberOfColumns) {
                    strings.add(tmpLabelProvider.getColumnText((Object)element, i));
                    images.add(tmpLabelProvider.getColumnImage((Object)element, i));
                    ++i;
                }
                item.setText(strings.toArray(new String[strings.size()]));
                item.setImage(images.toArray(new Image[images.size()]));
                if (EclipseUtils.isAtLeastEclipse411()) {
                    item.setImage(images.toArray(new Image[images.size()]));
                }
            } else {
                item.setText(this.fLabelProvider.getText((Object)element));
                item.setImage(this.fLabelProvider.getImage((Object)element));
                if (this.fLabelProvider instanceof IDHLabelProvider) {
                    item.setBackground(((IDHLabelProvider)this.fLabelProvider).getWrapperBackground(element));
                    item.setForeground(((IDHLabelProvider)this.fLabelProvider).getWrapperForeground(element));
                }
            }
            if (element.getSelectedElement() != null) {
                element.setSelectedElement(null);
                this.fTree.setSelection(item);
                this.fTree.update();
                if (!TestHelper.isFilteringSyntheticEvents()) {
                    this.fTree.notifyListeners(13, (Event)new DVTSyntheticEvent());
                }
            }
            item.setItemCount((hasChildren = this.hasLazyChildren(element)) ? 1 : 0);
            List<IDVTElementWrapper> lazyChildren = this.getLazyChildren();
            if (lazyChildren != null) {
                element.addChildren(lazyChildren);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private boolean setItemCount(TreeItem item, int newItemCount, int oldItemCount) {
        if (this.fDisableUpdateTree) {
            return false;
        }
        if (item != null && !item.isDisposed()) {
            int i = oldItemCount;
            while (i < newItemCount) {
                if (this.fDisableUpdateTree) {
                    return false;
                }
                ++this.fYieldCounter;
                if (this.fYieldCounter % 1000 == 0) {
                    Thread.yield();
                }
                new TreeItem(item, 0);
                ++i;
            }
            return true;
        }
        if (item == null && this.fTree != null && !this.fTree.isDisposed()) {
            int i = oldItemCount;
            while (i < newItemCount) {
                if (this.fDisableUpdateTree) {
                    return false;
                }
                ++this.fYieldCounter;
                if (this.fYieldCounter % 1000 == 0) {
                    Thread.yield();
                }
                new TreeItem(this.fTree, 0);
                ++i;
            }
            return true;
        }
        return false;
    }

    protected boolean testSetItemCount(TreeItem item, int newItemCount, int oldItemCount) {
        if (this.fDisableUpdateTree) {
            return false;
        }
        if (item != null && !item.isDisposed()) {
            int i = oldItemCount;
            while (i < newItemCount) {
                if (this.fDisableUpdateTree) {
                    return false;
                }
                TreeItem result = new TreeItem(item, 0);
                this.testUpdateItemWrapperData(result, i);
                ++i;
            }
            return true;
        }
        if (item == null && this.fTree != null && !this.fTree.isDisposed()) {
            int i = oldItemCount;
            while (i < newItemCount) {
                if (this.fDisableUpdateTree) {
                    return false;
                }
                TreeItem result = new TreeItem(this.fTree, 0);
                this.testUpdateItemWrapperData(result, i);
                ++i;
            }
            return true;
        }
        return false;
    }

    private void testUpdateItemWrapperData(TreeItem item, int index) {
        try {
            boolean hasChildren;
            TreeItem parentItem = item.getParentItem();
            List elements = parentItem == null ? (List)this.fTree.getData() : ((IDVTElementWrapper)parentItem.getData()).getChildren();
            if (index >= elements.size()) {
                return;
            }
            IDVTElementWrapper element = (IDVTElementWrapper)elements.get(index);
            if (element == null) {
                return;
            }
            item.setData((Object)element);
            element.setItem(item);
            int numberOfColumns = this.fTree.getColumnCount();
            if (numberOfColumns > 1 && this.fLabelProvider instanceof ITableLabelProvider) {
                ITableLabelProvider tmpLabelProvider = (ITableLabelProvider)this.fLabelProvider;
                ArrayList<String> strings = new ArrayList<String>();
                ArrayList<Image> images = new ArrayList<Image>();
                int i = 0;
                while (i < numberOfColumns) {
                    strings.add(tmpLabelProvider.getColumnText((Object)element, i));
                    images.add(tmpLabelProvider.getColumnImage((Object)element, i));
                    ++i;
                }
                item.setText(strings.toArray(new String[strings.size()]));
                item.setImage(images.toArray(new Image[images.size()]));
            } else {
                item.setText(this.fLabelProvider.getText((Object)element));
                item.setImage(this.fLabelProvider.getImage((Object)element));
                if (this.fLabelProvider instanceof IDHLabelProvider) {
                    item.setBackground(((IDHLabelProvider)this.fLabelProvider).getWrapperBackground(element));
                    item.setForeground(((IDHLabelProvider)this.fLabelProvider).getWrapperForeground(element));
                }
            }
            if (element.getSelectedElement() != null) {
                element.setSelectedElement(null);
                this.fTree.setSelection(item);
                if (!TestHelper.isFilteringSyntheticEvents()) {
                    this.fTree.notifyListeners(13, (Event)new DVTSyntheticEvent());
                }
            }
            if (hasChildren = this.hasLazyChildren(element)) {
                this.testSetItemCount(item, element.getChildren().size(), 0);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public List<IDVTElementWrapper> getLazyChildren() {
        return null;
    }

    public boolean hasLazyChildren(IDVTElementWrapper element) {
        List children = element.getChildren();
        return children != null && !children.isEmpty();
    }

    public static enum LabelUpdateKind {
        TEXT,
        IMAGE;

    }

    class LazyOverlayRefreshListener
    implements Listener {
        private TreeItem[] fRefreshList = new TreeItem[MAX_NUMBER_OF_ELEMENTS];
        private int fRefreshPointer = 0;
        private UIJob fRefreshJob = new RefreshJob();

        public void handleEvent(Event event) {
            try {
                if (event.item == null || event.item.isDisposed()) {
                    return;
                }
                ILazyOverlayElement element = (ILazyOverlayElement)((TreeItem)event.item).getData();
                if (element == null) {
                    return;
                }
                if (!element.getOverlayStatus()) {
                    this.fRefreshList[this.fRefreshPointer] = (TreeItem)event.item;
                    this.fRefreshPointer = (this.fRefreshPointer + 1) % MAX_NUMBER_OF_ELEMENTS;
                    this.fRefreshJob.cancel();
                    this.fRefreshJob.schedule(150L);
                }
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }

        private class RefreshJob
        extends UIJob {
            public RefreshJob() {
                super("LazyTypesOverlayUpdater");
                this.setSystem(true);
                this.setPriority(50);
            }

            public boolean shouldSchedule() {
                return super.shouldSchedule() && ((LazyOverlayRefreshListener)LazyOverlayRefreshListener.this).TreeViewContentProvider.this.fTree != null && !((LazyOverlayRefreshListener)LazyOverlayRefreshListener.this).TreeViewContentProvider.this.fTree.isDisposed();
            }

            public boolean shouldRun() {
                return super.shouldRun() && ((LazyOverlayRefreshListener)LazyOverlayRefreshListener.this).TreeViewContentProvider.this.fTree != null && !((LazyOverlayRefreshListener)LazyOverlayRefreshListener.this).TreeViewContentProvider.this.fTree.isDisposed();
            }

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (((LazyOverlayRefreshListener)LazyOverlayRefreshListener.this).TreeViewContentProvider.this.fTree == null || ((LazyOverlayRefreshListener)LazyOverlayRefreshListener.this).TreeViewContentProvider.this.fTree.isDisposed()) {
                    return Status.CANCEL_STATUS;
                }
                ((LazyOverlayRefreshListener)LazyOverlayRefreshListener.this).TreeViewContentProvider.this.fTree.setRedraw(false);
                int i = 0;
                while (i < MAX_NUMBER_OF_ELEMENTS) {
                    ILazyOverlayElement element;
                    TreeItem item = LazyOverlayRefreshListener.this.fRefreshList[i];
                    if (item != null && !item.isDisposed() && (element = (ILazyOverlayElement)item.getData()) != null && !element.getOverlayStatus()) {
                        element.setOverlayStatus(true);
                        ((LazyOverlayRefreshListener)LazyOverlayRefreshListener.this).TreeViewContentProvider.this.fDecorator.decorateImage(item.getImage(), (Object)element);
                        LazyOverlayRefreshListener.this.fRefreshList[i] = null;
                    }
                    ++i;
                }
                ((LazyOverlayRefreshListener)LazyOverlayRefreshListener.this).TreeViewContentProvider.this.fTree.setRedraw(true);
                return Status.OK_STATUS;
            }
        }
    }

    class UpdateItemCountJob
    extends UIJob {
        private int fCurrentItemCount;
        private int fTotalItemCount;
        private TreeItem fTreeItem;
        private int fIndex;

        public UpdateItemCountJob() {
            super(Display.getCurrent(), "Update Item Count");
            this.setSystem(true);
            this.setPriority(20);
        }

        public void setItemCount(TreeItem treeItem, int totalItemCount, int currentItemCount, int index) {
            this.fTreeItem = treeItem;
            this.fTotalItemCount = totalItemCount;
            this.fCurrentItemCount = currentItemCount;
            this.fIndex = index;
        }

        public void setItemCount(TreeItem treeItem, int totalItemCount, int currentItemCount) {
            this.setItemCount(treeItem, totalItemCount, currentItemCount, 0);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (TreeViewContentProvider.this.fDisableUpdateTree) {
                return Status.OK_STATUS;
            }
            if (TreeViewContentProvider.this.fTree.isDisposed()) {
                return Status.OK_STATUS;
            }
            TreeViewContentProvider.this.fTree.removeListener(42, TreeViewContentProvider.this.fExpandListener);
            if (this.fCurrentItemCount < this.fTotalItemCount) {
                int oldItemCount = this.fCurrentItemCount;
                this.fCurrentItemCount = Math.min(this.fCurrentItemCount + NUMBER_OF_ITEMS_ON_UPDATE, this.fTotalItemCount);
                if (TreeViewContentProvider.this.setItemCount(this.fTreeItem, this.fCurrentItemCount, oldItemCount)) {
                    if (this.fCurrentItemCount < this.fIndex + 50) {
                        this.schedule(150L);
                    } else {
                        this.handleExpandEvents();
                    }
                } else {
                    this.handleExpandEvents();
                }
            } else {
                this.handleExpandEvents();
            }
            return Status.OK_STATUS;
        }

        private void handleExpandEvents() {
            TreeViewContentProvider.this.fTree.addListener(42, TreeViewContentProvider.this.fExpandListener);
            Event event = new Event();
            event.item = TreeViewContentProvider.this.fTree.getTopItem();
            TreeViewContentProvider.this.fExpandListener.handleEvent(event);
        }
    }
}

