/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.ViewUpdateProgressNotification;
import ro.amiq.dvt.ui.views.IDVTJob;
import ro.amiq.dvt.ui.views.IUpdateJobImpl;
import ro.amiq.dvt.ui.views.ViewsUtils;

public class UpdateJob
extends Job
implements IDVTJob {
    public static final String UPDATE_JOB_MESSAGE_TEXT = "Updating...";
    private final IUpdateJobImpl implementation;
    private boolean jobIsCanceled;
    private ViewUpdateProgressNotification updateNotification;

    public UpdateJob(String name, IUpdateJobImpl implementation) {
        super(name);
        this.setSystem(true);
        this.implementation = implementation;
    }

    protected IStatus run(IProgressMonitor monitor) {
        this.jobIsCanceled = false;
        long timestamp = System.currentTimeMillis();
        this.implementation.updateNonGuiPart(this);
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                UpdateJob.this.implementation.updateGuiPart(UpdateJob.this);
                ObjectionManager.getInstance().clear(UpdateJob.this.implementation);
            }
        });
        try {
            TestHelper.addMetric((Object)this.implementation, System.currentTimeMillis() - timestamp);
        }
        catch (Throwable throwable) {}
        if (ViewsUtils.isCanceled(this)) {
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    protected void canceling() {
        super.canceling();
        this.jobIsCanceled = true;
        Utils.safeRunSynchInUIThread(new Runnable(){

            @Override
            public void run() {
                if (UpdateJob.this.updateNotification != null) {
                    UpdateJob.this.updateNotification.destroy();
                }
            }
        });
    }

    @Override
    public boolean isCanceled() {
        return this.jobIsCanceled;
    }

    public boolean belongsTo(Object family) {
        return family == this.implementation;
    }

    public IUpdateJobImpl getImplementation() {
        return this.implementation;
    }
}

