/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.internal.ViewReference;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.SimpleDVTNotification;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.actions.history.HistoryItem;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.views.AbstractFilteredView;
import ro.amiq.dvt.ui.views.AbstractTreeInformationControl;
import ro.amiq.dvt.ui.views.BuildEvents;
import ro.amiq.dvt.ui.views.ComplexFilter;
import ro.amiq.dvt.ui.views.DVTViewContributors;
import ro.amiq.dvt.ui.views.DVTViewEvent;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.IDVTJob;
import ro.amiq.dvt.ui.views.IDVTView;
import ro.amiq.dvt.ui.views.IDVTViewContributor;
import ro.amiq.dvt.ui.views.IFilterableView;
import ro.amiq.dvt.ui.views.TreeViewContentProvider;
import ro.amiq.dvt.ui.views.ViewDataContainer;
import ro.amiq.dvt.ui.views.ViewsUtilsCommon;
import ro.amiq.dvt.ui.views.callhierarchy.ICallHierarchyViewContributor;
import ro.amiq.dvt.ui.views.config.db.ConfigDBView;
import ro.amiq.dvt.ui.views.factory.overrides.FactoryOverridesView;
import ro.amiq.dvt.ui.views.inspect.IInspectViewContributor;
import ro.amiq.dvt.ui.views.layers.ILayersViewContributor;
import ro.amiq.dvt.ui.views.layers.LayersView;
import ro.amiq.dvt.ui.views.layers.QuickLayersView;
import ro.amiq.dvt.ui.views.lazy.views.quick.DVTQuickLazyView;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.VerificationHierarchyView;
import ro.amiq.dvt.ui.views.refactoring.RefactoringConnectView;
import ro.amiq.dvt.ui.views.registers.RegistersView;
import ro.amiq.dvt.ui.views.typehierarchy.ITHViewContributor;
import ro.amiq.dvt.ui.views.typehierarchy.QuickTypeHierarchyView;
import ro.amiq.dvt.ui.views.typehierarchy.TypeHierarchyView;
import ro.amiq.dvt.ui.views.uvmsequencetree.IUVMSequenceTreeViewContributor;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.StringMatcher;

public class ViewsUtils
extends ViewsUtilsCommon {
    public static final int VIEW_HEIGHT_IN_CHARS = 20;
    public static final int VIEW_WIDTH_IN_CHARS = 50;
    public static final String OVERRIDE_TEXT = "Override";
    public static final String INSERT_LAYER_TEXT = "Override";
    private static final String DID_YOU_KNOW_QUICKVEIEW_NOTIFICATION = "DID_YOU_KNOW_QUICKVEIEW_NOTIFICATION";
    private static final String DID_YOU_KNOW_EDITOR_NOTIFICATION = "DID_YOU_KNOW_EDITOR_NOTIFICATION";

    public static IProject openProjectSelectionDialog() {
        Object[] result;
        block10: {
            block9: {
                LinkedList<IProject> dvtProjects;
                block8: {
                    try {
                        IProject[] allProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                        dvtProjects = new LinkedList<IProject>();
                        IProject[] iProjectArray = allProjects;
                        int n = allProjects.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IProject project = iProjectArray[n2];
                            if (project.isOpen() && (project.hasNature("ro.amiq.vlogdt.VlogNature") || project.hasNature("ro.amiq.edt.enature") || project.hasNature("ro.amiq.vhdldt.VhdlNature") || project.hasNature("ro.amiq.pssdt.pssnature") || project.hasNature("ro.amiq.dvt.dvtnature"))) {
                                dvtProjects.add(project);
                            }
                            ++n2;
                        }
                        if (!dvtProjects.isEmpty()) break block8;
                        MessageDialog.openInformation((Shell)Utils.getActiveShell(), (String)"No DVT project", (String)"There are no DVT projects accessible in the workspace!");
                        return null;
                    }
                    catch (Exception e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                        return null;
                    }
                }
                if (dvtProjects.size() == 1) {
                    DVTPlugin.getSelectionManager().selectAndReveal((IResource)dvtProjects.get(0), DVTUiUtils.getActiveWorkbenchWindow());
                    return (IProject)dvtProjects.get(0);
                }
                ElementListSelectionDialog dialog2 = new ElementListSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (ILabelProvider)new WorkbenchLabelProvider());
                dialog2.setElements((Object[])dvtProjects.toArray(new IProject[dvtProjects.size()]));
                dialog2.setMultipleSelection(false);
                dialog2.setTitle("Select DVT Project");
                dialog2.setMessage("Select a DVT Project from Workspace");
                dialog2.open();
                result = dialog2.getResult();
                if (result != null && result.length != 0) break block9;
                return null;
            }
            if (result[0] != null && result[0] instanceof IProject) break block10;
            return null;
        }
        DVTPlugin.getSelectionManager().selectAndReveal((IResource)((IProject)result[0]), PlatformUI.getWorkbench().getActiveWorkbenchWindow());
        return (IProject)result[0];
    }

    public static <T extends DVTQuickLazyView> DVTQuickLazyView openQuickLazyView(Class<T> clazz) {
        return ViewsUtils.openQuickLazyView(clazz, null);
    }

    public static <T extends DVTQuickLazyView> DVTQuickLazyView openQuickLazyView(Class<T> clazz, Object inputData) {
        DVTQuickLazyView quickView;
        block7: {
            IProject project;
            block6: {
                block5: {
                    try {
                        project = DVTPlugin.getSelectionManager().getLastSelectedProject();
                        if (project != null && project.isAccessible() || (project = ViewsUtils.openProjectSelectionDialog()) != null) break block5;
                        return null;
                    }
                    catch (Exception e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                        return null;
                    }
                }
                if (DVTPlugin.getDefault().collect().c(project, "F636F7265")) break block6;
                return null;
            }
            quickView = null;
            Constructor<T> ctor = clazz.getDeclaredConstructor(Shell.class, IProject.class);
            quickView = (DVTQuickLazyView)ctor.newInstance(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), project);
            if (quickView != null) break block7;
            return null;
        }
        quickView.setInput(inputData);
        quickView.open();
        quickView.setFocus();
        quickView.getShell().forceActive();
        return quickView;
    }

    public static <T extends AbstractTreeInformationControl> AbstractTreeInformationControl openQuickView(Class<T> clazz) {
        return ViewsUtils.openQuickView(clazz, null);
    }

    public static <T extends AbstractTreeInformationControl> AbstractTreeInformationControl openQuickView(Class<T> clazz, Object inputData) {
        AbstractTreeInformationControl quickView;
        block7: {
            IProject project;
            block6: {
                block5: {
                    try {
                        project = DVTPlugin.getSelectionManager().getLastSelectedProject();
                        if (project != null && project.isAccessible() || (project = ViewsUtils.openProjectSelectionDialog()) != null) break block5;
                        return null;
                    }
                    catch (Exception e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                        return null;
                    }
                }
                if (DVTPlugin.getDefault().collect().c(project, "F636F7265")) break block6;
                return null;
            }
            quickView = null;
            Constructor<T> ctor = clazz.getDeclaredConstructor(Shell.class, IProject.class);
            quickView = (AbstractTreeInformationControl)ctor.newInstance(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), project);
            if (quickView != null) break block7;
            return null;
        }
        quickView.setInput(inputData);
        quickView.open();
        quickView.setFocus();
        quickView.getShell().forceActive();
        return quickView;
    }

    public static boolean selectFirstElement(IDVTViewContributor viewContentProvider, StringMatcher matcher, List<IDVTElementWrapper> elements) {
        return ViewsUtils.selectElement(viewContentProvider, matcher, elements, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean selectElement(IDVTViewContributor viewContentProvider, StringMatcher matcher, List<IDVTElementWrapper> elements, Object referenceData) {
        try {
            IDVTElementWrapper idvtElementWrapper;
            List<IDVTElementWrapper> children;
            if (elements == null) return false;
            if (elements.isEmpty()) {
                return false;
            }
            Iterator<IDVTElementWrapper> iterator = elements.iterator();
            do {
                if (!iterator.hasNext()) {
                    return false;
                }
                idvtElementWrapper = iterator.next();
                if (!viewContentProvider.isSelectable(idvtElementWrapper, referenceData, matcher)) continue;
                idvtElementWrapper.setSelectedElement(idvtElementWrapper);
                return true;
            } while (!ViewsUtils.selectElement(viewContentProvider, matcher, children = idvtElementWrapper.getChildren(), referenceData));
            return true;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean selectFirstMatch(List<IDVTElementWrapper> elements) {
        try {
            if (elements == null) return false;
            if (elements.isEmpty()) {
                return false;
            }
            Iterator<IDVTElementWrapper> iterator = elements.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return false;
                }
                IDVTElementWrapper idvtElementWrapper = iterator.next();
                if (idvtElementWrapper == null) continue;
                if (idvtElementWrapper.getAdditionalInfo((Object)IDVTElementWrapper.Attribute.MATCH) != null) {
                    idvtElementWrapper.setSelectedElement(idvtElementWrapper);
                    return true;
                }
                List<IDVTElementWrapper> children = idvtElementWrapper.getChildren();
                if (ViewsUtils.selectFirstMatch(children)) break;
            }
            return true;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return false;
    }

    public static boolean projectContainsENature(IProject project) {
        block3: {
            try {
                if (project != null && project.isAccessible()) break block3;
                return false;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return false;
            }
        }
        return project.hasNature("ro.amiq.edt.enature");
    }

    public static boolean projectContainsSLNNature(IProject project) {
        block3: {
            try {
                if (project != null && project.isAccessible()) break block3;
                return false;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return false;
            }
        }
        return project.hasNature("ro.amiq.slndt.slnnature");
    }

    public static boolean projectContainsPSSNature(IProject project) {
        block3: {
            try {
                if (project != null && project.isAccessible()) break block3;
                return false;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return false;
            }
        }
        return project.hasNature("ro.amiq.pssdt.pssnature");
    }

    public static boolean projectContainsMSDLNature(IProject project) {
        block3: {
            try {
                if (project != null && project.isAccessible()) break block3;
                return false;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return false;
            }
        }
        return project.hasNature("ro.amiq.msdldt.msdlnature");
    }

    public static boolean projectContainsVhdlNature(IProject project) {
        block3: {
            try {
                if (project != null && project.isAccessible()) break block3;
                return false;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return false;
            }
        }
        return project.hasNature("ro.amiq.vhdldt.VhdlNature");
    }

    public static boolean projectContainsVlogNature(IProject project) {
        block3: {
            try {
                if (project != null && project.isAccessible()) break block3;
                return false;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return false;
            }
        }
        return project.hasNature("ro.amiq.vlogdt.VlogNature");
    }

    public static boolean resetFilter(IDVTElementWrapper node, ComplexFilter filter) {
        node.unfilter();
        if (ViewsUtils.isCanceled(filter)) {
            return false;
        }
        if (node.getAllChildren() != null) {
            for (IDVTElementWrapper child : node.getAllChildren()) {
                ViewsUtils.resetFilter(child, filter);
            }
        }
        return true;
    }

    public static void addAdditionaInfoInTree(IDVTElementWrapper instanceTreeRoot, Collection<?> attributes, String info) {
        if (instanceTreeRoot == null) {
            return;
        }
        for (Object attribute : attributes) {
            instanceTreeRoot.setAdditionalInfo(attribute, info);
        }
        if (instanceTreeRoot.getChildren() == null) {
            return;
        }
        for (IDVTElementWrapper child : instanceTreeRoot.getChildren()) {
            ViewsUtils.addAdditionaInfoInTree(child, attributes, info);
        }
    }

    public static int countAllWrappersInTree(IDVTElementWrapper instanceTreeRoot) {
        if (instanceTreeRoot == null || instanceTreeRoot.getChildren() == null) {
            return 0;
        }
        int nofChildren = instanceTreeRoot.getChildren().size();
        for (IDVTElementWrapper child : instanceTreeRoot.getChildren()) {
            nofChildren += ViewsUtils.countAllWrappersInTree(child);
        }
        return nofChildren;
    }

    public static String trimText(String text, int maxLength, boolean replaceNewlinesWithSpaces) {
        String newComment = "";
        if (text == null || text.isEmpty()) {
            return newComment;
        }
        if (replaceNewlinesWithSpaces) {
            newComment = DVTStringUtil.replaceAll(DVTStringUtil.NEW_LINE, text, " ");
        }
        if (newComment.length() > maxLength) {
            newComment = String.valueOf(newComment.substring(0, maxLength)) + "...";
        }
        return newComment;
    }

    public static <T extends IDVTViewContributor> HistoryItem getHistoryItemAtCurrentOffset(Class<T> clazz, boolean ignoreMethods) {
        HistoryItem hItem;
        block14: {
            int[] cursor;
            IEditorPart[] editor;
            block13: {
                try {
                    editor = new IEditorPart[1];
                    cursor = new int[1];
                    Utils.safeRunSynchInUIThread(() -> {
                        iEditorPartArray[0] = DVTFileUtils.getInstance().getActiveEditor();
                        nArray[0] = editor[0] instanceof DVTEditor ? ((DVTEditor)editor[0]).getCursor() : -1;
                    });
                    if (editor[0] instanceof DVTEditor) break block13;
                    return null;
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    return null;
                }
            }
            T contributor = DVTViewContributors.getInstance().getViewContributor(((DVTEditor)editor[0]).getLanguageKind(), clazz);
            hItem = null;
            if (contributor instanceof ILayersViewContributor) {
                hItem = ((ILayersViewContributor)contributor).createHistoryItemForElementAtCursor((DVTEditor)editor[0], cursor[0]);
            } else if (contributor instanceof ITHViewContributor) {
                hItem = ((ITHViewContributor)contributor).createHistoryItemForElementAtCursor((DVTEditor)editor[0], cursor[0], ignoreMethods);
            } else if (contributor instanceof IUVMSequenceTreeViewContributor) {
                hItem = ((IUVMSequenceTreeViewContributor)contributor).createHistoryItemForElementAtCursor((DVTEditor)editor[0], cursor[0]);
            } else if (contributor instanceof ICallHierarchyViewContributor) {
                hItem = ((ICallHierarchyViewContributor)contributor).createHistoryItemForElementAtCursor((DVTEditor)editor[0], cursor[0]);
            } else if (contributor instanceof IInspectViewContributor) {
                hItem = ((IInspectViewContributor)contributor).createHistoryItemForElementAtCursor((DVTEditor)editor[0], cursor[0]);
            }
            if (hItem != null) break block14;
            return null;
        }
        return hItem;
    }

    @Deprecated
    public static boolean isCanceled(IProgressMonitor monitor) {
        return monitor != null && monitor.isCanceled();
    }

    public static boolean isCanceled(IDVTJob job) {
        return job != null && job.isCanceled();
    }

    public static boolean isViewVisible(IDVTView view) {
        return ViewsUtils.isViewVisible((IWorkbenchPart)view);
    }

    public static boolean isViewVisible(IWorkbenchPart view) {
        if (view instanceof AbstractFilteredView) {
            return ((AbstractFilteredView)view).isViewVisible();
        }
        if (view instanceof RefactoringConnectView) {
            return ((RefactoringConnectView)view).isViewVisible();
        }
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return false;
        }
        IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return false;
        }
        IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
        if (activePage == null) {
            return false;
        }
        return activePage.isPartVisible(view);
    }

    public static void notifyAllViewsById(String id, DVTViewEvent event, boolean forceVisible) {
        if (id == null || id.isEmpty() || event == null) {
            return;
        }
        IWorkbenchWindow[] allWindows = Utils.getAllWorkbenchWindows();
        if (allWindows == null) {
            return;
        }
        IWorkbenchWindow[] iWorkbenchWindowArray = allWindows;
        int n = allWindows.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            if (window != null) {
                ViewsUtils.notifyViewById(id, event, forceVisible, window);
            }
            ++n2;
        }
    }

    public static void notifyViewById(String viewId, DVTViewEvent event, boolean forceVisible, IWorkbenchWindow window) {
        if (event == null) {
            return;
        }
        IViewPart view = ViewsUtils.getViewById(viewId, forceVisible, window);
        if (!(view instanceof IDVTView)) {
            return;
        }
        ViewDataContainer viewData = ((IDVTView)view).getDataContainer();
        ViewDataContainer eventData = event.getDataContainer();
        if (eventData == null) {
            return;
        }
        if (!event.isForceOverride() && !eventData.equals(viewData)) {
            return;
        }
        switch (event.getKind()) {
            case TRIGGER: {
                ((AbstractFilteredView)view).setInput(new ViewDataContainer(eventData.getProject(), eventData.getHistoryItem()));
                ViewsUtils.updateView((AbstractFilteredView)view, null, false);
                break;
            }
            case CUSTOM: {
                DVTViewEvent.CustomEventImplementation impl = event.getCustomImplementation();
                if (impl == null) {
                    return;
                }
                impl.setUp(view);
                impl.run();
                break;
            }
        }
    }

    public static void notifyViewById(String viewId, DVTViewEvent event, boolean forceVisible) {
        ViewsUtils.notifyViewById(viewId, event, forceVisible, Utils.getActiveWorkbenchWindow());
    }

    public static ViewInWindow[] getAllViewsById(String id, boolean forceVisible) {
        if (id == null || id.isEmpty()) {
            return null;
        }
        ArrayList<ViewInWindow> parts = new ArrayList<ViewInWindow>(2);
        IWorkbenchWindow[] allWindows = Utils.getAllWorkbenchWindows();
        if (allWindows == null) {
            return null;
        }
        IWorkbenchWindow[] iWorkbenchWindowArray = allWindows;
        int n = allWindows.length;
        int n2 = 0;
        while (n2 < n) {
            IViewPart vp;
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            if (window != null && (vp = ViewsUtils.getViewById(id, forceVisible, window)) != null) {
                parts.add(new ViewInWindow(vp, window));
            }
            ++n2;
        }
        return parts.toArray(new ViewInWindow[parts.size()]);
    }

    public static IViewPart getViewById(String id, boolean forceVisible, IWorkbenchWindow window) {
        IViewPart view;
        IWorkbenchPage page;
        block9: {
            block8: {
                if (id == null || id.isEmpty() || window == null) {
                    return null;
                }
                try {
                    page = window.getActivePage();
                    if (page != null) break block8;
                    return null;
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    return null;
                }
            }
            view = page.findView(id);
            if (view == null && forceVisible) {
                if (page.findViewReference(id) == null) {
                    view = page.showView(id, null, 3);
                }
                view = page.showView(id, null, 2);
            }
            if (view != null) break block9;
            return null;
        }
        if (forceVisible) {
            page.bringToTop((IWorkbenchPart)view);
        }
        return view;
    }

    public static IViewPart getViewById(String id, boolean forceVisible) {
        return ViewsUtils.getViewById(id, forceVisible, Utils.getActiveWorkbenchWindow());
    }

    public static IViewPart getHiddenViewById(String id, boolean forceVisible) {
        IViewPart view;
        IWorkbenchPage page;
        block14: {
            Object viewReferencesField;
            block13: {
                Field field;
                WorkbenchPage workbenchPage;
                block12: {
                    block11: {
                        IWorkbenchWindow window = Utils.getActiveWorkbenchWindow();
                        if (id == null || id.isEmpty() || window == null) {
                            return null;
                        }
                        page = window.getActivePage();
                        if (page instanceof WorkbenchPage) break block11;
                        return null;
                    }
                    workbenchPage = (WorkbenchPage)page;
                    field = workbenchPage.getClass().getDeclaredField("viewReferences");
                    if (field != null) break block12;
                    return null;
                }
                field.setAccessible(true);
                viewReferencesField = field.get(workbenchPage);
                if (viewReferencesField instanceof List) break block13;
                return null;
            }
            try {
                List viewReferences = (List)viewReferencesField;
                view = null;
                for (Object referenceObj : viewReferences) {
                    ViewReference reference;
                    if (!(referenceObj instanceof ViewReference) || !id.equals((reference = (ViewReference)referenceObj).getId())) continue;
                    view = reference.getView(false);
                    break;
                }
                if (view == null && forceVisible) {
                    if (page.findViewReference(id) == null) {
                        view = page.showView(id, null, 3);
                    }
                    view = page.showView(id, null, 2);
                }
                if (view != null) break block14;
                return null;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return null;
            }
        }
        if (forceVisible) {
            page.bringToTop(view);
        }
        return view;
    }

    public static void notifySimAppsViews(BuildEvents event) {
        Utils.safeRunSynchInUIThread(() -> {
            IViewPart configDBView = ViewsUtils.getViewById("ro.amiq.dvt.ui.views.ConfigDBView", false);
            IViewPart registersView = ViewsUtils.getViewById("ro.amiq.dvt.ui.views.RegistersView", false);
            IViewPart factoryOverridesView = ViewsUtils.getViewById("ro.amiq.dvt.ui.views.FactoryOverridesView", false);
            IViewPart vhView = ViewsUtils.getViewById("ro.amiq.dvt.ui.views.VerificationHierarchyView", false);
            if (configDBView != null) {
                ((ConfigDBView)configDBView).update(event);
            }
            if (registersView != null) {
                ((RegistersView)registersView).update(event);
            }
            if (factoryOverridesView != null) {
                ((FactoryOverridesView)factoryOverridesView).update(event);
            }
            if (vhView != null) {
                ((VerificationHierarchyView)vhView).update(event);
            }
        });
    }

    public static void popOKDialog(int messageType, String title, String dialogMessage) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return;
        }
        Display display = workbench.getDisplay();
        if (display == null) {
            return;
        }
        display.asyncExec(() -> {
            IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
            if (TestHelper.isTestMode()) {
                return;
            }
            if (window != null) {
                new MessageDialog(window.getShell(), title, null, dialogMessage, messageType, new String[]{IDialogConstants.OK_LABEL}, 0).open();
            }
        });
    }

    public static void showDidYouKnowQuickViewNotification(IFilterableView filterableView) {
        if (!(filterableView instanceof AbstractFilteredView)) {
            return;
        }
        AbstractFilteredView view = (AbstractFilteredView)filterableView;
        QuickViewNotifications qvn = QuickViewNotifications.of(filterableView.getClass());
        if (qvn == null) {
            return;
        }
        String message = qvn.getMessage();
        if (message == null) {
            return;
        }
        new SimpleDVTNotification(view, qvn.fStyle, DID_YOU_KNOW_QUICKVEIEW_NOTIFICATION).setText(message).setShowPreferenceKey("show.notifications").setListener("openQuickView", () -> {
            AbstractTreeInformationControl abstractTreeInformationControl = ViewsUtils.openQuickView(quickViewNotifications.fQuickClass, view.getHistoryItem());
        }).create();
    }

    public static void showDidYouKnowEditorNotification(DVTEditor editor) {
        new SimpleDVTNotification(editor, 256, DID_YOU_KNOW_EDITOR_NOTIFICATION).setText("Right-click in the Editor > Show to see the available Quick Views.").setShowPreferenceKey("show.notifications").create();
    }

    public static void updateViewLabels(IDVTView view, EnumSet<TreeViewContentProvider.LabelUpdateKind> labelUpdateKind) {
        view.updateLabels(labelUpdateKind);
    }

    public static void showViewById(String id) {
        IWorkbenchWindow window = Utils.getActiveWorkbenchWindow();
        if (id == null || id.isEmpty() || window == null) {
            return;
        }
        try {
            IWorkbenchPage page = window.getActivePage();
            if (page == null) {
                return;
            }
            IViewPart view = page.findView(id);
            if (view == null) {
                if (page.findViewReference(id) == null) {
                    view = page.showView(id, null, 3);
                }
                view = page.showView(id, null, 2);
            }
            if (view == null) {
                return;
            }
            page.bringToTop((IWorkbenchPart)view);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public static void closeViewById(String id) {
        IWorkbenchWindow window = Utils.getActiveWorkbenchWindow();
        if (id == null || id.isEmpty() || window == null) {
            return;
        }
        try {
            IWorkbenchPage page = window.getActivePage();
            if (page == null) {
                return;
            }
            IViewPart view = page.findView(id);
            if (view == null || page.findViewReference(id) == null) {
                return;
            }
            page.hideView(view);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public static void closeView(IViewPart view) {
        try {
            IWorkbenchWindow window = Utils.getActiveWorkbenchWindow();
            if (window == null) {
                return;
            }
            IWorkbenchPage page = window.getActivePage();
            if (page == null) {
                return;
            }
            if (view == null) {
                return;
            }
            page.hideView(view);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public static List<IViewPart> findViewsContainingId(String id) {
        IWorkbenchPage page;
        block6: {
            IWorkbenchWindow window = Utils.getActiveWorkbenchWindow();
            if (id == null || id.isEmpty() || window == null) {
                return null;
            }
            page = window.getActivePage();
            if (page != null) break block6;
            return null;
        }
        try {
            ArrayList<IViewPart> viewParts = new ArrayList<IViewPart>(1);
            IViewReference[] iViewReferenceArray = page.getViewReferences();
            int n = iViewReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IViewPart viewPart;
                ViewReference ref;
                IViewReference reference = iViewReferenceArray[n2];
                if (reference instanceof ViewReference && id.equals((ref = (ViewReference)reference).getId()) && (viewPart = ref.getView(true)) != null) {
                    viewParts.add(viewPart);
                }
                ++n2;
            }
            return viewParts;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public static interface ITreePathAccessor<T> {
        public String getNameForPath(T var1);
    }

    private static enum QuickViewNotifications {
        TYPE_HIERARCHY(TypeHierarchyView.class, QuickTypeHierarchyView.class, "Quick Type Hierarchy", "ro.amiq.dvt.ui.action.QuickTypeHierarchy", 512),
        LAYERS(LayersView.class, QuickLayersView.class, "Quick Layers", "ro.amiq.dvt.ui.action.QuickLayers", 256);

        private Class<? extends IFilterableView> fViewClass;
        private Class<? extends AbstractTreeInformationControl> fQuickClass;
        private String fTitle;
        private String fShortcut;
        private int fStyle;

        private QuickViewNotifications(Class<? extends IFilterableView> viewClass, Class<? extends AbstractTreeInformationControl> quickClass, String title, String commandId, int style) {
            this.fViewClass = viewClass;
            this.fQuickClass = quickClass;
            this.fTitle = title;
            this.fStyle = style;
            IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getService(IBindingService.class);
            if (bindingService == null) {
                return;
            }
            Binding[] bindingArray = bindingService.getBindings();
            int n2 = bindingArray.length;
            int n3 = 0;
            while (n3 < n2) {
                Command command;
                Binding binding = bindingArray[n3];
                ParameterizedCommand parameterizedCommand = binding.getParameterizedCommand();
                if (parameterizedCommand != null && (command = parameterizedCommand.getCommand()) != null && commandId.equals(command.getId())) {
                    this.fShortcut = binding.getTriggerSequence().format();
                    break;
                }
                ++n3;
            }
        }

        public static QuickViewNotifications of(Class<? extends IFilterableView> viewClass) {
            QuickViewNotifications[] quickViewNotificationsArray = QuickViewNotifications.values();
            int n = quickViewNotificationsArray.length;
            int n2 = 0;
            while (n2 < n) {
                QuickViewNotifications c = quickViewNotificationsArray[n2];
                if (c.fViewClass == viewClass) {
                    return c;
                }
                ++n2;
            }
            return null;
        }

        public String getMessage() {
            if (this.fShortcut == null) {
                return null;
            }
            return "Press " + this.fShortcut + " in the editor to pop up the <a href=\"openQuickView\">" + this.fTitle + " View</a>.";
        }
    }

    public static class ViewInWindow {
        private IViewPart view;
        private IWorkbenchWindow window;

        private ViewInWindow(IViewPart view, IWorkbenchWindow window) {
            this.view = view;
            this.window = window;
        }

        public IViewPart getView() {
            return this.view;
        }

        public IWorkbenchWindow getWindow() {
            return this.window;
        }
    }
}

