/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.ILabelProvider;
import ro.amiq.dvt.diagrams.wave.IDVTWaveView;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.views.IRfFilterableTreeAccessor;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.search.text.ILineElement;
import ro.amiq.dvt.ui.views.BuildEvents;
import ro.amiq.dvt.ui.views.ComplexFilter;
import ro.amiq.dvt.ui.views.DVTBaseLabelProvider;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.IDVTView;
import ro.amiq.dvt.ui.views.UpdateJob;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.config.db.IDVTXConfigDBLabelProviderCommon;
import ro.amiq.dvt.ui.views.interpreter.DVTXInterpreterViewsLabelProvider;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.utils.DVTStringBuilder;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.SpecialStringMatcher;
import ro.amiq.dvt.utils.StringMatcher;

public abstract class ViewsUtilsCommon {
    public static final String LAZY_DESIGN_HIERARCHY_PORTS_VIEW_ID = "ro.amiq.dvt.ui.views.lazydesignhierarchy.LazyDesignHierarchyPortsView";
    public static final String PSS_SCENARIO_COVERAGE_VIEW_ID = "ro.amiq.pssdt.coverage.ScenarioCoverageView";
    public static final StringMatcher[] EMPTY_SEARCH_SEGMENTS = new StringMatcher[0];
    public static final boolean[] EMPTY_SEARCH_STRICTNESS = new boolean[0];
    public static final Set<String> ALL_VIEWS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("ro.amiq.dvt.ui.views.RefactoringConnectView", "ro.amiq.dvt.ui.views.LazyDesignHierarchyView", "ro.amiq.dvt.ui.views.TraceConnectionsView", "ro.amiq.dvt.ui.views.lazydesignhierarchy.LazyDesignHierarchyPortsView", "ro.amiq.pssdt.coverage.ScenarioCoverageView", "ro.amiq.dvt.ui.views.TraceConnectionsPortsView", "ro.amiq.dvt.ui.views.TypesView", "ro.amiq.dvt.ui.views.TypesMembersView", "ro.amiq.dvt.ui.views.UVMSequenceTreeView", "ro.amiq.dvt.ui.views.UVMComponentsHierarchyView", "ro.amiq.dvt.ui.views.VerificationHierarchyView", "ro.amiq.dvt.ui.views.VerificationHierarchyPortsView", "ro.amiq.dvt.ui.views.TypeHierarchyView", "ro.amiq.dvt.ui.views.MacrosView", "ro.amiq.dvt.ui.views.ChecksView", "ro.amiq.dvt.ui.views.CoverageView", "ro.amiq.dvt.ui.views.LayersView", "ro.amiq.dvt.ui.views.CallHierarchyView", "ro.amiq.dvt.tests.ui.views.HidHolderView", "ro.amiq.dvt.ui.views.CompileOrderView", "ro.amiq.dvt.ui.views.templates.CodeTemplatesView", "ro.amiq.dvt.ui.views.IntrpProfilerView", "ro.amiq.dvt.ui.views.RegistersView", "ro.amiq.dvt.ui.views.FactoryOverridesView", "ro.amiq.dvt.ui.views.ConfigDBView", "ro.amiq.dvt.ui.views.WaveViewerSignalTableView", "ro.amiq.dvt.ui.views.PowerDomainView", "ro.amiq.dvt.ui.views.WaveViewerSignalsPanelView", "ro.amiq.dvt.ui.views.WaveViewerLeftSignalsInstancesPanelView", "ro.amiq.dvt.ui.views.InspectView")));
    public static final Set<String> ALL_BUT_DH_VIEWS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("ro.amiq.dvt.ui.views.lazydesignhierarchy.LazyDesignHierarchyPortsView", "ro.amiq.dvt.ui.views.TraceConnectionsPortsView", "ro.amiq.dvt.ui.views.TypesView", "ro.amiq.dvt.ui.views.TypesMembersView", "ro.amiq.dvt.ui.views.UVMSequenceTreeView", "ro.amiq.dvt.ui.views.UVMComponentsHierarchyView", "ro.amiq.dvt.ui.views.VerificationHierarchyView", "ro.amiq.dvt.ui.views.VerificationHierarchyPortsView", "ro.amiq.dvt.ui.views.TypeHierarchyView", "ro.amiq.dvt.ui.views.MacrosView", "ro.amiq.dvt.ui.views.ChecksView", "ro.amiq.dvt.ui.views.CoverageView", "ro.amiq.dvt.ui.views.LayersView", "ro.amiq.dvt.ui.views.CallHierarchyView", "ro.amiq.dvt.tests.ui.views.HidHolderView", "ro.amiq.dvt.ui.views.CompileOrderView", "ro.amiq.dvt.ui.views.templates.CodeTemplatesView", "ro.amiq.dvt.ui.views.WaveViewerSignalTableView", "ro.amiq.dvt.ui.views.RegistersView", "ro.amiq.dvt.ui.views.PowerDomainView")));
    public static final Comparator<IRfNamedElement> NAMED_ELEMENT_LEXICAL_COMPARATOR = new Comparator<IRfNamedElement>(){

        @Override
        public int compare(IRfNamedElement o1, IRfNamedElement o2) {
            if (this.getName(o1) == null && this.getName(o2) == null) {
                return 0;
            }
            if (this.getName(o1) == null) {
                return -1;
            }
            if (this.getName(o2) == null) {
                return 1;
            }
            return this.getName(o1).compareTo(this.getName(o2));
        }

        private String getName(IRfNamedElement namedElement) {
            return namedElement == null ? null : namedElement.getName();
        }
    };

    public static StringMatcher createCamelCaseOrRegexMatcher(String text, boolean ignoreCase, boolean ignoreWildCards) {
        if (text == null || text.trim().isEmpty()) {
            return null;
        }
        if (!DVTStringUtil.isIdentifier(text) || text.endsWith("$")) {
            return SpecialStringMatcher.make(text, ignoreCase, ignoreWildCards);
        }
        return new StringMatcher(text, ignoreCase, ignoreWildCards);
    }

    public static boolean matchCamelCaseOrRegex(StringMatcher matcher, String text) {
        block5: {
            if (matcher != null && text != null) break block5;
            return true;
        }
        try {
            String pattern = matcher.getPattern();
            if (matcher instanceof SpecialStringMatcher) {
                return matcher.match(text);
            }
            return ViewsUtilsCommon.matchCamelCaseOnWordPieces(pattern, text);
        }
        catch (PatternSyntaxException patternSyntaxException) {
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return false;
    }

    private static boolean matchCamelCaseOnWordPieces(String pattern, String text) {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < text.length()) {
            if (Character.isJavaIdentifierPart(text.charAt(i))) {
                builder.append(text.charAt(i));
            } else if (builder.length() > 0) {
                if (DVTStringUtil.regionMatches(builder.toString(), pattern, 14)) {
                    return true;
                }
                builder.delete(0, builder.length());
            }
            ++i;
        }
        return builder.length() > 0 && DVTStringUtil.regionMatches(builder.toString(), pattern, 14);
    }

    public static String getUnitName(String baseUnitName, int unitNr, String prefix, String suffix) {
        StringBuilder result;
        StringBuilder stringBuilder = result = prefix != null && !prefix.isEmpty() ? new StringBuilder(prefix) : new StringBuilder();
        if (unitNr != 1) {
            result.append(baseUnitName).append("s");
        } else {
            result.append(baseUnitName);
        }
        if (suffix != null && !suffix.isEmpty()) {
            result.append(suffix);
        }
        return result.toString();
    }

    public static boolean filterElementComplex(IDVTElementWrapper node, ComplexFilter filter) {
        return ViewsUtilsCommon.filterElementComplex(node, filter, false, (IProgressMonitor)new NullProgressMonitor());
    }

    public static boolean filterElementComplex(IDVTElementWrapper node, ComplexFilter filter, IProgressMonitor monitor) {
        return ViewsUtilsCommon.filterElementComplex(node, filter, false, monitor);
    }

    public static boolean filterElementComplex(IDVTElementWrapper node, ComplexFilter filter, boolean markAsFilteredAndDoNotRemove, IProgressMonitor monitor) {
        if (!ViewsUtilsCommon.isValid(filter)) {
            return true;
        }
        boolean keepNode = false;
        if (ViewsUtils.isCanceled(filter) || monitor.isCanceled()) {
            return false;
        }
        if (node == null) {
            return false;
        }
        boolean match = ViewsUtilsCommon.matchesPath(node, filter.view);
        if (filter.matchPort) {
            match = match && ViewsUtilsCommon.matchesPort(node, filter.view);
        }
        boolean keepChildren = filter.keepChildrenForParentMatch && match;
        List allChildren = node.getAllChildren();
        if (!keepChildren && allChildren != null) {
            Iterator it = allChildren.iterator();
            while (it.hasNext()) {
                if (ViewsUtils.isCanceled(filter) || monitor.isCanceled()) {
                    return false;
                }
                IDVTElementWrapper child = (IDVTElementWrapper)it.next();
                if (child == null) continue;
                child.setAdditionalInfo(IDVTElementWrapper.Attribute.IS_FILTERED, false);
                boolean removeChild = ViewsUtilsCommon.filterElementComplex(child, filter, markAsFilteredAndDoNotRemove, monitor);
                if (removeChild) {
                    if (markAsFilteredAndDoNotRemove) {
                        child.setAdditionalInfo(IDVTElementWrapper.Attribute.IS_FILTERED, true);
                    } else {
                        it.remove();
                    }
                } else {
                    node.setAdditionalInfo(IDVTElementWrapper.Attribute.HAS_CHILDREN, true);
                }
                boolean bl = keepNode = keepNode || !removeChild;
            }
        }
        if (ViewsUtils.isCanceled(filter) || monitor.isCanceled()) {
            return false;
        }
        if (match) {
            node.setAdditionalInfo(IDVTElementWrapper.Attribute.MATCH, "*");
            if (!filter.shouldSkipCount(node)) {
                ++filter.matchCount;
            }
        }
        keepNode = keepNode || match;
        Object rfElement = node.getRfElement();
        if (rfElement instanceof IRfNamedElement) {
            IRfNamedElement namedElement = (IRfNamedElement)rfElement;
            keepNode = keepNode && !namedElement.getName().contains("Updating...");
        }
        return !keepNode;
    }

    private static boolean isValid(ComplexFilter filter) {
        if (filter == null || filter.view == null) {
            return false;
        }
        if (filter.view.getTreeSearchSegments() == null) {
            return false;
        }
        return filter.view.getTreeSearchSegments().length != 0 || filter.view.getTreeSearchPort() != null && !filter.view.getTreeSearchPort().isEmpty();
    }

    public static boolean matchesPath(Object node, IRfFilterableTreeAccessor view) {
        ILabelProvider labelProvider = view.getTreeLabelProvider();
        StringMatcher[] segments = view.getTreeSearchSegments();
        boolean[] isSegmentStrict = view.getTreeSearchStrictness();
        return ViewsUtilsCommon.matchesPath(node, labelProvider, segments, isSegmentStrict, view.getUpdateJob(), 1);
    }

    public static boolean matchesPath(Object node, ILabelProvider labelProvider, StringMatcher[] segments, boolean[] isSegmentStrict, UpdateJob job, int viewColumnCount) {
        int segmentsLength = segments.length;
        int currSegmentIndex = segmentsLength - 1;
        Object parentNode = node;
        Object lastNode = null;
        int lastSegmentIndex = segmentsLength;
        while (!ViewsUtils.isCanceled(job)) {
            if (currSegmentIndex < 0) {
                return true;
            }
            if (parentNode == null) {
                return false;
            }
            StringMatcher matcher = segments[currSegmentIndex];
            if (matcher == null) {
                return false;
            }
            String parentNodeLabel = "";
            boolean match = false;
            int i = 0;
            while (i < viewColumnCount) {
                parentNodeLabel = labelProvider instanceof DVTXInterpreterViewsLabelProvider ? ((DVTXInterpreterViewsLabelProvider)labelProvider).getColumnTextWithoutTrimming(parentNode, i) : (labelProvider instanceof DVTBaseLabelProvider ? ((DVTBaseLabelProvider)labelProvider).getColumnText(parentNode, i) : labelProvider.getText(parentNode));
                if ((!(labelProvider instanceof IDVTXConfigDBLabelProviderCommon) || parentNodeLabel != null) && (match = ViewsUtilsCommon.matchCamelCaseOrRegex(matcher, parentNodeLabel))) break;
                ++i;
            }
            if (match) {
                if (!isSegmentStrict[currSegmentIndex]) {
                    lastSegmentIndex = currSegmentIndex;
                    lastNode = parentNode;
                }
                --currSegmentIndex;
            } else if (isSegmentStrict[currSegmentIndex]) {
                if (lastSegmentIndex < segmentsLength && lastNode != null) {
                    currSegmentIndex = lastSegmentIndex;
                    parentNode = lastNode;
                } else {
                    return false;
                }
            }
            parentNode = ViewsUtilsCommon.getParent(parentNode);
        }
        return false;
    }

    private static Object getParent(Object node) {
        if (node instanceof IDVTElementWrapper) {
            return ((IDVTElementWrapper)node).getParent();
        }
        if (node instanceof ILineElement) {
            return ((ILineElement)node).getParent();
        }
        if (node instanceof IResource) {
            return ((IResource)node).getParent();
        }
        if (node instanceof TreePath) {
            return ((TreePath)node).getParent();
        }
        return null;
    }

    private static boolean matchesPort(IDVTElementWrapper node, IRfFilterableTreeAccessor view) {
        if (node == null || view == null) {
            return false;
        }
        if (ViewsUtils.isCanceled(view.getUpdateJob())) {
            return false;
        }
        String searchPort = view.getTreeSearchPort();
        List<String> memberNames = view.getMemberNames(node);
        if (searchPort == null || searchPort.isEmpty()) {
            return true;
        }
        if (memberNames == null || memberNames.isEmpty()) {
            return false;
        }
        StringMatcher matcher = ViewsUtilsCommon.createCamelCaseOrRegexMatcher(searchPort, true, false);
        for (String memberName : memberNames) {
            if (ViewsUtils.isCanceled(view.getUpdateJob())) {
                return false;
            }
            if (!ViewsUtilsCommon.matchCamelCaseOrRegex(matcher, memberName)) continue;
            return true;
        }
        return false;
    }

    public static boolean matchesUnfilteredPort(IDVTElementWrapper node, IRfFilterableTreeAccessor view) {
        if (node == null || view == null) {
            return false;
        }
        if (ViewsUtils.isCanceled(view.getUpdateJob())) {
            return false;
        }
        String searchPort = view.getTreeSearchPort();
        if (searchPort == null || searchPort.isEmpty()) {
            return true;
        }
        List<String> memberNames = view.getUnfilteredMemberNames(node);
        if (memberNames == null || memberNames.isEmpty()) {
            return false;
        }
        StringMatcher matcher = ViewsUtilsCommon.createCamelCaseOrRegexMatcher(searchPort, true, false);
        for (String memberName : memberNames) {
            if (ViewsUtils.isCanceled(view.getUpdateJob())) {
                return false;
            }
            if (!ViewsUtilsCommon.matchCamelCaseOrRegex(matcher, memberName)) continue;
            return true;
        }
        return false;
    }

    public static boolean matchesPort(TreePath node, IRfFilterableTreeAccessor view) {
        if (node == null || view == null) {
            return false;
        }
        if (ViewsUtils.isCanceled(view.getUpdateJob())) {
            return false;
        }
        String searchPort = view.getTreeSearchPort();
        if (view instanceof IDVTWaveView) {
            List<String> portsLabels = ((IDVTWaveView)((Object)view)).getPortsLabels(node);
            if (searchPort == null || searchPort.isEmpty()) {
                return true;
            }
            if (portsLabels == null || portsLabels.isEmpty()) {
                return false;
            }
            StringMatcher matcher = ViewsUtilsCommon.createCamelCaseOrRegexMatcher(searchPort, true, false);
            for (String string : portsLabels) {
                if (ViewsUtils.isCanceled(view.getUpdateJob())) {
                    return false;
                }
                if (!ViewsUtilsCommon.matchCamelCaseOrRegex(matcher, string)) continue;
                return true;
            }
        } else {
            List<? extends IRfNamedElement> ports = view.getPorts(node);
            if (searchPort == null || searchPort.isEmpty()) {
                return true;
            }
            if (ports == null || ports.isEmpty()) {
                return false;
            }
            StringMatcher matcher = ViewsUtilsCommon.createCamelCaseOrRegexMatcher(searchPort, true, false);
            for (IRfNamedElement iRfNamedElement : ports) {
                if (ViewsUtils.isCanceled(view.getUpdateJob())) {
                    return false;
                }
                String labelName = iRfNamedElement.getName();
                if (iRfNamedElement.isShallowCompiled()) {
                    labelName = "[S] " + labelName;
                } else if (iRfNamedElement.isIncrementalShallowCompiled()) {
                    labelName = "[iS] " + labelName;
                }
                if (!ViewsUtilsCommon.matchCamelCaseOrRegex(matcher, labelName)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hierarchicalSearch(IDVTElementWrapper node, DVTBaseLabelProvider labelProvider, UpdateJob updateJob, StringMatcher[] searchSegments, boolean[] searchStrictness) {
        return ViewsUtilsCommon.hierarchicalSearch(node, labelProvider, updateJob, searchSegments, searchStrictness, false);
    }

    public static boolean hierarchicalSearch(IDVTElementWrapper node, final DVTBaseLabelProvider labelProvider, UpdateJob updateJob, final StringMatcher[] searchSegments, final boolean[] searchStrictness, boolean keepChildrenForParentMatch) {
        if (searchSegments == null || searchSegments.length == 0) {
            return true;
        }
        IRfFilterableTreeAccessor filterAccesor = new IRfFilterableTreeAccessor(){

            @Override
            public boolean[] getTreeSearchStrictness() {
                return searchStrictness;
            }

            @Override
            public StringMatcher[] getTreeSearchSegments() {
                return searchSegments;
            }

            @Override
            public String getTreeSearchPort() {
                return null;
            }

            @Override
            public ILabelProvider getTreeLabelProvider() {
                return labelProvider;
            }

            @Override
            public List<String> getMemberNames(IDVTElementWrapper node) {
                return null;
            }

            @Override
            public boolean isFiltered() {
                return false;
            }

            @Override
            public UpdateJob getUpdateJob() {
                return null;
            }
        };
        return ViewsUtilsCommon.filterElementComplex(node, new ComplexFilter(filterAccesor, false, keepChildrenForParentMatch));
    }

    public static boolean isCanceled(ComplexFilter filter) {
        return ViewsUtils.isCanceled(filter.view.getUpdateJob());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean hasMoreThanOneDVTNature(IProject project) {
        try {
            if (project == null) return false;
            if (!project.isAccessible()) {
                return false;
            }
            String[] natures = new String[]{"ro.amiq.vlogdt.VlogNature", "ro.amiq.edt.enature", "ro.amiq.vhdldt.VhdlNature", "ro.amiq.slndt.slnnature", "ro.amiq.msdldt.msdlnature", "ro.amiq.pssdt.pssnature", "ro.amiq.dvt.cdt.cppextnature"};
            int nofNatures = 0;
            String[] stringArray = natures;
            int n = natures.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                String nature = stringArray[n2];
                if (project.hasNature(nature)) {
                    ++nofNatures;
                }
                if (nofNatures == 2) {
                    return true;
                }
                ++n2;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return false;
    }

    public static void updateView(IDVTView view, BuildEvents event, boolean viewWillBecomeVisible) {
        boolean viewVisible = ViewsUtils.isViewVisible(view);
        view.setDirty(!viewVisible);
        if (viewVisible || viewWillBecomeVisible) {
            view.update(event);
        }
    }

    public static String trimBeginningText(String text, int maxLength) {
        String newComment = text;
        if (newComment == null || newComment.isEmpty()) {
            return newComment;
        }
        if (maxLength <= -1) {
            return "";
        }
        if (newComment.length() > maxLength) {
            newComment = "..." + newComment.substring(newComment.length() - maxLength, newComment.length());
        }
        return newComment;
    }

    public static String trimText(String text, int maxLength, boolean replaceNewlinesWithSpaces) {
        String newComment = "";
        if (text == null || text.isEmpty()) {
            return newComment;
        }
        if (replaceNewlinesWithSpaces) {
            newComment = DVTStringUtil.replaceAll(DVTStringUtil.NEW_LINE, text, " ");
        }
        if (newComment.length() > maxLength) {
            newComment = String.valueOf(newComment.substring(0, maxLength)) + "...";
        }
        return newComment;
    }

    public static String pathToRoot(Object wrapper, String separator, ViewsUtils.ITreePathAccessor<Object> acc) {
        DVTStringBuilder pathBuilder = new DVTStringBuilder();
        ViewsUtilsCommon.pathToRootRecursive(wrapper, pathBuilder, separator, acc);
        if (pathBuilder.length() == 0) {
            return "";
        }
        return pathBuilder.toString();
    }

    private static void pathToRootRecursive(Object wrapper, DVTStringBuilder path, String separator, ViewsUtils.ITreePathAccessor<Object> acc) {
        Object parent;
        if (wrapper == null || acc == null) {
            return;
        }
        String text = acc.getNameForPath(wrapper);
        if (text == null || text.isEmpty()) {
            return;
        }
        if (path.length() != 0) {
            path.prepend(separator);
        }
        path.prepend(text);
        if (wrapper instanceof TreePath) {
            parent = ((TreePath)wrapper).getParent();
        } else if (wrapper instanceof IDVTElementWrapper) {
            parent = ((IDVTElementWrapper)wrapper).getParent();
        } else {
            return;
        }
        ViewsUtilsCommon.pathToRootRecursive(parent, path, separator, acc);
    }
}

