/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.callhierarchy;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.startup.core.EclipseUtils;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.DVTSpinnerInputDialog;
import ro.amiq.dvt.ui.actions.history.HistoryAction;
import ro.amiq.dvt.ui.actions.history.HistoryItem;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.ui.projectcolors.ProjectColorUtils;
import ro.amiq.dvt.ui.utils.DVTColorUtil;
import ro.amiq.dvt.ui.views.BuildEvents;
import ro.amiq.dvt.ui.views.DVTLabelProviderProxy;
import ro.amiq.dvt.ui.views.DVTViewContributors;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.IDVTJob;
import ro.amiq.dvt.ui.views.IUpdateJobImpl;
import ro.amiq.dvt.ui.views.InspectViewUpdateEvent;
import ro.amiq.dvt.ui.views.TreeViewContentProvider;
import ro.amiq.dvt.ui.views.UpdateJob;
import ro.amiq.dvt.ui.views.UpdateViewEvent;
import ro.amiq.dvt.ui.views.ViewDataContainer;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.callhierarchy.CallHierarchyComputeStrategy;
import ro.amiq.dvt.ui.views.callhierarchy.CallHierarchyViewCommon;
import ro.amiq.dvt.ui.views.callhierarchy.CallHierarchyViewInput;
import ro.amiq.dvt.ui.views.callhierarchy.CallHierarchyViewInputConfigurator;
import ro.amiq.dvt.ui.views.callhierarchy.ICallHierarchyViewContributor;
import ro.amiq.dvt.ui.views.inspect.InspectViewComponent;
import ro.amiq.dvt.ui.views.typehierarchy.GotoDataContainer;
import ro.amiq.dvt.utils.Utils;

public class CallHierarchyView
extends CallHierarchyViewCommon
implements IUpdateJobImpl {
    private static final List<ICallHierarchyViewContributor> fAllCallHierarchyContributors = DVTViewContributors.getInstance().getAllInstanceOf(ICallHierarchyViewContributor.class);
    private static final String NEEDS_REFRESH = "[Needs Refresh]";
    public static final String DELETE_NODE = "deleteNode";
    public static final String EXPAND_ALL_CHILDREN = "expandAllChildren";
    public static final String GO_TO_PARENT = "goToParent";
    public static final String GO_TO_DECLARATION = "goToDeclaration";
    private static final String EXPAND_MULTIPLE_LEVELS = "expandNLevels";
    private static final String EXPAND_MULTIPLE_LEVELS_LABEL = "Expand Multiple Levels";
    private static final String DEPTH_DIALOG_DESCRIPTION = "Levels to Expand:";
    private final Map<LanguageKind, ICallHierarchyViewContributor> fAllUVMSTContributorsByLanguageKind = new EnumMap<LanguageKind, ICallHierarchyViewContributor>(LanguageKind.class);
    private final UpdateJob fUpdateJob;
    private static final int INSPECT_PANEL_WEIGHT = 33;
    private static final int TREE_WEIGHT = 67;
    private DVTLabelProviderProxy<ICallHierarchyViewContributor> fLabelProvider = new DVTLabelProviderProxy<ICallHierarchyViewContributor>(ICallHierarchyViewContributor.class, "default-tree");
    private Label fInfo;
    private Label fContentFiltersLabel;
    private Image fContentFiltersEnabledIcon = DVTImages.imageCache.getImage(DVTImages.GUI_FILTERS_ICON_MINI);
    private Image fContentFiltersDisabledIcon = DVTImages.imageCache.getImage(DVTImages.GUI_FILTERS_ICON_MINI_DISABLED);
    private String fLabelInfo;
    private Tree fTree;
    private TreeViewContentProvider fLazyContentProvider;
    private boolean fHasGUIFilteredRoots;
    private boolean fIsLinkedWithEditor;
    private boolean fIsQuickSearchUpdate = false;
    private CallHierarchyHistoryAction fCallHierarchyHistoryAction = new CallHierarchyHistoryAction();
    private TreeColumn fNameColumn = null;
    private TreeColumn fLineColumn = null;
    private TreeColumn fSourceColumn = null;
    private TreeColumn fCommentColumn = null;
    private List<IDVTElementWrapper> fElements;
    private PrependPackageAction fPrependPackageAction = new PrependPackageAction();
    private FilterAction fFilterAction = new FilterAction();
    private RefreshAction fRefreshAction = new RefreshAction();
    private LinkWithEditorAction fLinkWithEditorAction = new LinkWithEditorAction();
    private EShowAllSimilarLayersModeAction fShowAllSimilarLayersAction = new EShowAllSimilarLayersModeAction();
    private DeleteNodeAction fDeleteNodeAction = new DeleteNodeAction();
    private ExpandAllChildrenAction fExpandAllChildrenAction = new ExpandAllChildrenAction();
    private GoToRecurrenceParentAction fGoToRecurrenceParentAction = new GoToRecurrenceParentAction();
    private GoToDeclarationAction fGoToDeclarationAction = new GoToDeclarationAction();
    private ExpandMultipleLevelsAction fExpandNLevelsRightClickAction = new ExpandMultipleLevelsAction(EXPAND_MULTIPLE_LEVELS_TYPE.RIGHT_CLICK);
    private ExpandMultipleLevelsAction fExpandNLevelsToolbarButtonAction = new ExpandMultipleLevelsAction(EXPAND_MULTIPLE_LEVELS_TYPE.TOOLBAR);
    private CallerHierarchySelectAction fCallerHierarchyAction = new CallerHierarchySelectAction();
    private CalleeHierarchySelectAction fCalleeHierarchyAction = new CalleeHierarchySelectAction();
    private ToggleInspectPanelAction fToggleInspectPanelAction = new ToggleInspectPanelAction();
    private Composite fLabelComposite;
    private PaintListener fPaintInfoLabelListener;
    private InspectViewComponent fInspectComponent;
    private SashForm fSashFormParent;
    private Composite fCompositeParent;
    private SashForm fSashForm;

    public CallHierarchyView() {
        this.fUpdateJob = new UpdateJob("Update Call Hierarchy View", this);
        this.fUpdateJob.setSystem(false);
        this.fUpdateJob.setUser(true);
        for (ICallHierarchyViewContributor contributor : fAllCallHierarchyContributors) {
            this.fAllUVMSTContributorsByLanguageKind.put(contributor.getLanguageKind(), contributor);
        }
    }

    @Override
    public void customCreatePartControl(Composite parent) {
        GridData gridData = new GridData(4, 4, true, true);
        parent.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        parent.setLayout((Layout)layout);
        this.fLabelComposite = new Composite(parent, 0);
        GridLayout labelLayout = new GridLayout(2, false);
        this.fLabelComposite.setLayout((Layout)labelLayout);
        this.fLabelComposite.setLayoutData((Object)new GridData(4, 1, true, false));
        this.fPaintInfoLabelListener = new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (CallHierarchyView.this.fInfo == null) {
                    return;
                }
                Color labelColor = CallHierarchyView.this.fInfo.getBackground();
                if (labelColor.equals((Object)DVTUiUtils.COLOR_RED)) {
                    return;
                }
                DVTColorUtil.INSTANCE.setBackground((Control)CallHierarchyView.this.fInfo, DVTColorUtil.INSTANCE.getBackground((Control)CallHierarchyView.this.fInfo.getParent()), false);
            }
        };
        this.fLabelComposite.addPaintListener(this.fPaintInfoLabelListener);
        this.fContentFiltersLabel = new Label(this.fLabelComposite, 0);
        if (EclipseUtils.isAtLeastEclipse419()) {
            this.fContentFiltersLabel.setImage(this.fHasGUIFilteredRoots ? this.fContentFiltersEnabledIcon : this.fContentFiltersDisabledIcon);
        } else {
            this.fContentFiltersLabel.setImage(this.fContentFiltersEnabledIcon);
        }
        this.fContentFiltersLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, true));
        this.fContentFiltersLabel.setToolTipText("Content Filters matched!");
        this.fContentFiltersLabel.setEnabled(this.fHasGUIFilteredRoots);
        this.fInfo = new Label(this.fLabelComposite, 16384);
        GridData layoutData = new GridData(4, 0x1000000, true, false);
        this.fInfo.setLayoutData((Object)layoutData);
        this.fSashFormParent = new SashForm(parent, 66048);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.fSashFormParent);
        this.fCompositeParent = new Composite((Composite)this.fSashFormParent, 0);
        GridLayoutFactory.fillDefaults().spacing(0, 1).applyTo(this.fCompositeParent);
        GridDataFactory.fillDefaults().applyTo((Control)this.fCompositeParent);
        this.fSashForm = new SashForm(this.fCompositeParent, 65792);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.fSashForm);
        this.fTree = new Tree((Composite)this.fSashForm, 268436228);
        this.fTree.setHeaderVisible(true);
        this.fLazyContentProvider = new TreeViewContentProvider(this.fTree, this.fLabelProvider);
        this.fTree.addListener(17, new Listener(){

            public void handleEvent(Event event) {
                IDVTElementWrapper wrapper = (IDVTElementWrapper)((TreeItem)event.item).getData();
                boolean childrenComputed = (Boolean)wrapper.getAdditionalInfo((Object)IDVTElementWrapper.Attribute.CHILDREN_COMPUTED);
                if (childrenComputed) {
                    return;
                }
                ComputeChildrenJob computeChildrenJob = new ComputeChildrenJob(event, 1, false);
                computeChildrenJob.setSystem(true);
                computeChildrenJob.schedule();
            }
        });
        this.fTree.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (!CallHierarchyView.this.fIsLinkedWithEditor) {
                    return;
                }
                if (!(e.item instanceof TreeItem)) {
                    return;
                }
                if (!(e.item.getData() instanceof IDVTElementWrapper)) {
                    return;
                }
                CallHierarchyView.this.gotoSelectedElement("default-tree");
                ((TreeItem)e.item).getParent().setFocus();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.fTree.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u007f') {
                    CallHierarchyView.this.fDeleteNodeAction.run();
                }
                if (e.keyCode == 0x1000004) {
                    Event expandEvent = new Event();
                    expandEvent.item = CallHierarchyView.this.fTree.getSelection()[0];
                    IDVTElementWrapper wrapper = CallHierarchyView.this.getSelectedWrapper("default-tree");
                    if (!wrapper.hasChildren() || wrapper.getAdditionalInfo((Object)IDVTElementWrapper.Attribute.CHILDREN_COMPUTED).equals(true) && wrapper.getExpanded() != -2) {
                        return;
                    }
                    ComputeChildrenJob computeChildrenJob = new ComputeChildrenJob(expandEvent, 1, true);
                    computeChildrenJob.setSystem(true);
                    computeChildrenJob.schedule();
                }
            }
        });
        this.fTree.addKeyListener((KeyListener)this.getKeyListener("default-filter", "default-tree"));
        this.fTree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                CallHierarchyView.this.gotoSelectedElement("default-tree");
            }

            public void mouseDown(MouseEvent e) {
            }
        });
        this.fInspectComponent = new InspectViewComponent((Composite)this.fSashForm, 300L);
        this.fInspectComponent.setVisible(PrefConst.getCallHierarchyShowInspectPanel());
        this.fSashForm.setWeights(new int[]{67, 33});
        this.createToolbar();
        this.installContextMenuAndSelectionListener((Control)this.fTree);
        this.createTreeContextMenu();
    }

    @Override
    protected void fireSelectionChanged(SelectionChangedEvent event) {
        super.fireSelectionChanged(event);
        ISelection selection = event.getSelection();
        if (!(selection instanceof StructuredSelection)) {
            return;
        }
        if (selection.isEmpty()) {
            return;
        }
        Object wrapper = ((StructuredSelection)selection).getFirstElement();
        if (!(wrapper instanceof IDVTElementWrapper)) {
            return;
        }
        Display.getDefault().asyncExec(() -> this.fInspectComponent.update(new InspectViewUpdateEvent((IDVTElementWrapper)wrapper, event)));
    }

    private IToolBarManager getToolbarManager() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        return actionBars.getToolBarManager();
    }

    private void createToolbar() {
        IToolBarManager tbm = this.getToolbarManager();
        tbm.removeAll();
        tbm.add((IAction)this.fShowAllSimilarLayersAction);
        tbm.add((IContributionItem)new Separator());
        tbm.add((IAction)this.fRefreshAction);
        tbm.add((IContributionItem)new Separator());
        tbm.add((IAction)this.fCallerHierarchyAction);
        tbm.add((IAction)this.fCalleeHierarchyAction);
        tbm.add((IContributionItem)new Separator());
        tbm.add((IAction)this.fLinkWithEditorAction);
        tbm.add((IAction)this.fFilterAction);
        tbm.add((IAction)this.fToggleInspectPanelAction);
        tbm.add((IContributionItem)new Separator());
        tbm.add((IAction)this.fCallHierarchyHistoryAction);
        tbm.add((IContributionItem)new Separator());
        tbm.add((IAction)this.fPrependPackageAction);
        tbm.add((IAction)this.fExpandNLevelsToolbarButtonAction);
        this.fFilterAction.setMenuCreator(new CallHierarchyViewMenuCreator());
        this.updateActionState();
    }

    private void addToHistory() {
        if (this.getHistoryItem() == null) {
            return;
        }
        this.fCallHierarchyHistoryAction.addElement(this.getHistoryItem());
    }

    @Override
    public void update(BuildEvents updateEvent) {
        try {
            IProject project;
            if (this.fTree == null) {
                return;
            }
            if (updateEvent == BuildEvents.INCREMENTAL_BUILD || updateEvent == BuildEvents.GUI_FILTERS_PROJECT || updateEvent == BuildEvents.GUI_FILTERS_WORKSPACE) {
                this.setCallHierarchyDirty(true, true);
                return;
            }
            HistoryItem historyItem = this.getHistoryItem();
            DVTColorUtil.INSTANCE.setBackground((Control)this.fInfo, DVTColorUtil.INSTANCE.getBackground((Control)this.fInfo.getParent()), true);
            if (historyItem == null) {
                this.fInfo.setText("");
                ProjectColorUtils.setFgBg(this, null);
                this.fLazyContentProvider.setInput((List<IDVTElementWrapper>)new ArrayList<IDVTElementWrapper>(INPUT_CALL_HIERARCHY_VIEW), this.fExpandLevel);
                return;
            }
            if (historyItem instanceof UpdateViewEvent) {
                UpdateViewEvent ev = (UpdateViewEvent)historyItem;
                if (ev.getUpdateHistory() == 6) {
                    this.addToHistory();
                }
                this.fLazyContentProvider.setInput((List<IDVTElementWrapper>)new ArrayList<IDVTElementWrapper>(UPDATE_JOB_MESSAGE_INPUT), this.fExpandLevel);
            }
            if ((project = this.getProject()) == null || !project.isAccessible() || !Utils.hasDvtNature(project)) {
                this.clean();
                return;
            }
            if (!DVTPlugin.getDefault().collect().c(project, "F636F7265")) {
                return;
            }
            if (!this.fIsQuickSearchUpdate) {
                this.setCallHierarchyDirty(false, false);
            }
            this.fHasGUIFilteredRoots = false;
            this.fUpdateJob.cancel();
            this.fUpdateJob.schedule();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    public void updateNonGuiPart(UpdateJob updateJob) {
        try {
            this.fElements = new ArrayList<IDVTElementWrapper>();
            ICallHierarchyViewContributor viewContributor = this.getViewContributor(this.getHistoryItem());
            if (viewContributor == null) {
                return;
            }
            if (!this.fIsQuickSearchUpdate) {
                viewContributor.updateFilterOptions();
            }
            if (updateJob == null || ViewsUtils.isCanceled(updateJob)) {
                return;
            }
            IProject project = this.getProject();
            CallHierarchyViewInput input = viewContributor.getInput(new CallHierarchyViewInputConfigurator(this.getHistoryItem(), project, this.isShowPrependPackage(), updateJob, PrefConst.getCallHierarchyViewStrategy()));
            List<IDVTElementWrapper> origElems = input.getElements();
            this.fElements.addAll(origElems);
            this.fHasGUIFilteredRoots = this.fHasGUIFilteredRoots || input.getHasGUIFilteredRoots();
            this.fLabelInfo = input.getLabelInfo();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    public void updateGuiPart(UpdateJob updateJob) {
        try {
            boolean redrawView = false;
            if (this.fSourceColumn == null || this.fCommentColumn == null || this.fLineColumn == null || this.fNameColumn == null) {
                redrawView = true;
            }
            HistoryItem historyItem = this.getHistoryItem();
            redrawView = this.enableFilter(redrawView, historyItem);
            redrawView = this.enableCallerStrategy(redrawView, historyItem);
            if (redrawView = this.enableShowAllLayers(redrawView, historyItem)) {
                this.redrawView();
            }
            IProject project = this.getProject();
            if (this.fLazyContentProvider == null | this.fElements == null || this.fInfo == null || project == null) {
                return;
            }
            if (this.fElements.isEmpty()) {
                if (this.fHasGUIFilteredRoots) {
                    this.fLazyContentProvider.setInput((List<IDVTElementWrapper>)new ArrayList<IDVTElementWrapper>(GUI_FILTERED_EMPTY_CONTENT), this.fExpandLevel);
                } else {
                    this.fLazyContentProvider.setInput((List<IDVTElementWrapper>)new ArrayList<IDVTElementWrapper>(NO_DATA_MESSAGE), this.fExpandLevel);
                }
            } else {
                this.fLazyContentProvider.setInput(this.fElements, -1);
                this.fTree.setFocus();
            }
            if (this.fLabelInfo == null) {
                this.fLabelInfo = "";
            }
            boolean dirty = this.fInfo.getText().startsWith(NEEDS_REFRESH);
            StringBuilder infoText = new StringBuilder();
            infoText.append("[").append(project.getName()).append("] ").append(this.fLabelInfo.replaceAll("\n", ""));
            this.fInfo.setText(infoText.toString());
            this.fInfo.setToolTipText(this.fLabelInfo);
            ProjectColorUtils.setFgBg(this, project.getName());
            if (this.fIsQuickSearchUpdate) {
                this.fIsQuickSearchUpdate = false;
                if (dirty) {
                    this.setCallHierarchyDirty(true, true);
                }
            }
            if (EclipseUtils.isAtLeastEclipse419()) {
                this.fContentFiltersLabel.setImage(this.fHasGUIFilteredRoots ? this.fContentFiltersEnabledIcon : this.fContentFiltersDisabledIcon);
            }
            this.fContentFiltersLabel.setEnabled(this.fHasGUIFilteredRoots);
            this.fExpandLevel = 1;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private boolean enableFilter(boolean redrawView, HistoryItem historyItem) {
        if (historyItem != null && this.fFilterAction != null) {
            boolean shouldEnable;
            boolean enabled = this.fFilterAction.isEnabled();
            boolean bl = shouldEnable = historyItem.getLanguage() == LanguageKind.VLOG;
            if (enabled != shouldEnable) {
                this.fFilterAction.setEnabled(shouldEnable);
                redrawView = true;
            }
        }
        return redrawView;
    }

    private boolean enableCallerStrategy(boolean redrawView, HistoryItem historyItem) {
        if (historyItem != null && this.fCalleeHierarchyAction != null && this.fCallerHierarchyAction != null) {
            boolean shouldEnable;
            boolean enabled = this.fCallerHierarchyAction.isEnabled();
            boolean bl = shouldEnable = historyItem.getLanguage() == LanguageKind.VLOG;
            if (enabled != shouldEnable) {
                this.fCallerHierarchyAction.setEnabled(shouldEnable);
                redrawView = true;
            }
            if (!shouldEnable && PrefConst.getCallHierarchyViewStrategy() == CallHierarchyComputeStrategy.CALLER) {
                this.fCallerHierarchyAction.setChecked(false);
                this.fCalleeHierarchyAction.setChecked(true);
            }
        }
        return redrawView;
    }

    private boolean enableShowAllLayers(boolean redrawView, HistoryItem historyItem) {
        if (historyItem != null && this.fShowAllSimilarLayersAction != null) {
            boolean shouldEnable;
            ICallHierarchyViewContributor viewContributor = this.getViewContributor(historyItem);
            boolean enabled = this.fShowAllSimilarLayersAction.isEnabled();
            boolean bl = shouldEnable = historyItem.getLanguage() == LanguageKind.E && viewContributor.enableAllLayers(historyItem);
            if (enabled != shouldEnable) {
                this.fShowAllSimilarLayersAction.setEnabled(shouldEnable);
                redrawView = true;
            }
        }
        return redrawView;
    }

    @Override
    public void dispose() {
        if (this.fTree != null && !this.fTree.isDisposed()) {
            this.fTree.dispose();
        }
        if (this.fInfo != null && !this.fInfo.isDisposed()) {
            this.fInfo.dispose();
        }
        if (this.fContentFiltersLabel != null && !this.fContentFiltersLabel.isDisposed()) {
            this.fContentFiltersLabel.dispose();
        }
        if (this.fNameColumn != null) {
            this.fNameColumn.dispose();
        }
        if (this.fLineColumn != null) {
            this.fLineColumn.dispose();
        }
        if (this.fSourceColumn != null) {
            this.fSourceColumn.dispose();
        }
        if (this.fCommentColumn != null) {
            this.fCommentColumn.dispose();
        }
        if (this.fLabelComposite != null && !this.fLabelComposite.isDisposed()) {
            this.fLabelComposite.removePaintListener(this.fPaintInfoLabelListener);
            this.fLabelComposite.dispose();
        }
        this.fTree = null;
        this.fInfo = null;
        this.fContentFiltersLabel = null;
        this.fLazyContentProvider = null;
        this.fInfo = null;
        this.fLabelComposite = null;
        super.dispose();
    }

    public void setFocus() {
        this.fTree.setFocus();
    }

    private void redrawView() {
        this.createToolbar();
        if (this.fNameColumn == null) {
            this.fNameColumn = new TreeColumn(this.fTree, 16384, 0);
            this.fNameColumn.setText("Calls");
            this.fNameColumn.setMoveable(true);
        }
        this.fNameColumn.setWidth(400);
        if (this.fLineColumn == null) {
            this.fLineColumn = new TreeColumn(this.fTree, 16384, 1);
            this.fLineColumn.setText("Line");
            this.fLineColumn.setMoveable(true);
        }
        this.fLineColumn.setWidth(100);
        if (this.fSourceColumn == null) {
            this.fSourceColumn = new TreeColumn(this.fTree, 16384, 2);
            this.fSourceColumn.setText("Source");
            this.fSourceColumn.setMoveable(true);
        }
        this.fSourceColumn.setWidth(150);
        if (this.fCommentColumn == null) {
            this.fCommentColumn = new TreeColumn(this.fTree, 16384, 3);
            this.fCommentColumn.setText("Comment");
            this.fCommentColumn.setMoveable(true);
        }
        this.fCommentColumn.setWidth(150);
    }

    private ICallHierarchyViewContributor getViewContributor(IDVTElementWrapper wrapper) {
        return DVTViewContributors.getInstance().getViewContributor(wrapper, ICallHierarchyViewContributor.class);
    }

    private ICallHierarchyViewContributor getViewContributor(HistoryItem historyItem) {
        if (historyItem == null) {
            return null;
        }
        return this.fAllUVMSTContributorsByLanguageKind.get((Object)this.getHistoryItem().getLanguage());
    }

    @Override
    public void gotoSelectedElement(String treeId) {
        IDVTElementWrapper selectedWrapper = this.getSelectedWrapper(treeId);
        ICallHierarchyViewContributor viewContributor = this.getViewContributor(selectedWrapper);
        if (selectedWrapper == null || viewContributor == null) {
            return;
        }
        viewContributor.gotoElement(this.getProject(), new GotoDataContainer(selectedWrapper, this.getHistoryItem()));
    }

    @Override
    public void stringMatcherUpdated(String textFilterId) {
    }

    @Override
    public Tree getTree(String treeId) {
        return this.fTree;
    }

    @Override
    public Object getTreeRootElement(String treeId) {
        return this.fTree.getData();
    }

    public DVTLabelProviderProxy<ICallHierarchyViewContributor> getLabelProvider() {
        return this.fLabelProvider;
    }

    @Override
    public void refreshSelection(IResource resource) {
    }

    @Override
    public void clean() {
        this.fUpdateJob.cancel();
        IProject project = this.getProject();
        if (project == null || !project.isAccessible() || !Utils.hasDvtNature(project)) {
            this.fInfo.setText("[no DVT Project or file selected]");
            ProjectColorUtils.setFgBg(this, null);
            this.fLazyContentProvider.setInput((List<IDVTElementWrapper>)new ArrayList<IDVTElementWrapper>(INPUT_SELECT_PROJECT_OR_FILE), this.fExpandLevel);
            this.fContentFiltersLabel.setEnabled(false);
        } else {
            this.fLazyContentProvider.setInput((List<IDVTElementWrapper>)new ArrayList<IDVTElementWrapper>(NO_DATA_MESSAGE), this.fExpandLevel);
            this.fContentFiltersLabel.setEnabled(false);
            if (this.fLabelInfo != null) {
                this.fInfo.setText("[" + project.getFullPath() + "] " + this.fLabelInfo.replaceAll("\n", ""));
                this.fInfo.setToolTipText(this.fLabelInfo);
                ProjectColorUtils.setFgBg(this, project.getName());
            }
        }
    }

    public boolean isShowPrependPackage() {
        if (this.fPrependPackageAction != null) {
            return this.fPrependPackageAction.isChecked();
        }
        return PrefConst.getCallHierarchyViewPrependPackage();
    }

    protected void updateActionState() {
        if (!(PrefConst.getCallHierarchyViewHideConditionals() || PrefConst.getCallHierarchyViewHideOverrides() || PrefConst.getCallHierarchyViewHideForks() || PrefConst.getCallHierarchyViewHideNamedBlocks())) {
            this.fFilterAction.setChecked(false);
        } else {
            this.fFilterAction.setChecked(true);
        }
    }

    private void setCallHierarchyDirty(boolean dirty, boolean showNeedsRefresh) {
        if (dirty && (this.getHistoryItem() == null || this.fElements == null || this.fElements.isEmpty())) {
            return;
        }
        this.fRefreshAction.setEnabled(dirty);
        if (!this.fInfo.getText().startsWith(NEEDS_REFRESH) && showNeedsRefresh) {
            String infoText = "[Needs Refresh] " + this.fInfo.getText();
            this.fInfo.setText(infoText);
            DVTColorUtil.INSTANCE.setBackground((Control)this.fInfo, DVTUiUtils.COLOR_RED);
            DVTColorUtil.INSTANCE.setForeground((Control)this.fInfo, DVTUiUtils.COLOR_BLACK);
        }
        this.getToolbarManager().update(true);
    }

    public void testRefresh() {
        this.fRefreshAction.run();
    }

    protected void createTreeContextMenu() {
        MenuManager contextMenuManager = this.installContextMenuAndSelectionListener((Control)this.fTree);
        if (contextMenuManager == null) {
            return;
        }
        contextMenuManager.setRemoveAllWhenShown(true);
        contextMenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                TreeItem currentSelection = CallHierarchyView.this.fTree.getSelection()[0];
                if (currentSelection == null) {
                    return;
                }
                IDVTElementWrapper selectedWrapper = CallHierarchyView.this.getSelectedWrapper("default-tree");
                if (selectedWrapper == null) {
                    return;
                }
                ICallHierarchyViewContributor viewContributor = CallHierarchyView.this.getViewContributor(CallHierarchyView.this.getHistoryItem());
                if (viewContributor == null) {
                    return;
                }
                ArrayList<String> actions = new ArrayList<String>();
                if (viewContributor.canGoToDeclarationOnWrapper(selectedWrapper)) {
                    actions.add(CallHierarchyView.GO_TO_DECLARATION);
                }
                if (currentSelection.getParentItem() != null) {
                    actions.add(CallHierarchyView.DELETE_NODE);
                }
                if (selectedWrapper.hasChildren()) {
                    actions.add(CallHierarchyView.EXPAND_MULTIPLE_LEVELS);
                    actions.add(CallHierarchyView.EXPAND_ALL_CHILDREN);
                }
                if (viewContributor.getRecurrenceWrapper(selectedWrapper) != null) {
                    actions.add(CallHierarchyView.GO_TO_PARENT);
                }
                CallHierarchyView.this.addToTreeContextMenu(manager, actions);
            }
        });
    }

    private void addToTreeContextMenu(IMenuManager manager, List<String> additionalActions) {
        if (manager == null || additionalActions == null || additionalActions.isEmpty()) {
            return;
        }
        IContributionItem[] items = manager.getItems();
        HashSet<String> itemsIds = new HashSet<String>();
        IContributionItem[] iContributionItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem item = iContributionItemArray[n2];
            itemsIds.add(item.getId());
            ++n2;
        }
        manager.add((IContributionItem)new Separator());
        for (String actionID : additionalActions) {
            if (DELETE_NODE.equals(actionID)) {
                manager.add((IAction)this.fDeleteNodeAction);
                continue;
            }
            if (EXPAND_MULTIPLE_LEVELS.equals(actionID)) {
                manager.add((IAction)this.fExpandNLevelsRightClickAction);
                continue;
            }
            if (EXPAND_ALL_CHILDREN.equals(actionID)) {
                manager.add((IAction)this.fExpandAllChildrenAction);
                continue;
            }
            if (GO_TO_PARENT.equals(actionID)) {
                manager.add((IAction)this.fGoToRecurrenceParentAction);
                continue;
            }
            if (!GO_TO_DECLARATION.equals(actionID)) continue;
            manager.add((IAction)this.fGoToDeclarationAction);
        }
    }

    @Override
    public TreeViewContentProvider getExpandableContentProvider() {
        return null;
    }

    @Override
    public Control getControlToColorBg() {
        return this.fInfo.getParent();
    }

    @Override
    public Control getControlToColorFg() {
        return this.fInfo;
    }

    class CallHierarchyHistoryAction
    extends HistoryAction {
        CallHierarchyHistoryAction() {
        }

        @Override
        public void openHistoryItem(HistoryItem item) {
            IProject newProject = Utils.getProject(((UpdateViewEvent)item).getProjectName());
            CallHierarchyView.this.setInput(new ViewDataContainer(newProject, item));
            CallHierarchyView.this.update(null);
        }

        @Override
        public boolean checkHistoryItem(HistoryItem item) {
            return true;
        }
    }

    class CallHierarchyViewMenuCreator
    implements IMenuCreator {
        Menu fMenu = null;

        CallHierarchyViewMenuCreator() {
        }

        public Menu getMenu(Menu parent) {
            return null;
        }

        public Menu getMenu(Control parent) {
            this.fMenu = new Menu(parent);
            this.fMenu.setVisible(true);
            CallHierarchyComputeStrategy currentStrategy = PrefConst.getCallHierarchyViewStrategy();
            MenuItem virtualMenuItem = new MenuItem(this.fMenu, 32);
            virtualMenuItem.setText("Hide function overrides");
            virtualMenuItem.setSelection(PrefConst.getCallHierarchyViewHideOverrides());
            virtualMenuItem.setEnabled(true);
            virtualMenuItem.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (!(e.widget instanceof MenuItem)) {
                        return;
                    }
                    PrefConst.setCallHierarchyViewHideOverrides(((MenuItem)e.widget).getSelection());
                    CallHierarchyView.this.updateActionState();
                    CallHierarchyView.this.setCallHierarchyDirty(true, true);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            if (currentStrategy == CallHierarchyComputeStrategy.CALLER) {
                return this.fMenu;
            }
            MenuItem conditionalsMenuItem = new MenuItem(this.fMenu, 32);
            conditionalsMenuItem.setText("Hide conditional statments");
            conditionalsMenuItem.setSelection(PrefConst.getCallHierarchyViewHideConditionals());
            conditionalsMenuItem.setEnabled(true);
            conditionalsMenuItem.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (!(e.widget instanceof MenuItem)) {
                        return;
                    }
                    PrefConst.setCallHierarchyViewHideConditionals(((MenuItem)e.widget).getSelection());
                    CallHierarchyView.this.updateActionState();
                    CallHierarchyView.this.setCallHierarchyDirty(true, true);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            MenuItem forksMenuItem = new MenuItem(this.fMenu, 32);
            forksMenuItem.setText("Hide forks");
            forksMenuItem.setSelection(PrefConst.getCallHierarchyViewHideForks());
            forksMenuItem.setEnabled(true);
            forksMenuItem.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (!(e.widget instanceof MenuItem)) {
                        return;
                    }
                    PrefConst.setCallHierarchyViewHideForks(((MenuItem)e.widget).getSelection());
                    CallHierarchyView.this.updateActionState();
                    CallHierarchyView.this.setCallHierarchyDirty(true, true);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            MenuItem namedBeginEndMenuItem = new MenuItem(this.fMenu, 32);
            namedBeginEndMenuItem.setText("Hide labeled blocks");
            namedBeginEndMenuItem.setSelection(PrefConst.getCallHierarchyViewHideNamedBlocks());
            namedBeginEndMenuItem.setEnabled(true);
            namedBeginEndMenuItem.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (!(e.widget instanceof MenuItem)) {
                        return;
                    }
                    PrefConst.setCallHierarchyViewHideNamedBlocks(((MenuItem)e.widget).getSelection());
                    CallHierarchyView.this.updateActionState();
                    CallHierarchyView.this.setCallHierarchyDirty(true, true);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            return this.fMenu;
        }

        public void dispose() {
            if (this.fMenu != null) {
                this.fMenu.dispose();
            }
        }
    }

    class CalleeHierarchySelectAction
    extends Action {
        private static final String CALLEE_HIERARCHY = "Callee Hierarchy";

        CalleeHierarchySelectAction() {
            super(CALLEE_HIERARCHY, 8);
            this.setDescription(CALLEE_HIERARCHY);
            this.setToolTipText(CALLEE_HIERARCHY);
            this.setImageDescriptor(DVTImages.CALLEE_HIERARCHY);
            this.setChecked(PrefConst.getCallHierarchyViewStrategy() == CallHierarchyComputeStrategy.CALLEE);
        }

        public void run() {
            if (PrefConst.getCallHierarchyViewStrategy() == CallHierarchyComputeStrategy.CALLEE && this.isChecked()) {
                return;
            }
            if (this.isChecked()) {
                PrefConst.setCallHierarchyViewStrategy(CallHierarchyComputeStrategy.CALLEE);
                CallHierarchyView.this.update(null);
            }
        }
    }

    class CallerHierarchySelectAction
    extends Action {
        private static final String CALLER_HIERARCHY = "Caller Hierarchy";

        CallerHierarchySelectAction() {
            super(CALLER_HIERARCHY, 8);
            this.setDescription(CALLER_HIERARCHY);
            this.setToolTipText(CALLER_HIERARCHY);
            this.setImageDescriptor(DVTImages.CALLER_HIERARCHY);
            this.setChecked(PrefConst.getCallHierarchyViewStrategy() == CallHierarchyComputeStrategy.CALLER);
        }

        public void run() {
            if (PrefConst.getCallHierarchyViewStrategy() == CallHierarchyComputeStrategy.CALLER && this.isChecked()) {
                return;
            }
            if (this.isChecked()) {
                PrefConst.setCallHierarchyViewStrategy(CallHierarchyComputeStrategy.CALLER);
                CallHierarchyView.this.update(null);
            }
        }
    }

    private final class ComputeChildrenJob
    extends Job
    implements IDVTJob {
        private boolean jobIsCanceled;
        private IDVTElementWrapper wrapper;
        private TreeItem item;
        private int levels;
        private boolean makeSyntheticUpdatingNode;

        private ComputeChildrenJob(TreeItem treeItem, int levels, boolean makeUpdatingNode) {
            super("");
            this.item = treeItem;
            this.levels = levels;
            this.wrapper = (IDVTElementWrapper)this.item.getData();
            this.makeSyntheticUpdatingNode = makeUpdatingNode;
            this.setName("Computing Call Hierarchy for " + this.wrapper.getRfElement().toString());
        }

        private ComputeChildrenJob(Event event, int levels, boolean makeUpdatingNode) {
            this((TreeItem)event.item, levels, makeUpdatingNode);
        }

        public IStatus run(IProgressMonitor monitor) {
            this.jobIsCanceled = false;
            if (this.wrapper == null) {
                return Status.CANCEL_STATUS;
            }
            final ICallHierarchyViewContributor viewContributor = CallHierarchyView.this.getViewContributor(CallHierarchyView.this.getHistoryItem());
            if (viewContributor == null) {
                return Status.CANCEL_STATUS;
            }
            if (this.makeSyntheticUpdatingNode) {
                DVTUiUtils.getActiveWorkbenchShell().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        ComputeChildrenJob.this.item.removeAll();
                        ComputeChildrenJob.this.item.setData((Object)viewContributor.copyWrapperWithUpdatingNode(ComputeChildrenJob.this.wrapper));
                        ComputeChildrenJob.this.item.setItemCount(1);
                    }
                });
            }
            viewContributor.expandXLevels(this.wrapper, this.levels, this);
            DVTUiUtils.getActiveWorkbenchShell().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    ComputeChildrenJob.this.item.removeAll();
                    ComputeChildrenJob.this.item.setData((Object)ComputeChildrenJob.this.wrapper);
                    List children = ComputeChildrenJob.this.wrapper.getChildren();
                    ComputeChildrenJob.this.item.setItemCount(children == null ? 0 : children.size());
                }
            });
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            return Status.OK_STATUS;
        }

        @Override
        public boolean isCanceled() {
            return this.jobIsCanceled;
        }

        protected void canceling() {
            super.canceling();
            this.jobIsCanceled = true;
        }
    }

    private class DeleteNodeAction
    extends Action {
        private static final String REMOVE_FROM_VIEW = "Remove from View";

        private DeleteNodeAction() {
            super(REMOVE_FROM_VIEW);
            this.setDescription(REMOVE_FROM_VIEW);
            this.setToolTipText(REMOVE_FROM_VIEW);
        }

        public String getId() {
            return CallHierarchyView.DELETE_NODE;
        }

        public void run() {
            IDVTElementWrapper selectedWrapper = CallHierarchyView.this.getSelectedWrapper("default-tree");
            if (selectedWrapper == null) {
                return;
            }
            TreeItem item = CallHierarchyView.this.getTree("default-tree").getSelection()[0];
            IDVTElementWrapper parentWrapper = selectedWrapper.getParent();
            TreeItem parentItem = item.getParentItem();
            if (parentWrapper == null || parentItem == null) {
                return;
            }
            int currentIndex = parentWrapper.getChildren().indexOf(selectedWrapper);
            if (currentIndex == parentWrapper.getChildren().size() - 1) {
                --currentIndex;
            }
            parentWrapper.removeChild(selectedWrapper);
            CallHierarchyView.this.fRefreshAction.setEnabled(true);
            parentItem.removeAll();
            parentItem.setData((Object)parentWrapper);
            parentItem.setItemCount(parentWrapper.getChildren().size());
            if (currentIndex >= 0) {
                parentItem.getParent().setSelection(parentItem.getItems()[currentIndex]);
            } else {
                parentItem.getParent().setSelection(parentItem);
            }
        }
    }

    class EShowAllSimilarLayersModeAction
    extends Action {
        private static final String ANALYZE_ALL_ROOT_METHOD_EXTENSIONS = "Analyze all root method extensions";

        public EShowAllSimilarLayersModeAction() {
            super(ANALYZE_ALL_ROOT_METHOD_EXTENSIONS, 2);
            this.setDescription(ANALYZE_ALL_ROOT_METHOD_EXTENSIONS);
            this.setToolTipText(ANALYZE_ALL_ROOT_METHOD_EXTENSIONS);
            this.setImageDescriptor(DVTImages.LAYERS_VIEW);
            this.setChecked(PrefConst.getCallHierarchyViewAllSimilarLayers());
        }

        public void run() {
            PrefConst.setCallHierarchyViewAllSimilarLayers(this.isChecked());
            CallHierarchyView.this.fShowAllSimilarLayersAction.setChecked(PrefConst.getCallHierarchyViewAllSimilarLayers());
            ICallHierarchyViewContributor viewContributor = CallHierarchyView.this.getViewContributor(CallHierarchyView.this.getHistoryItem());
            if (viewContributor == null) {
                return;
            }
            viewContributor.setStateWrapper(null);
            CallHierarchyView.this.update(null);
        }
    }

    private static enum EXPAND_MULTIPLE_LEVELS_TYPE {
        TOOLBAR,
        RIGHT_CLICK;

    }

    private class ExpandAllChildrenAction
    extends Action {
        private static final String EXPAND_CHILDREN = "Expand Children";

        private ExpandAllChildrenAction() {
            super(EXPAND_CHILDREN);
            this.setDescription(EXPAND_CHILDREN);
            this.setToolTipText(EXPAND_CHILDREN);
        }

        public String getId() {
            return CallHierarchyView.EXPAND_ALL_CHILDREN;
        }

        public void run() {
            TreeItem item = CallHierarchyView.this.getTree("default-tree").getSelection()[0];
            if (item == null) {
                return;
            }
            ComputeChildrenJob computeChildrenJob = new ComputeChildrenJob(item, 2, true);
            computeChildrenJob.setSystem(true);
            computeChildrenJob.schedule();
        }
    }

    class ExpandMultipleLevelsAction
    extends Action {
        private EXPAND_MULTIPLE_LEVELS_TYPE type;

        public ExpandMultipleLevelsAction(EXPAND_MULTIPLE_LEVELS_TYPE type) {
            super(CallHierarchyView.EXPAND_MULTIPLE_LEVELS_LABEL, 1);
            this.type = type;
            this.setDescription(CallHierarchyView.EXPAND_MULTIPLE_LEVELS_LABEL);
            if (type == EXPAND_MULTIPLE_LEVELS_TYPE.RIGHT_CLICK) {
                this.setToolTipText(CallHierarchyView.EXPAND_MULTIPLE_LEVELS_LABEL);
            }
            if (type == EXPAND_MULTIPLE_LEVELS_TYPE.TOOLBAR) {
                this.setImageDescriptor(DVTImages.EXPAND_ALL_ACTION);
            }
        }

        public String getId() {
            return CallHierarchyView.EXPAND_MULTIPLE_LEVELS;
        }

        public void run() {
            DVTUiUtils.getActiveWorkbenchShell().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    DVTSpinnerInputDialog dialog = new DVTSpinnerInputDialog(DVTUiUtils.getActiveWorkbenchShell(), "", CallHierarchyView.DEPTH_DIALOG_DESCRIPTION, 5, 1, 20);
                    dialog.create();
                    if (dialog.open() == 0) {
                        TreeItem item;
                        int depth = dialog.getValue();
                        if (ExpandMultipleLevelsAction.this.type == EXPAND_MULTIPLE_LEVELS_TYPE.RIGHT_CLICK) {
                            rootItems = CallHierarchyView.this.getTree("default-tree").getSelection();
                            if (rootItems.length == 0) {
                                return;
                            }
                            item = rootItems[0];
                        } else {
                            rootItems = CallHierarchyView.this.getTree("default-tree").getItems();
                            if (rootItems.length == 0) {
                                return;
                            }
                            item = rootItems[0];
                        }
                        if (item == null) {
                            return;
                        }
                        ComputeChildrenJob computeChildrenJob = new ComputeChildrenJob(item, depth, true);
                        computeChildrenJob.setSystem(false);
                        computeChildrenJob.setUser(true);
                        computeChildrenJob.schedule();
                    }
                }
            });
        }
    }

    class FilterAction
    extends Action {
        private static final String FILTERS = "Filters...";

        public FilterAction() {
            super(FILTERS, 2);
            this.setDescription(FILTERS);
            this.setToolTipText(FILTERS);
            this.setImageDescriptor(DVTImages.FILTER);
        }

        public void run() {
            new CallHierarchyViewMenuCreator().getMenu((Control)CallHierarchyView.this.getViewSite().getShell()).setVisible(true);
            CallHierarchyView.this.updateActionState();
        }
    }

    private class GoToDeclarationAction
    extends Action {
        private static final String GO_TO_DECLARATION2 = "Go to Declaration";

        private GoToDeclarationAction() {
            super(GO_TO_DECLARATION2);
            this.setDescription(GO_TO_DECLARATION2);
            this.setToolTipText(GO_TO_DECLARATION2);
        }

        public String getId() {
            return CallHierarchyView.GO_TO_DECLARATION;
        }

        public void run() {
            ICallHierarchyViewContributor viewContributor = CallHierarchyView.this.getViewContributor(CallHierarchyView.this.getHistoryItem());
            if (viewContributor == null) {
                return;
            }
            viewContributor.goToWrapperDeclaration(CallHierarchyView.this.getSelectedWrapper("default-tree"), CallHierarchyView.this.getProject());
        }
    }

    private class GoToRecurrenceParentAction
    extends Action {
        private static final String GO_TO_FIRST_CALL = "Go to First Call";

        private GoToRecurrenceParentAction() {
            super(GO_TO_FIRST_CALL);
            this.setDescription(GO_TO_FIRST_CALL);
            this.setToolTipText(GO_TO_FIRST_CALL);
        }

        public String getId() {
            return CallHierarchyView.GO_TO_PARENT;
        }

        public void run() {
            ICallHierarchyViewContributor viewContributor = CallHierarchyView.this.getViewContributor(CallHierarchyView.this.getHistoryItem());
            if (viewContributor == null) {
                return;
            }
            IDVTElementWrapper selectedWrapper = CallHierarchyView.this.getSelectedWrapper("default-tree");
            if (selectedWrapper == null) {
                return;
            }
            IDVTElementWrapper recurrenceWrapper = viewContributor.getRecurrenceWrapper(selectedWrapper);
            if (recurrenceWrapper == null) {
                return;
            }
            TreeItem item = CallHierarchyView.this.getTree("default-tree").getSelection()[0];
            item.getParent().setSelection((TreeItem)recurrenceWrapper.getItem());
        }
    }

    class LinkWithEditorAction
    extends Action {
        private static final String LINK_WITH_EDITOR = "Link with Editor";

        public LinkWithEditorAction() {
            super(LINK_WITH_EDITOR, 2);
            this.setDescription(LINK_WITH_EDITOR);
            this.setToolTipText(LINK_WITH_EDITOR);
            this.setImageDescriptor(DVTImages.SYNCED);
            CallHierarchyView.this.fIsLinkedWithEditor = PrefConst.getCallHierarchyViewLinkWithEditor();
            this.setChecked(CallHierarchyView.this.fIsLinkedWithEditor);
        }

        public void run() {
            PrefConst.setCallHierarchyViewLinkWithEditor(this.isChecked());
            CallHierarchyView.this.fIsLinkedWithEditor = PrefConst.getCallHierarchyViewLinkWithEditor();
        }
    }

    class PrependPackageAction
    extends Action {
        private static final String PREPEND_PACKAGE_NAME = "Prepend Package Name";

        public PrependPackageAction() {
            super(PREPEND_PACKAGE_NAME, 2);
            this.setDescription(PREPEND_PACKAGE_NAME);
            this.setToolTipText(PREPEND_PACKAGE_NAME);
            this.setImageDescriptor(DVTImages.PREPEND_PACKAGE);
            this.setChecked(PrefConst.getCallHierarchyViewPrependPackage());
        }

        public void run() {
            PrefConst.setCallHierarchyViewPrependPackage(this.isChecked());
            CallHierarchyView.this.fLazyContentProvider.updateAllLabels(EnumSet.of(TreeViewContentProvider.LabelUpdateKind.TEXT));
        }
    }

    class RefreshAction
    extends Action {
        private static final String REFRESH_VIEW = "Refresh View";
        private static final String REFRESH = "Refresh";

        public RefreshAction() {
            super(REFRESH, 1);
            this.setDescription(REFRESH_VIEW);
            this.setToolTipText(REFRESH_VIEW);
            this.setImageDescriptor(DVTImages.REFRESH);
        }

        public void run() {
            ICallHierarchyViewContributor viewContributor = CallHierarchyView.this.getViewContributor(CallHierarchyView.this.getHistoryItem());
            if (viewContributor != null) {
                viewContributor.updateFilterOptions();
                viewContributor.triggerRefresh((IDVTElementWrapper)CallHierarchyView.this.getTree("default-tree").getItems()[0].getData(), true);
            }
            CallHierarchyView.this.update(null);
        }
    }

    class ToggleInspectPanelAction
    extends Action {
        private static final String TOGGLE_INSPECT_PANEL = "Toggle Inspect Panel";

        public ToggleInspectPanelAction() {
            super(TOGGLE_INSPECT_PANEL, 2);
            this.setDescription(TOGGLE_INSPECT_PANEL);
            this.setToolTipText(TOGGLE_INSPECT_PANEL);
            this.setImageDescriptor(DVTImages.INSPECT_LAYOUT);
            this.setChecked(PrefConst.getCallHierarchyShowInspectPanel());
        }

        public void run() {
            PrefConst.setCallHierarchyShowInspectPanel(this.isChecked());
            CallHierarchyView.this.fInspectComponent.setVisible(PrefConst.getCallHierarchyShowInspectPanel());
            CallHierarchyView.this.fSashForm.layout();
        }
    }
}

