/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.checks;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IActionBars;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.EclipseUtils;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.ui.projectcolors.ProjectColorUtils;
import ro.amiq.dvt.ui.views.AbstractFilteredView;
import ro.amiq.dvt.ui.views.BuildEvents;
import ro.amiq.dvt.ui.views.DVTLabelProviderProxy;
import ro.amiq.dvt.ui.views.DVTViewContributors;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.IUpdateJobImpl;
import ro.amiq.dvt.ui.views.TreeViewContentProvider;
import ro.amiq.dvt.ui.views.UpdateJob;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.checks.ChecksViewCommon;
import ro.amiq.dvt.ui.views.checks.ChecksViewInput;
import ro.amiq.dvt.ui.views.checks.ChecksViewInputConfigurator;
import ro.amiq.dvt.ui.views.checks.IChecksViewContributor;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.dvt.utils.Utils;

public class ChecksView
extends ChecksViewCommon
implements IUpdateJobImpl {
    private static final List<IChecksViewContributor> fAllChecksContibutors = DVTViewContributors.getInstance().getAllInstanceOf(IChecksViewContributor.class);
    private final UpdateJob fUpdateJob;
    private DVTLabelProviderProxy<IChecksViewContributor> fLabelProvider = new DVTLabelProviderProxy<IChecksViewContributor>(IChecksViewContributor.class, "default-tree");
    private Label fInfo;
    private Tree fTree;
    private TreeViewContentProvider fLazyContentProvider;
    private List<IDVTElementWrapper> fElements;
    private FilterAction fFiltersAction;
    private SortByTypeAction fSortByTypeAction;
    private int fNrTotalChecks;
    private int fNrNotFilteredChecks;
    private int fNrOfEChecks = 0;
    private int fNrOfEExpects = 0;
    private int fNrOfEAsserts = 0;
    private int fNrOfEAssumption = 0;
    private int fNrOfVlogImmediateAssertions = 0;
    private int fNrOfVlogConcurrentAssertions = 0;
    private int fNrOfVlogImmediateAssumptions = 0;
    private int fNrOfVlogConcurrentAssumptions = 0;
    private int fNrOfVlogExpects = 0;
    private Label fContentFiltersLabel;
    private boolean fHasGUIFilteredElements;
    private Image fContentFiltersEnabledIcon = DVTImages.imageCache.getImage(DVTImages.GUI_FILTERS_ICON_MINI);
    private Image fContentFiltersDisabledIcon = DVTImages.imageCache.getImage(DVTImages.GUI_FILTERS_ICON_MINI_DISABLED);

    public ChecksView() {
        this.fUpdateJob = new UpdateJob("Update Checks View", this);
    }

    @Override
    public void customCreatePartControl(Composite parent) {
        GridData gridData = new GridData(1808);
        parent.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        parent.setLayout((Layout)layout);
        Composite labelComposite = new Composite(parent, 0);
        GridLayout labelLayout = new GridLayout(2, false);
        labelComposite.setLayout((Layout)labelLayout);
        labelComposite.setLayoutData((Object)new GridData(4, 1, true, false));
        this.fContentFiltersLabel = new Label(labelComposite, 0);
        if (EclipseUtils.isAtLeastEclipse419()) {
            this.fContentFiltersLabel.setImage(this.fHasGUIFilteredElements ? this.fContentFiltersEnabledIcon : this.fContentFiltersDisabledIcon);
        } else {
            this.fContentFiltersLabel.setImage(this.fContentFiltersEnabledIcon);
        }
        this.fContentFiltersLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.fContentFiltersLabel.setToolTipText("Content Filters matched!");
        this.fContentFiltersLabel.setEnabled(this.fHasGUIFilteredElements);
        this.fInfo = new Label(labelComposite, 16384);
        this.fInfo.setLayoutData((Object)new GridData(768));
        this.createTextFilter("default-filter", parent, "default-tree", false);
        this.setTextFilterMessage("default-filter", "Filter by: hierarchical name");
        Composite composite = new Composite(parent, 0);
        GridData compositeGridData = new GridData(1808);
        composite.setLayoutData((Object)compositeGridData);
        composite.setLayout((Layout)new FillLayout(256));
        this.createToolbar(parent);
        this.fTree = new Tree(composite, 268436228);
        this.fTree.setHeaderVisible(true);
        TreeColumn checksColumn = new TreeColumn(this.fTree, 16384);
        checksColumn.setText("Checks");
        checksColumn.setWidth(400);
        TreeColumn commentsColumn = new TreeColumn(this.fTree, 16384);
        commentsColumn.setText("Comments");
        commentsColumn.setWidth(100);
        this.fLazyContentProvider = new TreeViewContentProvider(this.fTree, this.fLabelProvider);
        this.fTree.addKeyListener((KeyListener)this.getKeyListener("default-filter", "default-tree"));
        this.fTree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                ChecksView.this.gotoSelectedElement("default-tree");
            }

            public void mouseDown(MouseEvent e) {
            }
        });
        this.installContextMenuAndSelectionListener((Control)this.fTree);
    }

    private void createToolbar(Composite parent) {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager tbm = actionBars.getToolBarManager();
        this.fFiltersAction = new FilterAction();
        this.fSortByTypeAction = new SortByTypeAction();
        tbm.add((IContributionItem)new Separator());
        tbm.add((IAction)this.fSortByTypeAction);
        tbm.add((IContributionItem)new Separator());
        tbm.add((IAction)this.fFiltersAction);
        tbm.add((IContributionItem)new Separator());
        tbm.add((IAction)new AbstractFilteredView.CollapseAllAction());
        tbm.add((IAction)new AbstractFilteredView.ExpandAllAction());
        this.fFiltersAction.setMenuCreator(new ChecksViewMenuCreator());
        this.updateActionState();
    }

    @Override
    public void update(BuildEvents updateEvent) {
        try {
            if (this.fTree == null) {
                return;
            }
            IProject project = this.getProject();
            if (project == null || project != null && !project.isAccessible() || !Utils.hasDvtNature(project)) {
                this.clean();
                return;
            }
            if (!DVTPlugin.getDefault().collect().c(project, "F636F7265")) {
                return;
            }
            this.fLazyContentProvider.setInput((List<IDVTElementWrapper>)new ArrayList<IDVTElementWrapper>(UPDATE_JOB_MESSAGE_INPUT), this.fExpandLevel);
            this.fHasGUIFilteredElements = false;
            this.fUpdateJob.cancel();
            this.fUpdateJob.schedule();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    public void updateNonGuiPart(UpdateJob updateJob) {
        try {
            this.resetElementCount();
            this.fElements = new ArrayList<IDVTElementWrapper>();
            boolean firstElemSelected = false;
            for (IChecksViewContributor checksViewContentProvider : fAllChecksContibutors) {
                if (ViewsUtils.isCanceled(updateJob)) {
                    return;
                }
                IProject project = this.getProject();
                ChecksViewInput input = checksViewContentProvider.getInput(new ChecksViewInputConfigurator(project, this.getSearchSegments("default-filter"), this.getSearchStrictness("default-filter"), ViewsUtils.hasMoreThanOneDVTNature(project), PrefConst.getChecksViewSortByType(), updateJob));
                List<IDVTElementWrapper> origElems = input.getElements();
                if (!firstElemSelected && !origElems.isEmpty()) {
                    firstElemSelected = ViewsUtils.selectFirstElement(checksViewContentProvider, this.getLightStringMatcher(), origElems);
                }
                this.fElements.addAll(origElems);
                this.fNrTotalChecks += input.getTotalChecks();
                this.fNrNotFilteredChecks += input.getNotFilteredChecks();
                this.fNrOfEChecks += input.getNrOfEChecks();
                this.fNrOfEExpects += input.getNrOfEExpects();
                this.fNrOfEAsserts += input.getNrOfEAsserts();
                this.fNrOfEAssumption += input.getNrOfEAssumption();
                this.fNrOfVlogImmediateAssertions += input.getNrOfVlogImmediateAssertions();
                this.fNrOfVlogConcurrentAssertions += input.getNrOfVlogConcurrentAssertions();
                this.fNrOfVlogImmediateAssumptions += input.getNrOfVlogImmediateAssumptions();
                this.fNrOfVlogConcurrentAssumptions += input.getNrOfVlogConcurrentAssumptions();
                this.fNrOfVlogExpects += input.getNrOfVlogExpects();
                boolean bl = this.fHasGUIFilteredElements = this.fHasGUIFilteredElements || input.hasGUIFilteredElements();
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    public void updateGuiPart(UpdateJob updateJob) {
        try {
            IProject project = this.getProject();
            if (this.fLazyContentProvider != null && this.fElements != null && this.fInfo != null && project != null) {
                this.fExpandLevel = -1;
                StringMatcher sm = this.getStringMatcher("default-filter");
                if (this.fElements.isEmpty()) {
                    if (sm != null && !sm.getPattern().isEmpty()) {
                        this.fLazyContentProvider.setInput((List<IDVTElementWrapper>)new ArrayList<IDVTElementWrapper>(NO_MATCHES_FOUND), this.fExpandLevel);
                    } else if (this.fHasGUIFilteredElements) {
                        this.fLazyContentProvider.setInput((List<IDVTElementWrapper>)new ArrayList<IDVTElementWrapper>(GUI_FILTERED_EMPTY_CONTENT), this.fExpandLevel);
                    } else {
                        this.fLazyContentProvider.setInput((List<IDVTElementWrapper>)new ArrayList<IDVTElementWrapper>(NO_DATA_MESSAGE), this.fExpandLevel);
                    }
                } else {
                    this.fLazyContentProvider.setInput(this.fElements, this.fExpandLevel);
                }
                StringBuilder infoText = new StringBuilder();
                infoText.append("[").append(project.getName()).append("]").append("[");
                if (this.fNrTotalChecks == this.fNrNotFilteredChecks) {
                    infoText.append(this.fNrTotalChecks);
                } else {
                    infoText.append(this.fNrNotFilteredChecks).append("/").append(this.fNrTotalChecks);
                }
                infoText.append(ViewsUtils.getUnitName("check", this.fNrTotalChecks, " ", "")).append("]");
                this.fInfo.setText(infoText.toString());
                ProjectColorUtils.setFgBg(this, project.getName());
                if (EclipseUtils.isAtLeastEclipse419()) {
                    this.fContentFiltersLabel.setImage(this.fHasGUIFilteredElements ? this.fContentFiltersEnabledIcon : this.fContentFiltersDisabledIcon);
                }
                this.fContentFiltersLabel.setEnabled(this.fHasGUIFilteredElements);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private StringMatcher getLightStringMatcher() {
        StringMatcher currentStringMatcher = this.getStringMatcher("default-filter");
        if (currentStringMatcher == null) {
            return null;
        }
        String currentPattern = currentStringMatcher.getPattern().replace("//", "");
        if (!currentPattern.contains("/")) {
            return new StringMatcher(currentPattern, true, false);
        }
        String[] parts = currentPattern.split("/");
        String newPattern = parts[parts.length - 1];
        if (!newPattern.startsWith("*")) {
            newPattern = "*" + newPattern;
        }
        return new StringMatcher(newPattern, true, false);
    }

    @Override
    public void dispose() {
        if (this.fTree != null && !this.fTree.isDisposed()) {
            this.fTree.dispose();
        }
        if (this.fInfo != null && !this.fInfo.isDisposed()) {
            this.fInfo.dispose();
        }
        if (this.fContentFiltersLabel != null && !this.fContentFiltersLabel.isDisposed()) {
            this.fContentFiltersLabel.dispose();
        }
        this.fTree = null;
        this.fInfo = null;
        this.fLazyContentProvider = null;
        this.fContentFiltersLabel = null;
        super.dispose();
    }

    public void setFocus() {
        this.fTree.setFocus();
    }

    private IChecksViewContributor getViewContributor(IDVTElementWrapper wrapper) {
        return DVTViewContributors.getInstance().getViewContributor(wrapper, IChecksViewContributor.class);
    }

    @Override
    public void gotoSelectedElement(String treeId) {
        IDVTElementWrapper selectedWrapper = this.getSelectedWrapper(treeId);
        if (selectedWrapper == null || this.getViewContributor(selectedWrapper) == null) {
            return;
        }
        this.getViewContributor(selectedWrapper).gotoElement(this.getProject(), selectedWrapper);
    }

    @Override
    public void stringMatcherUpdated(String textFilterId) {
        try {
            this.fTree.setRedraw(false);
            this.update(null);
            this.fTree.setRedraw(true);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    public Tree getTree(String treeId) {
        return this.fTree;
    }

    @Override
    public String prepareText(String textFilterId, String text) {
        if (!(text.trim().length() == 0 || text.endsWith("//") && text.endsWith("/"))) {
            text = String.valueOf(text) + "//";
        }
        return text;
    }

    protected void updateActionState() {
        if (!(PrefConst.getChecksViewEdtHideChecks() || PrefConst.getChecksViewEdtHideExpects() || PrefConst.getChecksViewEdtHideAssertions() || PrefConst.getChecksViewEdtHideAssumptions() || PrefConst.getChecksViewVlogdtHideImmediateAssertions() || PrefConst.getChecksViewVlogdtHideConcurrentAssertions() || PrefConst.getChecksViewVlogdtHideImmediateAssumptions() || PrefConst.getChecksViewVlogdtHideConcurrentAssumptions() || PrefConst.getChecksViewVlogdtHideExpects())) {
            this.fFiltersAction.setChecked(false);
        } else {
            this.fFiltersAction.setChecked(true);
        }
    }

    @Override
    public Object getTreeRootElement(String treeId) {
        return this.fElements;
    }

    public DVTLabelProviderProxy<IChecksViewContributor> getLabelProvider() {
        return this.fLabelProvider;
    }

    @Override
    public void refreshSelection(IResource resource) {
    }

    private void resetElementCount() {
        this.fNrTotalChecks = 0;
        this.fNrNotFilteredChecks = 0;
        this.fNrOfEChecks = 0;
        this.fNrOfEExpects = 0;
        this.fNrOfEAsserts = 0;
        this.fNrOfEAssumption = 0;
        this.fNrOfVlogImmediateAssertions = 0;
        this.fNrOfVlogConcurrentAssertions = 0;
        this.fNrOfVlogImmediateAssumptions = 0;
        this.fNrOfVlogConcurrentAssumptions = 0;
        this.fNrOfVlogExpects = 0;
    }

    @Override
    public void clean() {
        this.fUpdateJob.cancel();
        this.resetElementCount();
        IProject project = this.getProject();
        if (project == null || project != null && !project.isAccessible() || !Utils.hasDvtNature(project)) {
            this.fInfo.setText("[no DVT Project or file selected]");
            ProjectColorUtils.setFgBg(this, null);
            this.fLazyContentProvider.setInput((List<IDVTElementWrapper>)new ArrayList<IDVTElementWrapper>(INPUT_SELECT_PROJECT_OR_FILE), this.fExpandLevel);
            this.fContentFiltersLabel.setEnabled(false);
        } else {
            this.fInfo.setText("[" + project.getName() + "][" + this.fNrTotalChecks + " checks]");
            ProjectColorUtils.setFgBg(this, project.getName());
            this.fLazyContentProvider.setInput((List<IDVTElementWrapper>)new ArrayList<IDVTElementWrapper>(NO_DATA_MESSAGE), this.fExpandLevel);
            this.fContentFiltersLabel.setEnabled(this.fHasGUIFilteredElements);
        }
    }

    @Override
    public TreeViewContentProvider getExpandableContentProvider() {
        return this.fLazyContentProvider;
    }

    @Override
    public Control getControlToColorBg() {
        return this.fInfo.getParent();
    }

    @Override
    public Control getControlToColorFg() {
        return this.fInfo;
    }

    class ChecksViewMenuCreator
    implements IMenuCreator {
        Menu fMenu = null;

        ChecksViewMenuCreator() {
        }

        public Menu getMenu(Menu parent) {
            return null;
        }

        public Menu getMenu(Control parent) {
            this.fMenu = new Menu(parent);
            this.fMenu.setVisible(true);
            boolean hasENature = ViewsUtils.projectContainsENature(ChecksView.this.getProject());
            boolean hasSlnNature = ViewsUtils.projectContainsSLNNature(ChecksView.this.getProject());
            if (hasENature || hasSlnNature) {
                MenuItem menuItem;
                String language = " " + (hasENature && hasSlnNature ? String.valueOf(LanguageKind.E.DISPLAY_NAME) + "/" + LanguageKind.SLN.DISPLAY_NAME : (hasENature ? LanguageKind.E.DISPLAY_NAME : (hasSlnNature ? LanguageKind.SLN.DISPLAY_NAME : "")));
                if (ChecksView.this.fNrOfEChecks > 0) {
                    menuItem = new MenuItem(this.fMenu, 32);
                    menuItem.setText("Hide" + language + " Checks [" + ChecksView.this.fNrOfEChecks + "]");
                    menuItem.setSelection(PrefConst.getChecksViewEdtHideChecks());
                    menuItem.setEnabled(true);
                    menuItem.addSelectionListener(new SelectionListener(){

                        public void widgetSelected(SelectionEvent e) {
                            if (!(e.widget instanceof MenuItem)) {
                                return;
                            }
                            PrefConst.setChecksViewEdtHideChecks(((MenuItem)e.widget).getSelection());
                            ChecksView.this.updateActionState();
                            ChecksView.this.update(null);
                        }

                        public void widgetDefaultSelected(SelectionEvent e) {
                            this.widgetSelected(e);
                        }
                    });
                }
                if (ChecksView.this.fNrOfEExpects > 0) {
                    menuItem = new MenuItem(this.fMenu, 32);
                    menuItem.setText("Hide" + language + " Expects [" + ChecksView.this.fNrOfEExpects + "]");
                    menuItem.setSelection(PrefConst.getChecksViewEdtHideExpects());
                    menuItem.setEnabled(true);
                    menuItem.addSelectionListener(new SelectionListener(){

                        public void widgetSelected(SelectionEvent e) {
                            if (!(e.widget instanceof MenuItem)) {
                                return;
                            }
                            PrefConst.setChecksViewEdtHideExpects(((MenuItem)e.widget).getSelection());
                            ChecksView.this.updateActionState();
                            ChecksView.this.update(null);
                        }

                        public void widgetDefaultSelected(SelectionEvent e) {
                            this.widgetSelected(e);
                        }
                    });
                }
                if (ChecksView.this.fNrOfEAsserts > 0) {
                    menuItem = new MenuItem(this.fMenu, 32);
                    menuItem.setText("Hide" + language + " Assertions [" + ChecksView.this.fNrOfEAsserts + "]");
                    menuItem.setSelection(PrefConst.getChecksViewEdtHideAssertions());
                    menuItem.setEnabled(true);
                    menuItem.addSelectionListener(new SelectionListener(){

                        public void widgetSelected(SelectionEvent e) {
                            if (!(e.widget instanceof MenuItem)) {
                                return;
                            }
                            PrefConst.setChecksViewEdtHideAssertions(((MenuItem)e.widget).getSelection());
                            ChecksView.this.updateActionState();
                            ChecksView.this.update(null);
                        }

                        public void widgetDefaultSelected(SelectionEvent e) {
                            this.widgetSelected(e);
                        }
                    });
                }
                if (ChecksView.this.fNrOfEAssumption > 0) {
                    menuItem = new MenuItem(this.fMenu, 32);
                    menuItem.setText("Hide" + language + " Assumptions [" + ChecksView.this.fNrOfEAssumption + "]");
                    menuItem.setSelection(PrefConst.getChecksViewEdtHideAssumptions());
                    menuItem.setEnabled(true);
                    menuItem.addSelectionListener(new SelectionListener(){

                        public void widgetSelected(SelectionEvent e) {
                            if (!(e.widget instanceof MenuItem)) {
                                return;
                            }
                            PrefConst.setChecksViewEdtHideAssumptions(((MenuItem)e.widget).getSelection());
                            ChecksView.this.updateActionState();
                            ChecksView.this.update(null);
                        }

                        public void widgetDefaultSelected(SelectionEvent e) {
                            this.widgetSelected(e);
                        }
                    });
                }
                if (ChecksView.this.fNrOfEAsserts + ChecksView.this.fNrOfEAssumption + ChecksView.this.fNrOfEChecks + ChecksView.this.fNrOfEExpects > 0 && ChecksView.this.fNrOfVlogImmediateAssumptions + ChecksView.this.fNrOfVlogConcurrentAssertions + ChecksView.this.fNrOfVlogConcurrentAssumptions + ChecksView.this.fNrOfVlogImmediateAssertions + ChecksView.this.fNrOfVlogExpects > 0) {
                    new MenuItem(this.fMenu, 2);
                }
            }
            if (ViewsUtils.projectContainsVlogNature(ChecksView.this.getProject())) {
                MenuItem menuItem;
                if (ChecksView.this.fNrOfVlogImmediateAssertions > 0) {
                    menuItem = new MenuItem(this.fMenu, 32);
                    menuItem.setText("Hide SystemVerilog Immediate Assertions [" + ChecksView.this.fNrOfVlogImmediateAssertions + "]");
                    menuItem.setSelection(PrefConst.getChecksViewVlogdtHideImmediateAssertions());
                    menuItem.setEnabled(true);
                    menuItem.addSelectionListener(new SelectionListener(){

                        public void widgetSelected(SelectionEvent e) {
                            if (!(e.widget instanceof MenuItem)) {
                                return;
                            }
                            PrefConst.setChecksViewVlogdtHideImmediateAssertions(((MenuItem)e.widget).getSelection());
                            ChecksView.this.updateActionState();
                            ChecksView.this.update(null);
                        }

                        public void widgetDefaultSelected(SelectionEvent e) {
                            this.widgetSelected(e);
                        }
                    });
                }
                if (ChecksView.this.fNrOfVlogConcurrentAssertions > 0) {
                    menuItem = new MenuItem(this.fMenu, 32);
                    menuItem.setText("Hide SystemVerilog Concurrent Assertions [" + ChecksView.this.fNrOfVlogConcurrentAssertions + "]");
                    menuItem.setSelection(PrefConst.getChecksViewVlogdtHideConcurrentAssertions());
                    menuItem.setEnabled(true);
                    menuItem.addSelectionListener(new SelectionListener(){

                        public void widgetSelected(SelectionEvent e) {
                            if (!(e.widget instanceof MenuItem)) {
                                return;
                            }
                            PrefConst.setChecksViewVlogdtHideConcurrentAssertions(((MenuItem)e.widget).getSelection());
                            ChecksView.this.updateActionState();
                            ChecksView.this.update(null);
                        }

                        public void widgetDefaultSelected(SelectionEvent e) {
                            this.widgetSelected(e);
                        }
                    });
                }
                if (ChecksView.this.fNrOfVlogImmediateAssumptions > 0) {
                    menuItem = new MenuItem(this.fMenu, 32);
                    menuItem.setText("Hide SystemVerilog Immediate Assumptions [" + ChecksView.this.fNrOfVlogImmediateAssumptions + "]");
                    menuItem.setSelection(PrefConst.getChecksViewVlogdtHideImmediateAssumptions());
                    menuItem.setEnabled(true);
                    menuItem.addSelectionListener(new SelectionListener(){

                        public void widgetSelected(SelectionEvent e) {
                            if (!(e.widget instanceof MenuItem)) {
                                return;
                            }
                            PrefConst.setChecksViewVlogdtHideImmediateAssumptions(((MenuItem)e.widget).getSelection());
                            ChecksView.this.updateActionState();
                            ChecksView.this.update(null);
                        }

                        public void widgetDefaultSelected(SelectionEvent e) {
                            this.widgetSelected(e);
                        }
                    });
                }
                if (ChecksView.this.fNrOfVlogConcurrentAssumptions > 0) {
                    menuItem = new MenuItem(this.fMenu, 32);
                    menuItem.setText("Hide SystemVerilog Concurrent Assumptions [" + ChecksView.this.fNrOfVlogConcurrentAssumptions + "]");
                    menuItem.setSelection(PrefConst.getChecksViewVlogdtHideConcurrentAssumptions());
                    menuItem.setEnabled(true);
                    menuItem.addSelectionListener(new SelectionListener(){

                        public void widgetSelected(SelectionEvent e) {
                            if (!(e.widget instanceof MenuItem)) {
                                return;
                            }
                            PrefConst.setChecksViewVlogdtHideConcurrentAssumptions(((MenuItem)e.widget).getSelection());
                            ChecksView.this.updateActionState();
                            ChecksView.this.update(null);
                        }

                        public void widgetDefaultSelected(SelectionEvent e) {
                            this.widgetSelected(e);
                        }
                    });
                }
                if (ChecksView.this.fNrOfVlogExpects > 0) {
                    menuItem = new MenuItem(this.fMenu, 32);
                    menuItem.setText("Hide SystemVerilog Expects [" + ChecksView.this.fNrOfVlogExpects + "]");
                    menuItem.setSelection(PrefConst.getChecksViewVlogdtHideExpects());
                    menuItem.setEnabled(true);
                    menuItem.addSelectionListener(new SelectionListener(){

                        public void widgetSelected(SelectionEvent e) {
                            if (!(e.widget instanceof MenuItem)) {
                                return;
                            }
                            PrefConst.setChecksViewVlogdtHideExpects(((MenuItem)e.widget).getSelection());
                            ChecksView.this.updateActionState();
                            ChecksView.this.update(null);
                        }

                        public void widgetDefaultSelected(SelectionEvent e) {
                            this.widgetSelected(e);
                        }
                    });
                }
            }
            return this.fMenu;
        }

        public void dispose() {
            if (this.fMenu != null) {
                this.fMenu.dispose();
            }
        }
    }

    class FilterAction
    extends Action {
        public FilterAction() {
            super("Filters...", 2);
            this.setDescription("Filters...");
            this.setToolTipText("Filters...");
            this.setImageDescriptor(DVTImages.FILTER);
        }

        public void run() {
            new ChecksViewMenuCreator().getMenu((Control)ChecksView.this.getViewSite().getShell()).setVisible(true);
            ChecksView.this.updateActionState();
        }
    }

    class SortByTypeAction
    extends Action {
        public SortByTypeAction() {
            super("Category Sort", 2);
            this.setDescription("Sort by Category");
            this.setToolTipText("Sort Elements by Category");
            this.setImageDescriptor(DVTImages.CATEGORY_SORT);
            this.setChecked(PrefConst.getChecksViewSortByType());
        }

        public void run() {
            PrefConst.setChecksViewSortByType(this.isChecked());
            ChecksView.this.update(null);
        }
    }
}

