/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.commandhandlers;

import java.util.Map;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.menus.UIElement;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.actions.IMenuCommandDelegate;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.commandhandlers.AContextMenuCommandHandler;

public class ShowAllInstancesInDH
extends AContextMenuCommandHandler
implements IElementUpdater {
    @Override
    boolean executeAction(IMenuCommandDelegate contributor, IDVTElementWrapper wrapper, String partID) {
        return contributor.showAllInstancesInDH(wrapper);
    }

    public void updateElement(UIElement element, Map parameters) {
        IWorkbenchWindow workbenchWindow = DVTUiUtils.getActiveWorkbenchWindow();
        if (workbenchWindow == null) {
            return;
        }
        ISelectionService selectionService = workbenchWindow.getSelectionService();
        ISelection selection = selectionService.getSelection();
        if (!(selection instanceof StructuredSelection)) {
            return;
        }
        StructuredSelection structuredSelection = (StructuredSelection)selection;
        Object viewElement = structuredSelection.getFirstElement();
        if (!(viewElement instanceof IDVTElementWrapper)) {
            return;
        }
        IDVTElementWrapper elementWrapper = (IDVTElementWrapper)viewElement;
        Object rfElement = elementWrapper.getRfElement();
        if (rfElement instanceof IRfDefElement) {
            rfElement = ((IRfDefElement)rfElement).getNamedElement();
        }
        if (!(rfElement instanceof IRfNamedElement)) {
            return;
        }
        IRfSingleLangProject project = ((IRfNamedElement)rfElement).getRfProject();
        if (project == null) {
            return;
        }
        StringBuilder str = new StringBuilder("Show All Instances in Design Hierarchy");
        element.setText(str.toString());
    }
}

