/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.comparators;

import java.util.Comparator;
import org.eclipse.jface.viewers.ILabelProvider;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.utils.StringMatcher;

public class PromoteComparator
implements Comparator<IDVTElementWrapper> {
    private ILabelProvider fLabelProvider;
    private StringMatcher fPromoteMatcher;

    public PromoteComparator(StringMatcher promoteMatcher, ILabelProvider labelProvider) {
        this.fLabelProvider = labelProvider;
        this.fPromoteMatcher = promoteMatcher;
    }

    @Override
    public int compare(IDVTElementWrapper w1, IDVTElementWrapper w2) {
        if (this.fPromoteMatcher == null) {
            return 0;
        }
        boolean promoteP1 = false;
        boolean promoteP2 = false;
        String text1 = this.fLabelProvider.getText((Object)w1);
        String text2 = this.fLabelProvider.getText((Object)w2);
        promoteP1 = ViewsUtils.matchCamelCaseOrRegex(this.fPromoteMatcher, text1);
        promoteP2 = ViewsUtils.matchCamelCaseOrRegex(this.fPromoteMatcher, text2);
        if (promoteP1 && promoteP2) {
            return 0;
        }
        if (promoteP1) {
            return -1;
        }
        if (promoteP2) {
            return 1;
        }
        return 0;
    }
}

