/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.compileorder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import ro.amiq.dvt.symbolcollector.ISymbolCollectorPrerequisite;
import ro.amiq.dvt.symbolcollector.SymbolCollectorConfigurator;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.compileorder.CompileOrderViewInput;
import ro.amiq.dvt.ui.views.compileorder.CompileOrderViewInputConfigurator;
import ro.amiq.dvt.ui.views.compileorder.ICompileOrderViewContributor;

public abstract class BaseCompileOrderViewContributor
implements ICompileOrderViewContributor {
    @Override
    public List<ISymbolCollectorPrerequisite> getSymbolsPrerequisites(SymbolCollectorConfigurator symbolConfigurator) {
        CompileOrderViewInput input = this.getInput(new CompileOrderViewInputConfigurator(symbolConfigurator));
        if (input == null) {
            return Collections.emptyList();
        }
        List<IDVTElementWrapper> elements = input.getElements();
        if (elements == null || elements.isEmpty()) {
            return Collections.emptyList();
        }
        return new ArrayList<ISymbolCollectorPrerequisite>(elements);
    }

    @Override
    public final boolean symbolMatchesQueryKey(ISymbolCollectorPrerequisite symbolPrerequisite, SymbolCollectorConfigurator configurator) {
        return true;
    }

    protected final boolean shouldAddFile(ISymbolCollectorPrerequisite symbolPrerequisite, CompileOrderViewInputConfigurator configurator) {
        if (symbolPrerequisite == null || configurator == null) {
            return false;
        }
        if (!configurator.isCollectingSymbols()) {
            return true;
        }
        if (!this.shouldCollectSymbol(symbolPrerequisite, configurator.getSymbolConfigurator())) {
            return false;
        }
        configurator.countNewSymbol();
        return true;
    }
}

