/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.compileorder;

import java.util.Map;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.buildconfig.BCFileInstance;
import ro.amiq.dvt.model.reflection.views.IRfFilterableTreeAccessor;
import ro.amiq.dvt.symbolcollector.BaseSymbolInputConfigurator;
import ro.amiq.dvt.symbolcollector.SymbolCollectorConfigurator;
import ro.amiq.dvt.ui.views.UpdateJob;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.utils.StringMatcher;

public class CompileOrderViewInputConfigurator
extends BaseSymbolInputConfigurator {
    private final IProject fProject;
    private final StringMatcher[] fSearchSegments;
    private final boolean[] fSearchStrictness;
    private final boolean fShowLanguageNameAsRoot;
    private final boolean fShowFilesWithErrors;
    private final IRfFilterableTreeAccessor fView;
    private final Map<String, BCFileInstance> fParsedBCFiles;

    public CompileOrderViewInputConfigurator(IProject project, StringMatcher[] searchSegments, boolean[] searchStrictness, boolean showLanguageNameAsRoot, boolean showFilesWithErrors, IRfFilterableTreeAccessor view) {
        this(project, searchSegments, searchStrictness, showLanguageNameAsRoot, showFilesWithErrors, view, null);
    }

    public CompileOrderViewInputConfigurator(IProject project, StringMatcher[] searchSegments, boolean[] searchStrictness, boolean showLanguageNameAsRoot, boolean showFilesWithErrors, IRfFilterableTreeAccessor view, Map<String, BCFileInstance> parsedBCFiles) {
        this.fProject = project;
        this.fSearchSegments = searchSegments;
        this.fSearchStrictness = searchStrictness;
        this.fShowLanguageNameAsRoot = showLanguageNameAsRoot;
        this.fShowFilesWithErrors = showFilesWithErrors;
        this.fView = view;
        this.fParsedBCFiles = parsedBCFiles;
    }

    protected CompileOrderViewInputConfigurator(SymbolCollectorConfigurator symbolConfigurator) {
        super(symbolConfigurator);
        this.fProject = super.getProject();
        this.fSearchSegments = new StringMatcher[]{super.getQueryPatternMatcher()};
        this.fSearchStrictness = new boolean[1];
        this.fShowLanguageNameAsRoot = false;
        this.fShowFilesWithErrors = false;
        this.fView = super.getView();
        this.fParsedBCFiles = null;
    }

    public StringMatcher[] getSearchSegments() {
        return this.fSearchSegments;
    }

    public boolean[] getSearchStrictness() {
        return this.fSearchStrictness;
    }

    @Override
    public IProject getProject() {
        return this.fProject;
    }

    public boolean isShowLanguageNameAsRootElement() {
        return this.fShowLanguageNameAsRoot;
    }

    public boolean hasShowFilesWithErrors() {
        return this.fShowFilesWithErrors;
    }

    @Override
    public IRfFilterableTreeAccessor getView() {
        return this.fView;
    }

    public Map<String, BCFileInstance> getParsedBCFiles() {
        return this.fParsedBCFiles;
    }

    public UpdateJob getUpdateJob() {
        if (this.fView == null) {
            return null;
        }
        return this.fView.getUpdateJob();
    }

    public boolean isCanceled() {
        return ViewsUtils.isCanceled(this.getUpdateJob()) || this.isSymbolCollectionCanceled();
    }
}

