/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.config.db;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.preference.BooleanPropertyAction;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.interpreter.IXXVMConfigDBSetGetCallInfo;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.ui.views.BuildEvents;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.config.db.ConfigDBView;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.utils.Utils;

public class ConfigDBActions {

    public static class ConfigDBCopyInstanceFieldName
    extends Action {
        private final Tree tree;
        private final boolean isCopyInstance;

        public ConfigDBCopyInstanceFieldName(Tree tree, boolean isCopyInstance) {
            super(isCopyInstance ? "Copy instance name" : "Copy field name");
            this.tree = tree;
            this.isCopyInstance = isCopyInstance;
            this.setToolTipText("Copy resource " + (isCopyInstance ? "instance name" : "field name") + " to clipboard");
        }

        public void run() {
            if (this.tree == null || this.tree.isDisposed()) {
                return;
            }
            TreeItem[] sel = this.tree.getSelection();
            if (sel == null || sel.length == 0) {
                return;
            }
            Object data = sel[0].getData();
            if (!(data instanceof TreePath)) {
                return;
            }
            Object call = ((TreePath)data).getElement();
            if (!(call instanceof IDVTElementWrapper)) {
                return;
            }
            if (!((call = ((IDVTElementWrapper)call).getRfElement()) instanceof IXXVMConfigDBSetGetCallInfo)) {
                return;
            }
            String content = this.isCopyInstance ? ((IXXVMConfigDBSetGetCallInfo)call).getInstName() : ((IXXVMConfigDBSetGetCallInfo)call).getFieldName();
            Utils.copyToClipboard(content, 3);
        }
    }

    public static class ConfigDBInspectElement
    extends Action {
        private final IProject project;
        private final Tree tree;
        private final boolean isInspectValue;

        public ConfigDBInspectElement(Tree tree, IProject project, boolean isInspectValue) {
            super(isInspectValue ? "Inspect Value" : "Inspect Context");
            this.project = project;
            this.tree = tree;
            this.isInspectValue = isInspectValue;
            this.setToolTipText("Quick inspect view for " + (isInspectValue ? "value" : "context"));
        }

        public void run() {
            if (this.tree == null || this.tree.isDisposed()) {
                return;
            }
            TreeItem[] sel = this.tree.getSelection();
            if (sel == null || sel.length == 0) {
                return;
            }
            Object data = sel[0].getData();
            if (!(data instanceof TreePath)) {
                return;
            }
            Object call = ((TreePath)data).getElement();
            if (!(call instanceof IDVTElementWrapper)) {
                return;
            }
            if (!((call = ((IDVTElementWrapper)call).getRfElement()) instanceof IXXVMConfigDBSetGetCallInfo)) {
                return;
            }
        }
    }

    public static class ConfigDBOpenType
    extends Action {
        private final IProject project;
        private final Tree tree;

        public ConfigDBOpenType(Tree tree, IProject project) {
            super("Open Type Declaration");
            this.project = project;
            this.tree = tree;
            this.setToolTipText("Jump in the editor to the type declaration");
        }

        public void run() {
            if (this.tree == null || this.tree.isDisposed()) {
                return;
            }
            TreeItem[] sel = this.tree.getSelection();
            if (sel == null || sel.length == 0) {
                return;
            }
            Object data = sel[0].getData();
            if (!(data instanceof TreePath)) {
                return;
            }
            Object call = ((TreePath)data).getElement();
            if (!(call instanceof IDVTElementWrapper)) {
                return;
            }
            if (!((call = ((IDVTElementWrapper)call).getRfElement()) instanceof IXXVMConfigDBSetGetCallInfo)) {
                return;
            }
        }
    }

    public static class ConfigDBSortByExecution
    extends BooleanPropertyAction {
        ConfigDBView view;

        public ConfigDBSortByExecution(ConfigDBView configDBView) {
            super("Execution sort", DVTPlugin.getDefault().getPreferenceStore(), "configDBView.sortByExec");
            this.view = configDBView;
            this.setImageDescriptor(DVTImages.SORT_EXEC);
            this.setChecked(PrefConst.getConfigDBViewVlogSortByExecution());
            this.setToolTipText("Sort By Execution: " + (this.isChecked() ? "On" : "Off"));
        }

        public void run() {
            PrefConst.setConfigDBViewVlogSortByExecution(this.isChecked());
            this.view.update(BuildEvents.INTERPRETER_ACTION_VIEW);
        }

        public void setChecked(boolean checked) {
            super.setChecked(checked);
            this.setToolTipText("Sort By Execution: " + (checked ? "On" : "Off"));
        }
    }
}

