/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.config.db;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IActionBars;
import ro.amiq.dvt.interpreter.IXXVMConfigDBSetGetCallInfo;
import ro.amiq.dvt.interpreter.XViewsUtils;
import ro.amiq.dvt.model.reflection.GoToInfo;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.actions.guifilters.GUIFiltersHandler;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.ui.projectcolors.ProjectColorUtils;
import ro.amiq.dvt.ui.views.BuildEvents;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.TextFilterObject;
import ro.amiq.dvt.ui.views.ViewDataContainer;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.config.db.ConfigDBActions;
import ro.amiq.dvt.ui.views.config.db.ConfigDBRevealType;
import ro.amiq.dvt.ui.views.config.db.ConfigDBSortKind;
import ro.amiq.dvt.ui.views.config.db.ConfigDBViewCommon;
import ro.amiq.dvt.ui.views.config.db.ConfigDBViewModel;
import ro.amiq.dvt.ui.views.config.db.IXConfigDBContributor;
import ro.amiq.dvt.ui.views.config.db.LazyConfigDBTestUtils;
import ro.amiq.dvt.ui.views.inspect.InspectViewSelectionListener;
import ro.amiq.dvt.ui.views.interpreter.IInterpreterViewsCommon;
import ro.amiq.dvt.ui.views.lazy.tree.AbstractTreeIterator;
import ro.amiq.dvt.ui.views.lazy.tree.IDVTLazyTable;
import ro.amiq.dvt.ui.views.lazy.tree.IDVTModel;
import ro.amiq.dvt.ui.views.lazy.tree.LazyTree;
import ro.amiq.dvt.ui.views.lazy.tree.LazyTreeIteratorType;
import ro.amiq.dvt.ui.views.lazy.tree.LazyTreeMessageCompositeType;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeAction;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeActionArguments;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeRevealInViewActionArguments;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeSearchActionArguments;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeUpdateViewActionArguments;
import ro.amiq.dvt.ui.views.lazy.views.CollapseAllAction;
import ro.amiq.dvt.ui.views.lazy.views.DVTLazyViewUtils;
import ro.amiq.dvt.ui.views.lazy.views.ExpandAllAction;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.dvt.utils.Utils;

public class ConfigDBView
extends ConfigDBViewCommon
implements IDVTLazyTable {
    private Label labelInfo;
    private Composite controlParent;
    private Composite childComposite;
    private static final int COLUMN_SIZE = 25;
    private static final String SEARCH_BY = "Search by:";
    private LazyConfigDBTestUtils configDBTestUtils = new LazyConfigDBTestUtils(this);
    private Composite sashChildTree;
    private TextFilterObject filter;
    private ConfigDBFilterAction filterAction;
    private Action configDBSortByExec;
    private final Map<String, Integer> fColumnNamesIndexes = new HashMap<String, Integer>();

    public IXConfigDBContributor getViewContributor() {
        return XViewsUtils.getXConfigDBViewContributor();
    }

    @Override
    public int getViewColumnCount() {
        return this.fColumnNamesIndexes.size();
    }

    private void updateLabelInfo() {
        Display.getDefault().asyncExec(() -> {
            if (this.labelInfo == null || this.labelInfo.isDisposed()) {
                return;
            }
            this.labelInfo.setText(this.getLabelInfoText());
            ObjectionManager.getInstance().clear(Objection.CONFIG_DB_LABEL);
        });
    }

    @Override
    public void update(BuildEvents updateEvent) {
        boolean resetTop;
        this.updateLabelInfo();
        if (IInterpreterViewsCommon.isInterpreterMode()) {
            this.configDBViewModel = null;
            this.clean();
            updateEvent = updateEvent == BuildEvents.PRE_INTERPRETER_MODE ? updateEvent : BuildEvents.INTERPRETER_MODE;
        }
        IProject project = this.getProject();
        if (updateEvent == null && (project == null || !project.isAccessible()) || updateEvent != BuildEvents.INTERPRETER_MODE && updateEvent != BuildEvents.INTERPRETER_FAILED && updateEvent != BuildEvents.PRE_INTERPRETER_MODE && updateEvent != BuildEvents.GUI_FILTERS_WORKSPACE && updateEvent != BuildEvents.INTERPRETER_ACTION_VIEW) {
            this.configDBViewModel = null;
            this.clean();
            return;
        }
        if (updateEvent == BuildEvents.GUI_FILTERS_WORKSPACE) {
            this.currentContributor.setHasGuiFilters(GUIFiltersHandler.isFilteringEnabled());
            if (this.configDBViewModel == null) {
                return;
            }
        }
        if (!this.currentContributor.c(project)) {
            return;
        }
        LazyTree lazyTree = this.getLazyTree();
        if (lazyTree == null) {
            return;
        }
        if (this.configDBViewModel == null && updateEvent == BuildEvents.INTERPRETER_ACTION_VIEW) {
            return;
        }
        boolean resetSelection = updateEvent == null;
        boolean isInterpreterMode = updateEvent == BuildEvents.INTERPRETER_MODE;
        boolean resetModel = updateEvent == null || updateEvent == BuildEvents.FULL_BUILD || updateEvent == BuildEvents.GUI_FILTERS_WORKSPACE;
        boolean interpreterFailed = updateEvent == BuildEvents.INTERPRETER_FAILED;
        boolean isPreInterpreterMode = updateEvent == BuildEvents.PRE_INTERPRETER_MODE;
        boolean isInterpreterFinishedEvent = updateEvent == BuildEvents.INTERPRETER_MODE || updateEvent == BuildEvents.INTERPRETER_FAILED;
        ProjectColorUtils.setFgBg(this, this.getProject().getName());
        boolean bl = resetTop = updateEvent == null || updateEvent != BuildEvents.INCREMENTAL_BUILD && updateEvent != BuildEvents.INTERPRETER_FAILED && updateEvent != BuildEvents.INTERPRETER_MODE;
        if (this.configDBViewModel == null || isInterpreterMode || isPreInterpreterMode || resetModel) {
            this.configDBViewModel = new ConfigDBViewModel(this.getProject(), this, this.labelProvider, isPreInterpreterMode);
        }
        if (interpreterFailed) {
            this.configDBViewModel.setHasInterpreterFailed(true);
        }
        lazyTree.doAction(LazyTreeAction.UPDATE_VIEW, new LazyTreeUpdateViewActionArguments(this, this.configDBViewModel, resetSelection, resetTop, resetModel, isInterpreterFinishedEvent ? Objection.CONFIG_DB_INTERPRETED : Objection.CONFIG_DB));
    }

    @Override
    public void clean() {
        IProject project = this.getProject();
        if (project == null || !project.isAccessible() || !Utils.hasDvtNature(project)) {
            this.labelInfo.setText(LazyTreeMessageCompositeType.NO_DVT_PROJECT_SELECTED.getMessage());
            ProjectColorUtils.setFgBg(this, null);
        } else {
            this.labelInfo.setText("[" + project.getName() + "]");
            ProjectColorUtils.setFgBg(this, project.getName());
        }
        if (this.getLazyTree() != null) {
            this.getLazyTree().doAction(LazyTreeAction.CLEAN, new LazyTreeActionArguments(Objection.CONFIG_DB));
        }
        this.dataContainer = new ViewDataContainer(project, null);
        this.configDBViewModel = null;
    }

    @Override
    public Control getControlToColorBg() {
        if (this.labelInfo == null) {
            return null;
        }
        return this.labelInfo.getParent();
    }

    @Override
    public Control getControlToColorFg() {
        return this.labelInfo;
    }

    @Override
    public IProject getProject() {
        if (this.dataContainer == null) {
            return null;
        }
        return this.dataContainer.getProject();
    }

    @Override
    public void setCancelActionEnabled(boolean enabled) {
    }

    @Override
    public ConfigDBSortKind getSortKind() {
        if (this.configDBSortByExec != null) {
            return this.configDBSortByExec.isChecked() ? ConfigDBSortKind.EXEC_SORT : ConfigDBSortKind.GROUP_SG;
        }
        return PrefConst.getConfigDBViewVlogSortByExecution() ? ConfigDBSortKind.EXEC_SORT : ConfigDBSortKind.GROUP_SG;
    }

    protected void updateActionState() {
        if (!(PrefConst.getConfigDBViewVlogHideUnassociatedGetters() || PrefConst.getConfigDBViewVlogHideUnassociatedSetters() || PrefConst.getConfigDBViewVlogHideAssociatedSettersAndGetters() || PrefConst.getConfigDBViewVlogHideReadOnlySetters())) {
            this.filterAction.setChecked(false);
        } else {
            this.filterAction.setChecked(true);
        }
    }

    @Override
    public void createToolBar() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        if (actionBars == null) {
            return;
        }
        IToolBarManager toolBarManager = actionBars.getToolBarManager();
        toolBarManager.removeAll();
        if (toolBarManager.getItems().length > 0) {
            toolBarManager.add((IContributionItem)new Separator());
        }
        LazyTree lazyTree = this.getLazyTree();
        this.configDBSortByExec = new ConfigDBActions.ConfigDBSortByExecution(this);
        toolBarManager.add((IAction)this.configDBSortByExec);
        this.filterAction = new ConfigDBFilterAction();
        toolBarManager.add((IAction)this.filterAction);
        toolBarManager.add((IAction)new ExpandAllAction(lazyTree));
        toolBarManager.add((IAction)new CollapseAllAction(lazyTree));
        toolBarManager.update(true);
    }

    @Override
    public IDVTModel getModel(Class<? extends IDVTModel> modelClass) {
        return this.configDBViewModel;
    }

    @Override
    public ILabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    @Override
    public void selectionChanged() {
    }

    @Override
    public LazyTreeIteratorType getIteratorType() {
        return LazyTreeIteratorType.LAZY_CONFIG_DB;
    }

    @Override
    public Objection getObjection() {
        return Objection.CONFIG_DB;
    }

    @Override
    public LazyConfigDBTestUtils getLazyTreeTestUtils() {
        return this.configDBTestUtils;
    }

    @Override
    public void addViewSpecificListeners(AbstractTreeIterator treeIterator) {
    }

    @Override
    public boolean supportsDecorations() {
        return false;
    }

    @Override
    public String getMessageText() {
        if (this.getProject() == null || !this.getProject().isAccessible() || !Utils.hasDvtNature(this.getProject())) {
            return "Select a DVT Project or file.";
        }
        if (!this.getTextFilter("default-filter").getText().isEmpty()) {
            if (this.configDBViewModel == null) {
                return LazyTreeMessageCompositeType.NO_DATA.getMessage();
            }
            return LazyTreeMessageCompositeType.NO_MATCHES_FOUND.getMessage();
        }
        if (this.configDBViewModel != null && this.configDBViewModel.hasInterpreterFailed()) {
            this.configDBViewModel = null;
            return LazyTreeMessageCompositeType.INTERPRETER_FAILED.getMessage();
        }
        if (this.configDBViewModel != null && this.configDBViewModel.hasConfigDBFilteredElements()) {
            return LazyTreeMessageCompositeType.CONFIG_DB_FILTERED.getMessage();
        }
        if (this.configDBViewModel != null && this.configDBViewModel.isEmpty()) {
            return LazyTreeMessageCompositeType.NO_DATA.getMessage();
        }
        return "Select a runtime elaborated Verification Top from the UVM entry in the main menu.";
    }

    @Override
    public void gotoSelectedElement(String treeId) {
        TreePath selectedElement = this.getLazyTree().getSelection();
        if (selectedElement == null) {
            return;
        }
        IProject project = this.getProject();
        if (project == null) {
            return;
        }
        ((IXConfigDBContributor)this.currentContributor).setBreadcrumbData(selectedElement, project);
        this.currentContributor.gotoElement(project, selectedElement);
    }

    @Override
    public String prepareText(String textFilterId, String text) {
        return text;
    }

    @Override
    public void stringMatcherUpdated(String uIJobTextFilterId) {
        this.updateLabelInfo();
        this.getLazyTree().doAction(LazyTreeAction.SEARCH, new LazyTreeSearchActionArguments(true, true, this.configDBViewModel, Objection.CONFIG_DB));
    }

    @Override
    public ILabelProvider getTreeLabelProvider() {
        return this.labelProvider;
    }

    @Override
    public StringMatcher[] getTreeSearchSegments() {
        TextFilterObject textFilterObject = this.getTextFilterObject("default-filter");
        if (textFilterObject == null) {
            return null;
        }
        return textFilterObject.getSearchSegments();
    }

    @Override
    public boolean[] getTreeSearchStrictness() {
        TextFilterObject textFilterObject = this.getTextFilterObject("default-filter");
        if (textFilterObject == null) {
            return null;
        }
        return textFilterObject.getSearchTextStrictness();
    }

    @Override
    public String getTreeSearchPort() {
        return null;
    }

    @Override
    public List<String> getMemberNames(IDVTElementWrapper node) {
        return null;
    }

    @Override
    public boolean isFiltered() {
        TextFilterObject textFilterObject = this.getTextFilterObject("default-filter");
        if (textFilterObject == null) {
            return false;
        }
        return textFilterObject.isFiltered();
    }

    @Override
    public void createAndSyncTreeColumns(Table topTable, Tree tree, ScrolledComposite scrolledComposite) {
        int n = tree.getSize().x;
        if (n == 0) {
            n = 1000;
        }
        int columnIndex = 0;
        TableColumn fCallTypeColumn = new TableColumn(topTable, 16384);
        fCallTypeColumn.setText("Call");
        fCallTypeColumn.setWidth(n * 25 / 100);
        TreeColumn treeCallTypeColumn = new TreeColumn(tree, 16384);
        treeCallTypeColumn.setWidth(fCallTypeColumn.getWidth());
        this.fColumnNamesIndexes.put("Call", columnIndex++);
        this.labelProvider.updateColumnSize(this.fColumnNamesIndexes.get("Call"), fCallTypeColumn.getWidth());
        TableColumn fTypeColumn = new TableColumn(topTable, 16384);
        fTypeColumn.setText("Type");
        fTypeColumn.setWidth(n * 25 / 100);
        TreeColumn treeTypeColumn = new TreeColumn(tree, 16384);
        treeTypeColumn.setWidth(fTypeColumn.getWidth());
        this.fColumnNamesIndexes.put("Type", columnIndex++);
        this.labelProvider.updateColumnSize(this.fColumnNamesIndexes.get("Type"), fTypeColumn.getWidth());
        TableColumn fContextColumn = new TableColumn(topTable, 16384);
        fContextColumn.setText("Context");
        fContextColumn.setWidth(n * 25 / 100);
        TreeColumn treeContextColumn = new TreeColumn(tree, 16384);
        treeContextColumn.setWidth(fContextColumn.getWidth());
        this.fColumnNamesIndexes.put("Context", columnIndex++);
        this.labelProvider.updateColumnSize(this.fColumnNamesIndexes.get("Context"), fContextColumn.getWidth());
        TableColumn fInstanceNameColumn = new TableColumn(topTable, 16384);
        fInstanceNameColumn.setText("Applicable To");
        fInstanceNameColumn.setWidth(n * 25 / 100);
        TreeColumn treeInstanceNameColumn = new TreeColumn(tree, 16384);
        treeInstanceNameColumn.setWidth(fInstanceNameColumn.getWidth());
        this.fColumnNamesIndexes.put("Applicable To", columnIndex++);
        this.labelProvider.updateColumnSize(this.fColumnNamesIndexes.get("Applicable To"), fInstanceNameColumn.getWidth());
        TableColumn fFieldNameColumn = new TableColumn(topTable, 16384);
        fFieldNameColumn.setText("Field Name");
        fFieldNameColumn.setWidth(n * 25 / 100);
        TreeColumn treeFieldNameColumn = new TreeColumn(tree, 16384);
        treeFieldNameColumn.setWidth(fFieldNameColumn.getWidth());
        this.fColumnNamesIndexes.put("Field Name", columnIndex++);
        this.labelProvider.updateColumnSize(this.fColumnNamesIndexes.get("Field Name"), fFieldNameColumn.getWidth());
        TableColumn fValueColumn = new TableColumn(topTable, 16384);
        fValueColumn.setText("Value");
        fValueColumn.setWidth(n * 25 / 100);
        TreeColumn treeValueColumn = new TreeColumn(tree, 16384);
        treeValueColumn.setWidth(fValueColumn.getWidth());
        this.fColumnNamesIndexes.put("Value", columnIndex++);
        this.labelProvider.updateColumnSize(this.fColumnNamesIndexes.get("Value"), fValueColumn.getWidth());
        fCallTypeColumn.addListener(11, event -> {
            int n1 = fCallTypeColumn.getWidth() + fTypeColumn.getWidth() + fContextColumn.getWidth() + fInstanceNameColumn.getWidth() + fFieldNameColumn.getWidth() + fValueColumn.getWidth();
            scrolledComposite.setMinWidth(n1);
            treeCallTypeColumn.setWidth(fCallTypeColumn.getWidth());
            this.labelProvider.updateColumnSize(this.fColumnNamesIndexes.get("Call"), fCallTypeColumn.getWidth());
        });
        fTypeColumn.addListener(11, event -> {
            int n1 = fCallTypeColumn.getWidth() + fTypeColumn.getWidth() + fContextColumn.getWidth() + fInstanceNameColumn.getWidth() + fFieldNameColumn.getWidth() + fValueColumn.getWidth();
            scrolledComposite.setMinWidth(n1);
            treeTypeColumn.setWidth(fTypeColumn.getWidth());
            this.labelProvider.updateColumnSize(this.fColumnNamesIndexes.get("Type"), fTypeColumn.getWidth());
        });
        fContextColumn.addListener(11, event -> {
            int n1 = fCallTypeColumn.getWidth() + fTypeColumn.getWidth() + fContextColumn.getWidth() + fInstanceNameColumn.getWidth() + fFieldNameColumn.getWidth() + fValueColumn.getWidth();
            scrolledComposite.setMinWidth(n1);
            treeContextColumn.setWidth(fContextColumn.getWidth());
            this.labelProvider.updateColumnSize(this.fColumnNamesIndexes.get("Context"), fContextColumn.getWidth());
        });
        fInstanceNameColumn.addListener(11, event -> {
            int n1 = fCallTypeColumn.getWidth() + fTypeColumn.getWidth() + fContextColumn.getWidth() + fInstanceNameColumn.getWidth() + fFieldNameColumn.getWidth() + fValueColumn.getWidth();
            scrolledComposite.setMinWidth(n1);
            treeInstanceNameColumn.setWidth(fInstanceNameColumn.getWidth());
            this.labelProvider.updateColumnSize(this.fColumnNamesIndexes.get("Applicable To"), fInstanceNameColumn.getWidth());
        });
        fFieldNameColumn.addListener(11, event -> {
            int n1 = fCallTypeColumn.getWidth() + fTypeColumn.getWidth() + fContextColumn.getWidth() + fInstanceNameColumn.getWidth() + fFieldNameColumn.getWidth() + fValueColumn.getWidth();
            scrolledComposite.setMinWidth(n1);
            treeFieldNameColumn.setWidth(fFieldNameColumn.getWidth());
            this.labelProvider.updateColumnSize(this.fColumnNamesIndexes.get("Field Name"), fFieldNameColumn.getWidth());
        });
        fValueColumn.addListener(11, event -> {
            int n1 = fCallTypeColumn.getWidth() + fTypeColumn.getWidth() + fContextColumn.getWidth() + fInstanceNameColumn.getWidth() + fFieldNameColumn.getWidth() + fValueColumn.getWidth();
            scrolledComposite.setMinWidth(n1);
            treeValueColumn.setWidth(fValueColumn.getWidth());
            this.labelProvider.updateColumnSize(this.fColumnNamesIndexes.get("Value"), fValueColumn.getWidth());
        });
    }

    public Composite getControlParent() {
        return this.controlParent;
    }

    @Override
    protected void createViewSpecificPartControl(Composite parent) {
        this.controlParent = parent;
        LazyTree lazyTree = new LazyTree(this);
        this.setLazyTree(lazyTree);
        this.childComposite = new Composite(parent, 0);
        this.childComposite.setLayoutData((Object)new GridData(1808));
        this.childComposite.setLayout((Layout)DVTLazyViewUtils.LAYOUT);
        SashForm mainSashForm = new SashForm(this.childComposite, 512);
        mainSashForm.setLayout((Layout)DVTLazyViewUtils.LAYOUT);
        mainSashForm.setFont(this.childComposite.getFont());
        mainSashForm.setLayoutData((Object)new GridData(1808));
        Composite fUpperSashFormComposite = new Composite((Composite)mainSashForm, 0);
        fUpperSashFormComposite.setLayout((Layout)DVTLazyViewUtils.LAYOUT);
        fUpperSashFormComposite.setLayoutData((Object)new GridData(1808));
        Composite labelComposite = new Composite(fUpperSashFormComposite, 0);
        GridLayout labelLayout = new GridLayout(1, false);
        labelComposite.setLayout((Layout)labelLayout);
        labelComposite.setLayoutData((Object)new GridData(4, 1, false, false));
        this.labelInfo = new Label(labelComposite, 16384);
        this.labelInfo.setFont(labelComposite.getFont());
        this.labelInfo.setLayoutData((Object)new GridData(768));
        this.updateLabelInfo();
        SashForm upperSashForm = new SashForm(fUpperSashFormComposite, 256);
        upperSashForm.setLayout((Layout)DVTLazyViewUtils.TWO_PART_LAYOUT);
        upperSashForm.setLayoutData((Object)new GridData(1808));
        this.sashChildTree = new Composite((Composite)upperSashForm, 0);
        this.sashChildTree.setLayout((Layout)DVTLazyViewUtils.LAYOUT);
        this.sashChildTree.setLayoutData((Object)new GridData(1808));
        this.createTextFilter("default-filter", this.sashChildTree, "default-tree", false);
        this.filter = this.getTextFilterObject("default-filter");
        this.filter.setTextFilterMessage(SEARCH_BY);
        lazyTree.setSearchBar(this.filter);
        lazyTree.setLabelProvider(this.getLabelProvider(), false);
        lazyTree.install(this.sashChildTree);
        Tree fTree = lazyTree.getTree();
        fTree.setHeaderVisible(false);
        this.addSelectionChangedListener(InspectViewSelectionListener.getInstance());
        fTree.addKeyListener((KeyListener)this.getKeyListener("default-filter", "default-tree"));
    }

    @Override
    protected void createCustomContextMenu(IMenuManager manager) {
        TreePath selection = this.getLazyTree().getSelection();
        if (selection == null) {
            return;
        }
        Object selectedElement = selection.getElement();
        if (selectedElement instanceof TreePath) {
            selectedElement = ((TreePath)selectedElement).getElement();
        }
        if (!(selectedElement instanceof IDVTElementWrapper)) {
            return;
        }
        Object rfElement = ((IDVTElementWrapper)selectedElement).getRfElement();
        if (!(rfElement instanceof IXXVMConfigDBSetGetCallInfo)) {
            return;
        }
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new ConfigDBActions.ConfigDBCopyInstanceFieldName(this.getLazyTree().getTree(), true));
        manager.add((IAction)new ConfigDBActions.ConfigDBCopyInstanceFieldName(this.getLazyTree().getTree(), false));
    }

    @Override
    public void revealInView(GoToInfo goToInfo, IRfNamedElement rfField) {
        if (!(goToInfo instanceof XViewsUtils.GoToInfoWithRevealType)) {
            return;
        }
        ConfigDBRevealType type = ((XViewsUtils.GoToInfoWithRevealType)goToInfo).getType();
        if (type == ConfigDBRevealType.REVEAL_ASSOCIATED_SETTER_FOR_GETTER || type == ConfigDBRevealType.REVEAL_ASSOCIATED_GETTERS_FOR_SETTER) {
            this.getViewContributor().computeAssociatedReveal((XViewsUtils.GoToInfoWithRevealType)goToInfo, this);
            return;
        }
        String callType = type == ConfigDBRevealType.REVEAL_GETTER ? "getter" : "setter";
        TreePath treePath = this.getViewContributor().createTreePath(goToInfo, this, rfField);
        if (treePath == null) {
            ViewsUtils.popOKDialog(2, "Config DB", "The selected " + callType + " was not found in the Config DB View!");
            return;
        }
        if (treePath == TreePath.TOP_DUMMY_TREE_PATH) {
            ViewsUtils.popOKDialog(2, "Config DB", "The associated " + callType + " is filtered from Config DB View.\nPlease deactivate the view filters.");
            return;
        }
        this.configDBViewModel = new ConfigDBViewModel(this.getProject(), this, this.labelProvider, false);
        this.getLazyTree().doAction(LazyTreeAction.REVEAL_IN_VIEW, new LazyTreeRevealInViewActionArguments(treePath, false, this.getObjection()));
    }

    public TextFilterObject getFilter() {
        return this.filter;
    }

    class ConfigDBFilterAction
    extends Action {
        public ConfigDBFilterAction() {
            super("Filters...", 2);
            this.setDescription("Filters...");
            this.setToolTipText("Filters...");
            this.setImageDescriptor(DVTImages.FILTER);
        }

        public void run() {
            new ConfigDBMenuCreateor().getMenu((Control)ConfigDBView.this.getViewSite().getShell()).setVisible(true);
            ConfigDBView.this.updateActionState();
        }
    }

    class ConfigDBMenuCreateor
    implements IMenuCreator {
        Menu fMenu;

        ConfigDBMenuCreateor() {
        }

        public void dispose() {
        }

        public Menu getMenu(Menu parent) {
            return null;
        }

        public Menu getMenu(Control parent) {
            this.fMenu = new Menu(parent);
            this.fMenu.setVisible(true);
            if (!ViewsUtils.projectContainsVlogNature(ConfigDBView.this.getProject())) {
                return this.fMenu;
            }
            MenuItem filterUnused = new MenuItem(this.fMenu, 32);
            filterUnused.setText("Hide unassociated UVM Config DB Setters");
            filterUnused.setSelection(PrefConst.getConfigDBViewVlogHideUnassociatedSetters());
            filterUnused.setEnabled(true);
            filterUnused.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (!(e.widget instanceof MenuItem)) {
                        return;
                    }
                    PrefConst.setConfigDBViewVlogHideUnassociatedSetters(((MenuItem)e.widget).getSelection());
                    ConfigDBView.this.updateActionState();
                    ConfigDBView.this.update(BuildEvents.INTERPRETER_ACTION_VIEW);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            MenuItem filterChain = new MenuItem(this.fMenu, 32);
            filterChain.setText("Hide associated UVM Config DB Setters and Getters");
            filterChain.setSelection(PrefConst.getConfigDBViewVlogHideAssociatedSettersAndGetters());
            filterChain.setEnabled(true);
            filterChain.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (!(e.widget instanceof MenuItem)) {
                        return;
                    }
                    PrefConst.setConfigDBViewVlogHideAssociatedSettersAndGetters(((MenuItem)e.widget).getSelection());
                    ConfigDBView.this.updateActionState();
                    ConfigDBView.this.update(BuildEvents.INTERPRETER_ACTION_VIEW);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            MenuItem filterDirect = new MenuItem(this.fMenu, 32);
            filterDirect.setText("Hide unassociated UVM Config DB Getters");
            filterDirect.setSelection(PrefConst.getConfigDBViewVlogHideUnassociatedGetters());
            filterDirect.setEnabled(true);
            filterDirect.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (!(e.widget instanceof MenuItem)) {
                        return;
                    }
                    PrefConst.setConfigDBViewVlogHideUnassociatedGetters(((MenuItem)e.widget).getSelection());
                    ConfigDBView.this.updateActionState();
                    ConfigDBView.this.update(BuildEvents.INTERPRETER_ACTION_VIEW);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            MenuItem filterReadOnly = new MenuItem(this.fMenu, 32);
            filterReadOnly.setText("Hide UVM Config DB Setters for read only resources");
            filterReadOnly.setSelection(PrefConst.getConfigDBViewVlogHideReadOnlySetters());
            filterReadOnly.setEnabled(true);
            filterReadOnly.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (!(e.widget instanceof MenuItem)) {
                        return;
                    }
                    PrefConst.setConfigDBViewVlogHideReadOnlySetters(((MenuItem)e.widget).getSelection());
                    ConfigDBView.this.updateActionState();
                    ConfigDBView.this.update(BuildEvents.INTERPRETER_ACTION_VIEW);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            return this.fMenu;
        }
    }
}

