/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.config.db;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.interpreter.IXContributor;
import ro.amiq.dvt.interpreter.XViewsUtils;
import ro.amiq.dvt.ui.actions.history.HistoryItem;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.ui.views.ViewDataContainer;
import ro.amiq.dvt.ui.views.ViewKind;
import ro.amiq.dvt.ui.views.config.db.ConfigDBSortKind;
import ro.amiq.dvt.ui.views.config.db.ConfigDBViewFilters;
import ro.amiq.dvt.ui.views.config.db.DVTXConfigDBLabelProvider;
import ro.amiq.dvt.ui.views.config.db.IConfigDBModel;
import ro.amiq.dvt.ui.views.config.db.IXConfigDBContributor;
import ro.amiq.dvt.ui.views.interpreter.IInterpreterViews;
import ro.amiq.dvt.ui.views.interpreter.IInterpreterViewsCommon;
import ro.amiq.dvt.ui.views.lazy.views.DVTLazyView;

public abstract class ConfigDBViewCommon
extends DVTLazyView
implements IInterpreterViews {
    public static final String VALUE = "Value";
    public static final String FIELD_NAME = "Field Name";
    public static final String APPLICABLE_TO = "Applicable To";
    public static final String CONTEXT = "Context";
    public static final String TYPE = "Type";
    public static final String CALL = "Call";
    public static final String ID = "ro.amiq.dvt.ui.views.ConfigDBView";
    public static final EnumSet<ViewKind> VIEW_KIND = EnumSet.of(ViewKind.PROJECT_INFORMATION, ViewKind.CAN_HANDLE_ALL_BUILD_EVENTS, ViewKind.CAN_HANDLE_GUI_FILTERS);
    protected IXContributor currentContributor = XViewsUtils.getXConfigDBViewContributor();
    protected boolean dirty;
    protected ViewDataContainer dataContainer;
    protected IConfigDBModel configDBViewModel;
    protected DVTXConfigDBLabelProvider labelProvider = new DVTXConfigDBLabelProvider();

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public EnumSet<ViewKind> getKind() {
        return VIEW_KIND;
    }

    public IXContributor getCurrentContributor() {
        return this.currentContributor;
    }

    @Override
    public void setInput(ViewDataContainer dataContainer) {
        this.dataContainer = dataContainer;
    }

    @Override
    public void setDirty(boolean isDirty) {
        this.dirty = isDirty;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public ViewDataContainer getDataContainer() {
        return this.dataContainer;
    }

    public List<ConfigDBViewFilters> getHideFilters() {
        ArrayList<ConfigDBViewFilters> filters = new ArrayList<ConfigDBViewFilters>();
        if (PrefConst.getConfigDBViewVlogHideUnassociatedSetters()) {
            filters.add(ConfigDBViewFilters.SETTERS_WITHOUT_GETTERS);
        }
        if (PrefConst.getConfigDBViewVlogHideAssociatedSettersAndGetters()) {
            filters.add(ConfigDBViewFilters.SETTERS_AND_GETTERS);
        }
        if (PrefConst.getConfigDBViewVlogHideUnassociatedGetters()) {
            filters.add(ConfigDBViewFilters.GETTERS_WITHOUT_SETTERS);
        }
        if (PrefConst.getConfigDBViewVlogHideReadOnlySetters()) {
            filters.add(ConfigDBViewFilters.HIDE_READ_ONLY_SETTERS);
        }
        return filters;
    }

    public HistoryItem getHistoryItem() {
        IProject project;
        HistoryItem xvhHistoryItem;
        if (IInterpreterViewsCommon.isInterpreterMode() && (xvhHistoryItem = this.getXVHHistoryItem(project = this.getProject())) != null) {
            return xvhHistoryItem;
        }
        if (this.dataContainer == null) {
            return null;
        }
        return this.dataContainer.getHistoryItem();
    }

    public List<Object> computeAndGetAllModelElements() {
        return this.configDBViewModel.computeAndGetAllModelElements();
    }

    public String getLabelInfoText() {
        IProject project = this.getProject();
        if (project == null || !project.isAccessible()) {
            return "[no DVT Project or file selected]";
        }
        if (this.getHistoryItem() == null || !(this.currentContributor instanceof IXConfigDBContributor)) {
            return "[" + project.getName() + "]";
        }
        String labelText = ((IXConfigDBContributor)this.currentContributor).getTreeLabelText(this.getHistoryItem());
        if (labelText == null || labelText.isEmpty()) {
            labelText = "[" + project.getName() + "]";
        }
        return labelText;
    }

    public abstract ConfigDBSortKind getSortKind();
}

