/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.config.db;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import ro.amiq.dvt.interpreter.IXContributor;
import ro.amiq.dvt.interpreter.IXXVMConfigDBGetCallInfo;
import ro.amiq.dvt.interpreter.IXXVMConfigDBSetCallInfo;
import ro.amiq.dvt.interpreter.IXXVMConfigDBSetGetCallInfo;
import ro.amiq.dvt.interpreter.XViewsUtils;
import ro.amiq.dvt.model.reflection.semantic.extension2.DummyElement;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.ui.views.DVTBaseLabelProvider;
import ro.amiq.dvt.ui.views.DVTTreeElementWrapper;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.config.db.ConfigDBSortKind;
import ro.amiq.dvt.ui.views.config.db.ConfigDBView;
import ro.amiq.dvt.ui.views.config.db.ConfigDBViewFilters;
import ro.amiq.dvt.ui.views.config.db.IConfigDBModel;
import ro.amiq.dvt.ui.views.config.db.IXConfigDBContributor;
import ro.amiq.dvt.ui.views.lazy.tree.AbstractTreeIterator;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;

public class ConfigDBViewModel
implements IConfigDBModel {
    private final IProject project;
    private IXConfigDBContributor currentContributor;
    private final ConfigDBView configDBView;
    private final DVTBaseLabelProvider labelProvider;
    public static final Comparator<TreePath> treePathComparator = (t1, t2) -> {
        if (t1 == null || t2 == null) {
            return 0;
        }
        Object element1 = t1.getElement();
        Object element2 = t2.getElement();
        if (!(element1 instanceof IDVTElementWrapper) || !(element2 instanceof IDVTElementWrapper)) {
            return 0;
        }
        Object rfElement1 = ((IDVTElementWrapper)element1).getRfElement();
        Object rfElement2 = ((IDVTElementWrapper)element2).getRfElement();
        if (!(rfElement1 instanceof IXXVMConfigDBSetGetCallInfo) || !(rfElement2 instanceof IXXVMConfigDBSetGetCallInfo)) {
            return -1;
        }
        if (rfElement1 instanceof IXXVMConfigDBSetCallInfo && rfElement2 instanceof IXXVMConfigDBGetCallInfo) {
            return -1;
        }
        if (rfElement1 instanceof IXXVMConfigDBGetCallInfo && rfElement2 instanceof IXXVMConfigDBSetCallInfo) {
            return 1;
        }
        int id1 = ((IXXVMConfigDBSetGetCallInfo)rfElement1).getIdEvaluation();
        int id2 = ((IXXVMConfigDBSetGetCallInfo)rfElement2).getIdEvaluation();
        return id1 - id2;
    };

    public ConfigDBViewModel(IProject project, ConfigDBView configDBView, DVTBaseLabelProvider labelProvider, boolean isPreInterpreterMode) {
        this.project = project;
        this.currentContributor = XViewsUtils.getXConfigDBViewContributor();
        if (isPreInterpreterMode) {
            this.currentContributor.resetState();
        }
        this.configDBView = configDBView;
        this.labelProvider = labelProvider;
    }

    @Override
    public List<TreePath> getChildren(TreePath treePath, int childStartIndex, int childEndIndex, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return Collections.emptyList();
        }
        if (this.project == null || treePath == null) {
            return Collections.emptyList();
        }
        if (this.currentContributor == null || this.currentContributor.hasInterpreterFailed()) {
            return Collections.emptyList();
        }
        List<TreePath> result = new ArrayList<TreePath>();
        if (treePath == TreePath.TOP_DUMMY_TREE_PATH) {
            result = this.currentContributor.createTreePath(monitor, this.project, this.configDBView.getHideFilters(), this.configDBView.getSortKind() == ConfigDBSortKind.GROUP_SG);
            if (result != null) {
                return result;
            }
            result = new ArrayList();
            if (result.isEmpty()) {
                result.add(AbstractTreeIterator.getDummyOperatioNode(null));
            }
            return result;
        }
        Object element = treePath.getElement();
        if (element instanceof DummyElement) {
            return result;
        }
        List<Object> children = this.currentContributor.getChildrenForElement(element, this.project, monitor, this.configDBView.getHideFilters().contains((Object)ConfigDBViewFilters.HIDE_READ_ONLY_SETTERS));
        if (children == null) {
            return result;
        }
        int i = childStartIndex;
        while (i < Math.min(childEndIndex, children.size())) {
            TreePath prevChild;
            if (monitor.isCanceled()) {
                return Collections.emptyList();
            }
            Object dvtElementWrapper = children.get(i);
            String text = this.labelProvider.getText(dvtElementWrapper);
            TreePath child = TreePath.child(treePath, text, i, treePathComparator);
            child.setElement(dvtElementWrapper);
            TreePath treePath2 = prevChild = result.isEmpty() ? null : result.get(result.size() - 1);
            if (child.equals(prevChild, true)) {
                child.append("@(" + i + ")@");
            }
            result.add(child);
            ++i;
        }
        return result;
    }

    @Override
    public Boolean hasChildren(TreePath path, IProgressMonitor monitor) {
        List<TreePath> children = this.getChildren(path, 0, 1, monitor);
        if (children != null && !children.isEmpty()) {
            return true;
        }
        return false;
    }

    @Override
    public TreePath getLastChild(TreePath path, IProgressMonitor monitor) {
        List<TreePath> children = this.getChildren(path, 0, Integer.MAX_VALUE, monitor);
        return children == null || children.isEmpty() ? null : children.get(children.size() - 1);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public TreePath getEndTreePath(TreePath treePath, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return treePath;
        }
        currentPath = treePath;
        children = this.getChildren(currentPath, 0, 0x7FFFFFFF, monitor);
        if (children != null && !children.isEmpty()) ** GOTO lbl11
        return currentPath;
lbl-1000:
        // 1 sources

        {
            if (monitor.isCanceled()) {
                return currentPath;
            }
            currentPath = children.get(children.size() - 1);
            children = this.getChildren(currentPath, 0, 0x7FFFFFFF, monitor);
lbl11:
            // 2 sources

            ** while (children != null && !children.isEmpty())
        }
lbl12:
        // 1 sources

        return currentPath;
    }

    @Override
    public void clearModelCaches() {
    }

    @Override
    public boolean hasInterpreterFailed() {
        if (this.currentContributor == null) {
            throw new IllegalStateException("Contributor cannot be null!");
        }
        return this.currentContributor.hasInterpreterFailed();
    }

    @Override
    public void setHasInterpreterFailed(boolean isInterpreterProcessFailed) {
        if (this.currentContributor == null) {
            throw new IllegalStateException("Contributor cannot be null!");
        }
        this.currentContributor.setHasInterpreterFailed(isInterpreterProcessFailed);
    }

    @Override
    public List<Object> computeAndGetAllModelElements() {
        ArrayList<Object> children = new ArrayList<Object>();
        if (this.configDBView == null) {
            return children;
        }
        IXContributor xContributor = this.configDBView.getCurrentContributor();
        if (!(xContributor instanceof IXConfigDBContributor)) {
            throw new IllegalStateException("Unable to locate contributor");
        }
        this.currentContributor = (IXConfigDBContributor)xContributor;
        List<TreePath> rootTreePaths = this.getChildren(TreePath.TOP_DUMMY_TREE_PATH, 0, Integer.MAX_VALUE, (IProgressMonitor)new NullProgressMonitor());
        for (TreePath path : rootTreePaths) {
            DVTTreeElementWrapper rootWrapper = new DVTTreeElementWrapper(path);
            this.computeChildrenForElement(rootWrapper);
            children.add(rootWrapper);
        }
        return children;
    }

    private void computeChildrenForElement(DVTTreeElementWrapper element) {
        List<TreePath> elementChildren = this.getChildren((TreePath)element.getRfElement(), 0, Integer.MAX_VALUE, (IProgressMonitor)new NullProgressMonitor());
        if (elementChildren == null || elementChildren.isEmpty()) {
            return;
        }
        for (TreePath child : elementChildren) {
            DVTTreeElementWrapper elementWrapper = new DVTTreeElementWrapper(child);
            this.computeChildrenForElement(elementWrapper);
            element.addChild(elementWrapper);
        }
    }

    @Override
    public boolean hasConfigDBFilteredElements() {
        return PrefConst.getConfigDBViewVlogHideReadOnlySetters() || PrefConst.getConfigDBViewVlogHideUnassociatedSetters() || PrefConst.getConfigDBViewVlogHideUnassociatedGetters() || PrefConst.getConfigDBViewVlogHideAssociatedSettersAndGetters();
    }

    @Override
    public boolean isEmpty() {
        return this.computeAndGetAllModelElements().isEmpty();
    }
}

