/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.coverage;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IActionBars;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.EclipseUtils;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.ui.projectcolors.ProjectColorUtils;
import ro.amiq.dvt.ui.views.AbstractFilteredView;
import ro.amiq.dvt.ui.views.BuildEvents;
import ro.amiq.dvt.ui.views.DVTLabelProviderProxy;
import ro.amiq.dvt.ui.views.DVTViewContributors;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.IUpdateJobImpl;
import ro.amiq.dvt.ui.views.TreeViewContentProvider;
import ro.amiq.dvt.ui.views.UpdateJob;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.coverage.CoverageViewCommon;
import ro.amiq.dvt.ui.views.coverage.CoverageViewInput;
import ro.amiq.dvt.ui.views.coverage.CoverageViewInputConfigurator;
import ro.amiq.dvt.ui.views.coverage.ICoverageViewContributor;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.dvt.utils.Utils;

public class CoverageView
extends CoverageViewCommon
implements IUpdateJobImpl {
    private static final List<ICoverageViewContributor> fAllCoverageContibutors = DVTViewContributors.getInstance().getAllInstanceOf(ICoverageViewContributor.class);
    private final UpdateJob fUpdateJob;
    private DVTLabelProviderProxy<ICoverageViewContributor> fLabelProvider = new DVTLabelProviderProxy<ICoverageViewContributor>(ICoverageViewContributor.class, "default-tree");
    private Label fInfo;
    private Tree fTree;
    private TreeViewContentProvider fLazyContentProvider;
    private SortByTypeAction fSortByTypeAction;
    private AbstractFilteredView.CollapseAllAction fCollapseAllAction;
    private AbstractFilteredView.ExpandAllAction fExpandAllAction;
    private int fNrTotalCoverGroups;
    private int fNrNotFilteredCoverGroups;
    private int fNrTotalCoverItems;
    private int fNrNotFilteredCoverItems;
    private int fNrTotalCoverAsserts;
    private int fNrNotFilteredCoverAsserts;
    private List<IDVTElementWrapper> fElements;
    private Label fContentFiltersLabel;
    private boolean fHasGUIFilteredElements;
    private Image fContentFiltersEnabledIcon = DVTImages.imageCache.getImage(DVTImages.GUI_FILTERS_ICON_MINI);
    private Image fContentFiltersDisabledIcon = DVTImages.imageCache.getImage(DVTImages.GUI_FILTERS_ICON_MINI_DISABLED);

    public CoverageView() {
        this.fUpdateJob = new UpdateJob("Update Coverage View", this);
    }

    @Override
    public void customCreatePartControl(Composite parent) {
        GridData gridData = new GridData(1808);
        parent.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        parent.setLayout((Layout)layout);
        Composite labelComposite = new Composite(parent, 0);
        GridLayout labelLayout = new GridLayout(2, false);
        labelComposite.setLayout((Layout)labelLayout);
        labelComposite.setLayoutData((Object)new GridData(4, 1, true, false));
        this.fContentFiltersLabel = new Label(labelComposite, 0);
        if (EclipseUtils.isAtLeastEclipse419()) {
            this.fContentFiltersLabel.setImage(this.fHasGUIFilteredElements ? this.fContentFiltersEnabledIcon : this.fContentFiltersDisabledIcon);
        } else {
            this.fContentFiltersLabel.setImage(this.fContentFiltersEnabledIcon);
        }
        this.fContentFiltersLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.fContentFiltersLabel.setToolTipText("Content Filters matched!");
        this.fContentFiltersLabel.setEnabled(this.fHasGUIFilteredElements);
        this.fInfo = new Label(labelComposite, 16384);
        this.fInfo.setLayoutData((Object)new GridData(768));
        this.createTextFilter("default-filter", parent, "default-tree", false);
        this.setTextFilterMessage("default-filter", "Filter by: hierarchical name");
        Composite composite = new Composite(parent, 0);
        GridData compositeGridData = new GridData(1808);
        composite.setLayoutData((Object)compositeGridData);
        composite.setLayout((Layout)new FillLayout(256));
        this.createToolbar(parent);
        this.fTree = new Tree(composite, 268436228);
        this.fTree.setHeaderVisible(true);
        TreeColumn covergroups = new TreeColumn(this.fTree, 16384);
        covergroups.setText("Cover groups");
        covergroups.setWidth(400);
        TreeColumn comments = new TreeColumn(this.fTree, 16384);
        comments.setText("Comments");
        comments.setWidth(100);
        this.fLazyContentProvider = new TreeViewContentProvider(this.fTree, this.fLabelProvider);
        Menu coverageMenu = new Menu((Control)this.fTree);
        this.fTree.setMenu(coverageMenu);
        this.fTree.addKeyListener((KeyListener)this.getKeyListener("default-filter", "default-tree"));
        this.fTree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                CoverageView.this.gotoSelectedElement("default-tree");
            }

            public void mouseDown(MouseEvent e) {
            }
        });
        this.installContextMenuAndSelectionListener((Control)this.fTree);
    }

    private void createToolbar(Composite parent) {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager tbm = actionBars.getToolBarManager();
        this.fCollapseAllAction = new AbstractFilteredView.CollapseAllAction();
        this.fExpandAllAction = new AbstractFilteredView.ExpandAllAction();
        this.fSortByTypeAction = new SortByTypeAction();
        tbm.add((IAction)this.fSortByTypeAction);
        tbm.add((IContributionItem)new Separator());
        tbm.add((IAction)this.fExpandAllAction);
        tbm.add((IAction)this.fCollapseAllAction);
    }

    @Override
    public void update(BuildEvents updateEvent) {
        try {
            if (this.fTree == null) {
                return;
            }
            IProject project = this.getProject();
            if (project == null || project != null && !project.isAccessible() || !Utils.hasDvtNature(project)) {
                this.clean();
                return;
            }
            if (!DVTPlugin.getDefault().collect().c(project, "F636F7265")) {
                return;
            }
            this.fLazyContentProvider.setInput((List<IDVTElementWrapper>)new ArrayList<IDVTElementWrapper>(UPDATE_JOB_MESSAGE_INPUT), this.fExpandLevel);
            this.fHasGUIFilteredElements = false;
            this.fUpdateJob.cancel();
            this.fUpdateJob.schedule();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    public void updateNonGuiPart(UpdateJob updateJob) {
        try {
            this.resetElementCount();
            this.fElements = new ArrayList<IDVTElementWrapper>();
            boolean firstElemSelected = false;
            for (ICoverageViewContributor coverageViewContentProvider : fAllCoverageContibutors) {
                if (ViewsUtils.isCanceled(updateJob)) {
                    return;
                }
                IProject project = this.getProject();
                CoverageViewInput input = coverageViewContentProvider.getInput(new CoverageViewInputConfigurator(project, this.getSearchSegments("default-filter"), this.getSearchStrictness("default-filter"), ViewsUtils.hasMoreThanOneDVTNature(project), PrefConst.getCoverageViewSortByType(), updateJob));
                List<IDVTElementWrapper> origElems = input.getElements();
                if (!firstElemSelected && !origElems.isEmpty()) {
                    firstElemSelected = ViewsUtils.selectFirstElement(coverageViewContentProvider, this.getLightStringMatcher(), origElems);
                }
                this.fElements.addAll(origElems);
                this.fNrTotalCoverGroups += input.getTotalCoverGroups();
                this.fNrNotFilteredCoverGroups += input.getNotFilteredCoverGroups();
                this.fNrTotalCoverItems += input.getTotalCoverItems();
                this.fNrNotFilteredCoverItems += input.getNotFilteredCoverItems();
                this.fNrTotalCoverAsserts += input.getTotalCoverAsserts();
                this.fNrNotFilteredCoverAsserts += input.getNotFilteredCoverAsserts();
                boolean bl = this.fHasGUIFilteredElements = this.fHasGUIFilteredElements || input.hasGUIFilteredElements();
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    public void updateGuiPart(UpdateJob updateJob) {
        try {
            IProject project = this.getProject();
            if (this.fLazyContentProvider != null && this.fElements != null && this.fInfo != null && project != null) {
                this.fExpandLevel = -1;
                StringMatcher sm = this.getStringMatcher("default-filter");
                if (this.fElements.isEmpty()) {
                    if (sm != null && !sm.getPattern().isEmpty()) {
                        this.fLazyContentProvider.setInput((List<IDVTElementWrapper>)new ArrayList<IDVTElementWrapper>(NO_MATCHES_FOUND), this.fExpandLevel);
                    } else if (this.fHasGUIFilteredElements) {
                        this.fLazyContentProvider.setInput((List<IDVTElementWrapper>)new ArrayList<IDVTElementWrapper>(GUI_FILTERED_EMPTY_CONTENT), this.fExpandLevel);
                    } else {
                        this.fLazyContentProvider.setInput((List<IDVTElementWrapper>)new ArrayList<IDVTElementWrapper>(NO_DATA_MESSAGE), this.fExpandLevel);
                    }
                } else {
                    this.fLazyContentProvider.setInput(this.fElements, this.fExpandLevel);
                }
                StringBuilder infoText = new StringBuilder();
                infoText.append("[").append(project.getName()).append("]").append("[");
                if (this.fNrTotalCoverGroups == this.fNrNotFilteredCoverGroups) {
                    infoText.append(this.fNrTotalCoverGroups);
                } else {
                    infoText.append(this.fNrNotFilteredCoverGroups).append("/").append(this.fNrTotalCoverGroups);
                }
                infoText.append(ViewsUtils.getUnitName("cover group", this.fNrTotalCoverGroups, " ", "")).append("][");
                if (this.fNrTotalCoverItems == this.fNrNotFilteredCoverItems) {
                    infoText.append(this.fNrTotalCoverItems);
                } else {
                    infoText.append(this.fNrNotFilteredCoverItems).append("/").append(this.fNrTotalCoverItems);
                }
                if (project.getNature("ro.amiq.vlogdt.VlogNature") != null && this.fNrTotalCoverAsserts != 0) {
                    infoText.append(ViewsUtils.getUnitName("cover item", this.fNrTotalCoverItems, " ", "")).append("][");
                    if (this.fNrTotalCoverAsserts == this.fNrNotFilteredCoverAsserts) {
                        infoText.append(this.fNrTotalCoverAsserts);
                    } else {
                        infoText.append(this.fNrNotFilteredCoverAsserts).append("/").append(this.fNrTotalCoverAsserts);
                    }
                    infoText.append(ViewsUtils.getUnitName("cover assertion", this.fNrTotalCoverAsserts, " ", "")).append("]");
                } else {
                    infoText.append(ViewsUtils.getUnitName("cover item", this.fNrTotalCoverItems, " ", "")).append("]");
                }
                this.fInfo.setText(infoText.toString());
                ProjectColorUtils.setFgBg(this, project.getName());
                if (EclipseUtils.isAtLeastEclipse419()) {
                    this.fContentFiltersLabel.setImage(this.fHasGUIFilteredElements ? this.fContentFiltersEnabledIcon : this.fContentFiltersDisabledIcon);
                }
                this.fContentFiltersLabel.setEnabled(this.fHasGUIFilteredElements);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private StringMatcher getLightStringMatcher() {
        StringMatcher currentStringMatcher = this.getStringMatcher("default-filter");
        if (currentStringMatcher == null) {
            return null;
        }
        String currentPattern = currentStringMatcher.getPattern().replace("//", "");
        if (!currentPattern.contains("/")) {
            return new StringMatcher(currentPattern, true, false);
        }
        String[] parts = currentPattern.split("/");
        String newPattern = parts[parts.length - 1];
        if (!newPattern.startsWith("*")) {
            newPattern = "*" + newPattern;
        }
        return new StringMatcher(newPattern, true, false);
    }

    @Override
    public void dispose() {
        if (this.fTree != null && !this.fTree.isDisposed()) {
            this.fTree.dispose();
        }
        if (this.fInfo != null && !this.fInfo.isDisposed()) {
            this.fInfo.dispose();
        }
        if (this.fContentFiltersLabel != null && !this.fContentFiltersLabel.isDisposed()) {
            this.fContentFiltersLabel.dispose();
        }
        this.fTree = null;
        this.fInfo = null;
        this.fLazyContentProvider = null;
        this.fContentFiltersLabel = null;
        super.dispose();
    }

    public void setFocus() {
        this.fTree.setFocus();
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
    }

    private ICoverageViewContributor getViewContributor(IDVTElementWrapper wrapper) {
        return DVTViewContributors.getInstance().getViewContributor(wrapper, ICoverageViewContributor.class);
    }

    @Override
    public void gotoSelectedElement(String treeId) {
        IDVTElementWrapper selectedWrapper = this.getSelectedWrapper(treeId);
        if (selectedWrapper == null || this.getViewContributor(selectedWrapper) == null) {
            return;
        }
        this.getViewContributor(selectedWrapper).gotoElement(this.getProject(), selectedWrapper);
    }

    @Override
    public void stringMatcherUpdated(String textFilterId) {
        try {
            this.fTree.setRedraw(false);
            this.update(null);
            this.fTree.setRedraw(true);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    public Tree getTree(String treeId) {
        return this.fTree;
    }

    @Override
    public Object getTreeRootElement(String treeId) {
        return this.fTree.getData();
    }

    public DVTLabelProviderProxy<ICoverageViewContributor> getLabelProvider() {
        return this.fLabelProvider;
    }

    @Override
    public String prepareText(String textFilterId, String text) {
        if (!(text.trim().length() == 0 || text.endsWith("//") && text.endsWith("/"))) {
            text = String.valueOf(text) + "//";
        }
        return text;
    }

    @Override
    public void refreshSelection(IResource resource) {
    }

    private void resetElementCount() {
        this.fNrTotalCoverGroups = 0;
        this.fNrNotFilteredCoverGroups = 0;
        this.fNrTotalCoverItems = 0;
        this.fNrNotFilteredCoverItems = 0;
        this.fNrTotalCoverAsserts = 0;
        this.fNrNotFilteredCoverAsserts = 0;
    }

    @Override
    public void clean() {
        this.fUpdateJob.cancel();
        this.resetElementCount();
        IProject project = this.getProject();
        if (project == null || !project.isAccessible() || !Utils.hasDvtNature(project)) {
            this.fInfo.setText("[no DVT Project or file selected]");
            ProjectColorUtils.setFgBg(this, null);
            this.fLazyContentProvider.setInput((List<IDVTElementWrapper>)new ArrayList<IDVTElementWrapper>(INPUT_SELECT_PROJECT_OR_FILE), this.fExpandLevel);
            this.fContentFiltersLabel.setEnabled(false);
        } else {
            this.fInfo.setText("[" + project.getName() + "][" + this.fNrTotalCoverGroups + " cover groups]");
            ProjectColorUtils.setFgBg(this, project.getName());
            this.fLazyContentProvider.setInput((List<IDVTElementWrapper>)new ArrayList<IDVTElementWrapper>(NO_DATA_MESSAGE), this.fExpandLevel);
            if (EclipseUtils.isAtLeastEclipse419()) {
                this.fContentFiltersLabel.setImage(this.fHasGUIFilteredElements ? this.fContentFiltersEnabledIcon : this.fContentFiltersDisabledIcon);
            }
            this.fContentFiltersLabel.setEnabled(this.fHasGUIFilteredElements);
        }
    }

    @Override
    public TreeViewContentProvider getExpandableContentProvider() {
        return this.fLazyContentProvider;
    }

    @Override
    public Control getControlToColorBg() {
        return this.fInfo.getParent();
    }

    @Override
    public Control getControlToColorFg() {
        return this.fInfo;
    }

    class SortByTypeAction
    extends Action {
        public SortByTypeAction() {
            super("Category Sort", 2);
            this.setDescription("Sort by Category");
            this.setToolTipText("Sort Elements by Category");
            this.setImageDescriptor(DVTImages.CATEGORY_SORT);
            this.setChecked(PrefConst.getCoverageViewSortByType());
        }

        public void run() {
            PrefConst.setCoverageViewSortByType(this.isChecked());
            CoverageView.this.update(null);
        }
    }
}

