/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.designhierarchy;

import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.HierarchicalElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.views.DVTBaseLabelProvider;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.IMembersLabelProvider;
import ro.amiq.dvt.ui.views.designhierarchy.DHViewUtils;

public class DHPortsLabelProvider
extends DVTBaseLabelProvider
implements IMembersLabelProvider {
    protected boolean showUpf;

    @Override
    public Image getImage(Object wrapper) {
        if (!(wrapper instanceof IDVTElementWrapper)) {
            return DVTImages.imageCache.getImage(DVTImages.NONE);
        }
        Object element = ((IDVTElementWrapper)wrapper).getRfElement();
        if (element instanceof HierarchicalElement) {
            element = ((HierarchicalElement)element).getFirstSegment();
        }
        if (element instanceof IRfPortElement) {
            IRfPortElement port = (IRfPortElement)element;
            if (port.isInput() || port.isOutput() || port.isInout()) {
                return port.getImage();
            }
            if (port.isModportPort()) {
                return DVTImages.imageCache.getImage(DVTImages.OUTLINE_MODPORT);
            }
            if (port.isInterfacePort()) {
                return DVTImages.imageCache.getImage(DVTImages.OUTLINE_INTERFACE_PORT);
            }
            return DVTImages.imageCache.getImage(DVTImages.OUTLINE_NODIR_PORT);
        }
        if (element instanceof IRfNamedElement) {
            return ((IRfNamedElement)element).getImage();
        }
        return DVTImages.imageCache.getImage(DVTImages.NONE);
    }

    @Override
    public String getText(Object wrapper) {
        if (!(wrapper instanceof IDVTElementWrapper)) {
            return "";
        }
        Object element = ((IDVTElementWrapper)wrapper).getRfElement();
        if (element instanceof String) {
            return (String)element;
        }
        if (!(element instanceof IRfNamedElement)) {
            return "";
        }
        return DHViewUtils.getSignalLabelText((IRfNamedElement)element);
    }

    public void setShowUPF(boolean showUPF) {
        this.showUpf = showUPF;
    }

    protected ElementPath computePortPathFromElement(String port, String instance) {
        ElementPath instancePath = ElementPath.from(instance, "/");
        return ElementPath.join(instancePath, port);
    }
}

