/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.designhierarchy;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.designhierarchy.DHViewMessages;
import ro.amiq.dvt.ui.views.designhierarchy.DHViewUtilsCommon;
import ro.amiq.dvt.ui.views.designhierarchy.IDHLabelProvider;
import ro.amiq.dvt.ui.views.lazy.views.designhierarchy.DVTDHLabelProvider;
import ro.amiq.dvt.ui.views.lazy.views.designhierarchy.LazyDesignHierarchyView;

public class DHViewUtils
extends DHViewUtilsCommon {
    public static final String COPY_HIERARCHY_PATH = "Copy Hierarchy Path";
    public static final String DOT_REPLACE_IN_TOP_STRING_IN_BC_XML = "___dvt_dot___";

    public static void popDialog(int messageType, String dialogMessage) {
        ViewsUtils.popOKDialog(messageType, DHViewMessages.fDHPopUpDialogTitle, dialogMessage);
    }

    public static void popRevealDialog(int messageType, String dialogMessage) {
        ViewsUtils.popOKDialog(messageType, DHViewMessages.fDHRevealPopUpDialogTitle, dialogMessage);
    }

    public static IDVTElementWrapper getDHRoot() {
        IWorkbenchWindow activeWorkbenchWindow = Utils.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return null;
        }
        IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
        if (activePage == null) {
            return null;
        }
        String id = "ro.amiq.dvt.ui.views.LazyDesignHierarchyView";
        IViewReference ref = activePage.findViewReference(id);
        if (ref == null) {
            return null;
        }
        LazyDesignHierarchyView view = (LazyDesignHierarchyView)ref.getView(false);
        if (view == null) {
            return null;
        }
        return view.getRoot();
    }

    public static void findInstancesForDesignElementElabMode(IProject project, IRfNamedElement designElement, List<ElementPath> foundInstances, int maxNumOfFoundInstances) {
        ELManager elManager = RfMixedLangManager.getInstance().getELManager(project);
        if (elManager == null) {
            return;
        }
        if (!(designElement instanceof IRfDesignElement)) {
            return;
        }
        List<ELInstance> instancesFor = elManager.getMemory().getInstancesFor(designElement, false, maxNumOfFoundInstances);
        for (ELInstance instance : instancesFor) {
            foundInstances.add(instance.getHierarchyPath());
        }
    }

    public static IDHLabelProvider getLabelProvider() {
        try {
            return new DVTDHLabelProvider();
        }
        catch (RuntimeException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }
}

