/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.designhierarchy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.elaboration.model.IELMemory;
import ro.amiq.dvt.model.reflection.DummyDesignElement;
import ro.amiq.dvt.model.reflection.DummyInstance;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.ErrorDesignElement;
import ro.amiq.dvt.model.reflection.IRfAssociatedTypeElement;
import ro.amiq.dvt.model.reflection.IRfBlockElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfLibraryElement;
import ro.amiq.dvt.model.reflection.IRfMethodElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.designhierarchy.DHViewUtils;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.views.lazy.tree.utils.TreePathUtils;
import ro.amiq.dvt.ui.views.lazy.views.designhierarchy.DHTrimmedTreePath;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.StringMatcher;

public class DHViewUtilsCommon {
    public static String getLabelText(IRfNamedElement element, IRfNamedElement component, IRfNamedElement instanceType, boolean prependLibrary, boolean showUPF) {
        StringBuilder result;
        block27: {
            block29: {
                block28: {
                    block26: {
                        result = new StringBuilder();
                        if (!((element = DesignUtils.toGenericDesignElement(element)) instanceof DummyInstance)) break block26;
                        result.append(((IRfInstanceElement)element).getName());
                        break block27;
                    }
                    if (!(element instanceof IRfInstanceElement)) break block28;
                    IRfInstanceElement instance = (IRfInstanceElement)element;
                    result.append(instance.getName());
                    if (instanceType instanceof IRfDesignElement) {
                        result.append(" : ");
                        String designLabel = DHViewUtilsCommon.getLabelText(component != null ? component : instanceType, null, instanceType, prependLibrary, showUPF);
                        IRfDesignElement designElement = (IRfDesignElement)instanceType;
                        if (component == null && (designElement.getKind() == IRfNamedElement.ElementKind.VHDL_ARCHITECTURE || designElement.getKind() == IRfNamedElement.ElementKind.VHDL_ENTITY) && designLabel.indexOf(" of ") != -1) {
                            result.append("[").append(designLabel).append("]");
                        } else {
                            result.append(designLabel);
                        }
                    } else {
                        String designName = instance.getAssociatedTypeName();
                        if (designName != null) {
                            result.append(" : ").append(designName);
                        }
                    }
                    break block27;
                }
                if (!(element instanceof IRfBlockElement)) break block29;
                IRfBlockElement blockElement = (IRfBlockElement)element;
                result.append(blockElement.getName());
                switch (blockElement.getKind()) {
                    case VHDL_ARCHITECTURE: {
                        IRfDesignElement entity = ((IRfBlockElement)element).getEntity();
                        if (entity != null) {
                            IRfLibraryElement enclosingLibrary;
                            result.append(" of ");
                            if (prependLibrary && (enclosingLibrary = entity.getEnclosingLibrary()) != null) {
                                result.append(enclosingLibrary.getName()).append(".");
                            }
                            result.append(entity.getName());
                            break;
                        }
                        break block27;
                    }
                    default: {
                        String expression = blockElement.getExpression();
                        if (expression != null) {
                            result.append(" [").append(expression).append("]");
                            break;
                        }
                        break block27;
                    }
                }
                break block27;
            }
            if (element instanceof IRfDesignElement) {
                IRfDesignElement designElement = (IRfDesignElement)element;
                switch (designElement.getKind()) {
                    case VHDL_ENTITY: {
                        IRfDesignElement architecture = designElement.getArchitecture();
                        if (architecture != null) {
                            result.append(DHViewUtilsCommon.getLabelText(architecture, null, null, prependLibrary, showUPF));
                            break;
                        }
                        result.append(designElement.getName());
                        break;
                    }
                    case VHDL_COMPONENT: {
                        String componentName = designElement.getName();
                        if (instanceType == null) {
                            result.append(componentName);
                            break;
                        }
                        String actualTypeLabel = DHViewUtilsCommon.getLabelText(instanceType, null, null, prependLibrary, showUPF);
                        if (!actualTypeLabel.endsWith(componentName)) {
                            result.append(componentName).append(" ").append("[").append(actualTypeLabel).append("]");
                            break;
                        }
                        if (actualTypeLabel.indexOf(" of ") != -1) {
                            result.append("[").append(actualTypeLabel).append("]");
                            break;
                        }
                        result.append(actualTypeLabel);
                        break;
                    }
                    default: {
                        IRfLibraryElement enclosingLibrary;
                        if (prependLibrary && (enclosingLibrary = designElement.getEnclosingLibrary()) != null) {
                            result.append(enclosingLibrary.getName()).append(".");
                        }
                        result.append(designElement.getName());
                        break;
                    }
                }
            } else if (element instanceof IRfAssociatedTypeElement) {
                result.append(element.getName());
                IRfNamedElement associatedType = ((IRfAssociatedTypeElement)element).getAssociatedType();
                if (associatedType != null) {
                    result.append(" : ").append(associatedType.getName());
                }
            } else if (element != null) {
                result.append(element.getName());
            }
        }
        return result.toString();
    }

    public static String getSignalLabelText(IRfNamedElement element) {
        if (element instanceof IRfMethodElement) {
            return element.getName();
        }
        return element == null ? "" : element.toString();
    }

    public static ElementPath getInstancePath(IDVTElementWrapper wrapper) {
        if (wrapper == null) {
            return null;
        }
        IDVTElementWrapper parent = wrapper.getParent();
        if (parent == null) {
            IRfNamedElement element = wrapper.getRfElement(IRfNamedElement.class);
            return element != null ? ElementPath.join(null, element.getName()) : null;
        }
        ElementPath result = DHViewUtilsCommon.getHierarchicalPath(wrapper);
        return result;
    }

    public static ElementPath getHierarchicalPath(IDVTElementWrapper wrapper) {
        ElementPath result = ElementPath.EMPTY_PATH;
        if (wrapper == null) {
            return result;
        }
        IRfNamedElement element = wrapper.getRfElement(IRfNamedElement.class);
        if (element == null) {
            return result;
        }
        result = DHViewUtilsCommon.getHierarchicalPath(wrapper.getParent());
        result = ElementPath.join(result, element.getName());
        return result;
    }

    public static IRfNamedElement getDesignHintFromWrapper(IDVTElementWrapper selection) {
        return selection == null ? null : selection.getInstanceType();
    }

    public static IRfNamedElement getElementFromWrapper(IDVTElementWrapper selection) {
        if (selection == null) {
            return null;
        }
        return selection.getRfElement(IRfNamedElement.class);
    }

    public static String getCopyHierarchyName(IDVTElementWrapper wrapper, boolean isVHDL) {
        if (wrapper == null) {
            return "";
        }
        Object element = wrapper.getRfElement();
        if (!(element instanceof IRfNamedElement)) {
            return "";
        }
        return DHViewUtilsCommon.getCopyHierarchyName((IRfNamedElement)element, isVHDL);
    }

    public static String getCopyHierarchyName(IRfNamedElement element, boolean isVHDL) {
        IRfDesignElement entity;
        if (element instanceof IRfBlockElement && DesignUtils.getDesignKind(element) == IRfNamedElement.ElementKind.VHDL_ARCHITECTURE && (entity = ((IRfBlockElement)element).getEntity()) != null) {
            return entity.getName();
        }
        if (element == null || element instanceof DummyDesignElement || element instanceof ErrorDesignElement) {
            return "";
        }
        String result = element.getName();
        if (result != null && element instanceof IRfBlockElement && ((IRfBlockElement)element).isLoopGenerate()) {
            result = String.valueOf(result) + (isVHDL ? "(i)" : "[i]");
        }
        return result != null ? result : "";
    }

    public static String getCopyHierarchyName(TreePath treePath, String separator) {
        if (treePath == null) {
            return "";
        }
        IRfNamedElement namedElement = treePath.getNamedElement();
        if (namedElement == null) {
            return "";
        }
        IRfSingleLangProject rfProject = namedElement.getRfProject();
        if (rfProject == null) {
            return "";
        }
        IELMemory memory = RfMixedLangManager.getInstance().getELMemory(rfProject.getProject());
        if (memory != null) {
            return DHViewUtilsCommon.getELCopyHierarchyName(treePath, separator);
        }
        ArrayList<String> result = new ArrayList<String>(5);
        List<IRfNamedElement> elementsFromPath = TreePathUtils.getElementsFromPath(treePath, true);
        for (IRfNamedElement element : elementsFromPath) {
            result.add(DHViewUtilsCommon.getCopyHierarchyName(element, DHViewUtilsCommon.isVhdl(element)));
        }
        return DVTStringUtil.join(result, separator);
    }

    public static String getELCopyHierarchyName(TreePath treePath, String separator) {
        List<Object> result = new ArrayList(5);
        result = treePath instanceof DHTrimmedTreePath ? ((DHTrimmedTreePath)treePath).getSegmentsToRoot() : Arrays.asList(treePath.getSegments());
        return DVTStringUtil.join(result, separator);
    }

    public static boolean isVhdl(IRfNamedElement element) {
        return element.getLanguageKind() == LanguageKind.VHDL;
    }

    public static String getPathForElement(Object element, String copyHierarchyPathSegmentSeparator) {
        String path = null;
        if (element instanceof IDVTElementWrapper) {
            IDVTElementWrapper selectedWrapper = (IDVTElementWrapper)element;
            ViewsUtils.ITreePathAccessor<Object> viewsUtils = wrapper -> {
                if (!(wrapper instanceof IDVTElementWrapper)) {
                    return "";
                }
                boolean isVHDL = ((IDVTElementWrapper)wrapper).getLanguageKind() == LanguageKind.VHDL;
                return DHViewUtils.getCopyHierarchyName((IDVTElementWrapper)wrapper, isVHDL);
            };
            path = ViewsUtils.pathToRoot(selectedWrapper, PrefConst.getCopyHierarchyPathSegmentSepartor(), viewsUtils);
        } else if (element instanceof TreePath) {
            path = DHViewUtils.getCopyHierarchyName((TreePath)element, copyHierarchyPathSegmentSeparator);
        }
        return path;
    }

    public static class SignalViewComparator
    implements Comparator<IRfNamedElement> {
        private StringMatcher portToPromote;
        private boolean alphabeticalSort;

        public SignalViewComparator(StringMatcher portToPromote, boolean alphabeticalSort) {
            this.portToPromote = portToPromote;
            this.alphabeticalSort = alphabeticalSort;
        }

        @Override
        public int compare(IRfNamedElement p1, IRfNamedElement p2) {
            if (p1 == null) {
                return -1;
            }
            String p1Name = DHViewUtilsCommon.getSignalLabelText(p1);
            if (p1Name == null) {
                return -1;
            }
            if (p2 == null) {
                return 1;
            }
            String p2Name = DHViewUtilsCommon.getSignalLabelText(p2);
            if (p2Name == null) {
                return 1;
            }
            boolean promoteP1 = false;
            boolean promoteP2 = false;
            if (this.portToPromote != null) {
                promoteP1 = ViewsUtils.matchCamelCaseOrRegex(this.portToPromote, p1Name);
                promoteP2 = ViewsUtils.matchCamelCaseOrRegex(this.portToPromote, p2Name);
            }
            boolean firstIsPort = p1 instanceof IRfPortElement;
            boolean secondIsPort = p2 instanceof IRfPortElement;
            if (firstIsPort && secondIsPort || !firstIsPort && !secondIsPort) {
                if (promoteP1 && promoteP2 || !promoteP1 && !promoteP2) {
                    return this.alphabeticalSort ? p1Name.compareToIgnoreCase(p2Name) : 0;
                }
                if (promoteP1) {
                    return -1;
                }
                if (promoteP2) {
                    return 1;
                }
                return this.alphabeticalSort ? p1Name.compareToIgnoreCase(p2Name) : 0;
            }
            return firstIsPort ? -1 : 1;
        }
    }
}

