/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.designhierarchy;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.ui.views.designhierarchy.DHViewUtils;
import ro.amiq.dvt.utils.DVTDocumentCommon;
import ro.amiq.dvt.utils.Utils;

public class DVTCopyHierarchyPathAction
extends Action {
    IProject project;
    Tree tree;
    IRfPortElement portElement;

    public DVTCopyHierarchyPathAction(Tree tree, IProject project) {
        super("Copy Hierarchy Path");
        this.tree = tree;
        this.project = project;
    }

    public DVTCopyHierarchyPathAction(Tree tree, IProject project, IRfPortElement portElement) {
        super("Copy Hierarchy Path");
        this.tree = tree;
        this.project = project;
        this.portElement = portElement;
    }

    public void run() {
        if (this.tree == null || this.tree.isDisposed()) {
            return;
        }
        TreeItem[] sel = this.tree.getSelection();
        if (sel == null || sel.length == 0) {
            return;
        }
        StringBuilder result = new StringBuilder();
        String lineDelimiter = DVTDocumentCommon.getLineDelimiterByProject(this.project);
        String copyHierarchyPathSegmentSeparator = DVTCopyHierarchyPathAction.getCopyHierarchyPathSegmentSeparator();
        TreeItem[] treeItemArray = sel;
        int n = sel.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray[n2];
            String path = DHViewUtils.getPathForElement(treeItem.getData(), copyHierarchyPathSegmentSeparator);
            if (path != null && !path.isEmpty()) {
                if (this.portElement != null && !this.portElement.getName().isEmpty()) {
                    result.append(path).append(copyHierarchyPathSegmentSeparator).append(this.portElement.getName()).append(lineDelimiter);
                } else {
                    result.append(path).append(lineDelimiter);
                }
            }
            ++n2;
        }
        Utils.copyToClipboard(result.toString().trim(), 3);
    }

    public static String getCopyHierarchyPathSegmentSeparator() {
        return DVTPlugin.getDefault().getPreferenceStore().getString("copyHierarchyPathSegmentSeparator");
    }
}

