/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.designhierarchy;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;

public class InstancesToBindContainer {
    public Set<IRfInstanceElement> instancesToBind = new LinkedHashSet<IRfInstanceElement>();
    public Set<String> instancesToBindTargetScopeLastSegment = new HashSet<String>();
    public long timestamp;

    public InstancesToBindContainer(InstancesToBindContainer existingInstancesToBindContainer) {
        if (existingInstancesToBindContainer != null) {
            this.instancesToBind.addAll(existingInstancesToBindContainer.instancesToBind);
            this.instancesToBindTargetScopeLastSegment.addAll(existingInstancesToBindContainer.instancesToBindTargetScopeLastSegment);
        }
    }

    public static InstancesToBindContainer from(Collection<? extends IRfInstanceElement> newInstances) {
        return InstancesToBindContainer.from(null, newInstances);
    }

    public static InstancesToBindContainer from(InstancesToBindContainer existingInstancesToBindContainer, Collection<? extends IRfInstanceElement> newInstances) {
        InstancesToBindContainer newInstancesToBind = new InstancesToBindContainer(existingInstancesToBindContainer);
        if (newInstances == null || newInstances.isEmpty()) {
            return newInstancesToBind;
        }
        newInstancesToBind.instancesToBind.addAll(newInstances);
        for (IRfInstanceElement iRfInstanceElement : newInstances) {
            Collection<? extends String> targetInstanceLastSegmentNameSet = iRfInstanceElement.getTargetInstanceLastSegmentNameSet();
            if (targetInstanceLastSegmentNameSet == null || targetInstanceLastSegmentNameSet.isEmpty()) continue;
            newInstancesToBind.instancesToBindTargetScopeLastSegment.addAll(targetInstanceLastSegmentNameSet);
        }
        return newInstancesToBind;
    }
}

