/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.designhierarchy;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.ui.editor.dhbreadcrumb.DHBreadcrumbUtils;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.ui.views.designhierarchy.DHPortsLabelProvider;
import ro.amiq.dvt.ui.views.lazy.tree.LazyTree;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeAction;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeActionArguments;
import ro.amiq.dvt.ui.views.lazy.views.designhierarchy.DVTDHLabelProvider;

public class UPFPrefDialog
extends PopupDialog {
    private Object provider;
    private Composite contentsComposite;
    private Point location;
    private Button showPDName;
    private Button showColor;
    private Button colorText;
    private Button colorBackground;

    public UPFPrefDialog(Shell parent, Object provider, Point location) {
        super(parent, 0, true, false, false, false, false, null, null);
        this.location = location;
        this.provider = provider;
    }

    protected Control createContents(Composite parent) {
        this.contentsComposite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.contentsComposite);
        GridLayoutFactory.fillDefaults().margins(5, 5).spacing(5, 5).applyTo(this.contentsComposite);
        this.createMainArea(this.contentsComposite);
        this.addButtonsListenersAndSelections();
        Dialog.applyDialogFont((Control)this.contentsComposite);
        return this.contentsComposite;
    }

    private void createMainArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(composite);
        this.createCheckButtons(composite);
    }

    private void createCheckButtons(Composite paren) {
        Composite composite = new Composite(paren, 0);
        GridDataFactory.fillDefaults().align(1, 1).grab(false, false).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().applyTo(composite);
        this.showPDName = new Button(composite, 32);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.showPDName);
        this.showPDName.setText("Show PD Name");
        this.showColor = new Button(composite, 32);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.showColor);
        this.showColor.setText("Show PD Color");
        Composite comp = new Composite(composite, 0);
        GridDataFactory.fillDefaults().align(1, 1).grab(false, false).applyTo((Control)comp);
        GridLayoutFactory.fillDefaults().applyTo(comp);
        this.colorText = new Button(comp, 16);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.colorText);
        this.colorText.setText("Text");
        this.colorBackground = new Button(comp, 16);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.colorBackground);
        this.colorBackground.setText("Background");
    }

    private void addButtonsListenersAndSelections() {
        this.showPDName.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PrefConst.setDHViewShowUPF(UPFPrefDialog.this.showPDName.getSelection());
                UPFPrefDialog.this.updateLabel();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.showPDName.setSelection(PrefConst.getDHViewShowUPF());
        this.showColor.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                UPFPrefDialog.this.colorText.setEnabled(UPFPrefDialog.this.showColor.getSelection());
                UPFPrefDialog.this.colorBackground.setEnabled(UPFPrefDialog.this.showColor.getSelection());
                PrefConst.setDHViewShowPDColor(UPFPrefDialog.this.showColor.getSelection());
                UPFPrefDialog.this.updateLabel();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.showColor.setSelection(PrefConst.getDHViewShowPDColor());
        this.colorText.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PrefConst.setDHViewShowPDColorText(UPFPrefDialog.this.colorText.getSelection());
                PrefConst.setDHViewShowPDColorBackground(!UPFPrefDialog.this.colorText.getSelection());
                UPFPrefDialog.this.updateLabel();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.colorText.setEnabled(PrefConst.getDHViewShowPDColor());
        this.colorText.setSelection(PrefConst.getDHViewShowPDColorText());
        this.colorBackground.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PrefConst.setDHViewShowPDColorBackground(UPFPrefDialog.this.colorBackground.getSelection());
                PrefConst.setDHViewShowPDColorText(!UPFPrefDialog.this.colorBackground.getSelection());
                UPFPrefDialog.this.updateLabel();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.colorBackground.setEnabled(PrefConst.getDHViewShowPDColor());
        this.colorBackground.setSelection(PrefConst.getDHViewShowPDColorBackground());
    }

    protected Point getInitialLocation(Point initialSize) {
        return this.location;
    }

    protected Control getFocusControl() {
        return this.contentsComposite;
    }

    private void updateLabel() {
        if (this.provider == null) {
            return;
        }
        if (this.provider instanceof LazyTree) {
            ILabelProvider labelProvider = ((LazyTree)this.provider).getLabelProvider();
            if (labelProvider instanceof DVTDHLabelProvider) {
                ((DVTDHLabelProvider)labelProvider).setShowUPF(PrefConst.getDHViewShowUPF());
            }
            if (labelProvider instanceof DHPortsLabelProvider) {
                ((DHPortsLabelProvider)labelProvider).setShowUPF(PrefConst.getDHViewShowUPF());
            }
            ((LazyTree)this.provider).doAction(LazyTreeAction.UPDATE_LABELS, new LazyTreeActionArguments(Objection.DESIGN_HIERARCHY));
        }
        DHBreadcrumbUtils.updateBreadcrumbLabels();
    }
}

