/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.factory.overrides;

import java.util.List;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.interpreter.IXXVMComponent;
import ro.amiq.dvt.interpreter.IXXVMFactoryOverrideElement;
import ro.amiq.dvt.interpreter.IXXVMObject;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.interpreter.DVTXInterpreterViewsLabelProvider;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;

public class DVTXFactoryOverridesLabelProvider
extends DVTXInterpreterViewsLabelProvider {
    @Override
    public Image getColumnImage(Object element, int columnIndex) {
        if (element == null) {
            return DVTImages.imageCache.getImage(DVTImages.NONE);
        }
        boolean hasComponents = false;
        boolean hasObjects = false;
        if (element instanceof IDVTElementWrapper) {
            Object xvmObjectInfo = ((IDVTElementWrapper)element).getAdditionalInfo("object");
            if (xvmObjectInfo instanceof IXXVMObject && !(xvmObjectInfo instanceof IXXVMComponent)) {
                hasObjects = true;
            } else if (xvmObjectInfo instanceof IXXVMComponent) {
                hasComponents = true;
            }
            element = ((IDVTElementWrapper)element).getRfElement();
        }
        if (element instanceof String && (((String)element).equals("Direct") || ((String)element).equals("Chain") || ((String)element).equals("Unused"))) {
            return DVTImages.imageCache.getImage(DVTImages.NONE);
        }
        if (!(element instanceof IXXVMFactoryOverrideElement)) {
            DVTLogger.INSTANCE.logError("Illegal element, should be IXXVMFactoryOverride");
            return DVTImages.imageCache.getImage(DVTImages.NONE);
        }
        if (columnIndex == 0) {
            if ("Override Chain".equals(((IXXVMFactoryOverrideElement)element).getFullInstancePath(false))) {
                return DVTImages.imageCache.getImage(DVTImages.XVM_FACTORY_OVERRIDE_CHAIN);
            }
            return DVTImages.imageCache.getImage(DVTImages.XVM_FACTORY_OVERRIDE);
        }
        if (columnIndex == 1 || columnIndex == 2) {
            return DVTImages.imageCache.getImage(DVTImages.OUTLINE_CLASS);
        }
        if (columnIndex == 3) {
            if (hasComponents) {
                return DVTImages.imageCache.getImage(DVTImages.XVM_COMPONENT_INSTANCE);
            }
            if (hasObjects) {
                return DVTImages.imageCache.getImage(DVTImages.XVM_OBJECT_INSTANCE);
            }
            return DVTImages.imageCache.getImage(DVTImages.NONE);
        }
        if (columnIndex == 4) {
            if (!(element instanceof IXXVMFactoryOverrideElement)) {
                DVTLogger.INSTANCE.logError("Illegal element, should be IXXVMFactoryOverride");
                return DVTImages.imageCache.getImage(DVTImages.NONE);
            }
            if (!((IXXVMFactoryOverrideElement)element).isChain()) {
                return DVTImages.imageCache.getImage(DVTImages.NONE);
            }
            return DVTImages.imageCache.getImage(DVTImages.XVM_FACTORY_OVERRIDE_CHAIN);
        }
        return DVTImages.imageCache.getImage(DVTImages.NONE);
    }

    @Override
    public Image getImage(Object element) {
        if (element instanceof TreePath) {
            element = ((TreePath)element).getElement();
        }
        if (element instanceof IXXVMFactoryOverrideElement) {
            if (((IXXVMFactoryOverrideElement)element).isChain()) {
                return DVTImages.imageCache.getImage(DVTImages.XVM_FACTORY_OVERRIDE_CHAIN);
            }
            return DVTImages.imageCache.getImage(DVTImages.XVM_FACTORY_OVERRIDE);
        }
        if (element instanceof IXXVMComponent) {
            return DVTImages.imageCache.getImage(DVTImages.XVM_COMPONENT_INSTANCE);
        }
        return DVTImages.imageCache.getImage(DVTImages.NONE);
    }

    @Override
    public String getColumnText(Object obj, int columnIndex) {
        String dataContent = this.getLabelInfo(obj, columnIndex);
        return ViewsUtils.trimBeginningText(dataContent, (Integer)this.fColumnIndexesSizes.get(columnIndex) / 10);
    }

    @Override
    public String getLabelInfo(Object obj, int columnIndex) {
        IXXVMObject xvmObject = null;
        if (obj instanceof TreePath) {
            obj = ((TreePath)obj).getElement();
        }
        if (obj instanceof IDVTElementWrapper) {
            xvmObject = (IXXVMObject)((IDVTElementWrapper)obj).getAdditionalInfo("object");
            obj = ((IDVTElementWrapper)obj).getRfElement();
        }
        if (obj instanceof String) {
            if (columnIndex == 0) {
                return (String)obj;
            }
            return "";
        }
        if (!(obj instanceof IXXVMFactoryOverrideElement)) {
            return "";
        }
        IXXVMFactoryOverrideElement factoryOverride = (IXXVMFactoryOverrideElement)obj;
        String dataContent = "";
        switch (columnIndex) {
            case 0: {
                dataContent = factoryOverride.getFullInstancePath(true);
                break;
            }
            case 1: {
                dataContent = factoryOverride.getOriginalTypeName();
                break;
            }
            case 2: {
                dataContent = factoryOverride.getOverrideTypeName();
                break;
            }
            case 3: {
                dataContent = xvmObject == null ? "" : xvmObject.getSanitizedFullName();
                break;
            }
            case 4: {
                if (!factoryOverride.isChain()) break;
                StringBuilder sb = new StringBuilder();
                List<IXXVMFactoryOverrideElement> overridesInCompositionRecursively = factoryOverride.getOverridesInChain();
                sb.append(overridesInCompositionRecursively.get(0).getOriginalTypeName());
                int i = 0;
                while (i < overridesInCompositionRecursively.size()) {
                    sb.append(" > ").append(overridesInCompositionRecursively.get(i).getOverrideTypeName());
                    ++i;
                }
                dataContent = sb.toString();
                break;
            }
        }
        return dataContent;
    }

    @Override
    public String getColumnTextWithoutTrimming(Object parentNode, int columnIndex) {
        return this.getLabelInfo(parentNode, columnIndex);
    }
}

