/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.factory.overrides;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import ro.amiq.dvt.model.reflection.GoToInfo;
import ro.amiq.dvt.ui.views.factory.overrides.FactoryOverridesViewUtils;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.utils.Utils;

public class FactoryOverridesActions {

    public static class FactoryOverridesCopyHierarchyPath
    extends Action {
        private final Tree tree;

        public FactoryOverridesCopyHierarchyPath(Tree tree) {
            super("Copy Hierarchy Path");
            this.tree = tree;
            this.setToolTipText("Copy Component Hierarchy Path to clipboard");
        }

        public void run() {
            if (this.tree == null || this.tree.isDisposed()) {
                return;
            }
            TreeItem[] sel = this.tree.getSelection();
            if (sel == null || sel.length == 0) {
                return;
            }
            Object data = sel[0].getData();
            if (!(data instanceof TreePath)) {
                return;
            }
            String hierarchyPath = FactoryOverridesViewUtils.getInstance().getHierarchyPath((TreePath)data);
            if (hierarchyPath == null) {
                return;
            }
            Utils.copyToClipboard(hierarchyPath, 3);
        }
    }

    public static class FactoryOverridesOpenCreateCallLocation
    extends Action {
        private final Tree tree;
        private final IProject project;

        public FactoryOverridesOpenCreateCallLocation(Tree tree, IProject project) {
            super("Open Instantiation");
            this.tree = tree;
            this.project = project;
            this.setToolTipText("Open uvm component declaration");
        }

        public void run() {
            if (this.tree == null || this.tree.isDisposed()) {
                return;
            }
            TreeItem[] sel = this.tree.getSelection();
            if (sel == null || sel.length == 0) {
                return;
            }
            Object data = sel[0].getData();
            if (!(data instanceof TreePath)) {
                return;
            }
            FactoryOverridesViewUtils.getInstance().openCreateCall((TreePath)data, this.project);
        }
    }

    public static class FactoryOverridesOpenDeclarationType
    extends Action {
        private final IProject project;
        private final Tree tree;
        private final boolean isOriginalActionRequest;

        public FactoryOverridesOpenDeclarationType(Tree tree, IProject project, boolean isOriginalTypeAction) {
            super(isOriginalTypeAction ? "Open Original Type Declaration" : "Open Override Type Declaration");
            this.tree = tree;
            this.project = project;
            this.isOriginalActionRequest = isOriginalTypeAction;
            this.setToolTipText("Jump in the editor to the type declaration");
        }

        public void run() {
            if (this.tree == null || this.tree.isDisposed()) {
                return;
            }
            TreeItem[] sel = this.tree.getSelection();
            if (sel == null || sel.length == 0) {
                return;
            }
            Object data = sel[0].getData();
            if (!(data instanceof TreePath)) {
                return;
            }
            GoToInfo requestedTypeSourceOf = FactoryOverridesViewUtils.getInstance().getGoToDeclarationLocation((TreePath)data, this.isOriginalActionRequest);
            if (requestedTypeSourceOf != null) {
                requestedTypeSourceOf.open(this.project, true);
            }
        }
    }

    public static class FactoryOverridesOpenOverrideCallLocation
    extends Action {
        private final Tree tree;
        private final IProject project;

        public FactoryOverridesOpenOverrideCallLocation(Tree tree, IProject project) {
            super("Open Override Call");
            this.tree = tree;
            this.project = project;
            this.setToolTipText("Jump in the editor to the override call");
        }

        public void run() {
            if (this.tree == null || this.tree.isDisposed()) {
                return;
            }
            TreeItem[] sel = this.tree.getSelection();
            if (sel == null || sel.length == 0) {
                return;
            }
            Object data = sel[0].getData();
            if (!(data instanceof TreePath)) {
                return;
            }
            GoToInfo goToInfo = FactoryOverridesViewUtils.getInstance().getOverrideCallLocation((TreePath)data);
            if (goToInfo == null) {
                return;
            }
            goToInfo.open(this.project, true);
        }
    }
}

