/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.factory.overrides;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IActionBars;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.interpreter.IXXVMFactoryOverrideElement;
import ro.amiq.dvt.interpreter.IXXVMObject;
import ro.amiq.dvt.interpreter.XViewsUtils;
import ro.amiq.dvt.model.reflection.GoToInfo;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.actions.history.HistoryItem;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.ui.projectcolors.ProjectColorUtils;
import ro.amiq.dvt.ui.views.BuildEvents;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.InspectViewUpdateEvent;
import ro.amiq.dvt.ui.views.TextFilterObject;
import ro.amiq.dvt.ui.views.ViewDataContainer;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.factory.overrides.FactoryOverridesActions;
import ro.amiq.dvt.ui.views.factory.overrides.FactoryOverridesViewCommon;
import ro.amiq.dvt.ui.views.factory.overrides.FactoryOverridesViewModel;
import ro.amiq.dvt.ui.views.factory.overrides.FactoryOverridesViewUtils;
import ro.amiq.dvt.ui.views.factory.overrides.IXFactoryOverridesContributor;
import ro.amiq.dvt.ui.views.factory.overrides.LazyFactoryOverridesTestUtils;
import ro.amiq.dvt.ui.views.inspect.InspectViewComponent;
import ro.amiq.dvt.ui.views.inspect.InspectViewSelectionListener;
import ro.amiq.dvt.ui.views.interpreter.IInterpreterViewsCommon;
import ro.amiq.dvt.ui.views.lazy.tree.AbstractTreeIterator;
import ro.amiq.dvt.ui.views.lazy.tree.IDVTLazyTable;
import ro.amiq.dvt.ui.views.lazy.tree.IDVTModel;
import ro.amiq.dvt.ui.views.lazy.tree.LazyTree;
import ro.amiq.dvt.ui.views.lazy.tree.LazyTreeIteratorType;
import ro.amiq.dvt.ui.views.lazy.tree.LazyTreeMessageCompositeType;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeAction;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeActionArguments;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeRevealInViewActionArguments;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeSearchActionArguments;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeUpdateViewActionArguments;
import ro.amiq.dvt.ui.views.lazy.views.CollapseAllAction;
import ro.amiq.dvt.ui.views.lazy.views.DVTLazyViewUtils;
import ro.amiq.dvt.ui.views.lazy.views.ExpandAllAction;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.dvt.utils.Utils;

public class FactoryOverridesView
extends FactoryOverridesViewCommon
implements IDVTLazyTable {
    private static final String APPLICABLE_TO = "Applicable To";
    private static final String ORIGINAL_TYPE = "Original Type";
    private static final String OVERRIDE_TYPE = "Override Type";
    private static final String OVERRIDE_PATH = "Override Path";
    private static final String OVERRIDE_CHAIN = "Override Chain";
    private Label labelInfo;
    private FactoryOverridesFilterAction filterAction;
    private Composite controlParent;
    private Composite childComposite;
    private static final int COLUMN_SIZE = 25;
    private static final String SEARCH_BY = "Search by:";
    private LazyFactoryOverridesTestUtils factoryOverridesTestUtils = new LazyFactoryOverridesTestUtils(this);
    private Composite sashChildTree;
    private InspectViewComponent fInspectViewComponent;
    private ToggleInspectPanelAction fToggleInspectPanelAction = new ToggleInspectPanelAction();
    private final Map<String, Integer> fColumnNamesIndexes = new HashMap<String, Integer>();
    private SashForm upperSashForm;

    public IXFactoryOverridesContributor getViewContributor() {
        return XViewsUtils.getXFactoryOverridesViewContributor();
    }

    @Override
    public int getViewColumnCount() {
        return this.fColumnNamesIndexes.size();
    }

    @Override
    public void update(BuildEvents updateEvent) {
        boolean resetTop;
        this.updateLabelInfo();
        if (IInterpreterViewsCommon.isInterpreterMode()) {
            this.factoryOverridesViewModel = null;
            this.clean();
            updateEvent = updateEvent == BuildEvents.PRE_INTERPRETER_MODE ? updateEvent : BuildEvents.INTERPRETER_MODE;
        }
        IProject project = this.getProject();
        if (updateEvent == null && (project == null || !project.isAccessible()) || updateEvent != BuildEvents.INTERPRETER_MODE && updateEvent != BuildEvents.INTERPRETER_FAILED && updateEvent != BuildEvents.PRE_INTERPRETER_MODE && updateEvent != BuildEvents.GUI_FILTERS_WORKSPACE && updateEvent != BuildEvents.INTERPRETER_ACTION_VIEW) {
            this.factoryOverridesViewModel = null;
            this.clean();
            return;
        }
        if (updateEvent == BuildEvents.GUI_FILTERS_WORKSPACE) {
            return;
        }
        if (!this.currentContributor.c(project)) {
            return;
        }
        LazyTree lazyTree = this.getLazyTree();
        if (lazyTree == null) {
            return;
        }
        if (this.factoryOverridesViewModel == null && updateEvent == BuildEvents.INTERPRETER_ACTION_VIEW) {
            return;
        }
        boolean resetSelection = updateEvent == null;
        boolean isInterpreterMode = updateEvent == BuildEvents.INTERPRETER_MODE;
        boolean resetModel = updateEvent == null || updateEvent == BuildEvents.FULL_BUILD;
        boolean interpreterFailed = updateEvent == BuildEvents.INTERPRETER_FAILED;
        boolean isPreInterpreterMode = updateEvent == BuildEvents.PRE_INTERPRETER_MODE;
        boolean isInterpreterFinishedEvent = updateEvent == BuildEvents.INTERPRETER_MODE || updateEvent == BuildEvents.INTERPRETER_FAILED;
        ProjectColorUtils.setFgBg(this, this.getProject().getName());
        boolean bl = resetTop = updateEvent == null || updateEvent != BuildEvents.INCREMENTAL_BUILD && updateEvent != BuildEvents.INTERPRETER_FAILED && updateEvent != BuildEvents.INTERPRETER_MODE;
        if (this.factoryOverridesViewModel == null || isInterpreterMode || isPreInterpreterMode || resetModel) {
            this.factoryOverridesViewModel = new FactoryOverridesViewModel(this.getProject(), this, this.labelProvider, isPreInterpreterMode);
        }
        if (interpreterFailed) {
            this.factoryOverridesViewModel.setHasInterpreterFailed(true);
        }
        lazyTree.doAction(LazyTreeAction.UPDATE_VIEW, new LazyTreeUpdateViewActionArguments(this, this.factoryOverridesViewModel, resetSelection, resetTop, resetModel, isInterpreterFinishedEvent ? Objection.FACTORY_OVERRIDES_INTERPRETED : Objection.FACTORY_OVERRIDES));
    }

    @Override
    public void clean() {
        IProject project = this.getProject();
        if (project == null || !project.isAccessible() || !Utils.hasDvtNature(project)) {
            this.labelInfo.setText(LazyTreeMessageCompositeType.NO_DVT_PROJECT_SELECTED.getMessage());
            ProjectColorUtils.setFgBg(this, null);
        } else {
            this.labelInfo.setText("[" + project.getName() + "]");
            ProjectColorUtils.setFgBg(this, project.getName());
        }
        if (this.getLazyTree() != null) {
            this.getLazyTree().doAction(LazyTreeAction.CLEAN, new LazyTreeActionArguments(Objection.FACTORY_OVERRIDES));
        }
        this.dataContainer = new ViewDataContainer(project, null);
        this.fInspectViewComponent.update(null);
        this.factoryOverridesViewModel = null;
    }

    @Override
    public Control getControlToColorBg() {
        if (this.labelInfo == null) {
            return null;
        }
        return this.labelInfo.getParent();
    }

    @Override
    public Control getControlToColorFg() {
        return this.labelInfo;
    }

    @Override
    public IProject getProject() {
        if (this.dataContainer == null) {
            return null;
        }
        return this.dataContainer.getProject();
    }

    @Override
    public void setCancelActionEnabled(boolean enabled) {
    }

    @Override
    public void createToolBar() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        if (actionBars == null) {
            return;
        }
        IToolBarManager toolBarManager = actionBars.getToolBarManager();
        toolBarManager.removeAll();
        if (toolBarManager.getItems().length > 0) {
            toolBarManager.add((IContributionItem)new Separator());
        }
        LazyTree lazyTree = this.getLazyTree();
        this.filterAction = new FactoryOverridesFilterAction();
        toolBarManager.add((IAction)this.filterAction);
        toolBarManager.add((IAction)this.fToggleInspectPanelAction);
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)new ExpandAllAction(lazyTree));
        toolBarManager.add((IAction)new CollapseAllAction(lazyTree));
        toolBarManager.update(true);
    }

    @Override
    public IDVTModel getModel(Class<? extends IDVTModel> modelClass) {
        return this.factoryOverridesViewModel;
    }

    @Override
    public ILabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    @Override
    public void selectionChanged() {
    }

    @Override
    public LazyTreeIteratorType getIteratorType() {
        return LazyTreeIteratorType.LAZY_FACTORY_OVERRIDES;
    }

    @Override
    public Objection getObjection() {
        return Objection.FACTORY_OVERRIDES;
    }

    @Override
    public LazyFactoryOverridesTestUtils getLazyTreeTestUtils() {
        return this.factoryOverridesTestUtils;
    }

    @Override
    public void addViewSpecificListeners(AbstractTreeIterator treeIterator) {
    }

    @Override
    public boolean supportsDecorations() {
        return false;
    }

    @Override
    public String getMessageText() {
        if (this.getProject() == null || !this.getProject().isAccessible() || !Utils.hasDvtNature(this.getProject())) {
            return "Select a DVT Project or file.";
        }
        if (!this.getTextFilter("default-filter").getText().isEmpty()) {
            if (this.factoryOverridesViewModel == null) {
                return LazyTreeMessageCompositeType.NO_DATA.getMessage();
            }
            return LazyTreeMessageCompositeType.NO_MATCHES_FOUND.getMessage();
        }
        if (this.factoryOverridesViewModel != null && this.factoryOverridesViewModel.hasInterpreterFailed()) {
            this.factoryOverridesViewModel = null;
            return LazyTreeMessageCompositeType.INTERPRETER_FAILED.getMessage();
        }
        if (this.factoryOverridesViewModel != null && this.factoryOverridesViewModel.hasFactoryOverridesFilteredElements()) {
            return LazyTreeMessageCompositeType.FACTORY_OVERRIDES_FILTERED.getMessage();
        }
        if (this.factoryOverridesViewModel != null && this.factoryOverridesViewModel.isEmpty()) {
            return LazyTreeMessageCompositeType.NO_DATA.getMessage();
        }
        return "Select a runtime elaborated Verification Top from the UVM entry in the main menu.";
    }

    protected void updateActionState() {
        if (!(PrefConst.getFactoryOverridesViewVlogHideChainOverrides() || PrefConst.getFactoryOverridesViewVlogHideDirectOverrides() || PrefConst.getFactoryOverridesViewVlogHideUnusedOverrides())) {
            this.filterAction.setChecked(false);
        } else {
            this.filterAction.setChecked(true);
        }
    }

    @Override
    public void gotoSelectedElement(String treeId) {
        TreePath selection = this.getLazyTree().getSelection();
        if (selection == null) {
            return;
        }
        IProject project = this.getProject();
        if (project == null) {
            return;
        }
        this.getViewContributor().computeElabVHBreadcrumbData(this.getProject(), selection);
        FactoryOverridesViewUtils.getInstance().openCreateCall(selection, project);
    }

    @Override
    public String prepareText(String textFilterId, String text) {
        return text;
    }

    @Override
    public HistoryItem getHistoryItem() {
        IProject project;
        HistoryItem xvhHistoryItem;
        if (IInterpreterViewsCommon.isInterpreterMode() && (xvhHistoryItem = this.getXVHHistoryItem(project = DVTPlugin.getSelectionManager().getLastSelectedProject())) != null) {
            return xvhHistoryItem;
        }
        if (this.dataContainer == null) {
            return null;
        }
        return this.dataContainer.getHistoryItem();
    }

    @Override
    public void stringMatcherUpdated(String uIJobTextFilterId) {
        this.updateLabelInfo();
        this.getLazyTree().doAction(LazyTreeAction.SEARCH, new LazyTreeSearchActionArguments(true, true, this.factoryOverridesViewModel, Objection.REGISTERS));
    }

    private void updateLabelInfo() {
        Display.getDefault().asyncExec(() -> {
            if (this.labelInfo == null || this.labelInfo.isDisposed()) {
                return;
            }
            this.labelInfo.setText(this.getLabelInfoText());
            ObjectionManager.getInstance().clear(Objection.FACTORY_OVERRIDES_LABEL);
        });
    }

    @Override
    public ILabelProvider getTreeLabelProvider() {
        return this.labelProvider;
    }

    @Override
    public StringMatcher[] getTreeSearchSegments() {
        TextFilterObject textFilterObject = this.getTextFilterObject("default-filter");
        if (textFilterObject == null) {
            return null;
        }
        return textFilterObject.getSearchSegments();
    }

    @Override
    public boolean[] getTreeSearchStrictness() {
        TextFilterObject textFilterObject = this.getTextFilterObject("default-filter");
        if (textFilterObject == null) {
            return null;
        }
        return textFilterObject.getSearchTextStrictness();
    }

    @Override
    public String getTreeSearchPort() {
        return null;
    }

    @Override
    public List<String> getMemberNames(IDVTElementWrapper node) {
        return null;
    }

    @Override
    public boolean isFiltered() {
        TextFilterObject textFilterObject = this.getTextFilterObject("default-filter");
        if (textFilterObject == null) {
            return false;
        }
        return textFilterObject.isFiltered();
    }

    @Override
    protected void createViewSpecificPartControl(Composite parent) {
        this.controlParent = parent;
        LazyTree lazyTree = new LazyTree(this);
        this.setLazyTree(lazyTree);
        this.childComposite = new Composite(parent, 0);
        this.childComposite.setLayoutData((Object)new GridData(1808));
        this.childComposite.setLayout((Layout)DVTLazyViewUtils.LAYOUT);
        SashForm mainSashForm = new SashForm(this.childComposite, 512);
        mainSashForm.setLayout((Layout)DVTLazyViewUtils.LAYOUT);
        mainSashForm.setFont(this.childComposite.getFont());
        mainSashForm.setLayoutData((Object)new GridData(1808));
        Composite fUpperSashFormComposite = new Composite((Composite)mainSashForm, 0);
        fUpperSashFormComposite.setLayout((Layout)DVTLazyViewUtils.LAYOUT);
        fUpperSashFormComposite.setLayoutData((Object)new GridData(1808));
        Composite labelComposite = new Composite(fUpperSashFormComposite, 0);
        GridLayout labelLayout = new GridLayout(1, false);
        labelComposite.setLayout((Layout)labelLayout);
        labelComposite.setLayoutData((Object)new GridData(4, 1, false, false));
        this.labelInfo = new Label(labelComposite, 16384);
        this.labelInfo.setFont(labelComposite.getFont());
        this.labelInfo.setLayoutData((Object)new GridData(768));
        this.updateLabelInfo();
        this.upperSashForm = new SashForm(fUpperSashFormComposite, 256);
        this.upperSashForm.setLayout((Layout)DVTLazyViewUtils.TWO_PART_LAYOUT);
        this.upperSashForm.setLayoutData((Object)new GridData(1808));
        this.sashChildTree = new Composite((Composite)this.upperSashForm, 0);
        this.sashChildTree.setLayout((Layout)DVTLazyViewUtils.LAYOUT);
        this.sashChildTree.setLayoutData((Object)new GridData(1808));
        this.createTextFilter("default-filter", this.sashChildTree, "default-tree", false);
        TextFilterObject filter = this.getTextFilterObject("default-filter");
        filter.setTextFilterMessage(SEARCH_BY);
        lazyTree.setSearchBar(filter);
        lazyTree.setLabelProvider(this.getLabelProvider(), false);
        lazyTree.install(this.sashChildTree);
        Tree fTree = lazyTree.getTree();
        fTree.setHeaderVisible(false);
        this.fInspectViewComponent = new InspectViewComponent((Composite)this.upperSashForm);
        this.fInspectViewComponent.setVisible(PrefConst.getFactoryOverridesShowInspectPanel());
        this.addSelectionChangedListener(InspectViewSelectionListener.getInstance());
        fTree.addKeyListener((KeyListener)this.getKeyListener("default-filter", "default-tree"));
    }

    public Composite getControlParent() {
        return this.controlParent;
    }

    @Override
    protected void createCustomContextMenu(IMenuManager manager) {
        TreePath selection = this.getLazyTree().getSelection();
        if (selection == null) {
            return;
        }
        Object selectedElement = selection.getElement();
        if (selectedElement instanceof TreePath) {
            selectedElement = ((TreePath)selectedElement).getElement();
        }
        if (!(selectedElement instanceof IDVTElementWrapper)) {
            return;
        }
        Object rfElement = ((IDVTElementWrapper)selectedElement).getRfElement();
        if (!(rfElement instanceof IXXVMFactoryOverrideElement)) {
            return;
        }
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new FactoryOverridesActions.FactoryOverridesOpenOverrideCallLocation(this.getLazyTree().getTree(), this.getProject()));
        manager.add((IAction)new FactoryOverridesActions.FactoryOverridesOpenDeclarationType(this.getLazyTree().getTree(), this.getProject(), true));
        manager.add((IAction)new FactoryOverridesActions.FactoryOverridesOpenDeclarationType(this.getLazyTree().getTree(), this.getProject(), false));
        if (((IDVTElementWrapper)selectedElement).getAdditionalInfo("object") instanceof IXXVMObject) {
            manager.add((IAction)new FactoryOverridesActions.FactoryOverridesOpenCreateCallLocation(this.getLazyTree().getTree(), this.getProject()));
            manager.add((IAction)new FactoryOverridesActions.FactoryOverridesCopyHierarchyPath(this.getLazyTree().getTree()));
        }
    }

    public List<Object> getTreeElementsForRoot(Object root) {
        return this.factoryOverridesViewModel.getTreeElementsForRoot(root);
    }

    @Override
    public void createAndSyncTreeColumns(Table topTable, Tree tree, ScrolledComposite scrolledComposite) {
        int n = tree.getSize().x;
        if (n == 0) {
            n = 1000;
        }
        int columnIndex = 0;
        TableColumn fAppliedOnColumn = new TableColumn(topTable, 16384);
        fAppliedOnColumn.setText(APPLICABLE_TO);
        fAppliedOnColumn.setWidth(n * 25 / 100);
        TreeColumn treeAppliedOnColumn = new TreeColumn(tree, 16384);
        treeAppliedOnColumn.setWidth(fAppliedOnColumn.getWidth());
        this.fColumnNamesIndexes.put(APPLICABLE_TO, columnIndex++);
        this.labelProvider.updateColumnSize(this.fColumnNamesIndexes.get(APPLICABLE_TO), fAppliedOnColumn.getWidth());
        TableColumn fOriginalTypeColumn = new TableColumn(topTable, 16384);
        fOriginalTypeColumn.setText(ORIGINAL_TYPE);
        fOriginalTypeColumn.setWidth(n * 25 / 100);
        TreeColumn treeOriginalTypeColumn = new TreeColumn(tree, 16384);
        treeOriginalTypeColumn.setWidth(fOriginalTypeColumn.getWidth());
        this.fColumnNamesIndexes.put(ORIGINAL_TYPE, columnIndex++);
        this.labelProvider.updateColumnSize(this.fColumnNamesIndexes.get(ORIGINAL_TYPE), fOriginalTypeColumn.getWidth());
        TableColumn fOverrideTypeColumn = new TableColumn(topTable, 16384);
        fOverrideTypeColumn.setText(OVERRIDE_TYPE);
        fOverrideTypeColumn.setWidth(n * 25 / 100);
        TreeColumn treeOverrideTypeColumn = new TreeColumn(tree, 16384);
        treeOverrideTypeColumn.setWidth(fOverrideTypeColumn.getWidth());
        this.fColumnNamesIndexes.put(OVERRIDE_TYPE, columnIndex++);
        this.labelProvider.updateColumnSize(this.fColumnNamesIndexes.get(OVERRIDE_TYPE), fOverrideTypeColumn.getWidth());
        TableColumn fOverridePathColumn = new TableColumn(topTable, 16384);
        fOverridePathColumn.setText(OVERRIDE_PATH);
        fOverridePathColumn.setWidth(n * 25 / 100);
        TreeColumn treeOverridePathColumn = new TreeColumn(tree, 16384);
        treeOverridePathColumn.setWidth(fOverridePathColumn.getWidth());
        this.fColumnNamesIndexes.put(OVERRIDE_PATH, columnIndex++);
        this.labelProvider.updateColumnSize(this.fColumnNamesIndexes.get(OVERRIDE_PATH), fOverridePathColumn.getWidth());
        TableColumn fRecursiveChainColumn = new TableColumn(topTable, 16384);
        fRecursiveChainColumn.setText(OVERRIDE_CHAIN);
        fRecursiveChainColumn.setWidth(n * 25 / 100);
        TreeColumn treeRecursiveChainOnColumn = new TreeColumn(tree, 16384);
        treeRecursiveChainOnColumn.setWidth(fRecursiveChainColumn.getWidth());
        this.fColumnNamesIndexes.put(OVERRIDE_CHAIN, columnIndex++);
        this.labelProvider.updateColumnSize(this.fColumnNamesIndexes.get(OVERRIDE_CHAIN), fRecursiveChainColumn.getWidth());
        fAppliedOnColumn.addListener(11, event -> {
            int n1 = fOverridePathColumn.getWidth() + fOriginalTypeColumn.getWidth() + fOverrideTypeColumn.getWidth() + fAppliedOnColumn.getWidth() + fRecursiveChainColumn.getWidth();
            scrolledComposite.setMinWidth(n1);
            treeAppliedOnColumn.setWidth(fAppliedOnColumn.getWidth());
            this.labelProvider.updateColumnSize(this.fColumnNamesIndexes.get(APPLICABLE_TO), fAppliedOnColumn.getWidth());
        });
        fOriginalTypeColumn.addListener(11, event -> {
            int n1 = fOverridePathColumn.getWidth() + fOriginalTypeColumn.getWidth() + fOverrideTypeColumn.getWidth() + fAppliedOnColumn.getWidth() + fRecursiveChainColumn.getWidth();
            scrolledComposite.setMinWidth(n1);
            treeOriginalTypeColumn.setWidth(fOriginalTypeColumn.getWidth());
            this.labelProvider.updateColumnSize(this.fColumnNamesIndexes.get(ORIGINAL_TYPE), fOriginalTypeColumn.getWidth());
        });
        fOverrideTypeColumn.addListener(11, event -> {
            int n1 = fOverridePathColumn.getWidth() + fOriginalTypeColumn.getWidth() + fOverrideTypeColumn.getWidth() + fAppliedOnColumn.getWidth() + fRecursiveChainColumn.getWidth();
            scrolledComposite.setMinWidth(n1);
            treeOverrideTypeColumn.setWidth(fOverrideTypeColumn.getWidth());
            this.labelProvider.updateColumnSize(this.fColumnNamesIndexes.get(OVERRIDE_TYPE), fOverrideTypeColumn.getWidth());
        });
        fOverridePathColumn.addListener(11, event -> {
            int n1 = fOverridePathColumn.getWidth() + fOriginalTypeColumn.getWidth() + fOverrideTypeColumn.getWidth() + fAppliedOnColumn.getWidth() + fRecursiveChainColumn.getWidth();
            scrolledComposite.setMinWidth(n1);
            treeOverridePathColumn.setWidth(fOverridePathColumn.getWidth());
            this.labelProvider.updateColumnSize(this.fColumnNamesIndexes.get(OVERRIDE_PATH), fOverridePathColumn.getWidth());
        });
        fRecursiveChainColumn.addListener(11, event -> {
            int n1 = fOverridePathColumn.getWidth() + fOriginalTypeColumn.getWidth() + fOverrideTypeColumn.getWidth() + fAppliedOnColumn.getWidth() + fRecursiveChainColumn.getWidth();
            scrolledComposite.setMinWidth(n1);
            treeRecursiveChainOnColumn.setWidth(fRecursiveChainColumn.getWidth());
            this.labelProvider.updateColumnSize(this.fColumnNamesIndexes.get(OVERRIDE_CHAIN), fRecursiveChainColumn.getWidth());
        });
    }

    @Override
    public void fireSelectionChanged(SelectionChangedEvent event) {
        super.fireSelectionChanged(event);
        if (this.fInspectViewComponent == null) {
            return;
        }
        ISelection selection = event.getSelection();
        if (!(selection instanceof StructuredSelection) || selection.isEmpty()) {
            return;
        }
        Object wrapper = ((StructuredSelection)selection).getFirstElement();
        if (!(wrapper instanceof IDVTElementWrapper)) {
            return;
        }
        Object rfElement = ((IDVTElementWrapper)wrapper).getRfElement();
        if (!(rfElement instanceof IXXVMFactoryOverrideElement)) {
            return;
        }
        ((IDVTElementWrapper)wrapper).setProject(this.getProject());
        this.fInspectViewComponent.update(new InspectViewUpdateEvent((IDVTElementWrapper)wrapper, event));
    }

    @Override
    public void revealInView(GoToInfo goToInfo, IRfNamedElement rfField) {
        TreePath createTreePath = this.getViewContributor().createTreePath(goToInfo, this, rfField);
        if (createTreePath == null) {
            ViewsUtils.popOKDialog(2, "Factory Overrides", "The selected factory override call was not found in Factory Overrides View!");
            return;
        }
        this.factoryOverridesViewModel = new FactoryOverridesViewModel(this.getProject(), this, this.labelProvider, false);
        this.getLazyTree().doAction(LazyTreeAction.REVEAL_IN_VIEW, new LazyTreeRevealInViewActionArguments(createTreePath, false, Objection.FACTORY_OVERRIDES));
    }

    class FactoryOverridesFilterAction
    extends Action {
        public FactoryOverridesFilterAction() {
            super("Filters...", 2);
            this.setDescription("Filters...");
            this.setToolTipText("Filters...");
            this.setImageDescriptor(DVTImages.FILTER);
        }

        public void run() {
            new FactoryOverridesViewMenuCreator().getMenu((Control)FactoryOverridesView.this.getViewSite().getShell()).setVisible(true);
            FactoryOverridesView.this.updateActionState();
        }
    }

    class FactoryOverridesViewMenuCreator
    implements IMenuCreator {
        Menu fMenu;

        FactoryOverridesViewMenuCreator() {
        }

        public Menu getMenu(Menu parent) {
            return null;
        }

        public void dispose() {
        }

        public Menu getMenu(Control parent) {
            this.fMenu = new Menu(parent);
            this.fMenu.setVisible(true);
            if (!ViewsUtils.projectContainsVlogNature(FactoryOverridesView.this.getProject())) {
                return this.fMenu;
            }
            MenuItem filterUnused = new MenuItem(this.fMenu, 32);
            filterUnused.setText("Hide unused UVM Factory Overrides");
            filterUnused.setSelection(PrefConst.getFactoryOverridesViewVlogHideUnusedOverrides());
            filterUnused.setEnabled(true);
            filterUnused.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (!(e.widget instanceof MenuItem)) {
                        return;
                    }
                    PrefConst.setFactoryOverridesViewVlogHideUnusedOverrides(((MenuItem)e.widget).getSelection());
                    FactoryOverridesView.this.updateActionState();
                    FactoryOverridesView.this.update(BuildEvents.INTERPRETER_ACTION_VIEW);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            MenuItem filterChain = new MenuItem(this.fMenu, 32);
            filterChain.setText("Hide chain UVM Factory Overrides");
            filterChain.setSelection(PrefConst.getFactoryOverridesViewVlogHideChainOverrides());
            filterChain.setEnabled(true);
            filterChain.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (!(e.widget instanceof MenuItem)) {
                        return;
                    }
                    PrefConst.setFactoryOverridesViewVlogHideChainOverrides(((MenuItem)e.widget).getSelection());
                    FactoryOverridesView.this.updateActionState();
                    FactoryOverridesView.this.update(BuildEvents.INTERPRETER_ACTION_VIEW);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            MenuItem filterDirect = new MenuItem(this.fMenu, 32);
            filterDirect.setText("Hide direct UVM Factory Overrides");
            filterDirect.setSelection(PrefConst.getFactoryOverridesViewVlogHideDirectOverrides());
            filterDirect.setEnabled(true);
            filterDirect.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (!(e.widget instanceof MenuItem)) {
                        return;
                    }
                    PrefConst.setFactoryOverridesViewVlogHideDirectOverrides(((MenuItem)e.widget).getSelection());
                    FactoryOverridesView.this.updateActionState();
                    FactoryOverridesView.this.update(BuildEvents.INTERPRETER_ACTION_VIEW);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            return this.fMenu;
        }
    }

    class ToggleInspectPanelAction
    extends Action {
        private static final String TOGGLE_INSPECT_PANEL = "Toggle Inspect Panel";

        public ToggleInspectPanelAction() {
            super(TOGGLE_INSPECT_PANEL, 2);
            this.setDescription(TOGGLE_INSPECT_PANEL);
            this.setToolTipText(TOGGLE_INSPECT_PANEL);
            this.setImageDescriptor(DVTImages.INSPECT_LAYOUT);
            this.setChecked(PrefConst.getFactoryOverridesShowInspectPanel());
        }

        public void run() {
            PrefConst.setFactoryOverridesViewShowInspectPanel(this.isChecked());
            FactoryOverridesView.this.fInspectViewComponent.setVisible(PrefConst.getFactoryOverridesShowInspectPanel());
            FactoryOverridesView.this.upperSashForm.layout();
        }
    }
}

