/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.factory.overrides;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.interpreter.IXContributor;
import ro.amiq.dvt.interpreter.XViewsUtils;
import ro.amiq.dvt.ui.actions.history.HistoryItem;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.ui.views.ViewDataContainer;
import ro.amiq.dvt.ui.views.ViewKind;
import ro.amiq.dvt.ui.views.factory.overrides.DVTXFactoryOverridesLabelProvider;
import ro.amiq.dvt.ui.views.factory.overrides.FactoryOverridesViewFilters;
import ro.amiq.dvt.ui.views.factory.overrides.IFactoryOverridesModel;
import ro.amiq.dvt.ui.views.factory.overrides.IXFactoryOverridesContributor;
import ro.amiq.dvt.ui.views.interpreter.IInterpreterViews;
import ro.amiq.dvt.ui.views.lazy.views.DVTLazyView;
import ro.amiq.dvt.utils.StringMatcher;

public abstract class FactoryOverridesViewCommon
extends DVTLazyView
implements IInterpreterViews {
    public static final String ID = "ro.amiq.dvt.ui.views.FactoryOverridesView";
    public static final EnumSet<ViewKind> VIEW_KIND = EnumSet.of(ViewKind.PROJECT_INFORMATION, ViewKind.CAN_HANDLE_ALL_BUILD_EVENTS, ViewKind.CAN_HANDLE_GUI_FILTERS);
    protected IXContributor currentContributor = XViewsUtils.getXFactoryOverridesViewContributor();
    protected ViewDataContainer dataContainer;
    protected boolean dirty;
    protected IFactoryOverridesModel factoryOverridesViewModel;
    protected DVTXFactoryOverridesLabelProvider labelProvider = new DVTXFactoryOverridesLabelProvider();

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public EnumSet<ViewKind> getKind() {
        return VIEW_KIND;
    }

    public IXContributor getCurrentContributor() {
        return this.currentContributor;
    }

    public List<FactoryOverridesViewFilters> getHideFilters() {
        ArrayList<FactoryOverridesViewFilters> filters = new ArrayList<FactoryOverridesViewFilters>();
        if (PrefConst.getFactoryOverridesViewVlogHideChainOverrides()) {
            filters.add(FactoryOverridesViewFilters.CHAIN);
        }
        if (PrefConst.getFactoryOverridesViewVlogHideDirectOverrides()) {
            filters.add(FactoryOverridesViewFilters.DIRECT);
        }
        if (PrefConst.getFactoryOverridesViewVlogHideUnusedOverrides()) {
            filters.add(FactoryOverridesViewFilters.UNUSED);
        }
        return filters;
    }

    @Override
    public void setInput(ViewDataContainer dataContainer) {
        this.dataContainer = dataContainer;
    }

    @Override
    public ViewDataContainer getDataContainer() {
        return this.dataContainer;
    }

    @Override
    public void setDirty(boolean isDirty) {
        this.dirty = isDirty;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    public String getNumOfFactoryOverridesForLabel() {
        if (this.factoryOverridesViewModel == null) {
            return "";
        }
        long numOfOverrides = ((IXFactoryOverridesContributor)this.currentContributor).getTotalFactoryOverrides();
        return "[" + numOfOverrides + (numOfOverrides == 1L ? " factory override]" : " factory overrides]");
    }

    public String getLabelInfoText() {
        IProject project = this.getProject();
        if (project == null || !project.isAccessible()) {
            return "[no DVT Project or file selected]";
        }
        boolean isSearchMode = false;
        StringMatcher[] searchSegments = this.getTreeSearchSegments();
        if (searchSegments != null && searchSegments.length != 0) {
            isSearchMode = true;
        }
        if (this.getHistoryItem() == null || !(this.currentContributor instanceof IXFactoryOverridesContributor)) {
            return "[" + project.getName() + "]";
        }
        String labelText = ((IXFactoryOverridesContributor)this.currentContributor).getTreeLabelText(this.getHistoryItem());
        if (labelText == null || labelText.isEmpty()) {
            labelText = "[" + project.getName() + "]";
        }
        if (!isSearchMode) {
            labelText = String.valueOf(labelText) + " " + this.getNumOfFactoryOverridesForLabel();
        }
        return labelText;
    }

    protected abstract HistoryItem getHistoryItem();
}

