/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.factory.overrides;

import java.util.List;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.interpreter.IXXVMFactoryOverrideElement;
import ro.amiq.dvt.interpreter.IXXVMObject;
import ro.amiq.dvt.model.reflection.GoToInfo;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;

public class FactoryOverridesViewUtils {
    private static FactoryOverridesViewUtils INSTANCE;
    private static final Object SYNC_OBJECT;

    static {
        SYNC_OBJECT = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FactoryOverridesViewUtils getInstance() {
        if (INSTANCE == null) {
            Object object = SYNC_OBJECT;
            synchronized (object) {
                INSTANCE = new FactoryOverridesViewUtils();
            }
        }
        return INSTANCE;
    }

    public void openCreateCall(TreePath treePath, IProject project) {
        GoToInfo goToInfo = this.getCreateCallLocation(treePath);
        if (goToInfo == null) {
            return;
        }
        goToInfo.open(project, true);
    }

    public GoToInfo getCreateCallLocation(TreePath treePath) {
        Object component = treePath.getElement();
        if (!(component instanceof IDVTElementWrapper)) {
            return null;
        }
        if (!((component = ((IDVTElementWrapper)component).getAdditionalInfo("object")) instanceof IXXVMObject)) {
            return null;
        }
        GoToInfo goToInfo = ((IXXVMObject)component).getCreateCallGoToInfo();
        if (goToInfo == null) {
            return null;
        }
        return goToInfo;
    }

    public GoToInfo getOverrideCallLocation(TreePath data) {
        Object component = data.getElement();
        if (!(component instanceof IDVTElementWrapper)) {
            return null;
        }
        Object element = ((IDVTElementWrapper)component).getRfElement();
        if (!(element instanceof IXXVMFactoryOverrideElement)) {
            return null;
        }
        IXXVMFactoryOverrideElement factoryOverrideElement = (IXXVMFactoryOverrideElement)element;
        List<IXXVMFactoryOverrideElement> overrides = factoryOverrideElement.getOverridesInChain();
        GoToInfo goToInfo = null;
        goToInfo = overrides.isEmpty() ? factoryOverrideElement.getGoToInfo() : overrides.get(overrides.size() - 1).getGoToInfo();
        return goToInfo;
    }

    public GoToInfo getGoToDeclarationLocation(TreePath data, boolean isOriginalActionRequest) {
        Object overrideElement = data.getElement();
        if (!(overrideElement instanceof IDVTElementWrapper)) {
            return null;
        }
        if (!((overrideElement = ((IDVTElementWrapper)overrideElement).getRfElement()) instanceof IXXVMFactoryOverrideElement)) {
            return null;
        }
        IRfNamedElement requestedType = isOriginalActionRequest ? ((IXXVMFactoryOverrideElement)overrideElement).getOriginalType() : ((IXXVMFactoryOverrideElement)overrideElement).getOverrideType();
        if (requestedType == null) {
            return null;
        }
        return GoToInfo.sourceOf(requestedType);
    }

    public String getHierarchyPath(TreePath data) {
        Object xvmObject = data.getElement();
        if (!(xvmObject instanceof IDVTElementWrapper)) {
            return null;
        }
        if (!((xvmObject = ((IDVTElementWrapper)xvmObject).getAdditionalInfo("object")) instanceof IXXVMObject)) {
            return null;
        }
        String sanitizedFullName = ((IXXVMObject)xvmObject).getSanitizedFullName();
        if (sanitizedFullName == null) {
            DVTLogger.INSTANCE.logError("unable to copy to clipboard sanitized full name");
            return null;
        }
        return sanitizedFullName.replace('.', '/');
    }
}

