/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.inspect;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.internal.resources.MarkerInfo;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.ui.IEditorPart;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.diagrams.action.draw.obj.IDActionDiagramObject;
import ro.amiq.dvt.diagrams.fsm.editor.actions.menu.DFSMActionMessages;
import ro.amiq.dvt.diagrams.fsm.model.FSMCondition;
import ro.amiq.dvt.diagrams.fsm.model.FSMTransition;
import ro.amiq.dvt.draw.obj.interaction.DSelectable;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.fsm.model.IFSMCondition;
import ro.amiq.dvt.fsm.model.IFSMInput;
import ro.amiq.dvt.fsm.model.IFSMState;
import ro.amiq.dvt.interpreter.IXContributor;
import ro.amiq.dvt.logic.form.model.LFFormula;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.GoToInfo;
import ro.amiq.dvt.model.reflection.GoToInfoWithBreadcrumbElement;
import ro.amiq.dvt.model.reflection.IRfBreadcrumbElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.power.format.DVTPFInfo;
import ro.amiq.dvt.power.format.DVTPFIsolationStrategyInfo;
import ro.amiq.dvt.power.format.DVTPFModel;
import ro.amiq.dvt.power.format.utils.DVTPFUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.DVTPosition;
import ro.amiq.dvt.ui.editor.breadcrumb.IDVTBreadcrumbHost;
import ro.amiq.dvt.ui.editor.formatter.detectindentation.DVTAutoIndentDetectionManager;
import ro.amiq.dvt.ui.editor.formatter.detectindentation.DVTAutoIndentDetector;
import ro.amiq.dvt.ui.views.InspectViewGoToInfo;
import ro.amiq.dvt.ui.views.InspectViewUpdateEvent;
import ro.amiq.dvt.ui.views.InspectViewUpdateEventCommon;
import ro.amiq.dvt.ui.views.inspect.DVTInspectViewUtilsCommon;
import ro.amiq.dvt.ui.views.inspect.IInspectViewInputContributor;
import ro.amiq.dvt.ui.views.inspect.InspectViewAutoDetectIndentationPosition;
import ro.amiq.dvt.ui.views.inspect.InspectViewInput;
import ro.amiq.dvt.ui.views.inspect.InspectViewPosition;
import ro.amiq.dvt.utils.DVTDocumentCommon;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTStringUtil;

public class DVTInspectViewUtils
extends DVTInspectViewUtilsCommon {
    private static DVTInspectViewUtils INSTANCE;
    private static final Object SYNC_OBJECT;
    private static final Pattern LINE_SPLIT_PATTERN;
    public static final long TRIGGER_JOB_DELAY = 300L;
    private final List<IInspectViewInputContributor> viewContributors = new LinkedList<IInspectViewInputContributor>();
    private final List<IXContributor> xViewContributors;
    private static final String PROJECT_NAME = "Project name:     ";
    private static final String NATURE = "Nature:           ";
    private static final String NATURES = "Natures:          ";
    public static final String INDENTATION = "Indentation:      ";
    private static final String AUTO_DETECT_INDENTATION_SPACES = " spaces ";
    private static final String AUTO_DETECT_INDENTATION_TABS = "-sized tabs ";
    public static final String AUTO_DETECT_INDENTATION_TRIGGER = "Auto-detect Indentation";
    private static final Comparator<FSMTransition> FSM_TRANSITIONS_DEFINITION_COMPARATOR;
    private static final Comparator<CTPair> FSM_CONDITIONS_DEFINITION_COMPARATOR;
    public static final int NO_CONTEXT_PAINTING_START_LINE = 1;

    static {
        SYNC_OBJECT = new Object();
        LINE_SPLIT_PATTERN = Pattern.compile("\\n");
        FSM_TRANSITIONS_DEFINITION_COMPARATOR = (o1, o2) -> {
            Iterator<GoToInfo> it1 = o1.getMarkers().iterator();
            Iterator<GoToInfo> it2 = o2.getMarkers().iterator();
            if (it1.hasNext() && it2.hasNext()) {
                return it1.next().offset - it2.next().offset;
            }
            return 0;
        };
        FSM_CONDITIONS_DEFINITION_COMPARATOR = (o1, o2) -> {
            Iterator it1 = o1.condition.hasGoToSource().iterator();
            Iterator it2 = o2.condition.hasGoToSource().iterator();
            if (it1.hasNext() && it2.hasNext()) {
                return ((GoToInfo)it1.next()).offset - ((GoToInfo)it2.next()).offset;
            }
            return 0;
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DVTInspectViewUtils getInstance() {
        if (INSTANCE == null) {
            Object object = SYNC_OBJECT;
            synchronized (object) {
                INSTANCE = new DVTInspectViewUtils();
            }
        }
        return INSTANCE;
    }

    private DVTInspectViewUtils() {
        IConfigurationElement[] elements;
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor("ro.amiq.dvt.inspectViewInputContributors");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            Object contributor = null;
            try {
                contributor = element.createExecutableExtension("class");
                if (contributor != null && contributor instanceof IInspectViewInputContributor) {
                    this.viewContributors.add((IInspectViewInputContributor)contributor);
                }
            }
            catch (CoreException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
            ++n2;
        }
        this.xViewContributors = new ArrayList<IXContributor>();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("ro.amiq.dvt.XContributor");
        IExtension[] iExtensionArray = extensionPoint.getExtensions();
        int n3 = iExtensionArray.length;
        n = 0;
        while (n < n3) {
            IExtension extension = iExtensionArray[n];
            IConfigurationElement[] iConfigurationElementArray2 = extension.getConfigurationElements();
            int n4 = iConfigurationElementArray2.length;
            int n5 = 0;
            while (n5 < n4) {
                IConfigurationElement configurationElement = iConfigurationElementArray2[n5];
                if (!"XContributor".equals(configurationElement.getName())) {
                    DVTLogger.INSTANCE.logError((Throwable)new Exception("Invalid element: " + configurationElement + " for extension point: " + "ro.amiq.dvt.XContributor"));
                }
                try {
                    Object executableExtension = configurationElement.createExecutableExtension("class");
                    this.xViewContributors.add((IXContributor)executableExtension);
                }
                catch (CoreException e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
                ++n5;
            }
            ++n;
        }
    }

    public InspectViewUpdateEvent createInspectViewMSDLEvent(Set<DSelectable> hits, IProject project) {
        if (hits == null || hits.isEmpty() || project == null) {
            return null;
        }
        HashSet<InspectViewGoToInfo> infos = new HashSet<InspectViewGoToInfo>(hits.size());
        StringBuilder inspectInfo = new StringBuilder();
        for (DSelectable hit : hits) {
            Collection<GoToInfo> goTos;
            if (!(hit instanceof IDActionDiagramObject) || (goTos = ((IDActionDiagramObject)((Object)hit)).hasGoToSource()) == null || goTos.isEmpty()) continue;
            String inspectInfoPart = ((IDActionDiagramObject)((Object)hit)).getInspectInfo();
            if (inspectInfoPart != null) {
                inspectInfo.append(inspectInfoPart);
            }
            for (GoToInfo gotoEl : goTos) {
                infos.add(new InspectViewGoToInfo(gotoEl));
            }
        }
        if (inspectInfo.length() > 0) {
            return new InspectViewUpdateEvent(inspectInfo.toString(), LanguageKind.MSDL, 1, null, project, InspectViewUpdateEventCommon.TYPE.DIAGRAM);
        }
        if (infos.isEmpty()) {
            return null;
        }
        ArrayList infosList = new ArrayList(infos);
        for (InspectViewGoToInfo info : infosList) {
            GoToInfo marker = info.getGotoInfo();
            if (marker == null || marker.languageKind == null) continue;
            return new InspectViewUpdateEvent(infos, project, marker.languageKind, InspectViewUpdateEventCommon.TYPE.DIAGRAM);
        }
        return null;
    }

    public InspectViewInput processProject(IProject project) {
        if (project == null || project.getLocation() == null) {
            return null;
        }
        StringBuilder content = new StringBuilder();
        content.append(PROJECT_NAME).append(project.getName()).append("\n");
        try {
            String naturesString;
            String[] natureIds;
            IProjectDescription description;
            String physicalPath = project.getLocation().toFile().getCanonicalPath();
            if (physicalPath != null) {
                content.append("Physical path:    ").append(physicalPath).append("\n");
            }
            if (project.getRawLocation() != null) {
                content.append("System path:      ").append(project.getRawLocation().toOSString()).append("\n");
            }
            IProjectDescription iProjectDescription = description = project.isAccessible() ? project.getDescription() : null;
            if (description != null && (natureIds = description.getNatureIds()) != null && !(naturesString = Arrays.stream(natureIds).filter(natureId -> !"ro.amiq.dvt.dvtnature".equals(natureId)).map(natureId -> {
                LanguageKind lk = LanguageKind.from(natureId);
                if (lk != null) {
                    return lk.DISPLAY_NAME;
                }
                return natureId;
            }).sorted(String.CASE_INSENSITIVE_ORDER).collect(Collectors.joining(", "))).isEmpty()) {
                content.append(naturesString.contains(",") ? NATURES : NATURE).append(naturesString).append("\n");
            }
        }
        catch (IOException | CoreException e) {
            DVTLogger.INSTANCE.logError(e);
        }
        String contentString = content.toString();
        InspectViewInput result = new InspectViewInput(contentString);
        result.addContentPositions(this.getPaintedPositions(new Document(contentString), 0, DVTStringUtil.split(LINE_SPLIT_PATTERN, contentString).length - 1));
        return result;
    }

    private String getDetectedIndentationInfo(IFile iFile) {
        IEditorPart activeEditor = DVTUiUtils.getActivePage().getActiveEditor();
        if (!(activeEditor instanceof DVTEditor)) {
            return null;
        }
        IFile editorFile = ((DVTEditor)activeEditor).getCurrentFile();
        if (iFile != editorFile) {
            return null;
        }
        IDocument activeEditorDocument = ((DVTEditor)activeEditor).getDocument();
        DVTAutoIndentDetector.DetectedIndentation detectedIndentation = DVTAutoIndentDetectionManager.INSTANCE.getDetectedIndentationForDocument(activeEditorDocument);
        if (detectedIndentation == null) {
            return null;
        }
        StringBuilder detectedIndentationInfo = new StringBuilder();
        detectedIndentationInfo.append(INDENTATION);
        detectedIndentationInfo.append(detectedIndentation.getTabWidth());
        if (detectedIndentation.getInsertSpaces()) {
            detectedIndentationInfo.append(AUTO_DETECT_INDENTATION_SPACES);
        } else {
            detectedIndentationInfo.append(AUTO_DETECT_INDENTATION_TABS);
        }
        detectedIndentationInfo.append(AUTO_DETECT_INDENTATION_TRIGGER);
        return detectedIndentationInfo.toString();
    }

    public int getNumberOfIndicesFromCompileIndexInfo(String compileIndexInfo) {
        return StringUtils.countMatches((String)compileIndexInfo, (String)",") + 1;
    }

    public InspectViewInput processFolder(IFolder folder) {
        IPath location;
        StringBuilder content;
        block6: {
            content = new StringBuilder();
            content.append("Folder name:      ").append(folder.getName()).append("\n");
            location = folder.getLocation();
            if (location != null) break block6;
            return null;
        }
        try {
            String physicalPath = location.toFile().getCanonicalPath();
            if (physicalPath != null) {
                content.append("Physical path:    ").append(physicalPath).append("\n");
            }
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        if (folder.getRawLocation() != null) {
            content.append("System path:      ").append(folder.getRawLocation().toOSString()).append("\n");
        }
        if (folder.getProjectRelativePath() != null) {
            content.append("Path in project:  ").append(folder.getProjectRelativePath().toOSString()).append("\n");
        }
        String contentString = content.toString();
        InspectViewInput result = new InspectViewInput(contentString);
        result.addContentPositions(this.getPaintedPositions(new Document(contentString), 0, DVTStringUtil.split(LINE_SPLIT_PATTERN, contentString).length - 1));
        return result;
    }

    public InspectViewInput processSingleFSMTransition(FSMTransition transition, List<InspectViewGoToInfo> goToInfos, IProject project, LanguageKind languageKind) {
        IFSMInput sourceInput = transition.getSourceInput();
        List<IFSMCondition> conditions = sourceInput.getConditions();
        if (conditions == null || goToInfos == null || conditions.size() != goToInfos.size()) {
            return null;
        }
        InspectViewInput result = new InspectViewInput("", DVTDocumentCommon.getLineDelimiterByProject(project));
        int i = 0;
        while (i < conditions.size()) {
            result.appendInput(this.processFSMCondition(project, conditions.get(i), transition.getNextStateVarName(), transition.getDestination().getNiceID(), goToInfos.get(i), result.getContentLength(), languageKind));
            ++i;
        }
        return result;
    }

    private InspectViewInput processFSMCondition(IProject project, IFSMCondition condition, String nextStateVarName, String destinationText, InspectViewGoToInfo inspectViewGoToInfo, int currentOffset, LanguageKind languageKind) {
        GoToInfo gotoInfo = inspectViewGoToInfo.getGotoInfo();
        if (gotoInfo == null) {
            return null;
        }
        IFile iFile = DVTFileUtils.getInstance().findProjectFileUsingAbsolutePath(project, gotoInfo.filePath);
        if (iFile == null) {
            return null;
        }
        if (!(condition instanceof FSMCondition)) {
            return null;
        }
        String lineDelimiter = DVTDocumentCommon.getLineDelimiterByProject(project);
        String conditionText = this.internalProcessFSMConditionText(condition, true, nextStateVarName, destinationText, "", lineDelimiter, languageKind);
        if (languageKind == LanguageKind.VHDL) {
            conditionText = conditionText + lineDelimiter + "end if;";
        }
        String fileInfo = this.getInfoLine(project, "", iFile, this.getCommentFormat(gotoInfo.languageKind), gotoInfo.line);
        String content = String.valueOf(fileInfo) + conditionText;
        content = this.formatContent(content, project, true);
        InspectViewInput result = new InspectViewInput(content);
        Position[] backgroundAndHyperlinkPositions = this.getBackgroundAndHyperlinkPositions(currentOffset, fileInfo, iFile, gotoInfo.line);
        if (backgroundAndHyperlinkPositions != null) {
            result.addFileNamePosition(backgroundAndHyperlinkPositions[0]);
            result.addHyperlinkPosition((InspectViewPosition)backgroundAndHyperlinkPositions[1]);
        }
        int contentStartLine = fileInfo.split("\n").length;
        LFFormula formula = ((FSMCondition)condition).getFormula();
        int contentEndLine = formula != LFFormula.EMPTY && formula != LFFormula.FILTERED_FORMULA ? contentStartLine + 2 : contentStartLine;
        result.addContentPositions(this.getPaintedPositions((IDocument)new Document(content), contentStartLine, contentEndLine, currentOffset));
        result.setMaxDigitsNumber(this.getDigits(gotoInfo.line));
        String lineNumberContent = this.getLineNumberContent(gotoInfo.line, gotoInfo.line, true, fileInfo);
        result.setLineNumberContent(String.valueOf(lineNumberContent) + "\n");
        result.setHasContextLines(false);
        return result;
    }

    private String internalProcessFSMConditionText(IFSMCondition condition, boolean isFirst, String stateVarName, String destinationStateID, String indent, String lineDelimiter, LanguageKind languageKind) {
        boolean emptyFormula;
        if (!(condition instanceof FSMCondition)) {
            return "";
        }
        boolean isVHDLFSM = languageKind == LanguageKind.VHDL;
        StringBuilder result = new StringBuilder();
        LFFormula formula = ((FSMCondition)condition).getFormula();
        boolean bl = emptyFormula = formula == LFFormula.EMPTY || formula == LFFormula.FILTERED_FORMULA;
        if (!emptyFormula) {
            result.append(indent);
            if (isVHDLFSM) {
                result.append(isFirst ? "if " : "elsif ");
            } else {
                result.append(isFirst ? "if " : "else if ");
            }
            String formulaText = formula.toString();
            if (!formulaText.startsWith("(")) {
                result.append("(");
            }
            result.append(formulaText);
            if (!formulaText.startsWith("(")) {
                result.append(")");
            }
            if (isVHDLFSM) {
                result.append(" then");
            }
            result.append(lineDelimiter);
            result.append(indent);
        } else if (!isFirst) {
            result.append(indent);
            result.append("else ").append(lineDelimiter);
            result.append(indent);
        }
        result.append("\t").append(stateVarName).append(isVHDLFSM ? " <= " : " = ").append(destinationStateID).append(";");
        return result.toString();
    }

    public InspectViewInput processFSMTransitions(Collection<FSMTransition> transitions, List<InspectViewGoToInfo> goToInfos, boolean hasLoopBackTransitions, IProject project, LanguageKind languageKind) {
        if (transitions == null || transitions.isEmpty()) {
            return null;
        }
        if (transitions.size() == 1) {
            return this.processSingleFSMTransition(transitions.iterator().next(), goToInfos, project, languageKind);
        }
        ArrayList<FSMTransition> sorted = new ArrayList<FSMTransition>(transitions);
        Collections.sort(sorted, FSM_TRANSITIONS_DEFINITION_COMPARATOR);
        LinkedHashMap<String, ArrayList<FSMTransition>> statesWithTransitions = new LinkedHashMap<String, ArrayList<FSMTransition>>();
        ArrayList<FSMTransition> anyStateTransitions = new ArrayList<FSMTransition>();
        String stateVarName = null;
        String nextStateVarName = null;
        for (FSMTransition transition : sorted) {
            IFSMState source = transition.getSource();
            String string = source.getNiceID();
            if (stateVarName == null) {
                stateVarName = transition.getStateVarName();
            }
            if (nextStateVarName == null) {
                nextStateVarName = transition.getNextStateVarName();
            }
            if ("[ ANY STATE ]".equals(string)) {
                anyStateTransitions.add(transition);
                continue;
            }
            ArrayList<FSMTransition> outgoing = (ArrayList<FSMTransition>)statesWithTransitions.get(string);
            if (outgoing == null) {
                outgoing = new ArrayList<FSMTransition>();
                statesWithTransitions.put(string, outgoing);
            }
            outgoing.add(transition);
        }
        if (statesWithTransitions.isEmpty()) {
            return null;
        }
        boolean isVHDLFSM = languageKind == LanguageKind.VHDL;
        StringBuilder sb = new StringBuilder();
        String infoLine = sb.append(isVHDLFSM ? "-- " : "// ").append("FSM transitions").append("\n").toString();
        if (!hasLoopBackTransitions) {
            infoLine = sb.append(isVHDLFSM ? "-- " : "// ").append("Note: ").append(DFSMActionMessages.explicitLoopbackNotShow).append("\n").toString();
        }
        if (isVHDLFSM) {
            sb.append(nextStateVarName).append(" <= ").append("(others => 'X');").append("\n");
        } else {
            sb.append(nextStateVarName).append(" = ").append("'{default:1'bx};").append("\n");
        }
        sb.append("\n");
        if (isVHDLFSM) {
            sb.append("case ").append(stateVarName).append(" is");
        } else {
            sb.append("case (").append(stateVarName).append(")");
        }
        sb.append("\n");
        for (Map.Entry entry : statesWithTransitions.entrySet()) {
            sb.append("\n");
            String stateID = (String)entry.getKey();
            if (isVHDLFSM) {
                sb.append("when ").append(stateID).append(" => ").append("\n");
            } else {
                sb.append(stateID).append(" : ").append("\n");
            }
            ArrayList<FSMTransition> outgoings = (ArrayList<FSMTransition>)entry.getValue();
            if (!anyStateTransitions.isEmpty()) {
                outgoings = outgoings.isEmpty() ? new ArrayList<FSMTransition>() : new ArrayList(outgoings);
                outgoings.addAll(anyStateTransitions);
            }
            ArrayList<CTPair> allOuts = new ArrayList<CTPair>(outgoings.size());
            for (FSMTransition out : outgoings) {
                IFSMInput input = out.getSourceInput();
                List<IFSMCondition> conditions = input.getConditions();
                if (conditions == null) continue;
                for (IFSMCondition condition : conditions) {
                    if (!(condition instanceof FSMCondition)) continue;
                    allOuts.add(new CTPair((FSMCondition)condition, out));
                }
            }
            Collections.sort(allOuts, FSM_CONDITIONS_DEFINITION_COMPARATOR);
            this.internalProcessFSMTransitionInCaseItemStatement(allOuts, sb, "\n", languageKind);
            if (!isVHDLFSM) continue;
            sb.deleteCharAt(sb.length() - 1).append("\n").append("\t").append("end if;").append("\n");
        }
        sb.append("\n");
        if (isVHDLFSM) {
            sb.append("end case;");
        } else {
            sb.append("endcase");
        }
        String string = this.formatContent(sb.toString(), project, false);
        InspectViewInput result = new InspectViewInput(string);
        result.addFileNamePosition(new DVTPosition(0, infoLine.length()));
        return result;
    }

    private void internalProcessFSMTransitionInCaseItemStatement(List<CTPair> conditions, StringBuilder sb, String lineDelimiter, LanguageKind languageKind) {
        int conditionIndex = 0;
        while (conditionIndex < conditions.size()) {
            CTPair condition = conditions.get(conditionIndex);
            sb.append(this.internalProcessFSMConditionText(condition.condition, conditionIndex == 0, condition.transition.getNextStateVarName(), condition.transition.getDestination().getNiceID(), "\t", lineDelimiter, languageKind)).append(lineDelimiter);
            ++conditionIndex;
        }
    }

    @Override
    protected String computePowerFormatInfo(IProject project, IRfNamedElement element, ElementPath pathToTop) {
        String isolationStrategyName;
        String powerDomain = DVTPFUtils.getPowerDomainsForInstanceOrPortByPath(element, pathToTop, "\n");
        if (powerDomain == null) {
            return null;
        }
        DVTPFModel pfModel = DVTPFUtils.getUpfModel(project);
        if (pfModel == null) {
            return null;
        }
        DVTPFInfo pdInfo = pfModel.getPDInfoForInstance(pathToTop);
        if (pdInfo != null && (isolationStrategyName = pdInfo.getIsolationStrategyByElement(pathToTop)) != null) {
            DVTPFIsolationStrategyInfo isolationStrategyByName = pdInfo.getIsolationStrategyByName(isolationStrategyName);
            isolationStrategyName = "Isolation strategy: " + isolationStrategyName;
            if (isolationStrategyByName != null) {
                isolationStrategyName = String.valueOf(isolationStrategyName) + " [Clamp value: " + isolationStrategyByName.getClampValue() + "]";
            }
            powerDomain = String.valueOf(powerDomain) + "\n" + isolationStrategyName;
        }
        return "Low Power Information:\n" + powerDomain;
    }

    @Override
    protected String computePowerDomainInfo(IProject project, GoToInfo gotoInfo, ElementPath pathToTop) {
        ELManager elManager = RfMixedLangManager.getInstance().getELManager(project);
        if (elManager == null) {
            return null;
        }
        if (!(gotoInfo instanceof GoToInfoWithBreadcrumbElement)) {
            return null;
        }
        if (pathToTop == null) {
            return null;
        }
        IEditorPart editor = this.getActiveEditor();
        if (!(editor instanceof IDVTBreadcrumbHost)) {
            return null;
        }
        IRfBreadcrumbElement bcElement = ((GoToInfoWithBreadcrumbElement)gotoInfo).element;
        if (!(bcElement instanceof ElementPath)) {
            return null;
        }
        ELInstance instanceFor = elManager.getMemory().instanceFor(((ElementPath)bcElement).toElaborationForm());
        if (instanceFor == null) {
            return null;
        }
        IRfInstanceElement element = instanceFor.getDescription();
        String powerDomain = DVTPFUtils.getPowerDomainsForInstanceOrPortByPath(element, pathToTop, "\n");
        if (powerDomain == null || powerDomain.isEmpty()) {
            return null;
        }
        return "Power Domain:\n" + powerDomain;
    }

    public Map<String, Object> getProblemMarkerInfo(IMarker marker) {
        Object lineNumberAttribute;
        String message;
        int severity;
        MarkerInfo info;
        block10: {
            Object messageAttribute;
            block9: {
                Object severityAttribute;
                block8: {
                    block7: {
                        try {
                            info = ((Workspace)ResourcesPlugin.getWorkspace()).getMarkerManager().findMarkerInfo(marker.getResource(), marker.getId());
                            if (info != null) break block7;
                            return null;
                        }
                        catch (Exception e) {
                            DVTLogger.INSTANCE.logError((Throwable)e);
                            return null;
                        }
                    }
                    severityAttribute = info.getAttribute("severity");
                    if (severityAttribute instanceof Integer) break block8;
                    return null;
                }
                severity = (Integer)severityAttribute;
                messageAttribute = info.getAttribute("message");
                if (messageAttribute instanceof String) break block9;
                return null;
            }
            message = (String)messageAttribute;
            lineNumberAttribute = info.getAttribute("lineNumber");
            if (lineNumberAttribute instanceof Integer) break block10;
            return null;
        }
        int lineNumber = (Integer)lineNumberAttribute;
        String paths = (String)info.getAttribute("ELAB_PROBLEMS_ELEMENTPATH_ATTRIBUTE");
        Object hitAttribute = info.getAttribute("ro.amiq.vlogdt.linter.ui.LintingProblemsManager.HitAttribute");
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("file", marker.getResource());
        result.put("message", message);
        result.put("lineNumber", lineNumber);
        result.put("ELAB_PROBLEMS_ELEMENTPATH_ATTRIBUTE", paths);
        result.put("severity", severity);
        result.put("PROBLEM_SOURCE_FILE_PATH", info.getAttribute("PROBLEM_SOURCE_FILE_PATH"));
        result.put("PROBLEM_SOURCE_LINE", info.getAttribute("PROBLEM_SOURCE_LINE"));
        if (hitAttribute != null) {
            result.put("ro.amiq.vlogdt.linter.ui.LintingProblemsManager.HitAttribute", hitAttribute);
        }
        return result;
    }

    public void incrementContextLines(int increment) {
        int newValue = this.getInspectContextLines() + increment;
        newValue = newValue < 0 ? 0 : (newValue > 1000 ? 1000 : newValue);
        this.setInspectContextLines(newValue);
    }

    public void setInspectContextLines(int value) {
        DVTPlugin.getDefault().getPreferenceStore().setValue("inspect.context.lines", value);
    }

    public void setInspectMaxFileSize(int bytes) {
        DVTPlugin.getDefault().getPreferenceStore().setValue("inspect.max.file.size", bytes);
    }

    @Override
    public IEditorPart getActiveEditor() {
        IEditorPart[] activeEditor = new IEditorPart[1];
        DVTUiUtils.getActiveWorkbenchShell().getDisplay().syncExec(() -> {
            IEditorPart iEditorPart = DVTFileUtils.getInstance().getActiveEditor();
        });
        return activeEditor[0];
    }

    @Override
    protected List<IInspectViewInputContributor> getViewContributors() {
        return this.viewContributors;
    }

    @Override
    protected InspectViewAutoDetectIndentationPosition addAutoDetectedIndentationInformationAndGetHyperlinkPosition(IFile iFile, boolean addDetectIndentationInfo, StringBuilder content) {
        InspectViewAutoDetectIndentationPosition inspectViewDetectIndentationPosition = null;
        if (addDetectIndentationInfo) {
            String detectedIndentationInfo;
            if (!content.toString().endsWith("\n")) {
                content.append("\n");
            }
            if ((detectedIndentationInfo = this.getDetectedIndentationInfo(iFile)) != null) {
                content.append(detectedIndentationInfo);
                int triggerLen = AUTO_DETECT_INDENTATION_TRIGGER.length();
                inspectViewDetectIndentationPosition = new InspectViewAutoDetectIndentationPosition(content.toString().length() - triggerLen, triggerLen, iFile);
            }
        }
        return inspectViewDetectIndentationPosition;
    }

    @Override
    public InspectViewInput processProblemsView(Map<String, Object> info, IProject project) {
        String message = (String)info.get("message");
        StringBuilder result = new StringBuilder();
        result.append("Message:          ").append(this.getMessage(message));
        return this.processProblemsView(info, project, result, new InspectViewInput(""));
    }

    private static class CTPair {
        FSMCondition condition;
        FSMTransition transition;

        public CTPair(FSMCondition condition, FSMTransition transition) {
            this.condition = condition;
            this.transition = transition;
        }
    }
}

