/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.inspect;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.diagrams.DDiagram;
import ro.amiq.dvt.diagrams.action.draw.obj.IDActionDiagramObject;
import ro.amiq.dvt.diagrams.ch.ICHDiagram;
import ro.amiq.dvt.diagrams.ch.draw.obj.CHDObject;
import ro.amiq.dvt.diagrams.ch.model.ICHElement;
import ro.amiq.dvt.diagrams.ch.utils.CHAdapters;
import ro.amiq.dvt.diagrams.editor.DDiagramEditorSelection;
import ro.amiq.dvt.diagrams.fsm.FSMDiagram;
import ro.amiq.dvt.diagrams.fsm.FSMDiagramConfiguration;
import ro.amiq.dvt.diagrams.fsm.draw.FSMDrawUtils;
import ro.amiq.dvt.diagrams.fsm.draw.obj.FSMDObject;
import ro.amiq.dvt.diagrams.fsm.model.FSMTransition;
import ro.amiq.dvt.diagrams.fsm.model.IFSMViewSelectable;
import ro.amiq.dvt.diagrams.klay.utils.KLayDrawUtils;
import ro.amiq.dvt.diagrams.netlist.model.INLViewSelectable;
import ro.amiq.dvt.diagrams.netlist.model.NLConnection;
import ro.amiq.dvt.diagrams.netlist.model.NLGate;
import ro.amiq.dvt.diagrams.netlist.model.NLInstanceGate;
import ro.amiq.dvt.diagrams.netlist.model.NLPort;
import ro.amiq.dvt.diagrams.netlist.utils.NLUtils;
import ro.amiq.dvt.diagrams.uml.draw.UMLDrawUtils;
import ro.amiq.dvt.diagrams.uml.draw.obj.DUMLObject;
import ro.amiq.dvt.diagrams.uml.model.IUMLInspectViewSelectable;
import ro.amiq.dvt.draw.obj.interaction.DSelectable;
import ro.amiq.dvt.elaboration.ELBatchUtils;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.ELParamValuesHidEvaluator;
import ro.amiq.dvt.elaboration.model.IELMemory;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.IXContributor;
import ro.amiq.dvt.interpreter.XViewsUtils;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.GoToInfo;
import ro.amiq.dvt.model.reflection.GoToInfoWithBreadcrumbElement;
import ro.amiq.dvt.model.reflection.GoToInfoWithPlainText;
import ro.amiq.dvt.model.reflection.IRfBreadcrumbElement;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfElementPath;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.util.RfSearchUtils;
import ro.amiq.dvt.resources.properties.PropertiesManager;
import ro.amiq.dvt.resources.properties.PropertyTypes;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.DVTPosition;
import ro.amiq.dvt.ui.editor.TextUtils;
import ro.amiq.dvt.ui.editor.pathmanager.DesignPathManager;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.ui.search.DocumentManager;
import ro.amiq.dvt.ui.views.DVTViewContributors;
import ro.amiq.dvt.ui.views.InspectViewGoToInfo;
import ro.amiq.dvt.ui.views.InspectViewUpdateEvent;
import ro.amiq.dvt.ui.views.InspectViewUpdateEventCommon;
import ro.amiq.dvt.ui.views.inspect.FileCompileInfo;
import ro.amiq.dvt.ui.views.inspect.IInspectViewContributor;
import ro.amiq.dvt.ui.views.inspect.IInspectViewInputContributor;
import ro.amiq.dvt.ui.views.inspect.InspectViewBreadcrumbUpdatePosition;
import ro.amiq.dvt.ui.views.inspect.InspectViewInput;
import ro.amiq.dvt.ui.views.inspect.InspectViewPosition;
import ro.amiq.dvt.ui.views.lazy.views.designhierarchy.LazyDesignHierarchyPortsView;
import ro.amiq.dvt.ui.waveviewer.DVTWaveViewIDEFactory;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.dvt.utils.DVTDocumentCommon;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTStringUtil;

public abstract class DVTInspectViewUtilsCommon {
    public static final int INSPECT_VIEW_MAX_LINES = 1000;
    public static final int INSPECT_VIEW_MAX_CONTEXT_LINES = 1000;
    protected static final String ONE_SPACE = " ";
    protected static final String THREE_SPACES = "   ";
    protected static final String VHDL_COMMENT_START = "--";
    protected static final String VLOG_COMMENT_START = "//";
    public static final String NUMBER = "Number : ";
    protected static final String INITIAL_VALUE = "Initial value : ";
    protected static final String ACTUAL_VALUE = "Actual value : ";
    protected static final String NEW_LINE = "\n";
    protected static final String EXTENSION_POINT_ID = "ro.amiq.dvt.inspectViewInputContributors";
    protected static final Pattern SEMI_COLON_PATTERN = Pattern.compile(";");
    protected static final Pattern SPACE_PATTERN = Pattern.compile("\\s");
    private static final String EMPTY_SPACES = "                  ";
    private static final String PROBLEM_SOURCE_HEADER = "Source:           ";
    private static final String DESIGN_PATHS_HEADER = "Paths:            ";
    private static final String DESIGN_CONTEXT_HEADER = "Context:          ";
    private static final String MARKER_LOCATION_HEADER = "Location:         line ";
    private static final String MARKER_SEVERITY_HEADER = "Severity:         ";
    protected static final String MARKER_MESSAGE_HEADER = "Message:          ";
    protected static final String MARKER_FILE = "file";
    protected static final String MARKER_SEVERITY = "severity";
    protected static final String MARKER_LINE = "lineNumber";
    protected static final String MARKER_MESSAGE = "message";
    protected static final String MARKER_HIT = "ro.amiq.vlogdt.linter.ui.LintingProblemsManager.HitAttribute";
    protected static final String FOLDER_NAME = "Folder name:      ";
    protected static final String SYSTEM_PATH = "System path:      ";
    protected static final String PHYSICAL_PATH = "Physical path:    ";
    private static final String PROJECT_IDENTIFIER = "Project:          ";
    protected static final String PROJECT_PATH = "Path in project:  ";
    private static final String FILE_NAME = "File name:        ";
    private static final String READ_ONLY = "Read-only:        ";
    private static final String COMPILE_INDEX = "Compile index:    ";
    private static final String COMPILE_INDEXES = "Compile indexes:  ";
    private static final String COMPILE_SYNTAX = "Compile syntax:   ";
    private static final String NOT_COMPILED = "N/A (Not compiled by DVT)";
    private static final String CHECK_NAME = "Check name:       ";
    private static final String CHECK_DESCRIPTION = "Check description:";
    private static final Pattern LINE_SPLIT_PATTERN = Pattern.compile("\\n");
    protected static final Map<Integer, String> BASES = new LinkedHashMap<Integer, String>();
    protected static final List<IInspectViewContributor> inspectContributors;
    protected static final String COMPILE_INDEX_NO_INDENT = "Compile index: ";
    protected static final String COMPILE_INDEXES_NO_INDENT = "Compile indexes: ";
    private static final String FILE_INFORMATION = "File";
    private static final String FILE_INFORMATION_WITH_ELEMENT_INFO = "in file";
    private static final Comparator<InspectViewGoToInfo> goToInfoComparator;

    static {
        BASES.put(2, "Base  2: ");
        BASES.put(8, "Base  8: ");
        BASES.put(10, "Base 10: ");
        BASES.put(16, "Base 16: ");
        inspectContributors = DVTViewContributors.getInstance().getAllInstanceOf(IInspectViewContributor.class);
        goToInfoComparator = (info1, info2) -> {
            GoToInfo o1 = info1.getGotoInfo();
            GoToInfo o2 = info2.getGotoInfo();
            if (o1 instanceof GoToInfoWithPlainText && o2 instanceof GoToInfoWithPlainText) {
                return 0;
            }
            if (o1 instanceof GoToInfoWithPlainText) {
                return -1;
            }
            if (o2 instanceof GoToInfoWithPlainText) {
                return 1;
            }
            String file1 = o1.filePath;
            String file2 = o2.filePath;
            if (file1 == null && file2 == null) {
                return 0;
            }
            if (file1 == null) {
                return -1;
            }
            if (file2 == null) {
                return 1;
            }
            if (!file1.equals(file2)) {
                return file1.compareTo(file2);
            }
            int line1 = o1.line;
            int line2 = o2.line;
            if (line1 != line2) {
                return line1 - line2;
            }
            int offset1 = o1.offset;
            int offset2 = o2.offset;
            return offset1 - offset2;
        };
    }

    public InspectViewUpdateEvent createInspectViewNLEvent(Set<DSelectable> hits, IProject project) {
        if (hits == null || hits.isEmpty() || project == null) {
            return null;
        }
        HashSet<InspectViewGoToInfo> infos = new HashSet<InspectViewGoToInfo>();
        for (DSelectable hit : hits) {
            ElementPath path;
            INLViewSelectable nlSelectable = KLayDrawUtils.getNLViewSelectable(hit);
            if (nlSelectable == null) continue;
            if (nlSelectable instanceof NLConnection && ((NLConnection)nlSelectable).isEdge()) {
                Collection<GoToInfo> cachedFlowSignals = ((NLConnection)nlSelectable).getCachedFlowGoToInfos();
                if (cachedFlowSignals == null || cachedFlowSignals.isEmpty()) continue;
                for (GoToInfo goToInfo : cachedFlowSignals) {
                    infos.add(new InspectViewGoToInfo(goToInfo));
                }
                continue;
            }
            if (nlSelectable instanceof NLConnection && ((NLConnection)nlSelectable).isImplicitSignal()) {
                if (nlSelectable.getGoToSource() == null) continue;
                for (GoToInfo goToInfo : nlSelectable.getGoToSource()) {
                    InspectViewInput processedNumber = this.processNumber(((NLConnection)nlSelectable).getLabel(), goToInfo.languageKind);
                    infos.add(new InspectViewGoToInfo(goToInfo, processedNumber.getContent()));
                }
                continue;
            }
            if (nlSelectable instanceof NLPort) {
                if (nlSelectable.getGoToSource() == null) continue;
                path = null;
                NLGate nLGate = ((NLPort)nlSelectable).getEnclosingGate();
                if (nLGate instanceof NLInstanceGate) {
                    path = NLUtils.getGatePathToTop((NLInstanceGate)nLGate);
                }
                for (GoToInfo cachedFlowSignal : nlSelectable.getGoToSource()) {
                    infos.add(new InspectViewGoToInfo(cachedFlowSignal, path));
                }
                continue;
            }
            if (nlSelectable.getGoToSource() == null) continue;
            path = null;
            if (nlSelectable instanceof NLInstanceGate) {
                path = NLUtils.getGatePathToTop((NLInstanceGate)nlSelectable);
            }
            for (GoToInfo goToInfo : nlSelectable.getGoToSource()) {
                infos.add(new InspectViewGoToInfo(goToInfo, path));
            }
        }
        if (infos.isEmpty()) {
            return null;
        }
        ArrayList<InspectViewGoToInfo> infosList = new ArrayList<InspectViewGoToInfo>(infos);
        for (InspectViewGoToInfo info : infosList) {
            GoToInfo marker = info.getGotoInfo();
            if (marker == null || marker.languageKind == null) continue;
            return new InspectViewUpdateEvent(infosList, project, marker.languageKind, InspectViewUpdateEventCommon.TYPE.DIAGRAM);
        }
        return null;
    }

    public InspectViewUpdateEvent createInspectViewFSMEvent(Set<DSelectable> hits, DDiagram diagram, IProject project) {
        if (hits == null || hits.isEmpty() || project == null) {
            return null;
        }
        Set<FSMTransition> transitions = Collections.newSetFromMap(new IdentityHashMap());
        HashSet<InspectViewGoToInfo> infos = new HashSet<InspectViewGoToInfo>(hits.size());
        for (DSelectable hit : hits) {
            Collection<GoToInfo> goTos;
            IFSMViewSelectable selectable;
            if (!(hit instanceof FSMDObject) || (selectable = FSMDrawUtils.getFSMObjectFromFSMDObject((FSMDObject)((Object)hit), IFSMViewSelectable.class)) == null) continue;
            if (selectable instanceof FSMTransition) {
                transitions.add((FSMTransition)selectable);
            }
            if ((goTos = selectable.hasGoToSource()) == null || goTos.isEmpty()) continue;
            for (GoToInfo gotoEl : goTos) {
                infos.add(new InspectViewGoToInfo(gotoEl));
            }
        }
        if (infos.isEmpty()) {
            return null;
        }
        ArrayList infosList = new ArrayList(infos);
        for (InspectViewGoToInfo info : infosList) {
            GoToInfo marker = info.getGotoInfo();
            if (marker == null || marker.languageKind == null) continue;
            if (transitions != null && !transitions.isEmpty()) {
                FSMDiagramConfiguration config = diagram instanceof FSMDiagram ? ((FSMDiagram)diagram).getConfig() : null;
                InspectViewUpdateEventCommon.TYPE diagramType = config != null && !config.contains(FSMDiagramConfiguration.FSMDiagramConfigurationKey.REMOVE_LOOPBACK_TRANSITIONS) ? InspectViewUpdateEventCommon.TYPE.FSM_TRANSITIONS_WITH_LOOPBACK : InspectViewUpdateEventCommon.TYPE.FSM_TRANSITIONS;
                return new InspectViewUpdateEvent(transitions, infos, project, marker.languageKind, diagramType);
            }
            return new InspectViewUpdateEvent(infos, project, marker.languageKind, InspectViewUpdateEventCommon.TYPE.DIAGRAM);
        }
        return null;
    }

    public InspectViewUpdateEvent createInspectViewUMLEvent(Set<DSelectable> hits, IProject project) {
        if (hits == null || hits.isEmpty() || project == null) {
            return null;
        }
        HashSet<InspectViewGoToInfo> infos = new HashSet<InspectViewGoToInfo>(hits.size());
        for (DSelectable hit : hits) {
            Collection<GoToInfo> goTos;
            IUMLInspectViewSelectable selectable;
            if (!(hit instanceof DUMLObject) || (selectable = UMLDrawUtils.getUMLElementFromDUMLObject((DUMLObject)((Object)hit), IUMLInspectViewSelectable.class)) == null || (goTos = selectable.hasGoToSource()) == null || goTos.isEmpty()) continue;
            for (GoToInfo gotoEl : goTos) {
                infos.add(new InspectViewGoToInfo(gotoEl));
            }
        }
        if (infos.isEmpty()) {
            return null;
        }
        ArrayList infosList = new ArrayList(infos);
        for (InspectViewGoToInfo info : infosList) {
            GoToInfo marker = info.getGotoInfo();
            if (marker == null || marker.languageKind == null) continue;
            return new InspectViewUpdateEvent(infos, project, marker.languageKind, InspectViewUpdateEventCommon.TYPE.DIAGRAM);
        }
        return null;
    }

    public InspectViewUpdateEvent createInspectViewPSSEvent(Set<DSelectable> hits, IProject project) {
        if (hits == null || hits.isEmpty() || project == null) {
            return null;
        }
        HashSet<RfElementPath> actionElementPaths = new HashSet<RfElementPath>(hits.size());
        HashSet<InspectViewGoToInfo> infos = new HashSet<InspectViewGoToInfo>(hits.size());
        StringBuilder inspectInfo = new StringBuilder();
        for (DSelectable hit : hits) {
            if (!(hit instanceof IDActionDiagramObject)) continue;
            RfElementPath actionElementPath = ((IDActionDiagramObject)((Object)hit)).getActionElementPath();
            if (actionElementPath != null) {
                actionElementPaths.add(actionElementPath);
                continue;
            }
            Collection<GoToInfo> goTos = ((IDActionDiagramObject)((Object)hit)).hasGoToSource();
            if (goTos == null || goTos.isEmpty()) continue;
            String inspectInfoPart = ((IDActionDiagramObject)((Object)hit)).getInspectInfo();
            if (inspectInfoPart != null && !inspectInfoPart.isEmpty()) {
                inspectInfo.append(inspectInfoPart);
                continue;
            }
            for (GoToInfo gotoEl : goTos) {
                infos.add(new InspectViewGoToInfo(gotoEl));
            }
        }
        if (!actionElementPaths.isEmpty()) {
            return new InspectViewUpdateEvent(actionElementPaths, LanguageKind.PSS, 1, null, project, InspectViewUpdateEventCommon.TYPE.DIAGRAM);
        }
        if (inspectInfo.length() > 0) {
            return new InspectViewUpdateEvent(inspectInfo.toString(), LanguageKind.PSS, 1, null, project, InspectViewUpdateEventCommon.TYPE.DIAGRAM);
        }
        if (infos.isEmpty()) {
            return null;
        }
        ArrayList infosList = new ArrayList(infos);
        for (InspectViewGoToInfo info : infosList) {
            GoToInfo marker = info.getGotoInfo();
            if (marker == null || marker.languageKind == null) continue;
            return new InspectViewUpdateEvent(infos, project, marker.languageKind, InspectViewUpdateEventCommon.TYPE.DIAGRAM);
        }
        return null;
    }

    public InspectViewUpdateEvent createInspectViewCHDEvent(Set<DSelectable> hits, IProject project) {
        if (hits == null || hits.isEmpty() || project == null) {
            return null;
        }
        HashSet<InspectViewGoToInfo> infos = new HashSet<InspectViewGoToInfo>(hits.size());
        for (DSelectable hit : hits) {
            GoToInfo goTo;
            if (!(hit instanceof CHDObject)) continue;
            ICHElement selectable = CHAdapters.getCHObjectFromCHDObject((CHDObject)((Object)hit), ICHElement.class);
            if (selectable == null) {
                selectable = CHAdapters.getCHPortFromCHDSelectableLabel((CHDObject)((Object)hit), ICHElement.class);
            }
            if (selectable == null || (goTo = selectable.getInspectViewMarker()) == null) continue;
            infos.add(new InspectViewGoToInfo(goTo));
        }
        if (infos.isEmpty()) {
            return null;
        }
        ArrayList infosList = new ArrayList(infos);
        for (InspectViewGoToInfo info : infosList) {
            GoToInfo marker = info.getGotoInfo();
            if (marker == null || marker.languageKind == null) continue;
            return new InspectViewUpdateEvent(infos, project, marker.languageKind, InspectViewUpdateEventCommon.TYPE.DIAGRAM);
        }
        return null;
    }

    public FileCompileInfo getCompileInfo(IFile file) {
        for (IInspectViewContributor contrib : inspectContributors) {
            FileCompileInfo compileInfo = contrib.getCompileInfo(file);
            if (compileInfo == null) continue;
            return compileInfo;
        }
        return null;
    }

    public InspectViewInput processGoToInfos(List<InspectViewGoToInfo> infos, IProject project, LanguageKind languageKind) {
        return this.processGoToInfos(infos, project, -1, languageKind, true);
    }

    public InspectViewInput processGoToInfos(List<InspectViewGoToInfo> infos, IProject project, LanguageKind languageKind, boolean sortInfos) {
        return this.processGoToInfos(infos, project, -1, languageKind, sortInfos);
    }

    public synchronized InspectViewInput processGoToInfos(List<InspectViewGoToInfo> infos, IProject project, int nofContextLine, LanguageKind languageKind, boolean sortInfos) {
        if (infos == null || infos.isEmpty()) {
            return null;
        }
        if (sortInfos) {
            infos.sort(goToInfoComparator);
        }
        InspectViewInput result = new InspectViewInput("", DVTDocumentCommon.getLineDelimiterByProject(project));
        if (infos.size() == 1 && infos.get(0).getGotoInfo() != null && "Implicit net".equals(infos.get((int)0).getGotoInfo().filePath)) {
            result.appendInput(new InspectViewInput("Implicit net"));
            return result;
        }
        if (infos.size() == 1 && infos.get(0).getGotoInfo() != null && "Implicit port".equals(infos.get((int)0).getGotoInfo().filePath)) {
            result.appendInput(new InspectViewInput("Implicit port"));
            return result;
        }
        DocumentManager manager = new DocumentManager(true);
        ELManager elManager = RfMixedLangManager.getInstance().getELManager(project);
        if (elManager == null) {
            return result;
        }
        IELMemory memory = elManager.getMemory();
        try {
            for (InspectViewGoToInfo info : infos) {
                if (info.getGotoInfo() instanceof GoToInfoWithBreadcrumbElement && ((GoToInfoWithBreadcrumbElement)info.getGotoInfo()).element != null) {
                    IRfBreadcrumbElement bcElement = ((GoToInfoWithBreadcrumbElement)info.getGotoInfo()).element;
                    IRfNamedElement element = null;
                    if (bcElement instanceof ElementPath) {
                        ELInstance instanceFor = memory.instanceFor(((ElementPath)bcElement).toElaborationForm());
                        if (instanceFor == null) continue;
                        element = instanceFor.getDescription();
                    } else if (bcElement instanceof IRfNamedElement) {
                        element = (IRfNamedElement)bcElement;
                    }
                    if (element == null) continue;
                    ElementPath pathToTop = info.getPathToTop();
                    String powerDomain = this.computePowerFormatInfo(project, element, pathToTop);
                    result.appendInput(this.processDefElements(element.getDeclarations(), project, this.getCommentFormat(languageKind), powerDomain, result.getContentLength(), manager));
                    InspectViewInput waveformInspectViewInput = DVTWaveViewIDEFactory.getInstance().getInspectViewInput(project, pathToTop, bcElement);
                    if (waveformInspectViewInput == null) continue;
                    result.appendInput(waveformInspectViewInput);
                    continue;
                }
                result.appendInput(this.processGoToInfo(project, info, result.getContentLength(), nofContextLine, manager));
            }
        }
        finally {
            manager.deactivate();
        }
        return result;
    }

    public InspectViewInput processGoToInfo(IProject project, InspectViewGoToInfo inspectGotoInfo, int currentOffset, int nofContextLines, DocumentManager manager) {
        boolean hasContextLines;
        if (project == null || inspectGotoInfo == null || inspectGotoInfo.getGotoInfo() == null) {
            return null;
        }
        GoToInfo gotoInfo = inspectGotoInfo.getGotoInfo();
        if (gotoInfo == null) {
            return null;
        }
        if (gotoInfo instanceof GoToInfoWithPlainText) {
            InspectViewInput result = new InspectViewInput(((GoToInfoWithPlainText)gotoInfo).getPlainText());
            return result;
        }
        IFile iFile = DVTFileUtils.getInstance().findProjectFileUsingAbsolutePath(project, gotoInfo.filePath);
        if (iFile == null) {
            return null;
        }
        int origStartLine = gotoInfo.line;
        int origEndLine = gotoInfo.endLine;
        if (origStartLine < 0 || origEndLine < 0 || origStartLine > origEndLine) {
            return null;
        }
        if (origEndLine - origStartLine + 1 > 1000) {
            origEndLine = origStartLine + 1000;
        }
        boolean bl = hasContextLines = origStartLine == origEndLine;
        int contextLines = nofContextLines > 0 ? nofContextLines : (hasContextLines ? this.getInspectContextLines() : 0);
        int startLine = origStartLine - contextLines < 1 ? 1 : origStartLine - contextLines;
        int endLine = origEndLine + contextLines;
        String fileData = DVTFileUtils.getInstance().getLinesFromFile(iFile, startLine, endLine, manager);
        String comment = gotoInfo.languageKind == LanguageKind.VHDL ? VHDL_COMMENT_START : VLOG_COMMENT_START;
        String fileInfo = this.getInfoLine(project, inspectGotoInfo.getCommentAdditionalInfo(), iFile, comment, -1);
        String lineDelimiter = DVTDocumentCommon.getLineDelimiterByProject(project);
        String powerDomain = this.computePowerDomainInfo(project, gotoInfo, inspectGotoInfo.getPathToTop());
        fileInfo = String.valueOf(powerDomain == null ? "" : String.valueOf(powerDomain) + lineDelimiter) + fileInfo;
        String content = String.valueOf(fileInfo) + fileData;
        content = this.formatContent(content, project, true);
        String processedNumber = inspectGotoInfo.getProcessedNumber();
        if (processedNumber != null) {
            content = String.valueOf(content) + processedNumber;
        }
        InspectViewInput result = new InspectViewInput(content);
        Position[] backgroundAndHyperlinkPositions = this.getBackgroundAndHyperlinkPositions(currentOffset, fileInfo, iFile, gotoInfo.line);
        if (backgroundAndHyperlinkPositions != null) {
            result.addFileNamePosition(backgroundAndHyperlinkPositions[0]);
            result.addHyperlinkPosition((InspectViewPosition)backgroundAndHyperlinkPositions[1]);
        }
        int contentStartLine = contextLines != 0 ? origStartLine - startLine + 1 : fileInfo.split(NEW_LINE).length;
        int contentEndLine = contextLines != 0 ? origEndLine - startLine + 1 : origEndLine - origStartLine + fileInfo.split(NEW_LINE).length;
        result.addContentPositions(this.getPaintedPositions((IDocument)new Document(content), contentStartLine, contentEndLine, currentOffset));
        result.setMaxDigitsNumber(this.getDigits(endLine));
        result.setLineNumberContent(this.getLineNumberContent(startLine, endLine, true, fileInfo));
        result.setHasContextLines(hasContextLines);
        return result;
    }

    protected String getCommentFormat(IRfNamedElement element) {
        if (element == null) {
            return VLOG_COMMENT_START;
        }
        return this.getCommentFormat(element.getLanguageKind());
    }

    protected String getCommentFormat(LanguageKind languageKind) {
        if (languageKind == null) {
            return VLOG_COMMENT_START;
        }
        switch (languageKind) {
            case VHDL: {
                return VHDL_COMMENT_START;
            }
        }
        return VLOG_COMMENT_START;
    }

    public List<Position> getPaintedPositions(Document document, int startLine, int endLine) {
        return this.getPaintedPositions((IDocument)document, startLine, endLine, 0);
    }

    public List<Position> getPaintedPositions(IDocument document, int startLine, int endLine, int currentOffset) {
        try {
            int firstLineStartOffset = document.getLineOffset(startLine);
            int lastLineEndOffset = document.getLineOffset(endLine) + document.getLineLength(endLine);
            DVTPosition newPosition = new DVTPosition(currentOffset + firstLineStartOffset, lastLineEndOffset - firstLineStartOffset);
            return Collections.singletonList(newPosition);
        }
        catch (Exception exception) {
            return Collections.emptyList();
        }
    }

    /*
     * Unable to fully structure code
     */
    public String formatContent(String content, IProject project, boolean hasContextLine) {
        if (content == null || content.isEmpty()) {
            return content;
        }
        if (project == null) {
            return content;
        }
        tabSize = DVTPlugin.getDefault().getCombinedPreferenceStore().getInt("tabWidth");
        formattedContent = new StringBuilder();
        lineDelimiter = DVTDocumentCommon.getLineDelimiterByProject(project);
        contentSplit = content.split(lineDelimiter);
        v0 = i = hasContextLine != false ? 1 : 0;
        if (contentSplit.length > i) ** GOTO lbl14
        return content;
lbl-1000:
        // 1 sources

        {
            if (contentSplit.length > ++i) continue;
            return content;
lbl14:
            // 2 sources

            ** while (contentSplit[i].trim().length() <= 0)
        }
lbl15:
        // 1 sources

        document = new Document(content);
        indentAtOffset = new String[]{""};
        try {
            indentAtOffset[0] = DVTDocumentUtils.getIndent(document.getLineOffset(i), (IDocument)document);
        }
        catch (BadLocationException v1) {}
        visualSpacesToRemove = TextUtils.replaceTabsWithSpacesVisual(indentAtOffset[0], tabSize).length();
        i = 0;
        while (i < contentSplit.length) {
            funcLine = TextUtils.replaceTabsWithSpacesVisual(contentSplit[i], tabSize);
            funcLine = TextUtils.trimNumberOfWhitespacesFromBeginningOfString(funcLine, visualSpacesToRemove);
            formattedContent.append(funcLine).append(lineDelimiter);
            ++i;
        }
        return formattedContent.toString();
    }

    public InspectViewInput processDefElements(Collection<? extends IRfDefElement> declarations, IProject project, String commentFormat, String powerDomain, int currentOffset, DocumentManager manager) {
        boolean shouldDeactivate;
        if (declarations == null || declarations.isEmpty()) {
            return null;
        }
        InspectViewInput result = new InspectViewInput("", DVTDocumentCommon.getLineDelimiterByProject(project));
        boolean bl = shouldDeactivate = manager == null;
        if (manager == null) {
            manager = new DocumentManager(true);
        }
        try {
            int index = 0;
            for (IRfDefElement iRfDefElement : declarations) {
                result.appendInput(this.processDefElement(project, iRfDefElement, commentFormat, index == 0 ? powerDomain : null, currentOffset + result.getContentLength(), manager));
                ++index;
            }
        }
        finally {
            if (shouldDeactivate) {
                manager.deactivate();
            }
        }
        return result;
    }

    public InspectViewInput processDefElement(IProject project, IRfDefElement declaration, String commentFormat, String powerDomain, int currentOffset, DocumentManager manager) {
        if (declaration == null) {
            return null;
        }
        int origStartLine = declaration.getStartLine();
        int origEndLine = declaration.getEndLine();
        if (origStartLine < 0 || origEndLine < 0 || origStartLine > origEndLine) {
            return null;
        }
        if (origEndLine - origStartLine + 1 > 1000) {
            origEndLine = origStartLine + 1000;
        }
        int commentStartLine = -1;
        if (declaration.getCommentBlock() != null) {
            commentStartLine = declaration.getCommentBlock().getAboveCommentStartLine();
        }
        if (commentStartLine >= 0 && commentStartLine <= origEndLine) {
            origStartLine = commentStartLine;
        }
        return this.createInspectViewInput(project, declaration, commentFormat, powerDomain, currentOffset, manager, origStartLine, origEndLine);
    }

    public InspectViewInput createInspectViewInput(IProject project, IRfDefElement declaration, String commentFormat, String powerDomain, int currentOffset, DocumentManager manager, int origStartLine, int origEndLine) {
        String numberInformation;
        boolean hasContextLines = origStartLine == origEndLine;
        int contextLines = hasContextLines ? this.getInspectContextLines() : 0;
        int startLine = origStartLine - contextLines < 1 ? 1 : origStartLine - contextLines;
        int endLine = origEndLine + contextLines;
        if (declaration == null || declaration.getParserPath() == null) {
            return null;
        }
        String parserPath = declaration.getParserPath().path;
        IFile iFile = DVTFileUtils.getInstance().findProjectFileUsingAbsolutePath(project, parserPath);
        if (iFile == null) {
            return null;
        }
        String fileData = DVTFileUtils.getInstance().getLinesFromFile(iFile, startLine, endLine, manager);
        if (fileData == null || fileData.equals("")) {
            return null;
        }
        String lineDelimiter = DVTDocumentCommon.getLineDelimiterByProject(project);
        String fileInfo = this.getInfoLine(project, "", iFile, commentFormat, -1);
        fileInfo = String.valueOf(powerDomain == null ? "" : String.valueOf(powerDomain) + lineDelimiter) + fileInfo;
        String content = String.valueOf(fileInfo) + fileData + NEW_LINE;
        content = this.formatContent(content, project, true);
        InspectViewInput result = new InspectViewInput(content, lineDelimiter);
        Position[] positions = this.getBackgroundAndHyperlinkPositions(currentOffset, fileInfo, iFile, declaration.getStartLine());
        if (positions != null) {
            result.addFileNamePosition(positions[0]);
            result.addHyperlinkPosition((InspectViewPosition)positions[1]);
        }
        if (!(numberInformation = this.printNumberInDifferentBases(declaration)).isEmpty()) {
            numberInformation = numberInformation;
            int numberInformationOffset = content.length() + 1;
            result.addFileNamePosition(new DVTPosition(numberInformationOffset, numberInformation.indexOf(NEW_LINE)));
            result.setContent(content + NEW_LINE + numberInformation);
        }
        int contentStartLine = contextLines != 0 ? origStartLine - startLine + 1 : fileInfo.split(NEW_LINE).length;
        int contentEndLine = contextLines != 0 ? origEndLine - startLine + 1 : origEndLine - origStartLine + fileInfo.split(NEW_LINE).length;
        result.addContentPositions(this.getPaintedPositions((IDocument)new Document(content), contentStartLine, contentEndLine, currentOffset));
        result.setMaxDigitsNumber(this.getDigits(endLine));
        result.setLineNumberContent(this.getLineNumberContent(startLine, endLine, true, fileInfo));
        return result;
    }

    private String printActualValueInDifferentBases(IRfNamedElement namedElement, IELParamValue paramValue, ELManager manager) {
        if (paramValue == null) {
            return this.printNumberInDifferentBases(namedElement.getDeclaration());
        }
        ELParamValuesHidEvaluator evaluator = ELParamValues.create(true).getHidEvaluator(manager);
        BitVectorContext paramContext = ELUtils.makeEvaluatorContext(evaluator, namedElement, null, manager);
        return this.printNumberInDifferentBases(paramValue.toNiceString(paramContext, PrefConst.getParamRadix(), false, false), namedElement.getLanguageKind(), ACTUAL_VALUE, true);
    }

    public InspectViewUpdateEvent createEventFromDiagramSelection(DDiagramEditorSelection selection) {
        DDiagram diagram = selection.getDiagram();
        IProject project = diagram != null ? diagram.getProject() : null;
        Set<DSelectable> hits = selection.getElements();
        if (diagram instanceof ICHDiagram) {
            InspectViewUpdateEvent event = this.createInspectViewCHDEvent(hits, project);
            return event;
        }
        InspectViewUpdateEvent event = this.createInspectViewNLEvent(hits, project);
        if (event != null) {
            return event;
        }
        event = this.createInspectViewFSMEvent(hits, diagram, project);
        if (event != null) {
            return event;
        }
        event = this.createInspectViewUMLEvent(hits, project);
        if (event != null) {
            return event;
        }
        event = this.createInspectViewPSSEvent(hits, project);
        if (event != null) {
            return event;
        }
        return null;
    }

    public int getDigits(int line) {
        if (line < 10) {
            return 1;
        }
        if (line < 100) {
            return 2;
        }
        if (line < 1000) {
            return 3;
        }
        if (line < 10000) {
            return 4;
        }
        if (line < 100000) {
            return 5;
        }
        if (line < 1000000) {
            return 6;
        }
        if (line < 10000000) {
            return 7;
        }
        if (line < 100000000) {
            return 8;
        }
        return 9;
    }

    public String getLineNumberContent(int min, int max, boolean addFileInfoLine, String fileInfo) {
        if (min <= 1) {
            min = 1;
        }
        if (min > max) {
            min = max;
        }
        StringBuilder result = new StringBuilder();
        if (addFileInfoLine && fileInfo != null) {
            int i = 0;
            while (i < fileInfo.split(NEW_LINE).length) {
                result.append(NEW_LINE);
                ++i;
            }
        }
        result.append(min);
        int j = min + 1;
        while (j <= max) {
            result.append(NEW_LINE + j);
            ++j;
        }
        return result.toString();
    }

    public String getInfoLine(IProject project, String elementInfo, IFile file, String commentFormat, int line) {
        String compileIndexInfo;
        if (project == null || elementInfo == null || file == null) {
            return "";
        }
        String fileName = file.getName();
        FileCompileInfo compileInfo = this.getCompileInfo(file);
        String string = compileIndexInfo = compileInfo != null ? compileInfo.getCompileIndicesString() : null;
        if (compileIndexInfo != null) {
            compileIndexInfo = String.valueOf(compileIndexInfo.indexOf(44) == -1 ? COMPILE_INDEX_NO_INDENT : COMPILE_INDEXES_NO_INDENT) + compileIndexInfo;
        }
        if (commentFormat == null || commentFormat.isEmpty()) {
            commentFormat = VLOG_COMMENT_START;
        }
        StringBuilder result = new StringBuilder();
        result.append(commentFormat);
        result.append(ONE_SPACE);
        result.append(elementInfo);
        if (!elementInfo.isEmpty()) {
            result.append(ONE_SPACE);
        }
        if (!fileName.isEmpty()) {
            result.append(elementInfo.isEmpty() ? FILE_INFORMATION : FILE_INFORMATION_WITH_ELEMENT_INFO);
            result.append(ONE_SPACE);
            result.append(fileName);
            result.append(line >= 0 ? " (Line " + String.valueOf(line) + ")" : "");
            result.append(compileIndexInfo != null ? " (" + compileIndexInfo + ")" : "");
        }
        result.append(NEW_LINE);
        return result.toString();
    }

    public Position[] getBackgroundAndHyperlinkPositions(int currentOffset, String fullLineContent, IFile file, int line) {
        DVTPosition fileInfoPosition = new DVTPosition(currentOffset, fullLineContent.length());
        if (file == null || fullLineContent.indexOf(file.getName()) < 0) {
            return new Position[]{fileInfoPosition};
        }
        int hyperlinkStartOffset = currentOffset + fullLineContent.indexOf(file.getName());
        int hyperlinkLength = file.getName().length();
        InspectViewPosition hyperlinkPosition = new InspectViewPosition(hyperlinkStartOffset, hyperlinkLength, file, line);
        return new Position[]{fileInfoPosition, hyperlinkPosition};
    }

    public InspectViewInput processNumber(String number, LanguageKind language) {
        String contentString = this.printNumberInDifferentBases(number, language, NUMBER, false);
        InspectViewInput result = new InspectViewInput(contentString);
        try {
            result.addFileNamePosition(new DVTPosition(0, contentString.indexOf(NEW_LINE)));
            result.setMaxDigitsNumber(1);
        }
        catch (Exception exception) {}
        return result;
    }

    public String printNumberInDifferentBases(IRfDefElement declaration) {
        IRfNamedElement namedElement = declaration.getNamedElement();
        if (!(namedElement instanceof IRfFieldElement)) {
            return "";
        }
        String number = ((IRfFieldElement)namedElement).getInitialValue(true);
        LanguageKind languageKind = namedElement.getLanguageKind();
        return this.printNumberInDifferentBases(number, languageKind, INITIAL_VALUE, false);
    }

    public String printNumberInDifferentBases(String number, LanguageKind languageKind, String descriptionInfo, boolean parseAll) {
        Number numberToConvert = null;
        try {
            if (number != null) {
                number = DVTStringUtil.replaceAll(SEMI_COLON_PATTERN, number, "");
                number = DVTStringUtil.replaceAll(SPACE_PATTERN, number, "");
            }
            if (parseAll) {
                numberToConvert = DVTStringUtil.parseNumberVLOG(number, Float.valueOf(Float.MAX_VALUE), false);
                if (numberToConvert == null || numberToConvert.floatValue() == Float.MAX_VALUE) {
                    numberToConvert = DVTStringUtil.parseNumberVHDL(number, Float.valueOf(Float.MAX_VALUE));
                }
            } else if (languageKind == LanguageKind.VLOG) {
                numberToConvert = DVTStringUtil.parseNumberVLOG(number, Float.valueOf(Float.MAX_VALUE), false);
            } else if (languageKind == LanguageKind.VHDL) {
                numberToConvert = DVTStringUtil.parseNumberVHDL(number, Float.valueOf(Float.MAX_VALUE));
            } else if (languageKind == LanguageKind.E) {
                for (IInspectViewContributor contributor : inspectContributors) {
                    if (contributor.getLanguageKind() != languageKind) continue;
                    numberToConvert = contributor.parseNumber(number);
                }
            }
            if (numberToConvert == null || numberToConvert.floatValue() == Float.MAX_VALUE) {
                return "";
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return this.convertNumberToAnyBaseBesideTheOriginal(number, numberToConvert, languageKind, descriptionInfo);
    }

    private String convertNumberToAnyBaseBesideTheOriginal(String originalNumber, Number numberToConvert, LanguageKind language, String descriptionInfo) {
        String commentFormat = "";
        commentFormat = language == LanguageKind.VLOG || language == LanguageKind.E ? VLOG_COMMENT_START : VHDL_COMMENT_START;
        StringBuilder content = new StringBuilder(commentFormat).append(ONE_SPACE).append(descriptionInfo).append(originalNumber).append(NEW_LINE);
        for (Map.Entry<Integer, String> base : BASES.entrySet()) {
            content.append(THREE_SPACES).append(base.getValue()).append(this.numberIntoBase(numberToConvert, base.getKey())).append(NEW_LINE);
        }
        return content.toString();
    }

    private String numberIntoBase(Number numberToConvert, Integer base) {
        StringBuilder result = new StringBuilder(new BigInteger(numberToConvert.toString()).toString(base).toUpperCase());
        if (base == 2 || base == 16) {
            StringBuilder insertZeros = new StringBuilder();
            int converStringLength = result.length();
            while (converStringLength % 4 != 0) {
                insertZeros.append('0');
                ++converStringLength;
            }
            if (insertZeros.length() != 0) {
                result.insert(0, insertZeros.toString());
            }
            int position = 4;
            while (position < result.length()) {
                result.insert(position, "_");
                position += 5;
            }
        }
        return result.toString();
    }

    public int getInspectContextLines() {
        return DVTPlugin.getDefault().getPreferenceStore().getInt("inspect.context.lines");
    }

    public InspectViewInput processGoToInfo(IProject project, InspectViewGoToInfo inspectGotoInfo, int currentOffset) {
        return this.processGoToInfo(project, inspectGotoInfo, currentOffset, -1, null);
    }

    public int getInspectMaxFileSize() {
        return DVTPlugin.getDefault().getPreferenceStore().getInt("inspect.max.file.size");
    }

    public InspectViewInput processConstant(IRfFieldElement element, IProject project, InspectViewUpdateEvent event, String commentFormat) {
        String numberInformation;
        String fileData;
        Object sourceView;
        if (element == null) {
            return null;
        }
        IRfDefElement declaration = element.getDeclaration();
        if (declaration == null || declaration.getParserPath() == null) {
            return null;
        }
        String parserPath = declaration.getParserPath().path;
        IFile iFile = DVTFileUtils.getInstance().findProjectFileUsingAbsolutePath(project, parserPath);
        if (iFile == null) {
            return null;
        }
        IRfSingleLangProject rfProject = element.getRfProject();
        if (rfProject == null) {
            return null;
        }
        ELManager manager = rfProject.getELManager();
        if (manager == null) {
            return null;
        }
        IELParamValue actualValue = null;
        IRfScopeElement scopeNamedElement = null;
        ElementPath elementPath = null;
        SelectionChangedEvent triggerViewEvent = event != null && event.getType() == InspectViewUpdateEventCommon.TYPE.WRAPPER ? event.getTriggerEvent() : null;
        Object object = sourceView = triggerViewEvent != null ? triggerViewEvent.getSource() : null;
        if (sourceView instanceof LazyDesignHierarchyPortsView) {
            elementPath = ((LazyDesignHierarchyPortsView)sourceView).getSelectedElementPath();
            scopeNamedElement = ((LazyDesignHierarchyPortsView)sourceView).getSelectedNamedElement();
            ElementPath forcedDHElementPath = ((LazyDesignHierarchyPortsView)sourceView).getSelectedElementPath();
            if (forcedDHElementPath != null) {
                actualValue = ELBatchUtils.getParameterValueFromPath(element, manager.getMemory(), forcedDHElementPath);
            }
        } else if (sourceView != null) {
            scopeNamedElement = element.getEnclosingScope();
            actualValue = ELBatchUtils.getParameterOrConstantValue(element, null, manager, null, -1);
        } else {
            int callOffset = event != null ? event.getCallOffset() : -1;
            String callParserPath = event != null ? event.getCallParserPath() : "";
            ITextEditor activeEditor = (ITextEditor)this.getActiveEditor();
            if (callParserPath == null) {
                callParserPath = parserPath;
            }
            if (callOffset == -1) {
                callOffset = declaration.getStartOffset();
            }
            if (callOffset == -1 || callParserPath == null) {
                return null;
            }
            IRfDefElement scope = RfSearchUtils.getScope(project, new ParserPath(callParserPath), -1, callOffset);
            if (scope == null) {
                return null;
            }
            actualValue = ELBatchUtils.getParameterOrConstantValue(element, scopeNamedElement, manager, activeEditor, callOffset);
            elementPath = DesignPathManager.getInstance().getPathFor((DVTEditor)activeEditor, callOffset, element, scopeNamedElement, true, false);
            scopeNamedElement = element.getEnclosingScope();
        }
        if ((fileData = element.getTooltipSignature(scopeNamedElement, elementPath, null, false)) == null || fileData.equals("")) {
            return null;
        }
        fileData = DVTStringUtil.breakLongNonWhitespaceSequences(fileData, 400, '\n');
        String fileInfo = this.getInfoLine(project, "", iFile, commentFormat, -1);
        String content = String.valueOf(fileInfo) + fileData + NEW_LINE;
        content = this.formatContent(content, project, true);
        InspectViewInput result = new InspectViewInput(content);
        Position[] positions = this.getBackgroundAndHyperlinkPositions(0, fileInfo, iFile, declaration.getStartLine());
        if (positions != null) {
            result.addFileNamePosition(positions[0]);
            result.addHyperlinkPosition((InspectViewPosition)positions[1]);
        }
        if (fileData.length() < 8100 && !(numberInformation = this.printActualValueInDifferentBases(element, actualValue, manager)).isEmpty()) {
            numberInformation = numberInformation;
            int numberInformationOffset = content.length() + 1;
            result.addFileNamePosition(new DVTPosition(numberInformationOffset, numberInformation.indexOf(NEW_LINE)));
            result.setContent(content + NEW_LINE + numberInformation);
        }
        boolean hasContextLines = declaration.getStartLine() == declaration.getEndLine();
        int contextLines = hasContextLines ? this.getInspectContextLines() : 0;
        int startLine = declaration.getStartLine();
        int endLine = declaration.getEndLine();
        int contentStartLine = contextLines != 0 ? 1 : fileInfo.split(NEW_LINE).length;
        int contentEndLine = contextLines != 0 ? 1 : fileInfo.split(NEW_LINE).length;
        result.addContentPositions(this.getPaintedPositions((IDocument)new Document(content), contentStartLine, contentEndLine, 0));
        result.setMaxDigitsNumber(this.getDigits(endLine));
        result.setLineNumberContent(this.getLineNumberContent(startLine, endLine, true, fileInfo));
        return result;
    }

    public InspectViewInput getInputFromContributors(InspectViewUpdateEvent event) {
        Object input;
        if (event == null) {
            return null;
        }
        SelectionChangedEvent triggerEvent = event.getTriggerEvent();
        for (IInspectViewInputContributor contributor : this.getViewContributors()) {
            try {
                if (!contributor.canHandle(triggerEvent) || (input = contributor.getInput(event)) == null) continue;
                return input;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        for (IXContributor xContributor : XViewsUtils.getXContributors()) {
            try {
                if (!xContributor.canHandle(triggerEvent) || !((input = xContributor.getInput(event)) instanceof InspectViewInput)) continue;
                return (InspectViewInput)input;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        return null;
    }

    public InspectViewInput processFile(IFile iFile) {
        return this.processFile(iFile, false);
    }

    public InspectViewInput processFile(IFile iFile, boolean addDetectIndentationInfo) {
        try {
            String systemPath;
            String physicalPath;
            String fileName = iFile.getName();
            StringBuilder content = new StringBuilder();
            content.append(FILE_NAME).append(fileName).append(NEW_LINE);
            if (iFile.getProject() != null) {
                content.append(PROJECT_IDENTIFIER).append(iFile.getProject().getName()).append(NEW_LINE);
            }
            if (iFile.getLocation() != null && (physicalPath = iFile.getLocation().toFile().getCanonicalPath()) != null) {
                content.append(PHYSICAL_PATH).append(physicalPath).append(NEW_LINE);
            }
            if ((systemPath = DVTFileUtils.getInstance().resolveAutoLinkPath((IResource)iFile).toOSString()) != null) {
                content.append(SYSTEM_PATH).append(systemPath).append(NEW_LINE);
            }
            if (iFile.getProjectRelativePath() != null) {
                content.append(PROJECT_PATH).append(iFile.getProjectRelativePath().toOSString()).append(NEW_LINE);
            }
            String isReadOnly = iFile.isReadOnly() ? "true" : "false";
            content.append(READ_ONLY).append(isReadOnly).append(NEW_LINE);
            FileCompileInfo compileInfo = this.getCompileInfo(iFile);
            if (compileInfo != null) {
                String compileIndexInfo;
                String languageSyntaxInfo = compileInfo.getLanguageSyntaxesString();
                if (languageSyntaxInfo != null) {
                    content.append(COMPILE_SYNTAX).append(languageSyntaxInfo).append(NEW_LINE);
                }
                if ((compileIndexInfo = compileInfo.getCompileIndicesString()) != null) {
                    content.append(compileIndexInfo.indexOf(44) == -1 ? COMPILE_INDEX : COMPILE_INDEXES).append(compileIndexInfo);
                } else {
                    content.append("Compile index:    N/A (Not compiled by DVT)");
                }
            } else {
                String languageSyntaxId = PropertiesManager.getSessionProperty((IResource)iFile, PropertyTypes.QN_IMPORTED_FILE);
                IBuildConfigParserConstants.LanguageSyntax languageSyntax = IBuildConfigParserConstants.LanguageSyntax.from(languageSyntaxId);
                if (languageSyntax != null) {
                    content.append("Compile index:    N/A (Not compiled by DVT)");
                }
            }
            InspectViewPosition inspectViewDetectIndentationPosition = this.addAutoDetectedIndentationInformationAndGetHyperlinkPosition(iFile, addDetectIndentationInfo, content);
            String contentString = content.toString();
            InspectViewInput result = new InspectViewInput(contentString);
            List<Position> contentPositions = this.getPaintedPositions(new Document(contentString), 0, DVTStringUtil.split(LINE_SPLIT_PATTERN, contentString).length - 1);
            result.addContentPositions(contentPositions);
            if (inspectViewDetectIndentationPosition != null) {
                result.addHyperlinkPosition(inspectViewDetectIndentationPosition);
            }
            return result;
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    protected abstract InspectViewPosition addAutoDetectedIndentationInformationAndGetHyperlinkPosition(IFile var1, boolean var2, StringBuilder var3);

    public int getMaxDigitsNumberFromLineNumberContent(String content) {
        if (content == null || content.isEmpty()) {
            return 1;
        }
        String[] lines = content.split(NEW_LINE);
        int maxLine = 1;
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            try {
                int parsed = Integer.parseInt(line);
                if (parsed > maxLine) {
                    maxLine = parsed;
                }
            }
            catch (NumberFormatException numberFormatException) {}
            ++n2;
        }
        return this.getDigits(maxLine);
    }

    /*
     * Unable to fully structure code
     */
    public void skipToLine(StringBuilder lineContent, int line) {
        if (lineContent == null) {
            return;
        }
        currentLine = lineContent.toString().split("\n").length;
        if (currentLine < line) ** GOTO lbl8
        return;
lbl-1000:
        // 1 sources

        {
            lineContent.append("\n");
lbl8:
            // 2 sources

            ** while (currentLine++ <= line)
        }
lbl9:
        // 1 sources

    }

    public InspectViewInput processMultipleElements(IProject project, List<? extends IRfNamedElement> elements) {
        if (elements == null || elements.isEmpty()) {
            return null;
        }
        InspectViewInput result = new InspectViewInput("", DVTDocumentCommon.getLineDelimiterByProject(project));
        DocumentManager manager = new DocumentManager(true);
        try {
            for (IRfNamedElement iRfNamedElement : elements) {
                result.appendInput(this.processDefElement(project, iRfNamedElement.getDeclaration(), this.getCommentFormat(iRfNamedElement), null, result.getContentLength(), manager));
            }
        }
        finally {
            manager.deactivate();
        }
        return result;
    }

    protected InspectViewInput processProblemsView(Map<String, Object> info, IProject project, StringBuilder result, InspectViewInput input) {
        try {
            int lineNumber = (Integer)info.get(MARKER_LINE);
            Object fileInfo = info.get(MARKER_FILE);
            IFile file = null;
            if (fileInfo instanceof IFile) {
                file = (IFile)info.get(MARKER_FILE);
            }
            String pathsString = (String)info.get("ELAB_PROBLEMS_ELEMENTPATH_ATTRIBUTE");
            String problemSourcePaths = (String)info.get("PROBLEM_SOURCE_FILE_PATH");
            String problemSourceLines = (String)info.get("PROBLEM_SOURCE_LINE");
            int severiry = (Integer)info.get(MARKER_SEVERITY);
            Object hitInfo = info.get(MARKER_HIT);
            result.append(MARKER_SEVERITY_HEADER).append(severiry == 2 ? "Error" : "Warning").append(NEW_LINE);
            int fileNameOffset = 0;
            if (file != null) {
                result.append(MARKER_LOCATION_HEADER + lineNumber + " in file ");
                fileNameOffset = result.toString().length();
                result.append(file.getName()).append(NEW_LINE);
            }
            result.append(NEW_LINE);
            DVTInspectViewUtilsCommon.addProblemSourceInformation(project, problemSourcePaths, problemSourceLines, input, result);
            if (hitInfo != null) {
                this.addLintDetails(hitInfo, result);
            }
            if (file != null) {
                DVTInspectViewUtilsCommon.addElaborationInformations(project, pathsString, lineNumber, file, input, result);
                this.addFileInformations(file, result);
            }
            input.setContent(result.toString());
            if (file != null) {
                input.addFileNamePosition(new DVTPosition(fileNameOffset, file.getName().length()));
                input.addHyperlinkPosition(new InspectViewPosition(fileNameOffset, file.getName().length(), file, lineNumber));
            }
            input.addContentPosition(new DVTPosition(0, result.length()));
            return input;
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    private void addLintDetails(Object hitInfo, StringBuilder result) {
        for (IInspectViewContributor contrib : inspectContributors) {
            List<String> linterDetails = contrib.getLinterProblemsViewTitleAndDescription(hitInfo);
            if (linterDetails == null || linterDetails.size() != 2) continue;
            result.append(CHECK_NAME).append(linterDetails.get(0)).append(NEW_LINE);
            result.append(CHECK_DESCRIPTION).append(linterDetails.get(1)).append(NEW_LINE);
        }
    }

    private void addFileInformations(IFile file, StringBuilder result) throws IOException {
        FileCompileInfo compileInfo;
        String systemPath;
        String physicalPath;
        if (file.getLocation() != null && (physicalPath = file.getLocation().toFile().getCanonicalPath()) != null) {
            result.append(PHYSICAL_PATH).append(physicalPath).append(NEW_LINE);
        }
        if ((systemPath = DVTFileUtils.getInstance().resolveAutoLinkPath((IResource)file).toOSString()) != null) {
            result.append(SYSTEM_PATH).append(systemPath).append(NEW_LINE);
        }
        if ((compileInfo = this.getCompileInfo(file)) != null) {
            String compileIndexInfo;
            String languageSyntaxInfo = compileInfo.getLanguageSyntaxesString();
            if (languageSyntaxInfo != null) {
                result.append(COMPILE_SYNTAX).append(languageSyntaxInfo).append(NEW_LINE);
            }
            if ((compileIndexInfo = compileInfo.getCompileIndicesString()) != null) {
                result.append(compileIndexInfo.indexOf(44) == -1 ? COMPILE_INDEX : COMPILE_INDEXES).append(compileIndexInfo);
            } else {
                result.append("Compile index:    N/A (Not compiled by DVT)");
            }
        } else {
            result.append("Compile index:    N/A (Not compiled by DVT)");
        }
    }

    static void addProblemSourceInformation(IProject project, String filePaths, String lines, InspectViewInput input, StringBuilder result) {
        String[] unpackedLines;
        if (filePaths == null || lines == null) {
            return;
        }
        String[] unpackedFilePaths = filePaths.split(";");
        if (unpackedFilePaths.length != (unpackedLines = lines.split(";")).length) {
            return;
        }
        int i = 0;
        while (i < unpackedFilePaths.length) {
            int line;
            IFile file = DVTFileUtils.getInstance().findProjectFileUsingAbsolutePath(project, unpackedFilePaths[i]);
            if (file != null && (line = Integer.parseInt(unpackedLines[i])) > 0) {
                int fileNameOffset = result.append(i == 0 ? PROBLEM_SOURCE_HEADER : EMPTY_SPACES).append("line ").append(unpackedLines[i]).append(" in file ").length();
                String fileName = file.getName();
                result.append(file.getName()).append(NEW_LINE);
                input.addFileNamePosition(new DVTPosition(fileNameOffset, fileName.length()));
                input.addHyperlinkPosition(new InspectViewPosition(fileNameOffset, fileName.length(), file, line));
            }
            ++i;
        }
        result.append(NEW_LINE);
    }

    static void addElaborationInformations(IProject project, String pathsString, int lineNumber, IFile file, InspectViewInput input, StringBuilder result) {
        IELMemory elMemory = RfMixedLangManager.getInstance().getELMemory(project);
        if (elMemory == null) {
            return;
        }
        ArrayList<InspectViewPosition> inspectPos = new ArrayList<InspectViewPosition>();
        ArrayList<Position> normalPos = new ArrayList<Position>();
        if (pathsString != null) {
            String[] paths = pathsString.split(",");
            if (paths[paths.length - 1].contains("...")) {
                paths = Arrays.copyOf(paths, paths.length - 1);
            }
            if (paths == null || paths.length == 0) {
                return;
            }
            LinkedHashMap<String, Set<String>> mergedSpecializations = new LinkedHashMap<String, Set<String>>();
            String[] stringArray = paths;
            int n = paths.length;
            int n2 = 0;
            while (n2 < n) {
                String path = stringArray[n2];
                DVTInspectViewUtilsCommon.mergeSpecializations(path, elMemory, mergedSpecializations);
                ++n2;
            }
            for (Map.Entry entry : mergedSpecializations.entrySet()) {
                Set mergedPaths = (Set)entry.getValue();
                if (mergedPaths == null || mergedPaths.isEmpty()) continue;
                result.append(DESIGN_CONTEXT_HEADER);
                result.append((String)entry.getKey()).append(NEW_LINE);
                result.append(DESIGN_PATHS_HEADER);
                int i = 0;
                for (String path : mergedPaths) {
                    result.append(++i == 1 ? "" : EMPTY_SPACES);
                    InspectViewBreadcrumbUpdatePosition inspectViewBreadcrumbUpdatePosition = new InspectViewBreadcrumbUpdatePosition(result.toString().length(), path.length(), file, lineNumber, path);
                    inspectPos.add(inspectViewBreadcrumbUpdatePosition);
                    normalPos.add(new DVTPosition(result.toString().length(), path.length()));
                    result.append(path).append(NEW_LINE);
                }
                result.append(NEW_LINE);
            }
        }
        input.addFileNamePositions(normalPos);
        input.addHyperlinkPositions(inspectPos);
    }

    static void mergeSpecializations(String path, IELMemory elMemory, Map<String, Set<String>> mergedSpecializations) {
        Set<String> parameterValue;
        ELInstance instanceFor = elMemory.instanceFor(ElementPath.from(path, "."));
        if (instanceFor == null) {
            return;
        }
        IRfNamedElement binding = instanceFor.getBinding(true);
        if (binding == null) {
            return;
        }
        ELParamValues cachedParamValues = instanceFor.getParamValues();
        Map<Object, Object> entries = cachedParamValues == null ? Collections.emptyMap() : cachedParamValues.getEntries();
        StringBuilder parameters = new StringBuilder();
        int j = 0;
        for (Map.Entry<Object, Object> entry : entries.entrySet()) {
            parameters.append(++j == 1 ? "" : ", ");
            parameters.append(String.valueOf((String)entry.getKey()) + "=" + ((IELParamValue)entry.getValue()).toNiceString(null, PrefConst.getParamRadix(), false, false));
        }
        if (parameters.length() == 0) {
            parameters.append("N/A");
        }
        if ((parameterValue = mergedSpecializations.get(parameters.toString())) == null) {
            parameterValue = new LinkedHashSet<String>();
            mergedSpecializations.put(parameters.toString(), parameterValue);
        }
        parameterValue.add(path);
    }

    protected String getMessage(String message) {
        StringBuilder result = new StringBuilder();
        String[] messageSegments = message.split(NEW_LINE);
        if (messageSegments == null || messageSegments.length == 0) {
            return "";
        }
        int index = 0;
        String[] stringArray = messageSegments;
        int n = messageSegments.length;
        int n2 = 0;
        while (n2 < n) {
            String messageSegment = stringArray[n2];
            messageSegment = messageSegment.trim();
            result.append(++index == 1 ? "" : EMPTY_SPACES);
            result.append(messageSegment).append(NEW_LINE);
            ++n2;
        }
        return result.toString();
    }

    protected abstract List<IInspectViewInputContributor> getViewContributors();

    public abstract IEditorPart getActiveEditor();

    protected abstract String computePowerFormatInfo(IProject var1, IRfNamedElement var2, ElementPath var3);

    protected abstract String computePowerDomainInfo(IProject var1, GoToInfo var2, ElementPath var3);

    public abstract InspectViewInput processProblemsView(Map<String, Object> var1, IProject var2);
}

