/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.inspect;

import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;

public class FileCompileInfo {
    private List<Integer> compileIndices;
    private List<IBuildConfigParserConstants.LanguageSyntax> languageSyntaxes;

    public FileCompileInfo(List<Integer> indices, List<IBuildConfigParserConstants.LanguageSyntax> syntaxes) {
        this.compileIndices = indices;
        this.languageSyntaxes = syntaxes;
    }

    public List<Integer> getCompileIndices() {
        return this.compileIndices;
    }

    public String getCompileIndicesString() {
        return this.compileIndices != null ? this.compileIndices.stream().map(index -> String.valueOf(index)).collect(Collectors.joining(", ")) : null;
    }

    public List<IBuildConfigParserConstants.LanguageSyntax> getLanguageSyntaxes() {
        return this.languageSyntaxes;
    }

    public String getLanguageSyntaxesString() {
        EnumSet<IBuildConfigParserConstants.LanguageSyntax> uniqueSyntaxes = EnumSet.noneOf(IBuildConfigParserConstants.LanguageSyntax.class);
        uniqueSyntaxes.addAll(this.languageSyntaxes);
        if (uniqueSyntaxes.size() == 1) {
            return this.languageSyntaxes.iterator().next().getFirstName();
        }
        return this.languageSyntaxes != null ? this.languageSyntaxes.stream().map(lSyntax -> lSyntax.getFirstName()).collect(Collectors.joining(", ")) : null;
    }
}

