/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.inspect;

import org.eclipse.core.resources.IProject;
import org.eclipse.ui.IEditorPart;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfNamedElementAndScope;
import ro.amiq.dvt.ui.views.inspect.DVTInspectViewUtils;
import ro.amiq.dvt.ui.views.inspect.InspectViewInput;
import ro.amiq.dvt.ui.waveviewer.DVTWaveViewIDEFactory;
import ro.amiq.dvt.utils.DVTDocumentCommon;

public interface IWaveformViewerInspectViewInputContributor {
    default public InspectViewInput getWaveformInspectViewInput(IProject project, IRfNamedElement element, int offset) {
        if (!(element instanceof IRfFieldElement)) {
            return null;
        }
        if (!DVTWaveViewIDEFactory.getInstance().isVcdSetAsInput(project)) {
            return null;
        }
        IEditorPart activeEditor = DVTInspectViewUtils.getInstance().getActiveEditor();
        if (activeEditor == null) {
            return null;
        }
        IRfNamedElementAndScope namedElementAndScope = this.getNamedElementAndScope(activeEditor, offset);
        if (namedElementAndScope == null) {
            return null;
        }
        String waveformInspectViewInputContent = DVTWaveViewIDEFactory.getInstance().getInspectViewInputContent(activeEditor, namedElementAndScope, offset);
        if (waveformInspectViewInputContent == null || waveformInspectViewInputContent.isBlank()) {
            return null;
        }
        return new InspectViewInput(waveformInspectViewInputContent, DVTDocumentCommon.getLineDelimiterByProject(project));
    }

    public IRfNamedElementAndScope getNamedElementAndScope(IEditorPart var1, int var2);
}

