/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.inspect;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.contexts.IContextService;
import ro.amiq.dvt.diagrams.tables.TableExportFormat;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.startup.core.EclipseUtils;
import ro.amiq.dvt.ui.views.InspectViewUpdateEvent;
import ro.amiq.dvt.ui.views.InspectViewUpdateEventCommon;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.inspect.InspectViewCommon;
import ro.amiq.dvt.ui.views.inspect.InspectViewComponent;
import ro.amiq.dvt.ui.views.inspect.InspectViewWavedromComponent;
import ro.amiq.dvt.ui.views.inspect.OpenInspectAction;
import ro.amiq.dvt.ui.views.inspect.PinInspectAction;

public class InspectView
extends InspectViewCommon {
    private static InspectView INSTANCE;
    private static final Object SYNC_OBJECT;
    public static final String INSPECT_VIEW_CONTEXT_ID = "ro.amiq.dvt.ui.inspect.view.actions.context";
    public static final String DISABLE_WAVEDROM_ENV_VAR = "DVT_DISABLE_WAVEDROM";
    public static final InspectViewUpdateEvent LAST_EVENT_UPDATE;
    private final IPartListener2 fPartListener = new IPartListener2(){

        public void partActivated(IWorkbenchPartReference partRef) {
            if (partRef.getPart(false) instanceof InspectView && InspectView.this.lastEventIgnoredNotVisible != null) {
                InspectView.this.update(InspectView.this.lastEventIgnoredNotVisible);
            }
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
        }

        public void partClosed(IWorkbenchPartReference partRef) {
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
        }

        public void partOpened(IWorkbenchPartReference partRef) {
        }

        public void partHidden(IWorkbenchPartReference partRef) {
        }

        public void partVisible(IWorkbenchPartReference partRef) {
            if (partRef.getPart(false) instanceof InspectView && InspectView.this.lastEventIgnoredNotVisible != null) {
                InspectView.this.update(InspectView.this.lastEventIgnoredNotVisible);
            }
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
        }
    };
    private InspectViewWavedromComponent fWaveDromViewComponent;
    private final StackLayout fLayout = new StackLayout();
    private InspectViewUpdateEvent lastEventIgnoredNotVisible;
    private InspectViewUpdateEvent lastEvent;
    private Composite fParent;
    private OpenInspectAction fCloneInspectAction = new OpenInspectAction();
    private PinInspectAction fPinInspectAction = new PinInspectAction();
    private IToolBarManager toolBarManager;
    private volatile boolean fWavedromVisibility;

    static {
        SYNC_OBJECT = new Object();
        LAST_EVENT_UPDATE = new InspectViewUpdateEvent(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InspectView getInstance() {
        if (INSTANCE == null) {
            Object object = SYNC_OBJECT;
            synchronized (object) {
                INSTANCE = new InspectView();
            }
        }
        return INSTANCE;
    }

    public void createPartControl(Composite parent) {
        ALL_ACTIVE_INSTANCES.add(this);
        this.fParent = parent;
        this.fParent.setLayout((Layout)this.fLayout);
        this.fInspectViewComponent = new InspectViewComponent(this.fParent);
        if (EclipseUtils.hasWorkingBrowser()) {
            this.fWaveDromViewComponent = new InspectViewWavedromComponent(this.fParent);
        }
        this.fLayout.topControl = this.fInspectViewComponent;
        DVTUiUtils.getActivePage().addPartListener(this.fPartListener);
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        if (contextService != null) {
            contextService.activateContext(INSPECT_VIEW_CONTEXT_ID);
        }
        this.createToolBar();
    }

    public void createToolBar() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        this.toolBarManager = actionBars.getToolBarManager();
        this.toolBarManager.removeAll();
        if (this.toolBarManager.getItems().length > 0) {
            this.toolBarManager.add((IContributionItem)new Separator());
        }
        this.toolBarManager.add((IAction)this.fPinInspectAction);
        this.toolBarManager.add((IAction)this.fCloneInspectAction);
        this.toolBarManager.update(true);
    }

    public void setFocus() {
        this.fInspectViewComponent.setFocus();
    }

    public boolean wavedromComponentIsVisible() {
        return this.fWavedromVisibility;
    }

    public Object getLastContent() {
        return this.lastEvent == null ? null : this.lastEvent.getElement();
    }

    @Override
    protected void updateInspectInstanceLastEvent(InspectView inspectViewInstance, InspectViewUpdateEvent event) {
        inspectViewInstance.lastEvent = event;
    }

    @Override
    protected void updateInspectInstanceLastIgnoredEvent(InspectView inspectViewInstance, InspectViewUpdateEvent event) {
        inspectViewInstance.lastEventIgnoredNotVisible = event;
    }

    @Override
    protected boolean shouldIgnoreUpdateEvent(InspectView inspectViewInstance, InspectViewUpdateEvent event) {
        boolean[] viewVisible = new boolean[1];
        DVTUiUtils.getActiveWorkbenchShell().getDisplay().syncExec(() -> {
            boolean bl = ViewsUtils.isViewVisible((IWorkbenchPart)inspectViewInstance);
        });
        if (!viewVisible[0] || inspectViewInstance.fPinInspectAction.isChecked()) {
            this.updateInspectInstanceLastIgnoredEvent(inspectViewInstance, event);
            return true;
        }
        return false;
    }

    @Override
    protected boolean shouldUpdateWavedromInspect(InspectView inspectViewInstance, InspectViewUpdateEvent event) {
        return event.getType() == InspectViewUpdateEventCommon.TYPE.WAVEFORM && inspectViewInstance.fWaveDromViewComponent != null && inspectViewInstance.fWaveDromViewComponent.getBrowser() != null;
    }

    @Override
    protected void updateWavedromInspect(InspectView inspectViewInstance, InspectViewUpdateEvent event) {
        inspectViewInstance.fWaveDromViewComponent.generateWavedromDiagram(event.getElement());
        inspectViewInstance.fLayout.topControl = inspectViewInstance.fWaveDromViewComponent.getBrowser();
        inspectViewInstance.fWavedromVisibility = true;
    }

    @Override
    protected void updateInspect(InspectView inspectViewInstance, InspectViewUpdateEvent event) {
        inspectViewInstance.fInspectViewComponent.update(event);
        inspectViewInstance.fLayout.topControl = inspectViewInstance.fInspectViewComponent;
        inspectViewInstance.fWavedromVisibility = false;
    }

    @Override
    protected void layoutInspectView(InspectView inspectViewInstance) {
        Display.getDefault().asyncExec(() -> inspectView.fParent.layout());
    }

    public static boolean isActive() {
        return !ALL_ACTIVE_INSTANCES.isEmpty();
    }

    public void dispose() {
        ALL_ACTIVE_INSTANCES.remove((Object)this);
        super.dispose();
        DVTUiUtils.getActivePage().removePartListener(this.fPartListener);
    }

    public String getContent() {
        return this.fInspectViewComponent.getContent();
    }

    public boolean testCopyPath(int offset, String reference) {
        return this.fInspectViewComponent.testCopyPath(offset, reference);
    }

    public String getWaveDromSVGDiagram() {
        return this.fWaveDromViewComponent.getSVGDiagram();
    }

    public String testGetRegisterModelDescription() {
        return this.fWaveDromViewComponent.getRegisterModelDescription();
    }

    public static int getNoActiveInstances() {
        return ALL_ACTIVE_INSTANCES.size();
    }

    public boolean isPinned() {
        return this.fPinInspectAction.isChecked();
    }

    public void setPinned(boolean checked) {
        this.fPinInspectAction.setChecked(checked);
        if (!this.fPinInspectAction.isChecked()) {
            this.update(this.lastEvent);
        }
    }

    private boolean needsUpdateOnDetectIndentationPref() {
        if (this.lastEvent == null) {
            return false;
        }
        InspectViewUpdateEventCommon.TYPE lastEventType = this.lastEvent.getType();
        return lastEventType == InspectViewUpdateEventCommon.TYPE.FILE || lastEventType == InspectViewUpdateEventCommon.TYPE.PRELIMINARY_EDITOR || lastEventType == InspectViewUpdateEventCommon.TYPE.AUTO_DETECT_INDENTATION;
    }

    public void updateOnDetectIndentationPref() {
        for (InspectView inspectViewInstance : ALL_ACTIVE_INSTANCES) {
            if (!inspectViewInstance.needsUpdateOnDetectIndentationPref()) continue;
            this.update(LAST_EVENT_UPDATE);
        }
    }

    public void testCloneAction() {
        this.fCloneInspectAction.run();
    }

    public String testGetExportTable(TableExportFormat format) {
        return this.fWaveDromViewComponent.testGetExportTable(format);
    }

    public String testGetExportTableInAllFormats() {
        return this.fWaveDromViewComponent.testGetExportTableInAllFormats();
    }
}

