/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.inspect;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.IViewportListener;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.ui.IDVTNotificationsHost;
import ro.amiq.dvt.ui.SimpleDVTNotification;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.actions.history.HistoryItem;
import ro.amiq.dvt.ui.editor.LineBackgroundPainter;
import ro.amiq.dvt.ui.preferences.DVTPreviewSourceViewer;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.ui.utils.DVTColorUtil;
import ro.amiq.dvt.ui.views.DVTHelpListener;
import ro.amiq.dvt.ui.views.DVTViewContributors;
import ro.amiq.dvt.ui.views.InspectViewUpdateEvent;
import ro.amiq.dvt.ui.views.InspectViewUpdateEventCommon;
import ro.amiq.dvt.ui.views.inspect.DVTInspectViewUtils;
import ro.amiq.dvt.ui.views.inspect.IInspectViewContributor;
import ro.amiq.dvt.ui.views.inspect.InspectView;
import ro.amiq.dvt.ui.views.inspect.InspectViewHyperlinkDetector;
import ro.amiq.dvt.ui.views.inspect.InspectViewInput;
import ro.amiq.dvt.ui.views.inspect.InspectViewPosition;
import ro.amiq.dvt.ui.views.lazy.views.compileorder.CompileOrderView;
import ro.amiq.dvt.utils.DVTDocumentCommon;

public class InspectViewComponent
extends Composite
implements IDVTNotificationsHost {
    public static final String INSPECT_VIEW_CATEGORY = "INSPECT_VIEW";
    private static final String INSPECT_NOTIFICATION = "INSPECT_NOTIFICATION";
    private static final String PREF_ORG_ECLIPSE_UI_EDITORS = "org.eclipse.ui.editors";
    private static final String DEFAULT_VIEW_MESSAGE = "Select an element to inspect.";
    private static final Set<Character> SELECTION_DELIMITERS = new HashSet<Character>(Arrays.asList(Character.valueOf('\n'), Character.valueOf(':')));
    private static final Map<LanguageKind, IInspectViewContributor> fAllContributorsByLanguageKind = new EnumMap<LanguageKind, IInspectViewContributor>(LanguageKind.class);
    private final IPropertyChangeListener fContextLinesListener = new IPropertyChangeListener(){
        private TriggerInspectLastEventUpdate fTriggerJob = new TriggerInspectLastEventUpdate("TriggerInspectLastEventUpdate");

        public void propertyChange(PropertyChangeEvent event) {
            if ("inspect.context.lines".equals(event.getProperty()) && !InspectViewComponent.this.isDisposed() && InspectViewComponent.this.isVisible()) {
                this.fTriggerJob.cancel();
                this.fTriggerJob.schedule(300L);
            }
        }

        final class TriggerInspectLastEventUpdate
        extends Job {
            public TriggerInspectLastEventUpdate(String name) {
                super(name);
            }

            public IStatus run(IProgressMonitor monitor) {
                InspectViewComponent.this.update(InspectView.LAST_EVENT_UPDATE);
                return Status.OK_STATUS;
            }
        }
    };
    private final IPropertyChangeListener fFontChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            Font textFont = JFaceResources.getTextFont();
            InspectViewComponent.this.fPreviewViewer.getTextWidget().setFont(textFont);
            InspectViewComponent.this.fLineNumberText.setFont(textFont);
            InspectViewComponent.this.updateLineNumberWidth();
        }
    };
    private final IEclipsePreferences.IPreferenceChangeListener fLineNumberColorListener = new IEclipsePreferences.IPreferenceChangeListener(){

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            if (!"lineNumberColor".equals(event.getKey())) {
                return;
            }
            InspectViewComponent.this.updateLineNumberColor();
        }
    };
    private ITextDoubleClickStrategy fDoubleClickStrategy = null;
    private DVTPreviewSourceViewer fPreviewViewer;
    private LineBackgroundPainter fLineBackgroundPainter;
    private StyledText fLineNumberText;
    private Color fLineNumberColor;
    private GridData fLineNumberData;
    private InspectViewInput fInput;
    private String fInputString;
    private String fNatureName;
    private Composite fNotificationHost;
    private InspectViewUpdateEvent lastUpdateEvent;
    private long fTriggerJobDelay;
    private TriggerInspectUpdateJob updateJob = new TriggerInspectUpdateJob();
    private static final Set<InspectViewUpdateEventCommon.TYPE> NO_SYNTAX_EVENTS;
    private static final Set<InspectViewUpdateEventCommon.TYPE> DOUBLE_CLICK_STRATEGY_EVENTS;

    static {
        List<IInspectViewContributor> allContributors = DVTViewContributors.getInstance().getAllInstanceOf(IInspectViewContributor.class);
        for (IInspectViewContributor contributor : allContributors) {
            fAllContributorsByLanguageKind.put(contributor.getLanguageKind(), contributor);
        }
        NO_SYNTAX_EVENTS = EnumSet.of(InspectViewUpdateEventCommon.TYPE.FILE, new InspectViewUpdateEventCommon.TYPE[]{InspectViewUpdateEventCommon.TYPE.FOLDER, InspectViewUpdateEventCommon.TYPE.PROJECT, InspectViewUpdateEventCommon.TYPE.NUMBER, InspectViewUpdateEventCommon.TYPE.PROBLEM_MARKER, InspectViewUpdateEventCommon.TYPE.AUTO_DETECT_INDENTATION});
        DOUBLE_CLICK_STRATEGY_EVENTS = EnumSet.of(InspectViewUpdateEventCommon.TYPE.FILE, InspectViewUpdateEventCommon.TYPE.FOLDER, InspectViewUpdateEventCommon.TYPE.PROJECT);
    }

    public InspectViewComponent(Composite parent) {
        this(parent, 0L);
    }

    public InspectViewComponent(Composite parent, long delay) {
        super(parent, 2048);
        this.fTriggerJobDelay = delay;
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).margins(0, 0).spacing(1, 0).applyTo((Composite)this);
        this.fNotificationHost = new Composite((Composite)this, 0);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.fNotificationHost);
        GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo(this.fNotificationHost);
        this.fNatureName = null;
        parent.addHelpListener((HelpListener)DVTHelpListener.getInstance());
        Composite lineNumberComposite = new Composite((Composite)this, 0);
        GridLayoutFactory.fillDefaults().spacing(0, 5).margins(5, 0).applyTo(lineNumberComposite);
        GridDataFactory.fillDefaults().align(1, 4).grab(false, true).applyTo((Control)lineNumberComposite);
        this.fLineNumberText = new StyledText(lineNumberComposite, 66);
        this.fLineNumberData = GridDataFactory.fillDefaults().align(4, 4).grab(true, true).create();
        this.fLineNumberText.setLayoutData((Object)this.fLineNumberData);
        this.fLineNumberText.setFont(JFaceResources.getTextFont());
        this.fLineNumberText.setEditable(false);
        this.fLineNumberText.setEnabled(false);
        this.fLineNumberText.setAlignment(131072);
        this.updateLineNumberColor();
        DVTColorUtil.INSTANCE.setBackground((Control)lineNumberComposite, DVTColorUtil.INSTANCE.getBackground((Control)this.fLineNumberText));
        Composite viewerComposite = new Composite((Composite)this, 0);
        viewerComposite.setLayout((Layout)new FillLayout());
        viewerComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fPreviewViewer = new DVTPreviewSourceViewer(viewerComposite, 768);
        this.fPreviewViewer.setPreferenceStore(DVTPlugin.getDefault().getCombinedPreferenceStore());
        this.fPreviewViewer.getTextWidget().setFont(JFaceResources.getTextFont());
        this.fPreviewViewer.setEditable(false);
        this.fLineBackgroundPainter = new LineBackgroundPainter((ITextViewer)this.fPreviewViewer, DVTPlugin.getDefault().getCombinedPreferenceStore(), null);
        this.fPreviewViewer.addPainter(this.fLineBackgroundPainter);
        this.fPreviewViewer.addViewportListener(new IViewportListener(){

            public void viewportChanged(int verticalOffset) {
                int topIndex = InspectViewComponent.this.fPreviewViewer.getTextWidget().getTopPixel();
                InspectViewComponent.this.fLineNumberText.setTopPixel(topIndex);
            }
        });
        DVTPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.fContextLinesListener);
        JFaceResources.getFontRegistry().addListener(this.fFontChangeListener);
        InstanceScope.INSTANCE.getNode(PREF_ORG_ECLIPSE_UI_EDITORS).addPreferenceChangeListener(this.fLineNumberColorListener);
        this.resetViewToDefault();
        this.addDisposeListener(e -> {
            JFaceResources.getFontRegistry().removeListener(this.fFontChangeListener);
            DVTPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.fContextLinesListener);
            ConfigurationScope.INSTANCE.getNode(PREF_ORG_ECLIPSE_UI_EDITORS).removePreferenceChangeListener(this.fLineNumberColorListener);
            this.disposeLineNumberColor();
        });
    }

    public void performDoubleClick(ITextViewer viewer) {
        char c;
        int clickOffset = viewer.getTextWidget().getSelectionRange().x;
        String content = viewer.getDocument().get();
        int startOffset = clickOffset;
        int length = 0;
        int documentLength = content.length();
        while (startOffset >= 0) {
            c = content.charAt(startOffset);
            if (SELECTION_DELIMITERS.contains(Character.valueOf(c))) break;
            --startOffset;
            ++length;
        }
        while (clickOffset < documentLength) {
            c = content.charAt(clickOffset);
            if (SELECTION_DELIMITERS.contains(Character.valueOf(c))) break;
            ++clickOffset;
            ++length;
        }
        c = content.charAt(startOffset);
        while (c == ' ' || SELECTION_DELIMITERS.contains(Character.valueOf(c))) {
            c = content.charAt(++startOffset);
            --length;
        }
        if (startOffset < 0 || length < 0 || startOffset + length > documentLength) {
            return;
        }
        this.fPreviewViewer.setSelectedRange(startOffset, length);
        String selectedText = content.substring(startOffset, startOffset + length);
        ro.amiq.dvt.utils.Utils.copyToClipboard(selectedText, 3);
    }

    private void updateLineNumberColor() {
        RGB rgb;
        this.disposeLineNumberColor();
        if (this.fLineNumberText.isDisposed()) {
            return;
        }
        String lineNumberColorString = Platform.getPreferencesService().getString(PREF_ORG_ECLIPSE_UI_EDITORS, "lineNumberColor", null, null);
        if (lineNumberColorString != null && (rgb = StringConverter.asRGB((String)lineNumberColorString)) != null) {
            this.fLineNumberColor = new Color(null, rgb);
        }
        DVTColorUtil.INSTANCE.setForeground((Control)this.fLineNumberText, this.fLineNumberColor != null ? this.fLineNumberColor : Display.getDefault().getSystemColor(15), true);
    }

    private void disposeLineNumberColor() {
        if (this.fLineNumberColor != null) {
            this.fLineNumberColor.dispose();
            this.fLineNumberColor = null;
        }
    }

    public void update(InspectViewUpdateEvent event) {
        try {
            if (this.fPreviewViewer == null) {
                return;
            }
            if (event == null) {
                this.resetViewToDefault();
                ObjectionManager.getInstance().clear(Objection.INSPECT);
                this.lastUpdateEvent = null;
                return;
            }
            if (event == InspectView.LAST_EVENT_UPDATE) {
                if (this.lastUpdateEvent == null) {
                    ObjectionManager.getInstance().clear(Objection.INSPECT);
                    return;
                }
                event = this.lastUpdateEvent;
                this.lastUpdateEvent = null;
            }
            IProject project = event.getProject();
            if (!DVTPlugin.getDefault().collect().c(project, "F636F7265")) {
                ObjectionManager.getInstance().clear(Objection.INSPECT);
                return;
            }
            InspectViewUpdateEvent finalEvent = event;
            this.updateJob.cancel();
            this.updateJob.setTriggerEvent(finalEvent);
            this.updateJob.schedule(this.fTriggerJobDelay);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private InspectViewUpdateEvent computeInspectInput(InspectViewUpdateEvent event) {
        InspectViewUpdateEventCommon.TYPE type = event.getType();
        IInspectViewContributor viewContributor = InspectViewComponent.getViewContributor(event);
        if (viewContributor == null) {
            return event;
        }
        if (type == InspectViewUpdateEventCommon.TYPE.PRELIMINARY_EDITOR) {
            if ((event = viewContributor.createEventFromPreliminary(event)) == null) {
                return event;
            }
            type = event.getType();
            viewContributor = InspectViewComponent.getViewContributor(event);
        }
        if (event.equals(this.lastUpdateEvent) && type != InspectViewUpdateEventCommon.TYPE.AUTO_DETECT_INDENTATION) {
            return null;
        }
        this.lastUpdateEvent = event;
        switch (type) {
            case FILE: 
            case AUTO_DETECT_INDENTATION: {
                Object element = event.getElement();
                if (!(element instanceof IFile)) {
                    return event;
                }
                this.fInput = DVTInspectViewUtils.getInstance().processFile((IFile)element, PrefConst.isDetectIndentationEnabled());
                break;
            }
            case PROJECT: {
                Object element = event.getElement();
                if (!(element instanceof IProject)) {
                    return event;
                }
                this.fInput = DVTInspectViewUtils.getInstance().processProject((IProject)element);
                break;
            }
            case FOLDER: {
                Object element = event.getElement();
                if (!(element instanceof IFolder)) {
                    return event;
                }
                this.fInput = DVTInspectViewUtils.getInstance().processFolder((IFolder)element);
                break;
            }
            case WRAPPER: {
                this.fInput = DVTInspectViewUtils.getInstance().getInputFromContributors(event);
                if (this.fInput != null || viewContributor == null) break;
                this.fInput = viewContributor.getInput(event);
                break;
            }
            case NUMBER: {
                LanguageKind language = event.getLanguage();
                Object number = event.getElement();
                if (!(number instanceof String) || language != LanguageKind.VLOG && language != LanguageKind.VHDL && language != LanguageKind.E) break;
                this.fInput = DVTInspectViewUtils.getInstance().processNumber((String)number, language);
                break;
            }
            case FSM_TRANSITIONS: 
            case FSM_TRANSITIONS_WITH_LOOPBACK: {
                this.fInput = DVTInspectViewUtils.getInstance().processFSMTransitions((Collection)event.getElement(), event.getInfos(), type == InspectViewUpdateEventCommon.TYPE.FSM_TRANSITIONS_WITH_LOOPBACK, event.getProject(), event.getLanguage());
                break;
            }
            case PROBLEM_MARKER: {
                this.fInput = DVTInspectViewUtils.getInstance().processProblemsView((Map)event.getElement(), event.getProject());
                break;
            }
            default: {
                if (viewContributor == null) break;
                this.fInput = viewContributor.getInput(event);
            }
        }
        if (this.fInput == null) {
            return null;
        }
        this.fInputString = this.fInput.getContent();
        return event;
    }

    private void updateGUIPart(InspectViewUpdateEvent event) {
        try {
            if (this.fInput == null || this.fInputString == null || this.fInputString.isEmpty()) {
                this.resetViewToDefault();
                return;
            }
            try {
                List<Position> fileNamePositions;
                boolean shouldUpdatePreviewer;
                InspectViewUpdateEventCommon.TYPE type = event.getType();
                String eventNature = event.getLanguage().NATURE_ID;
                boolean isFileType = DOUBLE_CLICK_STRATEGY_EVENTS.contains((Object)type) || event.getTriggerEvent() != null && event.getTriggerEvent().getSource() instanceof CompileOrderView;
                boolean bl = shouldUpdatePreviewer = !eventNature.equals(this.fNatureName) || type == InspectViewUpdateEventCommon.TYPE.NUMBER;
                if (NO_SYNTAX_EVENTS.contains((Object)type) || isFileType) {
                    this.resetViewToDefault();
                    if ((type == InspectViewUpdateEventCommon.TYPE.PROBLEM_MARKER || (type == InspectViewUpdateEventCommon.TYPE.AUTO_DETECT_INDENTATION || type == InspectViewUpdateEventCommon.TYPE.FILE) && PrefConst.isDetectIndentationEnabled()) && (viewContributor = InspectViewComponent.getViewContributor(event)) != null) {
                        viewContributor.updatePreviewer(this.fPreviewViewer, new InspectViewHyperlinkDetector(), true);
                    }
                } else if (shouldUpdatePreviewer) {
                    this.fNatureName = eventNature;
                    viewContributor = InspectViewComponent.getViewContributor(event);
                    if (viewContributor != null) {
                        viewContributor.updatePreviewer(this.fPreviewViewer, new InspectViewHyperlinkDetector(), false);
                    }
                }
                this.installDoubleClickStrategy(isFileType);
                IDocument document = this.fPreviewViewer.getDocument();
                document.set(this.fInputString);
                if (document.containsPositionCategory(INSPECT_VIEW_CATEGORY)) {
                    document.removePositionCategory(INSPECT_VIEW_CATEGORY);
                }
                document.addPositionCategory(INSPECT_VIEW_CATEGORY);
                List<InspectViewPosition> hyperlinkPositions = this.fInput.getHyperlinkPositions();
                if (hyperlinkPositions != null) {
                    for (InspectViewPosition p : hyperlinkPositions) {
                        document.addPosition(INSPECT_VIEW_CATEGORY, (Position)p);
                    }
                }
                this.fPreviewViewer.setDocument(document);
                IProject project = event.getProject();
                String lineDelimiter = DVTDocumentCommon.getLineDelimiterByProject(project);
                String lineNumberContent = this.fInput.getLineNumbers(this.fInputString.split(lineDelimiter).length);
                this.updateLineNumberWidth();
                this.fLineNumberText.setText(lineNumberContent);
                List<Position> contentPositions = this.fInput.getContentPositions();
                if (contentPositions != null) {
                    this.fLineBackgroundPainter.setHighlightPositions(contentPositions, LineBackgroundPainter.LineBackgroundKind.INSPECT_INTEREST);
                }
                if ((fileNamePositions = this.fInput.getFileNamePositions()) != null) {
                    this.fLineBackgroundPainter.setHighlightPositions(fileNamePositions, LineBackgroundPainter.LineBackgroundKind.INSPECT_FILE_INFO);
                }
                if (Arrays.asList(InspectViewUpdateEventCommon.TYPE.FILE, InspectViewUpdateEventCommon.TYPE.FOLDER, InspectViewUpdateEventCommon.TYPE.PROJECT).contains((Object)this.lastUpdateEvent.getType())) {
                    new SimpleDVTNotification(this, 256, INSPECT_NOTIFICATION).setText("Double-click on a path to copy to clipboard.").setShowPreferenceKey("show.inspect.notifications").create();
                }
                if (PrefConst.isDetectIndentationEnabled() && (type == InspectViewUpdateEventCommon.TYPE.FILE || type == InspectViewUpdateEventCommon.TYPE.AUTO_DETECT_INDENTATION)) {
                    this.styleAutoDetectIndentationHyperlink();
                }
                if (type == InspectViewUpdateEventCommon.TYPE.AUTO_DETECT_INDENTATION) {
                    this.selectDetectIndentationValuesInView();
                }
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        finally {
            ObjectionManager.getInstance().clear(Objection.INSPECT);
        }
    }

    private void styleAutoDetectIndentationHyperlink() {
        int idx = this.fInputString.indexOf("Auto-detect Indentation");
        if (idx > 0) {
            StyledText styledText = this.fPreviewViewer.getTextWidget();
            StyleRange style = new StyleRange();
            style.start = idx;
            style.length = "Auto-detect Indentation".length();
            style.underline = true;
            style.foreground = JFaceResources.getColorRegistry().get("HYPERLINK_COLOR");
            styledText.setStyleRange(style);
        }
    }

    private void selectDetectIndentationValuesInView() {
        this.fPreviewViewer.setSelectedRange(this.fInputString.indexOf("Indentation:      ") + "Indentation:      ".length(), 1);
    }

    private void installDoubleClickStrategy(boolean copyPath) {
        if (copyPath) {
            this.fDoubleClickStrategy = new InspectViewDoubleClickStrategy();
            this.fPreviewViewer.setTextDoubleClickStrategy(this.fDoubleClickStrategy, "__dftl_partition_content_type");
        } else {
            this.fDoubleClickStrategy = null;
            this.fPreviewViewer.setTextDoubleClickStrategy(null, "__dftl_partition_content_type");
        }
    }

    private void updateLineNumberWidth() {
        if (this.fInput == null) {
            return;
        }
        DVTUiUtils.getActiveWorkbenchShell().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                GC gc = new GC((Drawable)InspectViewComponent.this);
                gc.setFont(JFaceResources.getTextFont());
                int averageWidth = gc.getFontMetrics().getAverageCharWidth();
                gc.dispose();
                InspectViewComponent.this.fLineNumberData.widthHint = (int)((double)(InspectViewComponent.this.fInput.getMaxDigits() * averageWidth) * 1.2);
                InspectViewComponent.this.layout(true);
            }
        });
    }

    private void resetViewToDefault() {
        DVTUiUtils.getActiveWorkbenchShell().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                InspectViewComponent.this.fNatureName = null;
                InspectViewComponent.this.fPreviewViewer.unconfigure();
                TextSourceViewerConfiguration configuration = new TextSourceViewerConfiguration();
                InspectViewComponent.this.fPreviewViewer.configure((SourceViewerConfiguration)configuration);
                InspectViewComponent.this.fPreviewViewer.setDocument((IDocument)new Document());
                InspectViewComponent.this.fPreviewViewer.getDocument().set(InspectViewComponent.DEFAULT_VIEW_MESSAGE);
                InspectViewComponent.this.fLineBackgroundPainter.setHighlightPositions(Collections.emptyList(), LineBackgroundPainter.LineBackgroundKind.INSPECT_FILE_INFO);
                InspectViewComponent.this.fLineBackgroundPainter.setHighlightPositions(Collections.emptyList(), LineBackgroundPainter.LineBackgroundKind.INSPECT_INTEREST);
                InspectViewComponent.this.fLineNumberText.setText(" ");
            }
        });
    }

    private static IInspectViewContributor getViewContributor(HistoryItem historyItem) {
        if (historyItem == null) {
            return null;
        }
        return fAllContributorsByLanguageKind.get((Object)historyItem.getLanguage());
    }

    @Override
    public Composite getNotificationsHostComposite() {
        return this.fNotificationHost;
    }

    public String getContent() {
        return this.fPreviewViewer.getDocument().get();
    }

    public boolean testCopyPath(int offset, String reference) {
        if (reference == null || offset < 0) {
            return false;
        }
        if (this.fDoubleClickStrategy == null) {
            return false;
        }
        if (!this.setCursorOffset(offset)) {
            return false;
        }
        this.performDoubleClick((ITextViewer)this.fPreviewViewer);
        return true;
    }

    private boolean setCursorOffset(int offset) {
        if (this.fPreviewViewer == null) {
            return false;
        }
        StyledText textWidget = this.fPreviewViewer.getTextWidget();
        if (textWidget == null) {
            return false;
        }
        textWidget.setCaretOffset(offset);
        return true;
    }

    public void cycleInputs() {
        StyledText textWidget = this.fPreviewViewer.getTextWidget();
        textWidget.setSelection(this.fInput.getNextContentPositionOffset());
    }

    private class InspectViewDoubleClickStrategy
    implements ITextDoubleClickStrategy {
        private InspectViewDoubleClickStrategy() {
        }

        public void doubleClicked(ITextViewer viewer) {
            InspectViewComponent.this.performDoubleClick(viewer);
        }
    }

    private class TriggerInspectUpdateJob
    extends Job {
        private InspectViewUpdateEvent triggerEvent;

        public TriggerInspectUpdateJob() {
            super("Computing Inspect View ...");
            this.triggerEvent = null;
            this.setSystem(true);
        }

        public void setTriggerEvent(InspectViewUpdateEvent event) {
            this.triggerEvent = event;
        }

        public IStatus run(IProgressMonitor monitor) {
            final InspectViewUpdateEvent newEvent = InspectViewComponent.this.computeInspectInput(this.triggerEvent);
            if (newEvent == null) {
                ObjectionManager.getInstance().clear(Objection.INSPECT);
                return Status.CANCEL_STATUS;
            }
            Utils.safeRunAsynchInUIThread(new Runnable(){

                @Override
                public void run() {
                    InspectViewComponent.this.updateGUIPart(newEvent);
                }
            });
            return Status.OK_STATUS;
        }
    }
}

