/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.inspect;

import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.formatter.detectindentation.DVTAutoIndentDetectionManager;
import ro.amiq.dvt.ui.editor.pathmanager.DesignPathManager;
import ro.amiq.dvt.ui.views.InspectViewUpdateEvent;
import ro.amiq.dvt.ui.views.InspectViewUpdateEventCommon;
import ro.amiq.dvt.ui.views.inspect.InspectView;
import ro.amiq.dvt.ui.views.inspect.InspectViewAutoDetectIndentationPosition;
import ro.amiq.dvt.ui.views.inspect.InspectViewBreadcrumbUpdatePosition;
import ro.amiq.dvt.ui.views.inspect.InspectViewPosition;
import ro.amiq.dvt.utils.DVTFileUtils;

class InspectViewHyperlinkDetector
implements IHyperlinkDetector {
    InspectViewHyperlinkDetector() {
    }

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        if (region == null || textViewer == null) {
            return null;
        }
        IDocument document = textViewer.getDocument();
        int offset = region.getOffset();
        try {
            Position[] positions;
            Position[] positionArray = positions = document.getPositions("INSPECT_VIEW");
            int n = positions.length;
            int n2 = 0;
            while (n2 < n) {
                InspectViewPosition ivp;
                Position p = positionArray[n2];
                if (p instanceof InspectViewPosition && (ivp = (InspectViewPosition)p).includes(offset) && ivp.getFile() != null && ivp.getLine() >= 1) {
                    if (p instanceof InspectViewBreadcrumbUpdatePosition) {
                        final InspectViewBreadcrumbUpdatePosition position = (InspectViewBreadcrumbUpdatePosition)p;
                        return new IHyperlink[]{new IHyperlink(){

                            public IRegion getHyperlinkRegion() {
                                return new Region(ivp.offset, ivp.length);
                            }

                            public String getTypeLabel() {
                                return null;
                            }

                            public String getHyperlinkText() {
                                return "Update breadcrumb";
                            }

                            public void open() {
                                DVTFileUtils.getInstance().openEditor(ivp.getFile(), ivp.getLine(), "");
                                Utils.safeRunSynchInUIThread(() -> {
                                    ElementPath path = ElementPath.from(position.getPath(), ".");
                                    IEditorPart activeEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
                                    if (activeEditor instanceof DVTEditor) {
                                        DesignPathManager.getInstance().updateFor((DVTEditor)activeEditor, path);
                                    }
                                });
                            }
                        }};
                    }
                    if (p instanceof InspectViewAutoDetectIndentationPosition) {
                        final InspectViewAutoDetectIndentationPosition position = (InspectViewAutoDetectIndentationPosition)p;
                        return new IHyperlink[]{new IHyperlink(){

                            public IRegion getHyperlinkRegion() {
                                return new Region(ivp.offset, ivp.length);
                            }

                            public String getTypeLabel() {
                                return null;
                            }

                            public String getHyperlinkText() {
                                return "Auto-detect Indentation";
                            }

                            public void open() {
                                IEditorPart activeEditor = DVTUiUtils.getActivePage().getActiveEditor();
                                if (!(activeEditor instanceof DVTEditor)) {
                                    return;
                                }
                                DVTEditor dvtActiveEditor = (DVTEditor)activeEditor;
                                if (ivp.getFile() != dvtActiveEditor.getCurrentFile()) {
                                    return;
                                }
                                DVTAutoIndentDetectionManager.INSTANCE.removeDetectedIndendationDocument(dvtActiveEditor.getDocument());
                                dvtActiveEditor.detectIndentation();
                                InspectView.getInstance().update(new InspectViewUpdateEvent(position.getFile(), InspectViewUpdateEventCommon.TYPE.AUTO_DETECT_INDENTATION));
                            }
                        }};
                    }
                    return new IHyperlink[]{new IHyperlink(){

                        public IRegion getHyperlinkRegion() {
                            return new Region(ivp.offset, ivp.length);
                        }

                        public String getTypeLabel() {
                            return null;
                        }

                        public String getHyperlinkText() {
                            return "Go To File";
                        }

                        public void open() {
                            DVTFileUtils.getInstance().openEditor(ivp.getFile(), ivp.getLine(), "");
                        }
                    }};
                }
                ++n2;
            }
        }
        catch (BadPositionCategoryException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return null;
    }
}

