/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.inspect;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.Position;
import org.eclipse.swt.graphics.Point;
import ro.amiq.dvt.ui.views.inspect.DVTInspectViewUtils;
import ro.amiq.dvt.ui.views.inspect.InspectViewPosition;

public class InspectViewInput {
    private static final String NEW_LINE = "\n";
    private StringBuilder fContent;
    private StringBuilder fLineNumberContent;
    private List<Position> fFileNamePositions;
    private List<Position> fContentPositions;
    private List<InspectViewPosition> fHyperlinkPositions;
    private String lineDelimiter;
    private boolean fHasContextLines;
    private int fLineNumberMaxDigits;
    private int fSelectedContentIndex;
    private String sectionTitle;

    public InspectViewInput(String content) {
        this.fContent = new StringBuilder(content != null ? content : "");
        this.fLineNumberContent = new StringBuilder();
        this.fFileNamePositions = new ArrayList<Position>();
        this.fContentPositions = new ArrayList<Position>();
        this.fHyperlinkPositions = new ArrayList<InspectViewPosition>();
        this.fSelectedContentIndex = 0;
        this.fHasContextLines = false;
    }

    public InspectViewInput(String content, String lineDelimiter) {
        this(content);
        this.setLineDelimiter(lineDelimiter);
    }

    public void appendInput(InspectViewInput elementInput) {
        if (elementInput == null) {
            return;
        }
        StringBuilder newContent = new StringBuilder(elementInput.getContent());
        int infoContentResultLines = InspectViewInput.countLines(elementInput.getContent());
        this.fLineNumberContent.append(elementInput.getLineNumbers(0));
        while (elementInput.hasContextLines() && infoContentResultLines++ < 2 * DVTInspectViewUtils.getInstance().getInspectContextLines() + 2) {
            this.fLineNumberContent.append(NEW_LINE);
            newContent.append(NEW_LINE);
        }
        this.fContent.append((CharSequence)newContent);
        this.addFileNamePositions(elementInput.getFileNamePositions());
        this.addHyperlinkPositions(elementInput.getHyperlinkPositions());
        this.setMaxDigitsNumber(Math.max(this.fLineNumberMaxDigits, elementInput.getMaxDigits()));
        if (elementInput.getContentPositions() != null) {
            this.addContentPositions(elementInput.getContentPositions());
        }
        this.fContent.append(this.lineDelimiter);
        this.fLineNumberContent.append(NEW_LINE);
        this.fLineNumberContent.append(NEW_LINE);
    }

    public void appendPositionAdjustedInput(InspectViewInput input) {
        if (input == null) {
            return;
        }
        if (this.getContentLength() > 0) {
            this.fContent.append(this.lineDelimiter);
            this.fLineNumberContent.append(this.lineDelimiter).append(this.lineDelimiter);
        }
        this.adjustPositions(input);
        this.fContent.append((CharSequence)input.fContent);
        this.fLineNumberContent.append((CharSequence)input.fLineNumberContent);
        this.addContentPositions(input.fContentPositions);
        this.addFileNamePositions(input.fFileNamePositions);
        this.addHyperlinkPositions(input.fHyperlinkPositions);
        this.setMaxDigitsNumber(Math.max(this.fLineNumberMaxDigits, input.fLineNumberMaxDigits));
    }

    private void adjustPositions(InspectViewInput input) {
        List<InspectViewPosition> hyperlinkPositions;
        List<Position> contentPositions;
        if (input == null) {
            return;
        }
        int padding = this.getContentLength();
        if (padding == 0) {
            return;
        }
        List<Position> fileNamePositions = input.getFileNamePositions();
        if (fileNamePositions != null) {
            fileNamePositions.forEach(p -> {
                int n2 = p.offset = p.offset + padding;
            });
        }
        if ((contentPositions = input.getContentPositions()) != null) {
            contentPositions.forEach(p -> {
                int n2 = p.offset = p.offset + padding;
            });
        }
        if ((hyperlinkPositions = input.getHyperlinkPositions()) != null) {
            hyperlinkPositions.forEach(p -> {
                int n2 = p.offset = p.offset + padding;
            });
        }
    }

    public String getContent() {
        return this.fContent.toString();
    }

    public void addFileNamePosition(Position p) {
        if (this.fFileNamePositions == null) {
            this.fFileNamePositions = new ArrayList<Position>();
        }
        this.fFileNamePositions.add(p);
    }

    public void addFileNamePositions(List<Position> positions) {
        for (Position p : positions) {
            this.addFileNamePosition(p);
        }
    }

    public void addContentPosition(Position p) {
        if (this.fContentPositions == null) {
            this.fContentPositions = new ArrayList<Position>();
        }
        this.fContentPositions.add(p);
    }

    public void addContentPositions(List<Position> positions) {
        for (Position p : positions) {
            this.addContentPosition(p);
        }
    }

    public void addHyperlinkPosition(InspectViewPosition p) {
        if (this.fHyperlinkPositions == null) {
            this.fHyperlinkPositions = new ArrayList<InspectViewPosition>();
        }
        this.fHyperlinkPositions.add(p);
    }

    public void addHyperlinkPositions(List<InspectViewPosition> positions) {
        for (InspectViewPosition p : positions) {
            this.addHyperlinkPosition(p);
        }
    }

    public List<Position> getFileNamePositions() {
        return this.fFileNamePositions;
    }

    public List<Position> getContentPositions() {
        return this.fContentPositions;
    }

    public List<InspectViewPosition> getHyperlinkPositions() {
        return this.fHyperlinkPositions;
    }

    public int getMaxDigits() {
        return this.fLineNumberMaxDigits;
    }

    public void setMaxDigitsNumber(int maxDigits) {
        this.fLineNumberMaxDigits = maxDigits;
    }

    public String getLineNumbers(int padding) {
        if (this.fLineNumberContent == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder(this.fLineNumberContent);
        if (padding > 0) {
            int i = 0;
            while (i < padding) {
                builder.append(NEW_LINE);
                ++i;
            }
        }
        return builder.toString();
    }

    public void setLineNumberContent(String lineNumberContent) {
        this.fLineNumberContent = new StringBuilder(lineNumberContent == null ? "" : lineNumberContent);
    }

    public void setContent(String content) {
        this.fContent = new StringBuilder(content);
    }

    public void setLineDelimiter(String lineDelimiter) {
        this.lineDelimiter = lineDelimiter;
    }

    public Point getNextContentPositionOffset() {
        Position result = this.fContentPositions.get(this.fSelectedContentIndex);
        this.fSelectedContentIndex = this.fSelectedContentIndex == this.fContentPositions.size() - 1 ? 0 : this.fSelectedContentIndex + 1;
        return new Point(result.getOffset(), result.getOffset() + result.getLength());
    }

    public boolean hasContextLines() {
        return this.fHasContextLines;
    }

    public void setHasContextLines(boolean hasContextLines) {
        this.fHasContextLines = hasContextLines;
    }

    private static int countLines(String content) {
        if (content == null || content.isEmpty()) {
            return 0;
        }
        int lines = 0;
        int i = 0;
        while (i < content.length()) {
            lines += content.charAt(i) == '\n' ? 1 : 0;
            ++i;
        }
        return lines;
    }

    public int getContentLength() {
        return this.fContent.length();
    }

    public String getSectionTitle() {
        return this.sectionTitle;
    }

    public void setSectionTitle(String title) {
        this.sectionTitle = title;
    }
}

