/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.inspect;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.navigator.resources.ProjectExplorer;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.diagrams.editor.DDiagramEditor;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.actions.history.HistoryItem;
import ro.amiq.dvt.ui.views.InspectViewUpdateEvent;
import ro.amiq.dvt.ui.views.InspectViewUpdateEventCommon;
import ro.amiq.dvt.ui.views.inspect.InspectViewSelectionListenerCommon;

public class InspectViewSelectionListener
extends InspectViewSelectionListenerCommon {
    private static InspectViewSelectionListener INSTANCE;
    private static final Object SYNC_OBJECT;

    static {
        SYNC_OBJECT = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InspectViewSelectionListener getInstance() {
        if (INSTANCE == null) {
            Object object = SYNC_OBJECT;
            synchronized (object) {
                INSTANCE = new InspectViewSelectionListener();
            }
        }
        return INSTANCE;
    }

    public void init() {
        ISelectionService selectionService = DVTPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getSelectionService();
        if (selectionService != null) {
            selectionService.addPostSelectionListener((ISelectionListener)this);
        }
        DDiagramEditor.addStaticSelectionChangedListener(this);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (part instanceof ProjectExplorer) {
            this.triggerInspectViewJob(InspectViewSelectionListenerCommon.Trigger.SELECTION_IN_TREE, selection);
        }
    }

    @Override
    protected HistoryItem handleSelectionInTree(Object triggerEvent, IProgressMonitor monitor) {
        if (!(triggerEvent instanceof TreeSelection)) {
            return null;
        }
        TreeSelection treeSelection = (TreeSelection)triggerEvent;
        if (!(treeSelection.getFirstElement() instanceof IResource)) {
            return null;
        }
        IResource resource = (IResource)treeSelection.getFirstElement();
        if (monitor.isCanceled()) {
            return null;
        }
        if (resource instanceof IFile) {
            return new InspectViewUpdateEvent((IFile)resource, InspectViewUpdateEventCommon.TYPE.FILE);
        }
        if (resource instanceof IProject) {
            return new InspectViewUpdateEvent((IProject)resource);
        }
        if (resource instanceof IFolder) {
            return new InspectViewUpdateEvent((IFolder)resource);
        }
        return null;
    }

    @Override
    protected boolean isDisplayAccesible() {
        Shell activeWorkbenchShell = DVTUiUtils.getActiveWorkbenchShell();
        if (activeWorkbenchShell == null) {
            return false;
        }
        Display display = activeWorkbenchShell.getDisplay();
        return display != null;
    }

    @Override
    protected boolean isInspectViewDisabled() {
        return System.getenv("DISABLE_INSPECT_VIEW") != null;
    }
}

