/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.views.inspect;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.ISelectionListener;
import ro.amiq.dvt.diagrams.editor.DDiagramEditor;
import ro.amiq.dvt.diagrams.editor.DDiagramEditorSelection;
import ro.amiq.dvt.diagrams.wavedrom.BitFieldFactory;
import ro.amiq.dvt.diagrams.wavedrom.BitFieldModel;
import ro.amiq.dvt.interpreter.IXXVMRegBlock;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IReflectionContributor;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.ui.DVTSelectionChangedEvent;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.actions.history.HistoryItem;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.InspectViewUpdateEvent;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.inspect.DVTInspectViewUtils;
import ro.amiq.dvt.ui.views.inspect.IInspectViewContributor;
import ro.amiq.dvt.ui.views.inspect.InspectView;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;

public abstract class InspectViewSelectionListenerCommon
implements ISelectionListener,
ISelectionChangedListener {
    protected TriggerInspectUpdateJob fTriggerInspectView = new TriggerInspectUpdateJob();
    private static final long fTriggerJobDelay = 300L;

    protected void triggerInspectViewJob(Trigger trigger, Object event) {
        if (this.isInspectViewDisabled()) {
            return;
        }
        this.fTriggerInspectView.cancel();
        this.fTriggerInspectView.setTrigger(trigger);
        this.fTriggerInspectView.setTriggerEvent(event);
        this.fTriggerInspectView.schedule(300L);
    }

    private HistoryItem handleSelectionInDiagram(Object triggerEvent, IProgressMonitor monitor) {
        if (!(triggerEvent instanceof SelectionChangedEvent)) {
            return null;
        }
        ISelection selection = ((SelectionChangedEvent)triggerEvent).getSelection();
        if (selection.isEmpty()) {
            return null;
        }
        if (!(selection instanceof DDiagramEditorSelection)) {
            return null;
        }
        if (monitor.isCanceled()) {
            return null;
        }
        return DVTInspectViewUtils.getInstance().createEventFromDiagramSelection((DDiagramEditorSelection)selection);
    }

    protected HistoryItem handleSelectionInEditor(Object triggerEvent, IProgressMonitor monitor) {
        if (!(triggerEvent instanceof ISelection)) {
            return null;
        }
        ISelection selection = (ISelection)triggerEvent;
        if (selection.isEmpty()) {
            return null;
        }
        if (selection instanceof StructuredSelection && ((StructuredSelection)selection).isEmpty()) {
            return null;
        }
        if (monitor.isCanceled()) {
            return null;
        }
        HistoryItem[] historyItem = new HistoryItem[1];
        Utils.safeRunSynchInUIThread(() -> {
            HistoryItem historyItem = ViewsUtils.getHistoryItemAtCurrentOffset(IInspectViewContributor.class, false);
        });
        return historyItem[0];
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (event.getSelectionProvider() instanceof DDiagramEditor) {
            this.triggerInspectViewJob(Trigger.SELECTION_IN_DIAGRAM, event);
        } else if (event instanceof DVTSelectionChangedEvent && ((DVTSelectionChangedEvent)event).isUserEvent()) {
            this.triggerInspectViewJob(Trigger.SELECTION_IN_VIEW, event);
        }
    }

    public void resourceSelectionChanged(ISelection selection) {
        this.triggerInspectViewJob(Trigger.SELECTION_IN_EDITOR, selection);
    }

    protected abstract HistoryItem handleSelectionInTree(Object var1, IProgressMonitor var2);

    protected HistoryItem handleSelectionInView(Object triggerEvent, IProgressMonitor monitor) {
        if (!(triggerEvent instanceof SelectionChangedEvent)) {
            return null;
        }
        SelectionChangedEvent selectionChangedEvent = (SelectionChangedEvent)triggerEvent;
        ISelection selection = selectionChangedEvent.getSelection();
        if (selection.isEmpty()) {
            return null;
        }
        if (!(selection instanceof StructuredSelection)) {
            return null;
        }
        Object selectionFirstElement = ((StructuredSelection)selection).getFirstElement();
        Object rfElement = null;
        IDVTElementWrapper wrapper = null;
        if (selectionFirstElement instanceof IDVTElementWrapper) {
            wrapper = (IDVTElementWrapper)selectionFirstElement;
            rfElement = wrapper.getRfElement();
        }
        if (selectionFirstElement instanceof TreePath) {
            rfElement = ((TreePath)selectionFirstElement).getElement();
        }
        if (monitor.isCanceled()) {
            return null;
        }
        List<IReflectionContributor> rfContributors = RfMixedLangManager.getReflectionContributors();
        if (rfElement instanceof IRfDefElement) {
            for (IReflectionContributor contributor : rfContributors) {
                IRfNamedElement vrAdEnumItem = contributor.getVrAdEnumItemFromStructLayer((IRfDefElement)rfElement);
                if (vrAdEnumItem == null) continue;
                rfElement = vrAdEnumItem;
                break;
            }
        }
        IXXVMRegBlock regBlock = null;
        if (rfElement instanceof IXXVMRegBlock) {
            regBlock = (IXXVMRegBlock)rfElement;
            rfElement = regBlock.getRegBlockAssocType();
        }
        if (rfElement instanceof IRfNamedElement) {
            BitFieldModel regModel;
            Object prependScope;
            if (wrapper != null && (prependScope = wrapper.getAdditionalInfo((Object)IDVTElementWrapper.Attribute.SEQ_TREE_PREPEND_SCOPE_TYPE)) instanceof IRfNamedElement) {
                rfElement = prependScope;
            }
            if ((regModel = BitFieldFactory.getModel((IRfNamedElement)rfElement, ElementPath.EMPTY_PATH)) != null) {
                return new InspectViewUpdateEvent(regModel, regBlock);
            }
        }
        if (wrapper == null) {
            return null;
        }
        return new InspectViewUpdateEvent(wrapper, selectionChangedEvent);
    }

    protected abstract boolean isDisplayAccesible();

    protected abstract boolean isInspectViewDisabled();

    protected static enum Trigger {
        SELECTION_IN_EDITOR,
        SELECTION_IN_VIEW,
        SELECTION_IN_DIAGRAM,
        SELECTION_IN_TREE;

    }

    private class TriggerInspectUpdateJob
    extends Job {
        private Trigger trigger;
        private Object triggerEvent;

        public TriggerInspectUpdateJob() {
            super("Trigger Inspect Update Job");
            this.trigger = null;
            this.triggerEvent = null;
        }

        public void setTriggerEvent(Object event) {
            this.triggerEvent = event;
        }

        public void setTrigger(Trigger trigger) {
            this.trigger = trigger;
        }

        public IStatus run(IProgressMonitor monitor) {
            HistoryItem[] historyItem = new HistoryItem[1];
            if (!InspectView.isActive()) {
                return this.returnCancel();
            }
            switch (this.trigger) {
                case SELECTION_IN_TREE: {
                    HistoryItem handleSelectionInTree = InspectViewSelectionListenerCommon.this.handleSelectionInTree(this.triggerEvent, monitor);
                    if (handleSelectionInTree == null) {
                        return this.returnCancel();
                    }
                    historyItem[0] = handleSelectionInTree;
                    break;
                }
                case SELECTION_IN_EDITOR: {
                    HistoryItem handleSelectionInEditor = InspectViewSelectionListenerCommon.this.handleSelectionInEditor(this.triggerEvent, monitor);
                    if (handleSelectionInEditor == null) {
                        return this.returnCancel();
                    }
                    historyItem[0] = handleSelectionInEditor;
                    break;
                }
                case SELECTION_IN_VIEW: {
                    HistoryItem handleSelectionInView = InspectViewSelectionListenerCommon.this.handleSelectionInView(this.triggerEvent, monitor);
                    if (handleSelectionInView == null) {
                        return this.returnCancel();
                    }
                    historyItem[0] = handleSelectionInView;
                    break;
                }
                case SELECTION_IN_DIAGRAM: {
                    HistoryItem handleSelectionInDiagram = InspectViewSelectionListenerCommon.this.handleSelectionInDiagram(this.triggerEvent, monitor);
                    if (handleSelectionInDiagram == null) {
                        return this.returnCancel();
                    }
                    historyItem[0] = handleSelectionInDiagram;
                    break;
                }
                default: {
                    return this.returnCancel();
                }
            }
            if (monitor.isCanceled()) {
                return this.returnCancel();
            }
            if (historyItem[0] == null || historyItem[0].getLanguage() == null) {
                return this.returnCancel();
            }
            InspectViewUpdateEvent event = (InspectViewUpdateEvent)historyItem[0];
            if (!InspectViewSelectionListenerCommon.this.isDisplayAccesible()) {
                return this.returnCancel();
            }
            if (!monitor.isCanceled()) {
                InspectView.getInstance().update(event);
            }
            this.triggerEvent = null;
            return Status.OK_STATUS;
        }

        private IStatus returnCancel() {
            this.triggerEvent = null;
            return Status.CANCEL_STATUS;
        }
    }
}

